/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.base;

import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import java.util.LinkedList;
import java.util.List;

public abstract class SeatUpdateNotifier
implements ISeatUpdateListener {
    private List<ISeatUpdateListener> mListeners = new LinkedList<ISeatUpdateListener>();

    public void startListen() {
        this.registerListeners(this.mListeners);
    }

    public void stopListen() {
        this.removeListeners(this.mListeners);
        this.mListeners.clear();
    }

    protected abstract void registerListeners(List<ISeatUpdateListener> var1);

    protected abstract void removeListeners(List<ISeatUpdateListener> var1);

    public void addListener(ISeatUpdateListener listener2) {
        this.mListeners.add(listener2);
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        for (ISeatUpdateListener listener2 : this.mListeners) {
            listener2.onSeatUpdate(seatUserList);
        }
    }
}

