/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.base;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.FamilyInfoBean;
import com.yy.hiyo.channel.base.bean.RecommendEnterData;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.hiido.FollowStatisHelper;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelMemberCallback;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.ITeamUpGameService;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupData;
import com.yy.hiyo.channel.component.profile.profilecard.base.DialogUiCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.IBaseCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.IDataProvider;
import com.yy.hiyo.channel.component.profile.profilecard.base.LeftAction;
import com.yy.hiyo.channel.component.profile.profilecard.base.MicStatus;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardData;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardDialog;
import com.yy.hiyo.channel.component.profile.profilecard.base.SeatUpdateNotifier;
import com.yy.hiyo.channel.component.profile.profilecard.base.TeamUpCardCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.ViewProvider;
import com.yy.hiyo.channel.component.profile.profilecard.helper.ProfileCardStatistics;
import com.yy.hiyo.channel.component.profile.profilecard.widget.HorFunctionListView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ProfileCardLiteBrowserView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ProfileCardOperationView;
import com.yy.hiyo.channel.gift.IGiftPanelActService;
import com.yy.hiyo.channel.gift.ProfileCpData;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.webservice.WebEnvSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbsProfileCardManager
implements ViewProvider,
ISeatUpdateListener,
INotify {
    private static final String TAG = "AbsProfileCardManager";
    protected Context mContext;
    protected ProfileCardData mBaseData;
    protected ProfileCardDialog mProfileCardDialog;
    private IBaseCallback mBaseCallback;
    protected SeatUpdateNotifier mSeatUpdateNotifier;
    protected IDataProvider mDataProvider;
    protected DialogLinkManager mDialogLinkManager;
    protected Boolean mCurrMicClosed = null;
    private Boolean mCurrVideoClosed = null;
    protected final MicStatus mMicStatus = new MicStatus();
    protected UserInfoKS mUserInfo;
    protected FollowView mFollowBtnView;
    protected ProfileCardOperationView mMicOperationView;
    protected ProfileCardLiteBrowserView mSelfFollowingView;
    protected ProfileCardLiteBrowserView mSelfFansView;
    protected ProfileCardOperationView mVideoOperationView;
    protected ProfileCardOperationView mFlipOperationView;
    private boolean hasShake;
    public static final String AVATAR_SHAKE_TIMES = "AVATAR_SHAKE_TIMES";

    public AbsProfileCardManager(@NonNull Context context, @NonNull ProfileCardData data2) {
        this.mContext = context;
        this.mBaseData = data2;
        this.mMicStatus.updateSeatStatus(data2.seatStatus);
        this.mDialogLinkManager = new DialogLinkManager(context);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
    }

    public void setBaseCallback(IBaseCallback baseCallback) {
        this.mBaseCallback = baseCallback;
    }

    public void setSeatUpdateNotifier(SeatUpdateNotifier seatUpdateNotifier) {
        this.mSeatUpdateNotifier = seatUpdateNotifier;
    }

    public void setDataProvider(IDataProvider dataProvider) {
        this.mDataProvider = dataProvider;
    }

    public void show() {
        if (this.mProfileCardDialog != null) {
            this.close();
        }
        this.mProfileCardDialog = new ProfileCardDialog(this.mContext, this, new DialogUiCallback(){

            @Override
            public void onAvatarClick() {
                if (AbsProfileCardManager.this.mBaseCallback != null) {
                    AbsProfileCardManager.this.mBaseCallback.onAvatarClick(AbsProfileCardManager.this.mBaseData.uid);
                    if (AbsProfileCardManager.this.hasShake) {
                        AbsProfileCardManager.this.hasShake = false;
                        MLog.info((Object)AbsProfileCardManager.TAG, (String)"onAvatarClick shake", (Object[])new Object[0]);
                        FollowStatisHelper.reportAvatarShakeClick((long)AccountUtil.getUid(), (long)AbsProfileCardManager.this.mBaseData.uid, (String)AbsProfileCardManager.this.mBaseData.channelId);
                        SettingFlags.setIntValue((String)AbsProfileCardManager.AVATAR_SHAKE_TIMES, (int)2);
                    }
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onMentioned() {
                if (AbsProfileCardManager.this.mBaseCallback != null) {
                    AbsProfileCardManager.this.mBaseCallback.onMentioned(AbsProfileCardManager.this.mUserInfo);
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onOutsideClick() {
                AbsProfileCardManager.this.close();
            }

            @Override
            public void onMedalClick(int id2) {
                if (AbsProfileCardManager.this.mBaseCallback != null && AbsProfileCardManager.this.mBaseCallback.onMedalClick(id2, AbsProfileCardManager.this.mUserInfo.uid)) {
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onGoldBeanClick() {
                if (AbsProfileCardManager.this.mBaseCallback != null) {
                    AbsProfileCardManager.this.mBaseCallback.onGoldBeanClick();
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onMedalsClick(String url) {
                if (AbsProfileCardManager.this.mBaseCallback != null) {
                    AbsProfileCardManager.this.mBaseCallback.onMedalsClick(AbsProfileCardManager.this.mBaseData.uid, url);
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onAnchorLevelClick() {
                if (AbsProfileCardManager.this.mBaseCallback != null) {
                    AbsProfileCardManager.this.mBaseCallback.onAnchorLevelClick(AbsProfileCardManager.this.mBaseData.uid);
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onGiftWallClick(String jumpUrl) {
                if (AbsProfileCardManager.this.mBaseCallback != null) {
                    AbsProfileCardManager.this.mBaseCallback.onGiftWallClick(jumpUrl);
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onFamilyLevelClick(String fid) {
                if (AbsProfileCardManager.this.mBaseCallback != null) {
                    AbsProfileCardManager.this.mBaseCallback.onFamilyLevelClick(fid);
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onFansGroupClick(FansGroupData data2) {
                if (AbsProfileCardManager.this.mBaseCallback != null) {
                    AbsProfileCardManager.this.mBaseCallback.onFansGroupClick(data2);
                    AbsProfileCardManager.this.close();
                }
            }

            @Override
            public void onAvatarGuideShow() {
                AbsProfileCardManager.this.hasShake = true;
                int count = SettingFlags.getIntValue((String)AbsProfileCardManager.AVATAR_SHAKE_TIMES, (int)0);
                MLog.info((Object)AbsProfileCardManager.TAG, (String)("onAvatarGuideShow() count = " + ++count), (Object[])new Object[0]);
                SettingFlags.setIntValue((String)AbsProfileCardManager.AVATAR_SHAKE_TIMES, (int)count);
                FollowStatisHelper.reportAvatarShakeGuideShow((long)AccountUtil.getUid(), (long)AbsProfileCardManager.this.mBaseData.uid, (String)AbsProfileCardManager.this.mBaseData.channelId);
            }

            @Override
            public void noNoAgeSexClick() {
                AbsProfileCardManager.this.mDialogLinkManager.dismissDialog();
                MsgDispatcher.getInstance().sendMessage(UserMsgDef.OPEN_WINDOW_EDIT_PROFILE);
                ProfileCardStatistics.INSTANCE.reportNoAgeClick();
            }
        });
        this.mDialogLinkManager.showDialog((BaseDialog)this.mProfileCardDialog);
    }

    public void close() {
        if (this.mProfileCardDialog != null) {
            this.mDialogLinkManager.dismissAndReleaseDialog();
        }
        this.mProfileCardDialog = null;
    }

    @Override
    public void onViewInit() {
        this.fetchData();
        this.onBindData();
    }

    @Override
    public void onViewDestroy() {
        this.onUnbindData();
    }

    @Override
    public boolean showOtherFollowings() {
        return this.mBaseData.uid != AccountUtil.getUid();
    }

    protected void onBindData() {
        if (this.mSeatUpdateNotifier != null) {
            this.mSeatUpdateNotifier.addListener(this);
            this.mSeatUpdateNotifier.startListen();
        }
    }

    protected void onUnbindData() {
        if (this.mSeatUpdateNotifier != null) {
            this.mSeatUpdateNotifier.stopListen();
        }
    }

    @Override
    public List<HorFunctionListView.ViewItem> createLiteBrowserViews() {
        ArrayList<HorFunctionListView.ViewItem> itemViews = new ArrayList<HorFunctionListView.ViewItem>(2);
        if (this.mBaseData.uid == AccountUtil.getUid()) {
            this.mSelfFansView = new ProfileCardLiteBrowserView(this.mContext);
            this.mSelfFansView.updateText(R.string.title_profile_card_fans);
            HorFunctionListView.ViewItem fansItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mSelfFansView, -1, -2).build();
            fansItem.getView().setOnClickListener(v -> {
                if (this.mBaseCallback != null) {
                    this.close();
                    this.mBaseCallback.onFansListClicked(this.mBaseData.uid);
                }
            });
            itemViews.add(fansItem);
            this.mSelfFollowingView = new ProfileCardLiteBrowserView(this.mContext);
            this.mSelfFollowingView.updateText(R.string.title_profile_card_followers);
            HorFunctionListView.ViewItem followItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mSelfFollowingView, -1, -2).build();
            followItem.getView().setOnClickListener(v -> {
                if (this.mBaseCallback != null) {
                    this.close();
                    this.mBaseCallback.onFollowingListClicked(this.mBaseData.uid);
                }
            });
            itemViews.add(followItem);
        }
        return itemViews;
    }

    protected void fetchData() {
        this.fetchUserInfo();
        if (this.mBaseData.uid != AccountUtil.getUid()) {
            this.fetchOtherHeadFrame();
        }
    }

    private void fetchUserInfo() {
        UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(this.mBaseData.uid);
        if (userInfoKS.ver > 0L) {
            this.updateUserInfo(userInfoKS);
        } else {
            ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).requestUserInfoFromServer(this.mBaseData.uid, new OnKSProfileListCallback(){

                public void onUISuccess(@NonNull List<UserInfoKS> userInfo) {
                    if (FP.empty(userInfo)) {
                        MLog.error((Object)AbsProfileCardManager.TAG, (String)"fetchUserInfo getUserInfo error, null data", (Object[])new Object[0]);
                        return;
                    }
                    AbsProfileCardManager.this.updateUserInfo(userInfo.get(0));
                }

                public void onError(@NonNull String reason, long code) {
                    MLog.error((Object)AbsProfileCardManager.TAG, (String)"fetchData getUserInfo error", (Object[])new Object[0]);
                }
            });
        }
    }

    public void updateUserInfo(UserInfoKS userInfo) {
        this.mUserInfo = userInfo;
        if (this.mProfileCardDialog == null) {
            return;
        }
        this.mProfileCardDialog.updateUserInfo(userInfo);
        this.mProfileCardDialog.updateRole(this.mBaseData.isTargetAnchor ? this.mBaseData.role : this.mBaseData.targetRoleSession.getRole(), this.mBaseData.isTargetMember, this.mBaseData.isTargetAnchor);
    }

    public UserInfoKS getUserInfo() {
        return this.mUserInfo;
    }

    private void fetchOtherHeadFrame() {
        if (this.mDataProvider == null) {
            return;
        }
        IHonorService honorService = (IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class);
        honorService.getSingleHeadFrame(this.mBaseData.uid, new OnGetHeadFrameCallback(){

            public void onGetHeadFrameSuccess(List<Integer> list2) {
                if (!FP.empty(list2)) {
                    AbsProfileCardManager.this.updateHeadFrame(list2.get(0));
                }
            }

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)AbsProfileCardManager.TAG, (String)"fetchOtherHeadFrame error, uid=%d", (Object[])new Object[]{AbsProfileCardManager.this.mBaseData.uid});
            }

            public void onResponseError(int id2, String message, String response) {
                MLog.error((Object)AbsProfileCardManager.TAG, (String)"fetchOtherHeadFrame error, uid=%d, msg=%s", (Object[])new Object[]{AbsProfileCardManager.this.mBaseData.uid, message});
            }
        });
    }

    @Override
    public LeftAction createLeftAction() {
        LeftAction leftAction = new LeftAction();
        if (this.mBaseData.uid == AccountUtil.getUid()) {
            leftAction.isShow = false;
        } else if ((FP.empty((CharSequence)this.mBaseData.targetChannelId) || this.mBaseData.targetChannelId.equals(this.mBaseData.channelId)) && (this.mBaseData.mineRoleSession.getRole() >= 10 && this.mBaseData.mineRoleSession.getRole() > this.mBaseData.targetRoleSession.getRole() || this.mBaseData.isMeAnchor && (this.mBaseData.targetRoleSession.getRole() <= 5 || this.mBaseData.mineRoleSession.getRole() > this.mBaseData.targetRoleSession.getRole()))) {
            leftAction.isShow = true;
            leftAction.icon = R.drawable.icon_profile_setting;
            leftAction.clickListener = v -> {
                if (this.mBaseCallback != null) {
                    this.mBaseCallback.onSetting(this.mBaseData.uid, this.mBaseData.targetChannelId, this.mBaseData.targetChannelOwnerUid, this.mBaseData.roomSource);
                    this.close();
                }
            };
        } else {
            leftAction.isShow = true;
            leftAction.icon = R.drawable.icon_voice_room_profile_card_report;
            leftAction.clickListener = v -> {
                if (this.mBaseCallback != null) {
                    this.mBaseCallback.onReport(this.mBaseData.uid, this.mBaseData.targetChannelId, this.mBaseData.targetChannelOwnerUid);
                    this.close();
                }
            };
        }
        return leftAction;
    }

    protected void doFollowOrUnFollowOther(RelationInfo followStatus) {
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        if (!followStatus.isFollow()) {
            this.requestFollow();
        } else {
            this.requestUnFollow();
        }
    }

    protected void fetchCpInfo() {
        ((IGiftPanelActService)ServiceManagerProxy.getService(IGiftPanelActService.class)).getProfileCardCpLevel(this.mBaseData.uid, this.mBaseData.mode, (ICommonCallback)new ICommonCallback<ProfileCpData>(){

            public void onSuccess(ProfileCpData profileCpData, Object ... ext) {
                if (AbsProfileCardManager.this.mProfileCardDialog != null) {
                    if (profileCpData.isShow()) {
                        ChannelTrack.INSTANCE.onCpCardShow();
                    }
                    AbsProfileCardManager.this.mProfileCardDialog.updateCpInfo(profileCpData, AbsProfileCardManager.this.mBaseData.channelId, AbsProfileCardManager.this.mBaseData.mode);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
            }
        });
    }

    protected void requestFamilyInfo(long uid, final ChannelInfo channelInfo) {
        ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(channelInfo.getChannelId()).getFamilyService().getFamilyByUid(uid, (ICommonCallback)new ICommonCallback<FamilyInfoBean>(){

            public void onSuccess(FamilyInfoBean familyInfoBean, Object ... ext) {
                if (FP.empty((CharSequence)familyInfoBean.getName())) {
                    if (AbsProfileCardManager.this.mProfileCardDialog != null) {
                        AbsProfileCardManager.this.mProfileCardDialog.hideFamilyInfo();
                    }
                } else if (AbsProfileCardManager.this.mProfileCardDialog != null) {
                    AbsProfileCardManager.this.mProfileCardDialog.updateFamilyInfo(channelInfo, familyInfoBean);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                if (AbsProfileCardManager.this.mProfileCardDialog != null) {
                    AbsProfileCardManager.this.mProfileCardDialog.hideFamilyInfo();
                }
            }
        });
    }

    protected void requestTeamUpInfo(final long uid, final IChannel channel) {
        if (channel.getTeamUpService() != null && channel.getTeamUpService().getGameInfo() != null) {
            ((ITeamUpGameService)ServiceManagerProxy.getService(ITeamUpGameService.class)).getGameCardInfoList(uid, (ICommonCallback)new ICommonCallback<Boolean>(){

                public void onSuccess(Boolean aBoolean, Object ... ext) {
                    List gameList;
                    if (aBoolean.booleanValue() && AbsProfileCardManager.this.mProfileCardDialog != null && (gameList = (List)((ITeamUpGameService)ServiceManagerProxy.getService(ITeamUpGameService.class)).data().getGameInfoMap().get(uid)) != null) {
                        AbsProfileCardManager.this.mProfileCardDialog.updateTeamUpInfo(gameList, new TeamUpCardCallback(){

                            @Override
                            public void onClick(String gid) {
                                WebEnvSettings settings = new WebEnvSettings();
                                settings.hideMinimizedRoomPanel = true;
                                settings.hideTitleBar = true;
                                settings.url = UriProvider.getTeamUpGameInfoDetailUrl((String)gid, (String)((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByIdWithType(gid, GameInfoSource.IN_VOICE_ROOM).getGname(), (Boolean)(AccountUtil.getUid() != uid ? 1 : 0), (Long)uid);
                                ((IWebService)ServiceManagerProxy.getService(IWebService.class)).loadUrl(settings);
                                AbsProfileCardManager.this.reportTeamUpMiniCardClick(channel);
                                AbsProfileCardManager.this.close();
                            }
                        });
                        AbsProfileCardManager.this.reportTeamUpMiniCardShow(channel);
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                }
            });
        }
    }

    protected void requestChannelMemberInfo(final String cid, long uid, IChannel channel) {
        channel.getChannelMemberService().fetchChannelMemberInfoByUid(cid, uid, new IChannelMemberCallback(){

            public void onSuccess(@NotNull ChannelUser user) {
                if (AbsProfileCardManager.this.mProfileCardDialog != null) {
                    IChannel iChannel;
                    IChannelCenterService channelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
                    if (channelCenterService != null && (iChannel = channelCenterService.getChannel(cid)) != null && iChannel.getDataService().getCacheDetail() != null) {
                        user.isShowChannelNick = iChannel.getDataService().getCacheDetail().baseInfo.isShowChannelNick;
                    }
                    MLog.info((Object)AbsProfileCardManager.TAG, (String)"requestChannelMemberInfo cid:%s, channelUser:%s", (Object[])new Object[]{cid, user});
                    AbsProfileCardManager.this.mProfileCardDialog.updateChannelMemberInfo(user);
                }
            }

            public void onFail(long code, @Nullable String msg) {
                if (AbsProfileCardManager.this.mProfileCardDialog != null) {
                    AbsProfileCardManager.this.mProfileCardDialog.updateChannelMemberInfo(null);
                }
            }
        });
    }

    private void requestUnFollow() {
        if (this.mBaseData != null) {
            String postToken = this.getPostToken();
            FollowStatisHelper.reportUnfollowClickWithToken((long)this.mBaseData.uid, (String)this.mBaseData.channelId, (int)1, (String)postToken, (String)"");
        }
        if (this.mUserInfo == null) {
            return;
        }
        if (this.mFollowBtnView.getMIsNewUi()) {
            if (this.mFollowBtnView != null) {
                this.mFollowBtnView.requestUnFollow();
            }
            this.reportUnFollowClick();
        } else {
            ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).cancelFollowVerify(this.mUserInfo.uid, new OkCancelDialogListener(){

                public void onCancel() {
                    AbsProfileCardManager.this.reportUnFollowCancel();
                }

                public void onOk() {
                    if (AbsProfileCardManager.this.mFollowBtnView != null) {
                        AbsProfileCardManager.this.mFollowBtnView.requestUnFollow();
                    }
                    AbsProfileCardManager.this.reportUnFollowClick();
                }
            });
            FollowStatisHelper.reportUnfollowPop();
        }
    }

    private void reportUnFollowCancel() {
        if (this.mBaseData != null) {
            long targetUid;
            int enterType = 1;
            if (this.mBaseData.enterChannelEntry == 30 && this.mBaseData.enterParamExtra != null && this.mBaseData.enterParamExtra.containsKey("home_search_result_uid") && (targetUid = ((Long)this.mBaseData.enterParamExtra.get("home_search_result_uid")).longValue()) == this.mBaseData.uid) {
                enterType = 6;
            }
            FollowStatisHelper.reportUnfollowCancelClick((long)this.mBaseData.uid, (String)this.mBaseData.channelId, (int)enterType);
        }
    }

    private void requestFollow() {
        int enterType = 1;
        if (this.mBaseData != null) {
            long targetUid;
            if (this.mBaseData.enterChannelEntry == 30 && this.mBaseData.enterParamExtra != null && this.mBaseData.enterParamExtra.containsKey("home_search_result_uid") && (targetUid = ((Long)this.mBaseData.enterParamExtra.get("home_search_result_uid")).longValue()) == this.mBaseData.uid) {
                enterType = 6;
            }
            LinkedHashMap<String, String> ext = new LinkedHashMap<String, String>();
            Object obj = null;
            if (this.mBaseData.enterParamExtra != null) {
                obj = this.mBaseData.enterParamExtra.get("from_recommend_info");
            }
            if (obj instanceof RecommendEnterData) {
                RecommendEnterData recommendEnterData = (RecommendEnterData)obj;
                ext.put("token", recommendEnterData.getToken());
            } else {
                String postId = this.getPostId();
                if (!FP.empty((CharSequence)postId) && this.mBaseData.uid == this.getPosterUid()) {
                    ext.put("token", this.getPostToken());
                    ext.put("post_id", postId);
                    ext.put("send_post_uid", this.getPosterUid().toString());
                    ext.put("post_pg_source", this.getPostPgSource());
                }
            }
            ext.put("mini_profile_card_source", this.mBaseData.from.getValue() + "");
            FollowStatisHelper.reportFollowClickWithExt((long)this.mBaseData.uid, (String)this.mBaseData.channelId, (int)enterType, ext);
        }
        if (this.mFollowBtnView != null) {
            this.mFollowBtnView.requestFollow(FollowerUtils.INSTANCE.enterType2ePath(enterType + ""));
        }
    }

    private void reportUnFollowClick() {
        if (this.mBaseData != null) {
            long targetUid;
            int enterType = 1;
            if (this.mBaseData.enterChannelEntry == 30 && this.mBaseData.enterParamExtra != null && this.mBaseData.enterParamExtra.containsKey("home_search_result_uid") && (targetUid = ((Long)this.mBaseData.enterParamExtra.get("home_search_result_uid")).longValue()) == this.mBaseData.uid) {
                enterType = 6;
            }
            String postToken = this.getPostToken();
            FollowStatisHelper.reportUnfollowOkClickWithToken((long)this.mBaseData.uid, (String)this.mBaseData.channelId, (int)enterType, (String)postToken, (String)"");
        }
    }

    private void reportTeamUpMiniCardShow(IChannel channel) {
        if (channel != null) {
            String gid = "";
            String role = "";
            if (channel.getPluginService() != null && channel.getPluginService().getCurPluginData() != null && channel.getPluginService().getCurPluginData().getPluginId() != null) {
                gid = channel.getPluginService().getCurPluginData().getPluginId();
            }
            if (channel.getRoleService() != null) {
                role = String.valueOf(channel.getRoleService().getMyRoleCache());
            }
            FollowStatisHelper.reportMiniGameCardShow((String)channel.getChannelId(), (String)gid, (String)role);
        }
    }

    private void reportTeamUpMiniCardClick(IChannel channel) {
        if (channel != null) {
            String gid = "";
            String role = "";
            if (channel.getPluginService() != null && channel.getPluginService().getCurPluginData() != null && channel.getPluginService().getCurPluginData().getPluginId() != null) {
                gid = channel.getPluginService().getCurPluginData().getPluginId();
            }
            if (channel.getRoleService() != null) {
                role = String.valueOf(channel.getRoleService().getMyRoleCache());
            }
            FollowStatisHelper.reportMiniGameCardClick((String)channel.getChannelId(), (String)gid, (String)role);
        }
    }

    private String getPostToken() {
        MLog.debug((Object)TAG, (String)("getPostToken= " + this.mBaseData.enterParamExtra.containsKey("post_token")), (Object[])new Object[0]);
        if (this.mBaseData.enterParamExtra != null && this.mBaseData.enterParamExtra.get("post_token") != null) {
            return this.mBaseData.enterParamExtra.get("post_token").toString();
        }
        return "";
    }

    private String getPostId() {
        MLog.debug((Object)TAG, (String)("getPostToken= " + this.mBaseData.enterParamExtra.containsKey("post_id")), (Object[])new Object[0]);
        if (this.mBaseData.enterParamExtra != null && this.mBaseData.enterParamExtra.get("post_id") != null) {
            return this.mBaseData.enterParamExtra.get("post_id").toString();
        }
        return "";
    }

    private String getPostPgSource() {
        if (this.mBaseData.enterParamExtra != null && this.mBaseData.enterParamExtra.get("post_page_source") != null) {
            return this.mBaseData.enterParamExtra.get("post_page_source").toString();
        }
        return "";
    }

    private Long getPosterUid() {
        Object value;
        HashMap<String, Object> param2 = this.mBaseData.enterParamExtra;
        if (param2 != null && param2.containsKey("post_creator_id") && (value = param2.get("post_creator_id")) instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    protected HorFunctionListView.ViewItem createOperationViewItem(@DrawableRes int icon, @StringRes int text, View.OnClickListener clickListener) {
        ProfileCardOperationView operationView = new ProfileCardOperationView(this.mContext);
        operationView.updateIcon(icon);
        operationView.updateText(text);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, ResourceUtils.getDimen((int)R.dimen.profile_card_operation_view_height));
        HorFunctionListView.ViewItem viewItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)operationView, lp).build();
        viewItem.getView().setOnClickListener(clickListener);
        return viewItem;
    }

    protected HorFunctionListView.ViewItem createMicOperationViewItem() {
        this.mMicOperationView = new ProfileCardOperationView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, ResourceUtils.getDimen((int)R.dimen.profile_card_operation_view_height));
        HorFunctionListView.ViewItem micViewItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mMicOperationView, lp).build();
        micViewItem.getView().setOnClickListener(v -> {
            if (this.mBaseData.uid == AccountUtil.getUid()) {
                if (this.mMicStatus.isMicForbidden()) {
                    this.close();
                    ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.tips_open_room_mic_forbid), (int)0);
                } else if (this.mMicStatus.isMicClosedBySelf()) {
                    this.mBaseCallback.onChangeMic(this.mBaseData.uid, true);
                } else {
                    this.mBaseCallback.onChangeMic(this.mBaseData.uid, false);
                }
            } else if (this.mMicStatus.isMicForbidden()) {
                this.mBaseCallback.onChangeMic(this.mBaseData.uid, true);
            } else {
                this.mBaseCallback.onChangeMic(this.mBaseData.uid, false);
            }
        });
        this.updateMicStatus();
        return micViewItem;
    }

    protected void updateMicOperationView(boolean micClosed) {
        if (this.mMicOperationView == null) {
            return;
        }
        if (micClosed) {
            this.mMicOperationView.updateIcon(R.drawable.icon_profile_card_turn_on_mic);
            this.mMicOperationView.updateText(R.string.btn_profile_card_bottom_mic_open);
        } else {
            this.mMicOperationView.updateIcon(R.drawable.icon_profile_card_turn_off_mic);
            this.mMicOperationView.updateText(R.string.btn_profile_card_bottom_mic_close);
        }
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        SeatUser currSeatUser = null;
        if (seatUserList != null) {
            for (SeatUser seatUser : seatUserList) {
                if (seatUser.uid != this.mBaseData.uid) continue;
                currSeatUser = seatUser;
                break;
            }
        }
        if (currSeatUser != null) {
            this.mMicStatus.updateSeatStatus(currSeatUser.status);
        } else {
            this.mMicStatus.updateSeatStatus(0L);
        }
        this.updateMicStatus();
        this.updateVideoStatus();
        this.updateFlipStatus();
    }

    protected void updateMicStatus() {
        boolean isMicClosedNow = this.mBaseData.uid == AccountUtil.getUid() ? this.mMicStatus.isMicClosedBySelf() : this.mMicStatus.isMicForbidden();
        if (this.mCurrMicClosed == null || this.mCurrMicClosed != isMicClosedNow) {
            this.updateMicOperationView(isMicClosedNow);
            this.mCurrMicClosed = isMicClosedNow;
        }
    }

    protected void updateHeadFrame(int id2) {
        String url = ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(id2);
        if (!FP.empty((CharSequence)url) && this.mProfileCardDialog != null) {
            this.mProfileCardDialog.updateHeadFrame(url);
        }
    }

    protected HorFunctionListView.ViewItem createVideoOperationViewItem() {
        this.mVideoOperationView = new ProfileCardOperationView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, ResourceUtils.getDimen((int)R.dimen.profile_card_operation_view_height));
        HorFunctionListView.ViewItem videoViewItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mVideoOperationView, lp).build();
        videoViewItem.getView().setOnClickListener(v -> {
            if (this.mBaseData.uid == AccountUtil.getUid()) {
                if (this.mMicStatus.isVideoForbidden()) {
                    this.close();
                    ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.tips_open_video_forbid), (int)0);
                } else if (this.mMicStatus.isVideoClosedBySelf()) {
                    this.mBaseCallback.onChangeVideo(this.mBaseData.uid, true);
                } else {
                    this.mBaseCallback.onChangeVideo(this.mBaseData.uid, false);
                }
            } else if (this.mMicStatus.isVideoForbidden()) {
                this.mBaseCallback.onChangeVideo(this.mBaseData.uid, true);
            } else {
                this.mBaseCallback.onChangeVideo(this.mBaseData.uid, false);
            }
            this.close();
        });
        this.updateVideoStatus();
        return videoViewItem;
    }

    protected void updateVideoStatus() {
        boolean isVideoClosedNow = SeatStatusUtils.isVideoForbidden((long)this.mMicStatus.getSeatStatus()) ? true : SeatStatusUtils.isVideoClose((long)this.mMicStatus.getSeatStatus());
        if (this.mCurrVideoClosed == null || this.mCurrVideoClosed != isVideoClosedNow) {
            this.updateVideoOperationView(isVideoClosedNow);
            this.mCurrVideoClosed = isVideoClosedNow;
        }
    }

    protected void updateVideoOperationView(boolean closed) {
        if (this.mVideoOperationView == null) {
            return;
        }
        if (closed) {
            this.mVideoOperationView.updateIcon(R.drawable.icon_profile_card_video_off);
            this.mVideoOperationView.updateText(R.string.title_video_off);
        } else {
            this.mVideoOperationView.updateIcon(R.drawable.icon_profile_card_video_on);
            this.mVideoOperationView.updateText(R.string.title_video_on);
        }
    }

    protected HorFunctionListView.ViewItem createFlipOperationViewItem() {
        this.mFlipOperationView = new ProfileCardOperationView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, ResourceUtils.getDimen((int)R.dimen.profile_card_operation_view_height));
        HorFunctionListView.ViewItem flipViewItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mFlipOperationView, lp).build();
        flipViewItem.getView().setOnClickListener(v -> {
            if (this.mBaseData.uid == AccountUtil.getUid() && this.mBaseCallback != null && SeatStatusUtils.isVideoOpen((long)this.mMicStatus.getSeatStatus())) {
                this.close();
                this.mBaseCallback.onCameraFlip(this.mBaseData.uid);
            }
        });
        this.updateFlipStatus();
        return flipViewItem;
    }

    protected void updateFlipStatus() {
        boolean isVideoClosedNow = SeatStatusUtils.isVideoForbidden((long)this.mMicStatus.getSeatStatus()) ? true : SeatStatusUtils.isVideoClose((long)this.mMicStatus.getSeatStatus());
        this.updateFlipOperationView(isVideoClosedNow);
    }

    protected void updateFlipOperationView(boolean closed) {
        if (this.mFlipOperationView == null) {
            return;
        }
        if (closed) {
            this.mFlipOperationView.updateIcon(R.drawable.icon_profile_card_flip_disable);
        } else {
            this.mFlipOperationView.updateIcon(R.drawable.icon_profile_card_flip);
        }
        this.mFlipOperationView.updateText(R.string.btn_bottom_add_flip);
    }

    @Override
    public ProfileCardData getProfileCardData() {
        return this.mBaseData;
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT && this.mProfileCardDialog != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    @Override
    public boolean avatarNeedShake() {
        return false;
    }
}

