/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.entranceshow.data;

import com.yy.appbase.account.AccountUtil;
import com.yy.hiyo.channel.component.profile.entranceshow.EntranceShowManager;
import com.yy.hiyo.channel.component.profile.entranceshow.data.EntranceShowConfigBean;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.family.CallEffectStyle;
import net.ihago.money.api.family.FamilyCallNotify;
import net.ihago.money.api.inshow.InshowStartNotify;
import net.ihago.money.api.usercard.SimpleCardInfo;

public class EntranceShowNotify {
    public static final int FAMILY = 1;
    public static final int THEME_ROOM = 2;
    public long uid;
    public String userName;
    public String avatar;
    public int inShowIds;
    public int medalIds;
    public boolean isFamily = false;
    public String effectUrl;
    public List<com.yy.hiyo.channel.base.bean.SimpleCardInfo> cardInfoList;
    public int familyEffectStyle = CallEffectStyle.CALL_EFFECT_STYLE_SMALL.getValue();
    private int discardPriority = -1;
    public int businessType = 0;

    public static EntranceShowNotify from(InshowStartNotify inshowStartNotify) {
        EntranceShowNotify entranceShowNotify = new EntranceShowNotify();
        entranceShowNotify.isFamily = false;
        entranceShowNotify.uid = inshowStartNotify.uid;
        entranceShowNotify.userName = inshowStartNotify.name;
        entranceShowNotify.inShowIds = inshowStartNotify.inshow_id;
        entranceShowNotify.medalIds = inshowStartNotify.medal_id;
        entranceShowNotify.avatar = inshowStartNotify.avatar;
        ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo> list2 = new ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo>();
        for (SimpleCardInfo card : inshowStartNotify.cards) {
            list2.add(new com.yy.hiyo.channel.base.bean.SimpleCardInfo(card.card_type.intValue(), card.level.intValue(), card.name, card.fid, card.sub_type));
        }
        entranceShowNotify.cardInfoList = list2;
        return entranceShowNotify;
    }

    public static EntranceShowNotify from(FamilyCallNotify notify2) {
        EntranceShowNotify entranceShowNotify = new EntranceShowNotify();
        entranceShowNotify.isFamily = true;
        entranceShowNotify.businessType = 1;
        entranceShowNotify.avatar = notify2.family_avatar;
        entranceShowNotify.userName = notify2.family_name;
        entranceShowNotify.effectUrl = notify2.new_effect_url;
        entranceShowNotify.familyEffectStyle = notify2.effect_style.getValue();
        return entranceShowNotify;
    }

    public static EntranceShowNotify from(String svgaUrl) {
        EntranceShowNotify entranceShowNotify = new EntranceShowNotify();
        entranceShowNotify.businessType = 2;
        entranceShowNotify.effectUrl = svgaUrl;
        return entranceShowNotify;
    }

    public int getDiscardPriority() {
        EntranceShowConfigBean.ShowType showType;
        if (this.discardPriority >= 0) {
            return this.discardPriority;
        }
        this.discardPriority = this.isFamily ? (this.familyEffectStyle == CallEffectStyle.CALL_EFFECT_STYLE_SMALL.getValue() ? 2 : (this.familyEffectStyle == CallEffectStyle.CALL_EFFECT_STYLE_MIDDLE.getValue() ? 3 : (this.familyEffectStyle == CallEffectStyle.CALL_EFFECT_STYLE_BIG.getValue() ? 4 : 0))) : ((showType = EntranceShowManager.INSTANCE.getShowType(this.inShowIds)) == EntranceShowConfigBean.ShowType.ShowTypeSide ? 1 : (showType == EntranceShowConfigBean.ShowType.ShowTypeBigArea ? 2 : (showType == EntranceShowConfigBean.ShowType.ShowTypeMount ? 3 : (showType == EntranceShowConfigBean.ShowType.ShowTypeBigMount ? 4 : 0))));
        if (this.uid == AccountUtil.getUid()) {
            this.discardPriority += 100;
        }
        return this.discardPriority;
    }

    public String toString() {
        return "EntranceShowNotify=[uid=" + this.uid + ",inShowIds=" + this.inShowIds + ",medalIds=" + this.medalIds + "]";
    }
}

