/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.entranceshow.data;

import android.util.SparseArray;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.inshow.InShowResourceUrl;
import net.ihago.money.api.inshow.InshowConf;

public class EntranceShowConfigBean {
    private int id;
    private InshowType inshowType;
    private int validSecond;
    private String url;
    private String mirrorUrl;
    private int height;
    private int width;
    private String uri;
    private ShowType showType;
    private String backupUrl;
    private String backgroundUrl;
    private SparseArray<InShowResourceUrl> resourceUrls = new SparseArray(4);

    public EntranceShowConfigBean(Builder builder) {
        this.id = builder.id;
        this.inshowType = builder.inshowType;
        this.validSecond = builder.validSecond;
        this.url = builder.url;
        this.mirrorUrl = builder.mirrorUrl;
        this.height = builder.height;
        this.width = builder.width;
        this.uri = builder.uri;
        this.backupUrl = builder.backupUrl;
        this.backgroundUrl = builder.backgroundUrl;
        this.showType = builder.showType;
        if (builder.resourceUrls != null) {
            for (InShowResourceUrl item : builder.resourceUrls) {
                this.resourceUrls.put(item.resource_type.intValue(), (Object)item);
            }
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static EntranceShowConfigBean parse(InshowConf inshowConf) {
        if (inshowConf != null) {
            return EntranceShowConfigBean.newBuilder().id(inshowConf.id).inshowType(InshowType.to(inshowConf.getInshow_typeValue())).validSecond(inshowConf.valid_secs).url(inshowConf.url).mirrorUrl(inshowConf.mirror_url).height(inshowConf.height).width(inshowConf.width).uri(inshowConf.uri).backupUrl(inshowConf.backup_url).backgroundUrl(inshowConf.background_url).showType(ShowType.to(inshowConf.getShow_typeValue())).resourceUrls(inshowConf.resource_urls).build();
        }
        return null;
    }

    public static List<EntranceShowConfigBean> parseList(List<InshowConf> inshowConfList) {
        if (inshowConfList == null || inshowConfList.size() == 0) {
            return null;
        }
        ArrayList<EntranceShowConfigBean> list2 = new ArrayList<EntranceShowConfigBean>(inshowConfList.size());
        for (int i = 0; i < inshowConfList.size(); ++i) {
            EntranceShowConfigBean bean2 = EntranceShowConfigBean.parse(inshowConfList.get(i));
            list2.add(bean2);
        }
        return list2;
    }

    public int getId() {
        return this.id;
    }

    public InshowType getInshowType() {
        return this.inshowType;
    }

    public int getValidSecond() {
        return this.validSecond;
    }

    public String getUrl() {
        return this.url;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String getUri() {
        return this.uri;
    }

    public String getBackupUrl() {
        return this.backupUrl;
    }

    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    public String getMirrorUrl() {
        return this.mirrorUrl;
    }

    public ShowType getShowType() {
        return this.showType;
    }

    public SparseArray<InShowResourceUrl> getResourceUrls() {
        return this.resourceUrls;
    }

    public static enum ShowType {
        ShowTypeNone,
        ShowTypeSide,
        ShowTypeBigArea,
        ShowTypeMount,
        ShowTypeBigMount,
        ShowTypeFullScreenMount,
        ShowTypeDynamicInShow,
        ShowTypeStaticInShow;


        public static ShowType to(int type) {
            switch (type) {
                case 1: {
                    return ShowTypeSide;
                }
                case 2: {
                    return ShowTypeBigArea;
                }
                case 3: {
                    return ShowTypeMount;
                }
                case 4: {
                    return ShowTypeBigMount;
                }
                case 5: {
                    return ShowTypeFullScreenMount;
                }
                case 6: {
                    return ShowTypeDynamicInShow;
                }
                case 7: {
                    return ShowTypeStaticInShow;
                }
            }
            return ShowTypeNone;
        }
    }

    public static enum InshowType {
        NONE,
        ACTIVITY;


        public static InshowType to(int type) {
            switch (type) {
                case 1: {
                    return ACTIVITY;
                }
            }
            return NONE;
        }
    }

    public static class Builder {
        int id;
        InshowType inshowType;
        int validSecond;
        String url;
        String mirrorUrl;
        int height;
        int width;
        String uri;
        String backupUrl;
        ShowType showType;
        String backgroundUrl;
        List<InShowResourceUrl> resourceUrls;

        public Builder id(int id2) {
            this.id = id2;
            return this;
        }

        public Builder inshowType(InshowType inshowType) {
            this.inshowType = inshowType;
            return this;
        }

        public Builder validSecond(int validSecond) {
            this.validSecond = validSecond;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder mirrorUrl(String mirrorUrl) {
            this.mirrorUrl = mirrorUrl;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder backupUrl(String uri) {
            this.backupUrl = uri;
            return this;
        }

        public Builder backgroundUrl(String uri) {
            this.backgroundUrl = uri;
            return this;
        }

        public Builder showType(ShowType showType) {
            this.showType = showType;
            return this;
        }

        public Builder resourceUrls(List<InShowResourceUrl> resourceUrls) {
            this.resourceUrls = resourceUrls;
            return this;
        }

        public EntranceShowConfigBean build() {
            return new EntranceShowConfigBean(this);
        }
    }
}

