/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.entranceshow;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.HonorBean;
import com.yy.hiyo.channel.base.bean.UserTagInfo;
import com.yy.hiyo.channel.base.bean.UserTagLocation;
import com.yy.hiyo.channel.base.widget.UserTagsLayout;
import com.yy.hiyo.channel.component.profile.entranceshow.WebPImageView;
import com.yy.hiyo.channel.component.profile.entranceshow.listener.IEntranceShowViewCallback;
import java.util.List;

public class EntranceShowView
extends YYFrameLayout {
    private static final String TAG = "EntranceShowView";
    private IEntranceShowViewCallback mShowViewCallback;
    private View mRootView;
    private WebPImageView mBgView;
    private SVGAImageView mBgSvga;
    private RoundImageView mAvatarView;
    private RecycleImageView mMedalView;
    private YYTextView mUserNameView;
    private YYTextView mTipsView;
    private ObjectAnimator mStartAnimator = null;
    private ObjectAnimator mExitAnimator = null;
    private UserTagsLayout mUserTagLayout;
    private int translationWidth = 0;

    public EntranceShowView(Context context) {
        this(context, null);
    }

    public EntranceShowView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EntranceShowView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
        this.translationWidth = ResolutionUtils.getScreenWidth((Context)context);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_entrance_show_channel, (ViewGroup)this);
        this.mRootView = this;
        this.mBgView = (WebPImageView)this.findViewById(R.id.bg_iv);
        this.mBgSvga = (SVGAImageView)this.findViewById(R.id.bg_svga);
        this.mAvatarView = (RoundImageView)this.findViewById(R.id.avatar_img);
        this.mMedalView = (RecycleImageView)this.findViewById(R.id.medal_img);
        this.mUserNameView = (YYTextView)this.findViewById(R.id.username_tv);
        this.mTipsView = (YYTextView)this.findViewById(R.id.entrance_tips_tv);
        this.mUserTagLayout = (UserTagsLayout)this.findViewById(R.id.userTagLayout);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(ResolutionUtils.dip2Px((float)270.0f), ResolutionUtils.dip2Px((float)50.0f));
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void setEntranceShowViewCallback(IEntranceShowViewCallback callback2) {
        this.mShowViewCallback = callback2;
    }

    public void updateLayoutParams(int marginTop, int marginLeft, boolean bigArea, boolean isRoundAvatar) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mRootView.getLayoutParams();
        lp.topMargin = marginTop;
        lp.leftMargin = marginLeft;
        lp.height = bigArea ? ResolutionUtils.dip2Px((float)75.0f) : ResolutionUtils.dip2Px((float)50.0f);
        this.mRootView.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (bigArea) {
            LinearLayout.LayoutParams avatarParams = (LinearLayout.LayoutParams)this.mAvatarView.getLayoutParams();
            avatarParams.width = ResolutionUtils.dip2Px((float)25.0f);
            avatarParams.height = ResolutionUtils.dip2Px((float)25.0f);
            if (isRoundAvatar) {
                this.setViewMarginStart(avatarParams, ResolutionUtils.dip2Px((float)20.0f));
            } else {
                this.setViewMarginStart(avatarParams, ResolutionUtils.dip2Px((float)15.0f));
            }
            this.mAvatarView.setLayoutParams((ViewGroup.LayoutParams)avatarParams);
            LinearLayout.LayoutParams medalParams = (LinearLayout.LayoutParams)this.mMedalView.getLayoutParams();
            this.setViewMarginStart(medalParams, ResolutionUtils.dip2Px((float)6.0f));
            this.mMedalView.setLayoutParams((ViewGroup.LayoutParams)medalParams);
            LinearLayout.LayoutParams userNameParams = (LinearLayout.LayoutParams)this.mUserNameView.getLayoutParams();
            this.setViewMarginStart(userNameParams, ResolutionUtils.dip2Px((float)6.0f));
            this.mUserNameView.setLayoutParams((ViewGroup.LayoutParams)userNameParams);
        }
        if (isRoundAvatar) {
            this.mAvatarView.setType(1);
            this.mAvatarView.setBorderPxRadius(ResolutionUtils.dip2Px((float)4.0f));
        } else {
            this.mAvatarView.setType(0);
        }
    }

    private void setViewMarginStart(LinearLayout.LayoutParams params, int marginValue) {
        if (Build.VERSION.SDK_INT >= 17) {
            params.setMarginStart(marginValue);
        } else {
            params.setMargins(marginValue, 0, 0, 0);
        }
    }

    public void updateView(String avatarUrl, String userName, final String bgUrl, HonorBean honorBean, String tips, List<UserTagInfo> userTagsFromConfig, long uid) {
        ImageLoader.loadImage((ImageView)this.mAvatarView, (String)(avatarUrl + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)0));
        if (honorBean != null && !StringUtils.isEmpty((String)honorBean.getUrl())) {
            ImageLoader.loadImage((ImageView)this.mMedalView, (String)honorBean.getUrl());
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mMedalView.getLayoutParams();
            lp.height = ResolutionUtils.dip2Px((float)(honorBean.getHeight() >> 1));
            lp.width = ResolutionUtils.dip2Px((float)(honorBean.getWidth() >> 1));
            this.mMedalView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.mMedalView.setVisibility(0);
        } else {
            this.mMedalView.setVisibility(8);
        }
        if (userTagsFromConfig == null) {
            this.mUserTagLayout.setVisibility(8);
        } else {
            this.mUserTagLayout.setData(userTagsFromConfig, UserTagLocation.LOCATION_INSHOW.getLocation(), uid, DpToPxDef.RESOLUTION_20_DP);
        }
        if (!StringUtils.isEmpty((String)bgUrl)) {
            if (bgUrl.endsWith("svga")) {
                this.mBgSvga.setVisibility(0);
                this.mBgView.setVisibility(8);
                SvgaLoader.load((SVGAImageView)this.mBgSvga, (String)bgUrl, (ISvgaLoadCallback)new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        EntranceShowView.this.mBgSvga.startAnimation();
                        EntranceShowView.this.startEnterAnim();
                    }

                    public void onFailed(Exception e) {
                        YYTaskExecutor.postToMainThread(() -> {
                            if (EntranceShowView.this.mShowViewCallback != null) {
                                EntranceShowView.this.mShowViewCallback.removeShowView();
                            }
                        });
                        MLog.info((Object)EntranceShowView.TAG, (String)"updateView load svga fail url:%s", (Object[])new Object[]{bgUrl});
                    }
                });
            } else {
                this.mBgSvga.setVisibility(8);
                this.mBgView.setVisibility(0);
                this.mBgView.setLoopCount(1);
                String url = bgUrl;
                if (!bgUrl.endsWith("webp")) {
                    url = bgUrl + YYImageUtils.getThumb((int)270, (int)50);
                }
                if (bgUrl.endsWith(".anim.webp")) {
                    url = bgUrl + "?anim=1";
                }
                ImageLoader.loadImage((ImageView)this.mBgView, (String)url);
                this.startEnterAnim();
            }
        } else {
            this.mBgView.setBackgroundResource(R.drawable.entrance_show_bg);
            this.startEnterAnim();
        }
        this.mUserNameView.setText((CharSequence)userName);
        if (!TextUtils.isEmpty((CharSequence)tips)) {
            this.mTipsView.setText((CharSequence)tips);
            this.mUserNameView.setTypeface(Typeface.defaultFromStyle((int)1));
        } else {
            this.mTipsView.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_enter));
            this.mUserNameView.setTypeface(Typeface.defaultFromStyle((int)0));
        }
        this.mUserNameView.requestLayout();
    }

    private void startEnterAnim() {
        if (this.mStartAnimator == null) {
            this.mStartAnimator = this.getStartEnterAnim();
        }
        this.mStartAnimator.start();
        this.setAlpha(1.0f);
        this.setVisibility(0);
    }

    public void startExitAnim() {
        if (this.mExitAnimator == null) {
            this.mExitAnimator = this.getExitAnim();
        }
        this.mExitAnimator.start();
    }

    private ObjectAnimator getStartEnterAnim() {
        float trans = this.translationWidth;
        if (LanguageUtils.isRtl()) {
            trans = -this.translationWidth;
        }
        ObjectAnimator mStartAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{trans, 0.0f})});
        mStartAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        mStartAnimator.setDuration(400L);
        mStartAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (EntranceShowView.this.mShowViewCallback != null) {
                    EntranceShowView.this.mShowViewCallback.removeStayRunnable();
                }
            }
        });
        return mStartAnimator;
    }

    @NonNull
    private ObjectAnimator getExitAnim() {
        float trans = -this.translationWidth;
        if (LanguageUtils.isRtl()) {
            trans = this.translationWidth;
        }
        ObjectAnimator mAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{0.0f, trans})});
        mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        mAnimator.setDuration(333L);
        mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (EntranceShowView.this.mShowViewCallback != null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (EntranceShowView.this.mShowViewCallback != null) {
                                EntranceShowView.this.mShowViewCallback.removeShowView();
                            }
                        }
                    });
                }
            }
        });
        return mAnimator;
    }
}

