/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.entranceshow;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.alphaplayer.AlphaVideoPlayer;
import com.yy.hiyo.channel.component.profile.entranceshow.data.EntranceShowConfigBean;
import com.yy.hiyo.channel.component.profile.entranceshow.data.EntranceShowNotify;
import com.yy.hiyo.channel.component.profile.entranceshow.listener.IEntranceShowAddListener;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.money.api.inshow.GetInshowConfsReq;
import net.ihago.money.api.inshow.GetInshowConfsRes;
import net.ihago.money.api.inshow.InshowNotify;
import net.ihago.money.api.inshow.InshowStartNotify;
import net.ihago.money.api.inshow.Uri;

public enum EntranceShowManager {
    INSTANCE;

    private static final String TAG = "FTEntranceShow_EntranceShowManager";
    private SparseArray<EntranceShowConfigBean> entranceShowMap = new SparseArray();
    private Map<String, IEntranceShowAddListener> mEntranceShowAddListener;
    private final Map<String, List<EntranceShowNotify>> cacheShowNotifyList = new HashMap<String, List<EntranceShowNotify>>();
    private boolean configHadReq = false;
    private IProtoNotify mEntranceShowNotify = new IProtoNotify<InshowNotify>(){

        public String serviceName() {
            return "net.ihago.money.api.inshow";
        }

        public void onNotify(@NonNull InshowNotify notify2) {
            if (notify2 != null && notify2.getUriValue() == Uri.UriInshow.getValue()) {
                String roomId = notify2.header.roomid;
                InshowStartNotify inshowStartNotify = notify2.start_notify;
                FeatureLog.i((String)EntranceShowManager.TAG, (String)"entranceShowNotify %s", (Object[])new Object[]{roomId});
                if (inshowStartNotify != null) {
                    EntranceShowNotify entranceShowNotify = EntranceShowNotify.from(inshowStartNotify);
                    EntranceShowManager.this.addEntranceShowNotify(roomId, entranceShowNotify);
                }
            }
        }
    };

    private EntranceShowManager() {
        AlphaVideoPlayer.resetCount();
    }

    public void registerNotify() {
        ProtoManager.getInstance().registerNotify(this.mEntranceShowNotify);
    }

    public void setEntranceShowAddListener(String roomId, IEntranceShowAddListener listener2) {
        MLog.info((Object)TAG, (String)"setEntranceShowAddListener roomId: %s, %b", (Object[])new Object[]{roomId, listener2 == null});
        if (this.mEntranceShowAddListener == null) {
            this.mEntranceShowAddListener = new HashMap<String, IEntranceShowAddListener>();
        }
        if (listener2 == null) {
            this.mEntranceShowAddListener.remove(roomId);
        } else {
            this.mEntranceShowAddListener.put(roomId, listener2);
            this.checkNotifyCache();
        }
    }

    public void requestEntranceShowConfig(String roomId) {
        FeatureLog.i((String)"FTEntranceShow", (String)"requestEntranceShowConfig roomId=%s", (Object[])new Object[]{roomId});
        GetInshowConfsReq req = new GetInshowConfsReq.Builder().build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetInshowConfsRes>(){

            public void onResponse(@NonNull GetInshowConfsRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                FeatureLog.i((String)"FTEntranceShow", (String)"onResponse code=%d, msg=%s", (Object[])new Object[]{code, msg});
                boolean last = EntranceShowManager.this.configHadReq;
                EntranceShowManager.this.configHadReq = true;
                List list2 = message.inshow_confs;
                EntranceShowManager.this.putEntranceShowConfigDatas(EntranceShowConfigBean.parseList(list2));
                if (last != EntranceShowManager.this.configHadReq) {
                    EntranceShowManager.this.checkNotifyCache();
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTEntranceShow", (String)"retryWhenTimeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.i((String)"FTEntranceShow", (String)"retryWhenError reason=%s, code=%s", (Object[])new Object[]{reason, code});
                return false;
            }
        });
    }

    private void putEntranceShowConfigDatas(List<EntranceShowConfigBean> list2) {
        if (list2 != null) {
            for (EntranceShowConfigBean bean2 : list2) {
                this.entranceShowMap.put(bean2.getId(), (Object)bean2);
            }
        }
    }

    public EntranceShowConfigBean getEntranceShowConfigById(int id2) {
        return (EntranceShowConfigBean)this.entranceShowMap.get(id2);
    }

    public String getEnShowBgUrl(int id2) {
        EntranceShowConfigBean bean2 = (EntranceShowConfigBean)this.entranceShowMap.get(id2);
        if (bean2 == null) {
            return null;
        }
        return bean2.getUrl();
    }

    public EntranceShowConfigBean.ShowType getShowType(int id2) {
        EntranceShowConfigBean bean2 = (EntranceShowConfigBean)this.entranceShowMap.get(id2);
        if (bean2 == null) {
            return EntranceShowConfigBean.ShowType.ShowTypeNone;
        }
        return bean2.getShowType();
    }

    public void addEntranceShowNotify(final String roomId, final EntranceShowNotify notify2) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (EntranceShowManager.this.mEntranceShowAddListener != null && EntranceShowManager.this.configHadReq) {
                    IEntranceShowAddListener listener2 = (IEntranceShowAddListener)EntranceShowManager.this.mEntranceShowAddListener.get(roomId);
                    if (listener2 != null) {
                        listener2.onEntranceShowAdd(notify2);
                    } else {
                        EntranceShowManager.this.addCache(roomId, notify2);
                    }
                } else {
                    EntranceShowManager.this.addCache(roomId, notify2);
                }
            }
        });
    }

    private void addCache(String roomId, EntranceShowNotify notify2) {
        List<EntranceShowNotify> list2 = this.cacheShowNotifyList.get(roomId);
        if (list2 == null) {
            list2 = new ArrayList<EntranceShowNotify>();
            this.cacheShowNotifyList.put(roomId, list2);
        }
        list2.add(notify2);
    }

    private void checkNotifyCache() {
        if (this.mEntranceShowAddListener == null || this.mEntranceShowAddListener.size() <= 0 || !this.configHadReq || this.cacheShowNotifyList == null || this.cacheShowNotifyList.size() <= 0) {
            return;
        }
        MLog.info((Object)TAG, (String)"checkNotifyCache", (Object[])new Object[0]);
        for (Map.Entry<String, List<EntranceShowNotify>> entry : this.cacheShowNotifyList.entrySet()) {
            String roomId = entry.getKey();
            List<EntranceShowNotify> list2 = entry.getValue();
            IEntranceShowAddListener listener2 = this.mEntranceShowAddListener.get(roomId);
            if (listener2 == null || list2 == null || list2.size() <= 0) continue;
            for (EntranceShowNotify notify2 : list2) {
                listener2.onEntranceShowAdd(notify2);
            }
        }
        this.cacheShowNotifyList.clear();
    }
}

