/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.searchmusic;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.component.music.addmusic.ChannelAddMusicMsgDef;
import com.yy.hiyo.channel.component.music.searchmusic.ChannelSearchMusicMsgDef;
import com.yy.hiyo.channel.component.music.searchmusic.ISearchMusicCallback;
import com.yy.hiyo.channel.component.music.searchmusic.SearchMusicWindow;
import java.util.List;

public class SearchMusicController
extends DefaultController
implements ISearchMusicCallback {
    private SearchMusicWindow mSearchMusicWindow;
    private int mode = 0;

    public SearchMusicController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_ENTERED, (INotify)this);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ChannelSearchMusicMsgDef.OPEN_SEARCH_MUSIC) {
            this.mode = msg.arg1;
            if (msg.obj instanceof List) {
                List list2 = (List)msg.obj;
                this.showSearchMusicWindow(list2);
            }
        } else if (msg.what == ChannelSearchMusicMsgDef.CLOSE_SEARCH_MUSIC) {
            this.closeWindow();
        }
    }

    private void showSearchMusicWindow(List<MusicPlaylistDBBean> list2) {
        this.mSearchMusicWindow = new SearchMusicWindow(this.mContext, list2, this);
        if (null != this.mSearchMusicWindow.getPage()) {
            this.mSearchMusicWindow.getPage().setSelectMode(this.mode != 1);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mSearchMusicWindow, true);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mSearchMusicWindow == abstractWindow) {
            this.mSearchMusicWindow = null;
        }
    }

    @Override
    public void selectMusic(MusicPlaylistDBBean bean2) {
        if (!bean2.isFileExist()) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.tips_music_unvailable), (int)0);
            return;
        }
        Message msg = Message.obtain();
        msg.what = ChannelMsgDef.PLAY_MUSIC;
        msg.obj = bean2;
        this.sendMessage(msg);
        this.sendMessage(ChannelMsgDef.CLOSE_MUSIC_PLAYLIST);
        this.closeWindow();
    }

    @Override
    public void backEvent(List<MusicPlaylistDBBean> list2) {
        this.closeWindow();
        if (this.mode == 3) {
            Message message = Message.obtain();
            message.what = ChannelAddMusicMsgDef.ADD_MUSIC_FORM_SEARCH;
            message.obj = list2;
            this.sendMessage(message);
        } else if (this.mode == 2) {
            Message message = Message.obtain();
            message.what = ChannelMsgDef.DELETE_MUSIC_FROM_SEARCH;
            message.obj = list2;
            this.sendMessage(message);
        }
    }

    private void closeWindow() {
        if (this.mSearchMusicWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mSearchMusicWindow);
        }
        this.mSearchMusicWindow = null;
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.mSearchMusicWindow != null && this.mSearchMusicWindow.getPage() != null) {
            this.backEvent(this.mSearchMusicWindow.getPage().getSourceList());
            return true;
        }
        return super.onWindowBackKeyEvent();
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationIdDef.CHANNEL_ENTERED) {
            this.closeWindow();
        }
    }
}

