/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.playlist;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.music.MusicHelper;
import com.yy.hiyo.channel.component.music.playlist.IPlaylistUICallback;
import java.util.List;

public class PlaylistAdapter
extends RecyclerView.Adapter<NormalHolder> {
    protected Context mContext;
    protected List<MusicPlaylistDBBean> mList;
    private IPlaylistUICallback mCallback;
    protected boolean isSelectMode = false;

    public PlaylistAdapter(Context context, List<MusicPlaylistDBBean> list2, IPlaylistUICallback callback2) {
        this.mContext = context;
        this.mCallback = callback2;
        this.mList = list2;
    }

    public PlaylistAdapter() {
    }

    @NonNull
    public NormalHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new NormalHolder(View.inflate((Context)this.mContext, (int)R.layout.item_music_playlist_channel, null));
    }

    public void onBindViewHolder(@NonNull NormalHolder holder, int position) {
        final MusicPlaylistDBBean bean2 = this.mList.get(position);
        holder.nameTv.setText((CharSequence)bean2.getMusicName());
        holder.contentTv.setText((CharSequence)bean2.getSinger());
        if (!TextUtils.isEmpty((CharSequence)bean2.getChatThemeTag())) {
            holder.tagView.setVisibility(0);
            holder.tagView.setText((CharSequence)bean2.getChatThemeTag());
        } else {
            holder.tagView.setVisibility(8);
        }
        if (this.isSelectMode) {
            holder.selectIv.setVisibility(0);
            holder.selectIv.setSelected(bean2.isSelected());
        } else {
            holder.selectIv.setVisibility(8);
        }
        if (MusicHelper.getPlayingBean() == bean2) {
            holder.nameTv.setTextColor(Color.parseColor((String)"#18ffff"));
            holder.contentTv.setTextColor(Color.parseColor((String)"#8018ffff"));
            holder.playingSvga.setVisibility(0);
        } else if (bean2.isFileExist()) {
            holder.nameTv.setTextColor(Color.parseColor((String)"#ffffff"));
            holder.contentTv.setTextColor(Color.parseColor((String)"#80ffffff"));
            holder.playingSvga.setVisibility(8);
        } else {
            holder.nameTv.setTextColor(Color.parseColor((String)"#4dffffff"));
            holder.contentTv.setTextColor(Color.parseColor((String)"#4dffffff"));
            holder.playingSvga.setVisibility(8);
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlaylistAdapter.this.isSelectMode) {
                    PlaylistAdapter.this.mCallback.clickItemSelect(bean2);
                } else {
                    PlaylistAdapter.this.mCallback.clickItemSong(bean2);
                }
            }
        });
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    public void changeMode() {
        this.isSelectMode = !this.isSelectMode;
        this.notifyDataSetChanged();
    }

    public void setSelectMode(boolean mode) {
        this.isSelectMode = mode;
        this.notifyDataSetChanged();
    }

    public boolean isSelectMode() {
        return this.isSelectMode;
    }

    protected class NormalHolder
    extends RecyclerView.ViewHolder {
        public View itemView;
        public YYTextView nameTv;
        public YYTextView contentTv;
        public YYImageView playingSvga;
        public YYImageView selectIv;
        public YYTextView tagView;

        public NormalHolder(View itemView) {
            super(itemView);
            this.itemView = itemView;
            this.nameTv = (YYTextView)itemView.findViewById(R.id.tv_name);
            this.contentTv = (YYTextView)itemView.findViewById(R.id.tv_content);
            this.playingSvga = (YYImageView)itemView.findViewById(R.id.svga_playing);
            this.selectIv = (YYImageView)itemView.findViewById(R.id.iv_select);
            this.tagView = (YYTextView)itemView.findViewById(R.id.tv_name_tag);
        }
    }
}

