/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.musicplayer;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.BasePanel;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.module.audiopk.IAudioPkModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.component.music.MusicHelper;
import com.yy.hiyo.channel.component.music.addmusic.ChannelAddMusicMsgDef;
import com.yy.hiyo.channel.component.music.musicplayer.MusicPLayerPanel;
import com.yy.hiyo.channel.component.music.musicplayer.MusicPlayerMvp;
import com.yy.hiyo.channel.service.themeroom.IChatThemeRoomService;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IVoiceService;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.ihago.channel.srv.mgr.PlayBgMusicReq;
import net.ihago.channel.srv.mgr.PlayBgMusicRes;
import net.ihago.room.api.rrec.ReportChannelSongReq;
import net.ihago.room.api.rrec.ReportChannelSongRes;

public class MusicPlayerPresenter
extends BaseChannelPresenter
implements MusicPlayerMvp.IPresenter,
IVoiceService.OnAudioPlayCallback,
ISeatUpdateListener {
    public static final String TAG = "MusicPlayerPresenter";
    private static final int ERROR_CODE_FORMAT_NOT_SUPPORT = -999999;
    private MusicPlayerMvp.IView mView;
    private static final int DEFAULT_MUSIC_VOLUME = 50;
    private AtomicInteger mPlayState = new AtomicInteger(0);
    private boolean mPlayBgmInNotify = false;
    private long operUid = 0L;
    private boolean mPauseingOtherSong = false;
    private MusicPlaylistDBBean mWaitingPlaySong;
    private boolean mCurrentMySongPlaying = false;
    private long mPreOperUid = 0L;
    private boolean mSendNotice = false;
    private long musicPlayStartElapseTime = 0L;
    private INotifyDispatchService.INotifyHandler<ChannelNotify> mChannelNotify = notify2 -> {
        if (notify2 != null && StringUtils.equal((String)notify2.cid, (String)this.getChannel().getChannelId())) {
            if (notify2.uri == ChannelNotify.Uri.UriPlayBgmNotify) {
                if (StringUtils.equal((String)notify2.notify.mBgmPlayNotify.ownerCid, (String)this.getChannel().getChannelId())) {
                    this.mPreOperUid = this.operUid;
                    this.mSendNotice = !notify2.notify.mBgmPlayNotify.manual;
                    this.operUid = notify2.notify.mBgmPlayNotify.uid;
                    this.mPlayBgmInNotify = notify2.notify.mBgmPlayNotify.playState;
                    MLog.info((Object)TAG, (String)"UriPlayBgmNotify uid:%d,play\uff1a%b mSendNotice:%b", (Object[])new Object[]{this.operUid, this.mPlayBgmInNotify, this.mSendNotice});
                    this.getChannel().getChannelDetail().dynamicInfo.mCurrentPlayBgUid = this.mPlayBgmInNotify ? this.operUid : 0L;
                    this.getChannel().getChannelDetail().dynamicInfo.mBgmPlaying = this.mPlayBgmInNotify;
                    this.updatePlayState();
                    RuntimeContext.setPlayingBackgroundMusic((String)this.getChannel().getChannelId(), (boolean)this.mPlayBgmInNotify);
                } else if (this.getPluginMode() == 16) {
                    ((IAudioPkModulePresenter)this.getPresenter(IAudioPkModulePresenter.class)).notifyBgmChangeState(notify2.notify.mBgmPlayNotify);
                }
            } else if (notify2.uri == ChannelNotify.Uri.UriUpdateBgmMode) {
                boolean openBgmMode = notify2.notify.mBgmUpdateNotify.bgmEnable;
                MLog.info((Object)TAG, (String)"UriUpdateBgmMode enable:%b", (Object[])new Object[]{openBgmMode});
                if (this.getChannel().getDataService().getCacheDetail() != null) {
                    this.getChannel().getDataService().getCacheDetail().baseInfo.mBgmMode = openBgmMode ? 0 : 1;
                }
            }
        }
    };
    private int fileNotExistNum = 0;

    public void onInit(@Nonnull IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.getNotifyDispatcher().addHandler(this.mChannelNotify);
        if (this.getChannel().getChannelDetail().dynamicInfo.mCurrentPlayBgUid != 0L) {
            this.mPlayState.set(2);
            this.operUid = this.getChannel().getChannelDetail().dynamicInfo.mCurrentPlayBgUid;
            this.mPlayBgmInNotify = true;
        } else {
            this.mPlayState.set(0);
        }
        this.getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
        this.checkDeleteCache();
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        if (this.isSkipCheckInSeat()) {
            return;
        }
        if (this.getChannelDetailInfo().dynamicInfo.mBgmPlaying && this.getChannelDetailInfo().dynamicInfo.mCurrentPlayBgUid == AccountUtil.getUid() && !this.getChannel().getSeatService().isMeInSeat() && !this.isMePlayingChatThemeMusic()) {
            this.stopMusic(true);
        }
    }

    private boolean isMePlayingChatThemeMusic() {
        return ((IChatThemeRoomService)this.getChannel().getPluginService(IChatThemeRoomService.class)).isMePlayingRoomThemeMusic();
    }

    public void onMyRoleChanged(String channelId, int newRoleType) {
        super.onMyRoleChanged(channelId, newRoleType);
        if (this.getChannelDetailInfo().dynamicInfo.mBgmPlaying && this.getChannelDetailInfo().dynamicInfo.mCurrentPlayBgUid == AccountUtil.getUid() && newRoleType < 10) {
            this.stopMusic(true);
        }
    }

    @Override
    public void clickPlay() {
        if (this.mPlayState.get() == 2) {
            if (MusicHelper.getPlaylistSize() > 0) {
                this.mWaitingPlaySong = MusicHelper.getPlayList().get(0);
                this.showPauseOtherDialog();
            }
        } else if (MusicHelper.getMusicStatus() == 0) {
            this.playFirstSong();
        } else if (MusicHelper.getMusicStatus() == 1) {
            this.pauseMusic(false);
        } else if (MusicHelper.getMusicStatus() == 2) {
            this.resumeMusic();
        }
    }

    public void playFirstSong() {
        if (MusicHelper.getPlaylistSize() > 0) {
            MusicHelper.setPlayingBean(MusicHelper.getPlayList().get(0));
            this.playMusic(MusicHelper.getPlayingBean());
            this.fileNotExistNum = 0;
        }
    }

    @Override
    public void clickNext() {
        if (this.mPlayState.get() == 2) {
            this.mWaitingPlaySong = this.getNextMusic();
            this.showPauseOtherDialog();
        } else {
            this.nextMusic();
        }
    }

    @Override
    public void clickPre() {
        if (this.mPlayState.get() == 2) {
            this.mWaitingPlaySong = this.getPreMusic();
            this.showPauseOtherDialog();
        } else {
            this.preMusic();
        }
    }

    @Override
    public void clickPlaylist() {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u6253\u5f00\u64ad\u653e\u5217\u8868", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(ChannelMsgDef.OPEN_MUSIC_PLAYLIST);
        if (null != this.mView) {
            this.mView.hidePanel(this.getWindow());
        }
    }

    @Override
    public void clickAddMusic() {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u6253\u5f00\u6dfb\u52a0\u97f3\u4e50", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(ChannelAddMusicMsgDef.OPEN_ADD_MUSIC_PAGE);
        if (null != this.mView) {
            this.mView.hidePanel(this.getWindow());
        }
    }

    @Override
    public void setVolume(int volume) {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u97f3\u4e50\u97f3\u91cf\uff1a %s", (Object[])new Object[]{volume});
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).adjustAudioMixingVolume(volume);
        SettingFlags.setIntValue((String)"key_user_show_wallet_bean_tab", (int)volume);
    }

    @Override
    public void showMusicPanel() {
        if (null == this.mView) {
            this.mView = new MusicPLayerPanel(this.getMvpContext().getContext());
            this.mView.setPresenter(this);
            this.mView.setPanelListener(new BasePanel.SimplePanelListener(){

                public void onPanelHidden(BasePanel panel2) {
                    super.onPanelHidden(panel2);
                }

                public void onPanelShow(BasePanel panel2, boolean animated) {
                    super.onPanelShow(panel2, animated);
                    if (MusicPlayerPresenter.this.mView != null) {
                        MusicPlayerPresenter.this.mView.requestUpdateView();
                        MusicPlayerPresenter.this.mView.setPlayView(MusicHelper.getMusicStatus() == 1);
                    }
                }
            });
        }
        this.mView.showPanel(this.getWindow());
        RoomTrack.INSTANCE.onVoiceRoomMusicEnterClick(this.getChannel().getChannelId(), this.getChannel().getPluginService().getCurPluginData().getPluginId());
    }

    @Override
    public void requestPlaylist(MusicHelper.PlaylistCallback callback2) {
        MusicHelper.requestPlaylist(playList -> {
            callback2.playlistGetted(playList);
            int volume = SettingFlags.getIntValue((String)"key_user_show_wallet_bean_tab", (int)50);
            if (MusicHelper.getMusicStatus() == 0) {
                if (null != this.mView) {
                    this.mView.setVolume(volume);
                    this.mView.setPlayView(false);
                    if (null != playList && !playList.isEmpty()) {
                        this.mView.setMusicName(((MusicPlaylistDBBean)playList.get(0)).getMusicName());
                    }
                }
            } else if (null != MusicHelper.getPlayingBean() && null != this.mView) {
                this.mView.setVolume(volume);
                this.mView.setMusicName(MusicHelper.getPlayingBean().getMusicName());
                this.mView.setPlayView(MusicHelper.getMusicStatus() == 1);
            }
        });
    }

    @Override
    public void playMusic(MusicPlaylistDBBean bean2) {
        if (this.mPlayState.get() == 2) {
            this.mWaitingPlaySong = bean2;
            this.mPauseingOtherSong = true;
            this.showPauseOtherDialog();
        } else {
            FeatureLog.i((String)"FTChannelBgm", (String)"\u64ad\u653e\u97f3\u4e50", (Object[])new Object[0]);
            if (null == bean2) {
                return;
            }
            if (!this.roleHasBgmPermission()) {
                FeatureLog.i((String)"FTChannelBgm", (String)"\u6ca1\u6709\u73a9\u6cd5\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u80fd\u64ad\u653e\u97f3\u4e50", (Object[])new Object[0]);
                return;
            }
            if (!((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).isInMultiRoom()) {
                FeatureLog.i((String)"FTChannelBgm", (String)"\u6ca1\u6709\u52a0\u5165\u9891\u9053\uff0c\u4e0d\u80fd\u64ad\u653e\u97f3\u4e50", (Object[])new Object[0]);
                return;
            }
            FeatureLog.i((String)"FTChannelBgm", (String)"\u97f3\u4e50\u4fe1\u606f: name\uff1a%s, suffix:%s", (Object[])new Object[]{bean2.getMusicName(), MusicHelper.getMusicSuffix(bean2.getMusicPath())});
            this.mCurrentMySongPlaying = true;
            this.mPlayState.set(1);
            MusicHelper.setPlayingBean(bean2);
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).startAudioMixing(bean2.getMusicPath(), bean2.getContentUri(), (IVoiceService.OnAudioPlayCallback)this, true);
            this.reportChannelSong(this.getChannelId(), bean2.getMusicName(), bean2.getDuration());
            MsgDispatcher.getInstance().sendMessage(ChannelMsgDef.MUSIC_CHANGE);
            this.reportPlayState(true, false, true);
            this.mWaitingPlaySong = null;
        }
    }

    @Override
    public void forcePlayMusic(MusicPlaylistDBBean bean2) {
        if (this.mPlayState.get() == 2) {
            this.mWaitingPlaySong = bean2;
            this.mPauseingOtherSong = true;
            this.pauseOthersSongAndPlayMySong();
        } else {
            this.playMusic(bean2);
        }
    }

    @Override
    public void pauseMusic(boolean sendNotice) {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u6682\u505c\u97f3\u4e50", (Object[])new Object[0]);
        if (MusicHelper.getMusicStatus() == 1) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).pauseAudioMixing();
            MusicHelper.setMusicStatus(2);
            if (null != this.mView) {
                this.mView.setPlayView(false);
            }
            this.mCurrentMySongPlaying = false;
            this.reportPlayState(false, false, !sendNotice);
        }
    }

    @Override
    public void stopMusic(boolean sendNotice) {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u505c\u6b62\u97f3\u4e50", (Object[])new Object[0]);
        if (MusicHelper.getMusicStatus() != 0) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).stopAudioMixing();
            MusicHelper.setMusicStatus(0);
            if (null != this.mView) {
                this.mView.setPlayView(false);
                this.mView.hidePanel(this.getWindow());
            }
            if (this.mCurrentMySongPlaying) {
                this.reportPlayState(false, false, !sendNotice);
            }
        }
    }

    @Override
    public void resumeMusic() {
        if (this.mPlayState.get() == 2) {
            this.showPauseOtherDialog();
        } else {
            FeatureLog.i((String)"FTChannelBgm", (String)"\u91cd\u65b0\u64ad\u653e\u97f3\u4e50", (Object[])new Object[0]);
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).resumeAudioMixing(true);
            MusicHelper.setMusicStatus(1);
            this.mCurrentMySongPlaying = true;
            if (null != this.mView) {
                this.mView.setPlayView(true);
            }
            this.reportPlayState(true, false, true);
        }
    }

    private void preMusic() {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u64ad\u653e\u97f3\u4e50---\u4e0a\u4e00\u66f2", (Object[])new Object[0]);
        if (0 == MusicHelper.getPlaylistSize()) {
            ToastUtils.showToast((Context)this.getMvpContext().getContext(), (String)ResourceUtils.getString((int)R.string.tips_music_unvailable), (int)0);
            return;
        }
        this.playMusic(this.getPreMusic());
    }

    private MusicPlaylistDBBean getPreMusic() {
        List<MusicPlaylistDBBean> list2 = MusicHelper.getPlayList();
        if (FP.empty(list2)) {
            return null;
        }
        if (null == MusicHelper.getPlayingBean()) {
            MusicHelper.setPlayingBean(list2.get(0));
        }
        int musicIndex = 0;
        for (int i = 0; i < MusicHelper.getPlaylistSize(); ++i) {
            if (!MusicHelper.getPlayingBean().getMusicPath().equals(list2.get(i).getMusicPath())) continue;
            musicIndex = i;
        }
        musicIndex = musicIndex > 0 ? --musicIndex : MusicHelper.getPlaylistSize() - 1;
        return list2.get(musicIndex);
    }

    private void nextMusic() {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u64ad\u653e\u97f3\u4e50---\u4e0b\u4e00\u66f2", (Object[])new Object[0]);
        if (0 == MusicHelper.getPlaylistSize() || this.fileNotExistNum >= MusicHelper.getPlaylistSize()) {
            ToastUtils.showToast((Context)this.getMvpContext().getContext(), (String)ResourceUtils.getString((int)R.string.tips_music_unvailable), (int)0);
            return;
        }
        this.playMusic(this.getNextMusic());
    }

    private MusicPlaylistDBBean getNextMusic() {
        List<MusicPlaylistDBBean> list2 = MusicHelper.getPlayList();
        if (FP.empty(list2)) {
            return null;
        }
        if (null == MusicHelper.getPlayingBean()) {
            MusicHelper.setPlayingBean(list2.get(0));
        }
        int musicIndex = 0;
        for (int i = 0; i < MusicHelper.getPlaylistSize(); ++i) {
            if (!StringUtils.equal((String)MusicHelper.getPlayingBean().getMusicPath(), (String)list2.get(i).getMusicPath())) continue;
            musicIndex = i;
        }
        musicIndex = musicIndex < MusicHelper.getPlaylistSize() - 1 ? ++musicIndex : 0;
        return list2.get(musicIndex);
    }

    public void onAudioFilePlayEnd() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SystemClock.elapsedRealtime() - MusicPlayerPresenter.this.musicPlayStartElapseTime > 500L) {
                    FeatureLog.i((String)"FTChannelBgm", (String)"\u5224\u65ad\u64ad\u653e\u97f3\u4e50\u6210\u529f\u56de\u8c03\u64ad\u653e\u6210\u529f", (Object[])new Object[0]);
                    FeatureLog.i((String)"FTChannelBgm", (String)"\u64ad\u653e\u97f3\u4e50\u7ed3\u675f", (Object[])new Object[0]);
                    MusicPlayerPresenter.this.nextMusic();
                } else {
                    FeatureLog.i((String)"FTChannelBgm", (String)"\u5224\u65ad\u64ad\u653e\u97f3\u4e50\u6210\u529f\u56de\u8c03\u64ad\u653e\u5931\u8d25", (Object[])new Object[0]);
                    MusicPlayerPresenter.this.onAudioFilePlayFail(-999999);
                }
            }
        });
    }

    public void onAudioFilePlaySuccess() {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u64ad\u653e\u97f3\u4e50\u6210\u529f", (Object[])new Object[0]);
        this.musicPlayStartElapseTime = SystemClock.elapsedRealtime();
        MusicHelper.setMusicStatus(1);
        int volume = SettingFlags.getIntValue((String)"key_user_show_wallet_bean_tab", (int)50);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).adjustAudioMixingVolume(volume);
        this.fileNotExistNum = 0;
        if (null != this.mView) {
            if (null != MusicHelper.getPlayingBean()) {
                this.mView.setMusicName(MusicHelper.getPlayingBean().getMusicName());
            }
            this.mView.setPlayView(true);
        }
    }

    public void onAudioFilePlayFail(int errorCode) {
        FeatureLog.e((String)"FTChannelBgm", (String)"\u64ad\u653e\u97f3\u4e50\u5931\u8d25 error: %s", (Object[])new Object[]{errorCode});
        ++this.fileNotExistNum;
        MusicPlaylistDBBean currentBean = MusicHelper.getPlayingBean();
        if (null != currentBean) {
            this.reportBgmError(currentBean.getMusicName(), MusicHelper.getMusicSuffix(currentBean.getMusicPath()), errorCode);
        }
        switch (errorCode) {
            case -2: 
            case -1: {
                ToastUtils.showToast((Context)this.getMvpContext().getContext(), (int)R.string.tips_bgm_parse_error);
                break;
            }
            case -999999: 
            case -3: {
                ToastUtils.showToast((Context)this.getMvpContext().getContext(), (int)R.string.tips_bgm_unsupport_error);
                break;
            }
            case -4: {
                ToastUtils.showToast((Context)this.getMvpContext().getContext(), (int)R.string.tips_bgm_unknown_path_error);
                break;
            }
        }
        if (this.fileNotExistNum >= MusicHelper.getPlaylistSize()) {
            FeatureLog.e((String)"FTChannelBgm", (String)"\u5217\u8868\u4e2d\u5168\u662f\u65e0\u6548\u97f3\u4e50", (Object[])new Object[0]);
            MusicHelper.setPlayingBean(null);
            MusicHelper.setMusicStatus(0);
            if (null != this.mView) {
                this.mView.setPlayView(false);
            }
            return;
        }
        this.nextMusic();
    }

    private void reportBgmError(String songName, String fileType, int errorCode) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "channel_bgm_error");
        statContent.put("ifield", errorCode);
        statContent.put("sfield", songName + fileType);
        statContent.put("sfieldtwo", fileType);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public void onDestroy() {
        super.onDestroy();
        FeatureLog.i((String)"FTChannelBgm", (String)"MusicPlayerPresenter onDestroy", (Object[])new Object[0]);
        if (this.mCurrentMySongPlaying || MusicHelper.getMusicStatus() == 2) {
            this.stopMusic(false);
            MusicHelper.setDataNull();
            this.getNotifyDispatcher().removeHandler(this.mChannelNotify);
            this.getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
            this.getChannel().getChannelDetail().dynamicInfo.mCurrentPlayBgUid = 0L;
        }
        if (null != this.mView) {
            this.mView.hidePanel(this.getWindow());
            this.mView = null;
        }
    }

    private void updatePlayState() {
        int preState = this.mPlayState.get();
        switch (preState) {
            case 0: {
                if (this.mPlayBgmInNotify) {
                    if (this.operUid == AccountUtil.getUid()) break;
                    this.mPlayState.set(2);
                    break;
                }
                this.mPlayState.set(0);
                break;
            }
            case 1: {
                if (this.mPlayBgmInNotify) {
                    if (this.operUid == AccountUtil.getUid()) break;
                    this.mPlayState.set(0);
                    break;
                }
                if (this.mCurrentMySongPlaying && this.operUid != AccountUtil.getUid()) {
                    this.mPlayState.set(4);
                    this.stopByOther();
                    break;
                }
                if (this.operUid != AccountUtil.getUid()) break;
                this.mPlayState.set(0);
                break;
            }
            case 2: {
                if (this.mPlayBgmInNotify) break;
                if (this.operUid == AccountUtil.getUid()) {
                    this.mPlayState.set(3);
                    break;
                }
                this.mPlayState.set(0);
                break;
            }
            case 3: {
                if (this.mWaitingPlaySong == null) break;
                this.mPlayState.set(0);
                this.playMusic(this.mWaitingPlaySong);
                break;
            }
            case 4: {
                if (this.mPlayBgmInNotify) {
                    this.mPlayState.set(2);
                    break;
                }
                this.mPlayState.set(0);
                break;
            }
        }
        if (!this.mPlayBgmInNotify && this.mSendNotice) {
            ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).sendBgmPauseByOtherMsg(this.operUid);
        }
        MLog.info((Object)TAG, (String)"pre state:%d current state:%d", (Object[])new Object[]{preState, this.mPlayState.get()});
    }

    private void reportPlayState(final boolean play, final boolean isPauseOther, final boolean manual) {
        Runnable playMusicCommand = new Runnable(){

            @Override
            public void run() {
                PlayBgMusicReq playBgMusicReq = new PlayBgMusicReq.Builder().cid(MusicPlayerPresenter.this.getChannelId()).play(Boolean.valueOf(play)).manual(Boolean.valueOf(manual)).build();
                MLog.info((Object)MusicPlayerPresenter.TAG, (String)"reportPlayState play:%b  isPauseOther:%b manual:%b", (Object[])new Object[]{play, isPauseOther, manual});
                ProtoManager.getInstance().sendRpc((AndroidMessage)playBgMusicReq, (IProtoCallback)new SimpleProtoCallback<PlayBgMusicRes>(){

                    public void onResponse(@NonNull PlayBgMusicRes message, long code, String msg) {
                        super.onResponse((AndroidMessage)message, code, msg);
                        MLog.info((Object)MusicPlayerPresenter.TAG, (String)"reportPlayState onResponse code:%d", (Object[])new Object[]{code});
                    }

                    public void onError(String reason, int code) {
                        super.onError(reason, code);
                        MLog.info((Object)MusicPlayerPresenter.TAG, (String)"reportPlayState onError,reason:%s, code:%d", (Object[])new Object[]{reason, code});
                    }
                });
            }
        };
        playMusicCommand.run();
    }

    private void reportChannelSong(String channelId, String songName, Long duration) {
        ReportChannelSongReq.Builder reqBuilder = new ReportChannelSongReq.Builder();
        reqBuilder.cid(channelId).song(songName).duration(duration);
        ProtoManager.getInstance().sendRpc((AndroidMessage)reqBuilder.build(), (IProtoCallback)new IProtoCallback<ReportChannelSongRes>(){

            public void onResponse(@NonNull ReportChannelSongRes message, long code, String msgTip) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)MusicPlayerPresenter.TAG, (String)"reportChannelSong respond success", (Object[])new Object[0]);
                } else {
                    MLog.error((Object)MusicPlayerPresenter.TAG, (String)"reportChannelSong onResponse channelId;$channelId song:$songName error code $code", (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)MusicPlayerPresenter.TAG, (String)"reportChannelSong channelId;$channelId song:$songName error code $code", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)MusicPlayerPresenter.TAG, (String)"reportChannelSong channelId;$channelId song:$songName error code $code", (Object[])new Object[0]);
                return false;
            }
        });
    }

    @Override
    public void pauseOthersSongAndPlayMySong() {
        this.reportPlayState(false, true, false);
    }

    private void showPauseOtherDialog() {
        if (this.operUid == 0L) {
            MLog.error((Object)TAG, (String)"showPauseOtherDialog uid is 0!!", (Object[])new Object[0]);
            return;
        }
        UserInfoKS userInfoBeans = ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).getUserInfo(this.operUid);
        MLog.info((Object)TAG, (String)"showPauseOtherDialog", (Object[])new Object[0]);
        if (userInfoBeans != null && userInfoBeans.ver > 0L && this.mView != null) {
            String userName = userInfoBeans.nick;
            this.mView.showOthersSongPlayingDialog(this.getWindow(), userName);
        }
    }

    private void stopByOther() {
        MLog.info((Object)TAG, (String)"stopByOther", (Object[])new Object[0]);
        this.stopMusic(false);
    }

    private boolean roleHasBgmPermission() {
        if (this.getChannel().getRoleService().isMeAnchor()) {
            return true;
        }
        if (this.getChannel().getRoleService().getMyRoleCache() == 5 || this.getChannel().getRoleService().getMyRoleCache() == 1 || this.getChannel().getRoleService().getMyRoleCache() == -1) {
            return false;
        }
        int mode = this.getChannel().getPluginService().getCurPluginData().mode;
        if (mode == 10 && ((IChatThemeRoomService)this.getChannel().getPluginService(IChatThemeRoomService.class)).isOpenedThemeRoom()) {
            return true;
        }
        switch (mode) {
            case 14: {
                return this.getChannel().getRoleService().getMyRoleCache() == 15;
            }
            case 1: {
                return this.getChannel().getRoleService().getMyRoleCache() == 15 || this.getChannel().getRoleService().getMyRoleCache() == 10;
            }
        }
        return !(!this.isSkipCheckInSeat() && !this.getChannel().getSeatService().isInSeat(AccountUtil.getUid()) || this.getChannel().getRoleService().getMyRoleCache() != 15 && this.getChannel().getRoleService().getMyRoleCache() != 10);
    }

    private boolean isSkipCheckInSeat() {
        return this.getPluginMode() == 16;
    }

    private void checkDeleteCache() {
        if (!SdkVersionUtils.hasScopedStorage()) {
            return;
        }
        boolean isDeletedCache = SettingFlags.getBoolean((String)"key_deleted_music_storage_cache", (boolean)false);
        if (!isDeletedCache) {
            MLog.info((Object)TAG, (String)"checkDeleteCache, start delete~", (Object[])new Object[0]);
            try {
                MyBox musicPlaylistMyBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(MusicPlaylistDBBean.class);
                if (musicPlaylistMyBox != null) {
                    musicPlaylistMyBox.deleteAll();
                }
                SettingFlags.setBoolean((String)"key_deleted_music_storage_cache", (boolean)true);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)("checkDeleteCache:" + e.toString()), (Object[])new Object[0]);
            }
        }
    }
}

