/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.lock.gridpasswordview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.lock.gridpasswordview.CustomPasswordTransformationMethod;
import com.yy.hiyo.channel.component.lock.gridpasswordview.PasswordType;
import com.yy.hiyo.channel.component.lock.gridpasswordview.PasswordView;
import com.yy.hiyo.channel.component.lock.gridpasswordview.imebugfixer.ImeDelBugFixedEditText;

public class GridPasswordView
extends YYLinearLayout
implements PasswordView {
    private static final int DEFAULT_PASSWORDLENGTH = 6;
    private static final int DEFAULT_TEXTSIZE = 16;
    private static final String DEFAULT_TRANSFORMATION = "\u25cf";
    private static final int DEFAULT_LINECOLOR = -1433892728;
    private static final int DEFAULT_GRIDCOLOR = -1;
    private ColorStateList mTextColor;
    private int mTextSize = 16;
    private int mLineWidth;
    private int mLineColor;
    private int mGridColor;
    private Drawable mLineDrawable;
    private Drawable mOuterLineDrawable;
    private int mPasswordLength;
    private String mPasswordTransformation;
    private int mPasswordType;
    private boolean mInputShowable = true;
    private String[] mPasswordArr;
    private TextView[] mViewArr;
    private ImeDelBugFixedEditText mInputView;
    private OnPasswordChangedListener mListener;
    private PasswordTransformationMethod mTransformationMethod;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (GridPasswordView.this.mInputShowable) {
                GridPasswordView.this.forceInputViewGetFocus();
            }
        }
    };
    private ImeDelBugFixedEditText.OnDelKeyEventListener onDelKeyEventListener = new ImeDelBugFixedEditText.OnDelKeyEventListener(){

        @Override
        public void onDeleteClick() {
            for (int i = GridPasswordView.this.mPasswordArr.length - 1; i >= 0; --i) {
                if (GridPasswordView.this.mPasswordArr[i] != null) {
                    ((GridPasswordView)GridPasswordView.this).mPasswordArr[i] = null;
                    GridPasswordView.this.mViewArr[i].setText(null);
                    GridPasswordView.this.notifyTextChanged();
                    break;
                }
                GridPasswordView.this.mViewArr[i].setText(null);
            }
        }
    };
    private TextWatcher textWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (s == null) {
                return;
            }
            String newStr = s.toString();
            if (newStr.length() == 1) {
                ((GridPasswordView)GridPasswordView.this).mPasswordArr[0] = newStr;
                GridPasswordView.this.notifyTextChanged();
            } else if (newStr.length() == 2) {
                String newNum = newStr.substring(1);
                for (int i = 0; i < GridPasswordView.this.mPasswordArr.length; ++i) {
                    if (GridPasswordView.this.mPasswordArr[i] != null) continue;
                    ((GridPasswordView)GridPasswordView.this).mPasswordArr[i] = newNum;
                    GridPasswordView.this.mViewArr[i].setText((CharSequence)newNum);
                    GridPasswordView.this.notifyTextChanged();
                    break;
                }
                GridPasswordView.this.mInputView.removeTextChangedListener(this);
                GridPasswordView.this.mInputView.setText(GridPasswordView.this.mPasswordArr[0]);
                if (GridPasswordView.this.mInputView.getText().length() >= 1) {
                    GridPasswordView.this.mInputView.setSelection(1);
                }
                GridPasswordView.this.mInputView.addTextChangedListener(this);
            }
        }

        public void afterTextChanged(Editable s) {
        }
    };
    @Deprecated
    private View.OnKeyListener onKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() == 0 && event.getKeyCode() == 67) {
                GridPasswordView.this.onDelKeyEventListener.onDeleteClick();
                return true;
            }
            return false;
        }
    };

    public GridPasswordView(Context context) {
        super(context);
        this.initViews(context);
        this.init(context, null, 0);
    }

    public GridPasswordView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public GridPasswordView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public GridPasswordView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.initAttrs(context, attrs, defStyleAttr);
        this.initViews(context);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        int textSize;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.gridPasswordView, defStyleAttr, 0);
        this.mTextColor = ta.getColorStateList(R.styleable.gridPasswordView_gpvTextColor);
        if (this.mTextColor == null) {
            this.mTextColor = ColorStateList.valueOf((int)this.getResources().getColor(17170435));
        }
        if ((textSize = ta.getDimensionPixelSize(R.styleable.gridPasswordView_gpvTextSize, -1)) != -1) {
            this.mTextSize = ResolutionUtils.pxToSp((float)textSize);
        }
        this.mLineWidth = (int)ta.getDimension(R.styleable.gridPasswordView_gpvLineWidth, (float)ResolutionUtils.dip2Px((float)1.0f));
        this.mLineColor = ta.getColor(R.styleable.gridPasswordView_gpvLineColor, -1433892728);
        this.mGridColor = ta.getColor(R.styleable.gridPasswordView_gpvGridColor, -1);
        this.mLineDrawable = ta.getDrawable(R.styleable.gridPasswordView_gpvLineColor);
        if (this.mLineDrawable == null) {
            this.mLineDrawable = new ColorDrawable(this.mLineColor);
        }
        this.mOuterLineDrawable = this.generateBackgroundDrawable();
        this.mPasswordLength = ta.getInt(R.styleable.gridPasswordView_gpvPasswordLength, 6);
        this.mPasswordTransformation = ta.getString(R.styleable.gridPasswordView_gpvPasswordTransformation);
        if (TextUtils.isEmpty((CharSequence)this.mPasswordTransformation)) {
            this.mPasswordTransformation = DEFAULT_TRANSFORMATION;
        }
        this.mPasswordType = ta.getInt(R.styleable.gridPasswordView_gpvPasswordType, 0);
        ta.recycle();
        this.mPasswordArr = new String[this.mPasswordLength];
        this.mViewArr = new TextView[this.mPasswordLength];
    }

    private void initViews(Context context) {
        this.setShowDividers(0);
        this.setOrientation(0);
        this.mTransformationMethod = new CustomPasswordTransformationMethod(this.mPasswordTransformation);
        this.inflaterViews(context);
    }

    private void inflaterViews(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.gpv_gridpasswordview_channel, (ViewGroup)this);
        this.mInputView = (ImeDelBugFixedEditText)this.findViewById(R.id.inputView);
        this.mInputView.setMaxEms(this.mPasswordLength);
        this.mInputView.addTextChangedListener(this.textWatcher);
        this.mInputView.setDelKeyEventListener(this.onDelKeyEventListener);
        this.setCustomAttr((TextView)this.mInputView);
        this.mViewArr[0] = this.mInputView;
        for (int index = 1; index < this.mPasswordLength; ++index) {
            View dividerView = inflater.inflate(R.layout.gpv_divider_channel, null);
            LinearLayout.LayoutParams dividerParams = new LinearLayout.LayoutParams(this.mLineWidth, -1);
            dividerView.setBackgroundDrawable(this.mLineDrawable);
            this.addView(dividerView, (ViewGroup.LayoutParams)dividerParams);
            TextView textView = (TextView)inflater.inflate(R.layout.gpv_textview_channel, null);
            this.setCustomAttr(textView);
            LinearLayout.LayoutParams textViewParams = new LinearLayout.LayoutParams(ResourceUtils.getDimen((int)R.dimen.password_dialog_txt_size), -1);
            this.addView((View)textView, (ViewGroup.LayoutParams)textViewParams);
            this.mViewArr[index] = textView;
        }
        this.setOnClickListener(this.mOnClickListener);
    }

    private void setCustomAttr(TextView view2) {
        if (this.mTextColor != null) {
            view2.setTextColor(this.mTextColor);
        }
        view2.setTextSize((float)this.mTextSize);
        view2.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        int inputType = 2;
        switch (this.mPasswordType) {
            case 1: {
                inputType = 129;
                break;
            }
            case 2: {
                inputType = 145;
                break;
            }
            case 3: {
                inputType = 225;
                break;
            }
        }
        view2.setInputType(inputType);
        view2.setTransformationMethod((TransformationMethod)this.mTransformationMethod);
    }

    public void setItemBackground(Drawable bgDrawable) {
        if (null != this.mViewArr) {
            for (TextView tv : this.mViewArr) {
                tv.setBackgroundDrawable(bgDrawable);
            }
        }
    }

    public void setInputShowable(boolean inputShowable) {
        this.mInputShowable = inputShowable;
        this.mInputView.setFocusable(this.mInputShowable);
        this.mInputView.setFocusableInTouchMode(this.mInputShowable);
    }

    private GradientDrawable generateBackgroundDrawable() {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setColor(this.mGridColor);
        drawable2.setStroke(this.mLineWidth, this.mLineColor);
        return drawable2;
    }

    public void forceInputViewGetFocus() {
        this.mInputView.setFocusable(true);
        this.mInputView.setFocusableInTouchMode(true);
        this.mInputView.requestFocus();
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.showSoftInput((View)this.mInputView, 1);
    }

    private void notifyTextChanged() {
        if (this.mListener == null) {
            return;
        }
        String currentPsw = this.getPassWord();
        this.mListener.onTextChanged(currentPsw);
        if (currentPsw.length() == this.mPasswordLength) {
            this.mListener.onInputFinish(currentPsw);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putStringArray("passwordArr", this.mPasswordArr);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mPasswordArr = bundle.getStringArray("passwordArr");
            state = bundle.getParcelable("instanceState");
            this.mInputView.removeTextChangedListener(this.textWatcher);
            this.setPassword(this.getPassWord());
            this.mInputView.addTextChangedListener(this.textWatcher);
        }
        super.onRestoreInstanceState(state);
    }

    private void setError(String error) {
        this.mInputView.setError(error);
    }

    @Override
    public String getPassWord() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mPasswordArr.length; ++i) {
            if (this.mPasswordArr[i] == null) continue;
            sb.append(this.mPasswordArr[i]);
        }
        return sb.toString();
    }

    @Override
    public void clearPassword() {
        for (int i = 0; i < this.mPasswordArr.length; ++i) {
            this.mPasswordArr[i] = null;
            this.mViewArr[i].setText(null);
        }
    }

    @Override
    public void setPassword(String password) {
        this.clearPassword();
        if (TextUtils.isEmpty((CharSequence)password)) {
            return;
        }
        char[] pswArr = password.toCharArray();
        for (int i = 0; i < pswArr.length; ++i) {
            if (i >= this.mPasswordArr.length) continue;
            this.mPasswordArr[i] = pswArr[i] + "";
            this.mViewArr[i].setText((CharSequence)this.mPasswordArr[i]);
        }
    }

    @Override
    public void setPasswordVisibility(boolean visible) {
        for (TextView textView : this.mViewArr) {
            textView.setTransformationMethod((TransformationMethod)(visible ? null : this.mTransformationMethod));
            if (!(textView instanceof EditText)) continue;
            EditText et = (EditText)textView;
            et.setSelection(et.getText().length());
        }
    }

    @Override
    public void togglePasswordVisibility() {
        boolean currentVisible = this.getPassWordVisibility();
        this.setPasswordVisibility(!currentVisible);
    }

    private boolean getPassWordVisibility() {
        return this.mViewArr[0].getTransformationMethod() == null;
    }

    @Override
    public void setOnPasswordChangedListener(OnPasswordChangedListener listener2) {
        this.mListener = listener2;
    }

    @Override
    public void setPasswordType(PasswordType passwordType) {
        boolean visible = this.getPassWordVisibility();
        int inputType = 2;
        switch (passwordType) {
            case TEXT: {
                inputType = 129;
                break;
            }
            case TEXTVISIBLE: {
                inputType = 145;
                break;
            }
            case TEXTWEB: {
                inputType = 225;
                break;
            }
        }
        for (TextView textView : this.mViewArr) {
            textView.setInputType(inputType);
        }
        this.setPasswordVisibility(visible);
    }

    public void setBackground(Drawable background) {
    }

    public void setBackgroundColor(int color2) {
    }

    public void setBackgroundResource(int resid) {
    }

    public void setBackgroundDrawable(Drawable background) {
    }

    public static interface OnPasswordChangedListener {
        public void onTextChanged(String var1);

        public void onInputFinish(String var1);
    }
}

