/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.voiceroom;

import android.graphics.Color;
import android.widget.TextView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.component.invite.base.OnlineBean;
import com.yy.hiyo.channel.component.invite.online.handler.AbsOnlineInviteHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MultiVideoSeatInviteHandler
extends AbsOnlineInviteHandler {
    private static final String TAG = "MultiVideoSeatInviteHandler";
    private static final int COLOR_SEATED;
    private static final int COLOR_INVITED;
    private IChannel mChannel;
    private int mSeatIndex = -1;
    private boolean fromMultiVideo = false;
    private Callback<Boolean> mInviteStatusChangedCallback;

    public MultiVideoSeatInviteHandler(IChannel channel) {
        this.mChannel = channel;
    }

    public MultiVideoSeatInviteHandler(IChannel channel, int seatIndex) {
        this.mChannel = channel;
        this.mSeatIndex = seatIndex;
    }

    public MultiVideoSeatInviteHandler(IChannel channel, boolean fromMultiVideo) {
        this.mChannel = channel;
        this.fromMultiVideo = fromMultiVideo;
    }

    @Override
    protected void notifyInviteStatusChange(OnlineBean onlineBean) {
        super.notifyInviteStatusChange(onlineBean);
        if (null != this.mInviteStatusChangedCallback) {
            this.mInviteStatusChangedCallback.onResponse((Object)true);
        }
    }

    @Override
    public String getInviteTitle() {
        return ResourceUtils.getString((int)R.string.short_title_channel_invite_to_seat);
    }

    @Override
    public List<OnlineBean> filterOnlineData(List<OnlineBean> data2) {
        List uidInSeat = this.mChannel.getSeatService().getSeatUidsList();
        if (!FP.empty((Collection)uidInSeat) && data2 != null) {
            for (OnlineBean onlineBean : data2) {
                if (uidInSeat.contains(onlineBean.uid)) {
                    onlineBean.inivteStatus = 3;
                    onlineBean.isSeated = true;
                } else {
                    onlineBean.isSeated = false;
                }
                if (this.fromMultiVideo) {
                    onlineBean.pluginMode = 15;
                }
                MLog.info((Object)TAG, (String)("onlineBean pluginMode:" + onlineBean.pluginMode), (Object[])new Object[0]);
            }
        }
        if (this.fromMultiVideo && data2 != null) {
            Collections.sort(data2, new Comparator<OnlineBean>(){

                @Override
                public int compare(OnlineBean o1, OnlineBean o2) {
                    return o2.inivteStatus - o1.inivteStatus;
                }
            });
        }
        return data2;
    }

    @Override
    public void onInviteClick(final OnlineBean onlineBean) {
        this.mChannel.getSeatService().makeSitDown(this.mSeatIndex, onlineBean.uid, new IOperationCallback(){

            public void onSuccess() {
                onlineBean.inivteStatus = 1;
                MultiVideoSeatInviteHandler.this.notifyInviteStatusChange(onlineBean);
            }

            public void onFail(long reason) {
                MLog.error((Object)MultiVideoSeatInviteHandler.TAG, (String)("onInviteClick makeSitDown fail reason = " + reason), (Object[])new Object[0]);
            }
        });
    }

    @Override
    public void updateActionBtn(OnlineBean onlineBean, TextView actionBtn) {
        if (onlineBean.uid == AccountUtil.getUid()) {
            actionBtn.setVisibility(8);
        } else if (onlineBean.inivteStatus == 3) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(COLOR_SEATED);
            actionBtn.setText(R.string.btn_room_user_sitted);
            actionBtn.setBackgroundResource(0);
            actionBtn.setOnClickListener(null);
        } else if (onlineBean.inivteStatus == 1) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(COLOR_INVITED);
            actionBtn.setText(R.string.invited);
            actionBtn.setBackgroundResource(0);
            actionBtn.setOnClickListener(null);
        } else if (onlineBean.inivteStatus == 0) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(-1);
            actionBtn.setText(R.string.invite);
            actionBtn.setBackgroundResource(R.drawable.bg_multi_video_sit_profile_card);
            actionBtn.setOnClickListener(v -> this.onInviteClick(onlineBean));
        } else {
            actionBtn.setVisibility(8);
        }
    }

    public void setStatusChangedCallback(Callback<Boolean> callback2) {
        this.mInviteStatusChangedCallback = callback2;
    }

    static {
        COLOR_INVITED = COLOR_SEATED = Color.parseColor((String)"#999999");
    }
}

