/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.online;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.FlowLayout;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.util.StatusUtil;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.framework.core.ui.svga.YYSvgaImageView;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.HonorBean;
import com.yy.hiyo.channel.base.bean.UserTagLocation;
import com.yy.hiyo.channel.base.bean.UserTagSource;
import com.yy.hiyo.channel.base.utils.NationalFlagUtils;
import com.yy.hiyo.channel.base.widget.UserTagsLayout;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.invite.base.OnlineBean;
import com.yy.hiyo.channel.component.invite.online.OnlineListCallback;
import com.yy.hiyo.channel.component.seat.holder.IItemView;
import com.yy.hiyo.channel.plugins.general.innerpresenter.GameOpenChannelPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.GameChannelFollow;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.GameChannelInfoPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.IGameChannelFollowView;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.entity.ChannelUserStatusInfo;
import com.yy.hiyo.mvp.base.ICustomView;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.wallet.base.IUserIDView;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import net.ihago.channel.srv.mgr.ComerFlag;

class OnlineItemView
extends YYConstraintLayout
implements ICustomView,
IItemView<OnlineBean> {
    public static final String TAG = OnlineItemView.class.getSimpleName();
    private static final int DEFAULT_NICK_COLOR = Color.parseColor((String)"#0b0505");
    private CircleImageView mAvatar;
    private YYTextView mNickName;
    private RecycleImageView mRoleView;
    private RecycleImageView mUserGenderView;
    private YYTextView mTvLocation;
    private YYTextView mActionBtn;
    private OnItemListener mItemListener;
    private OnlineBean mItemData;
    private FlowLayout mMedalsLayout;
    private Context mContext;
    private OnlineListCallback mOnlineListCallback;
    private YYTextView mTvAge;
    private LinearLayout mGenderAndAgeContainer;
    private RecycleImageView mNationFlagIv;
    private static final long HIDE_LOCATION = 1L;
    private static final long SHOW_LOCATION = 0L;
    private IUserIDView mIUserIDView;
    private YYFrameLayout mChannelStatusView;
    private GameChannelFollow gameChannelFollow;
    private UserTagsLayout mUserTagsLayout;
    private RecycleImageView mIvStatusBadge;
    private YYTextView mChargeTag;
    private IGameChannelFollowView mChannelFollowView;

    OnlineItemView(Context context) {
        super(context);
        this.mContext = context;
        this.createView(null);
    }

    public void createView(@Nullable AttributeSet attrs) {
        OnlineItemView.inflate((Context)this.getContext(), (int)R.layout.room_online_list_item_channel, (ViewGroup)this);
        this.setMinHeight(ResolutionUtils.dip2Px((float)75.0f));
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
        this.setLayoutParams(params);
        this.mAvatar = (CircleImageView)this.findViewById(R.id.avatar);
        this.mNickName = (YYTextView)this.findViewById(R.id.nick_name);
        this.mRoleView = (RecycleImageView)this.findViewById(R.id.iv_role);
        this.mIvStatusBadge = (RecycleImageView)this.findViewById(R.id.iv_status_badge);
        this.mUserGenderView = (RecycleImageView)this.findViewById(R.id.iv_gender);
        this.mGenderAndAgeContainer = (LinearLayout)this.findViewById(R.id.ll_gender_and_age);
        this.mTvAge = (YYTextView)this.findViewById(R.id.tv_age);
        this.mTvLocation = (YYTextView)this.findViewById(R.id.tv_location);
        this.mActionBtn = (YYTextView)this.findViewById(R.id.action_btn);
        this.mMedalsLayout = (FlowLayout)this.findViewById(R.id.fl_medals);
        this.mNationFlagIv = (RecycleImageView)this.findViewById(R.id.iv_nation_flag);
        this.mChannelStatusView = (YYFrameLayout)this.findViewById(R.id.channel_status_container);
        this.mUserTagsLayout = (UserTagsLayout)this.findViewById(R.id.userTagLayout);
        this.mUserTagsLayout.setClickSource(UserTagSource.ONLINE_MEMBER);
        this.mChargeTag = (YYTextView)this.findViewById(R.id.charge_tag);
        this.mChannelFollowView = GameChannelFollow.getChannelGameFollowView(IGameChannelFollowView.ViewType.ONLINE_LIST);
        this.mChannelFollowView.getView().setVisibility(8);
        this.mChannelStatusView.addView(this.mChannelFollowView.getView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.gameChannelFollow = new GameChannelFollow(new GameChannelFollow.OnGameChannelFollow(){

            @Override
            public IMvpContext getPageMvpContext() {
                if (OnlineItemView.this.mOnlineListCallback != null) {
                    return OnlineItemView.this.mOnlineListCallback.getMvpContext();
                }
                return null;
            }

            @Override
            public void updateView() {
                if (OnlineItemView.this.gameChannelFollow.canShowEntry()) {
                    IGameChannelFollowView.EntryType entryShowType = OnlineItemView.this.mChannelFollowView.getEntryShowType();
                    if (OnlineItemView.this.mItemData != null) {
                        if (entryShowType == IGameChannelFollowView.EntryType.GAME) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "online_enter_channel_but_show").put("room_id", OnlineItemView.this.getChannelId()).put("other_uid", ((OnlineItemView)OnlineItemView.this).mItemData.uid + ""));
                        } else if (entryShowType == IGameChannelFollowView.EntryType.ROOM) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "online_enter_game_but_show").put("room_id", OnlineItemView.this.getChannelId()).put("other_uid", ((OnlineItemView)OnlineItemView.this).mItemData.uid + ""));
                        }
                    }
                    OnlineItemView.this.mChannelFollowView.getView().setVisibility(0);
                } else {
                    OnlineItemView.this.mChannelFollowView.getView().setVisibility(8);
                }
            }

            @Override
            public String getCurChannelId() {
                return null;
            }

            @Override
            public boolean interceptClick() {
                return OnlineItemView.this.mOnlineListCallback != null && OnlineItemView.this.mOnlineListCallback.getMvpContext() != null && ((GameOpenChannelPresenter)OnlineItemView.this.mOnlineListCallback.getMvpContext().getPresenter(GameOpenChannelPresenter.class)).isOpenByGame();
            }
        });
        this.gameChannelFollow.setView(this.mChannelFollowView);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OnlineItemView.this.mItemData != null) {
                    OnlineItemView.this.mItemListener.onAvatarClick(OnlineItemView.this.mItemData);
                }
            }
        });
        if (LanguageUtils.isRtl()) {
            this.mMedalsLayout.setRtl(true);
        }
    }

    private String getChannelId() {
        InvitePresenter presenter;
        IMvpContext mvpContext;
        if (this.mOnlineListCallback != null && (mvpContext = this.mOnlineListCallback.getMvpContext()) != null && (presenter = (InvitePresenter)mvpContext.getPresenter(InvitePresenter.class)) != null) {
            return presenter.getChannelId();
        }
        return "";
    }

    public void setOnlineListCallback(OnlineListCallback onlineListCallback) {
        this.mOnlineListCallback = onlineListCallback;
    }

    @Override
    public void setData(OnlineBean data2) {
        IMvpContext mvpContext;
        if (data2 == null || data2.userInfo == null) {
            return;
        }
        if (data2.isVipSeat) {
            this.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.vip_seat_item_bg));
        } else {
            this.setBackgroundDrawable(null);
        }
        this.mMedalsLayout.removeAllViews();
        this.mMedalsLayout.addView((View)this.mNationFlagIv);
        this.mMedalsLayout.addView((View)this.mRoleView);
        this.mMedalsLayout.addView((View)this.mUserTagsLayout);
        this.mMedalsLayout.addView((View)this.mGenderAndAgeContainer);
        this.mMedalsLayout.addView((View)this.mTvLocation);
        this.mItemData = data2;
        this.mUserTagsLayout.setData(data2.mUserTagInfoList, UserTagLocation.LOCATION_MEMBER.getLocation(), data2.uid, DpToPxDef.RESOLUTION_17_DP);
        for (int i = 0; i < this.mUserTagsLayout.getChildCount(); ++i) {
            View child = this.mUserTagsLayout.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)child.getLayoutParams();
            params.rightMargin = i == this.mUserTagsLayout.getChildCount() - 1 ? 0 : DpToPxDef.RESOLUTION_3_DP;
        }
        MLog.info((Object)"OnlineItemView", (String)"uid: %s,nick: %s,role type: %s", (Object[])new Object[]{data2.uid, data2.userInfo.nick, data2.roleType});
        ImageLoader.loadImage((ImageView)this.mAvatar, (String)(data2.userInfo.avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)0, (int)AvatarUtils.getDefaultAvatar((int)data2.userInfo.sex));
        this.mNickName.setText((CharSequence)data2.userInfo.nick);
        if (data2.nickColor != 0) {
            this.mNickName.setTextColor(data2.nickColor);
        } else {
            this.mNickName.setTextColor(DEFAULT_NICK_COLOR);
        }
        this.mNationFlagIv.setVisibility(8);
        this.setNationFlag(data2.userInfo);
        if (this.mRoleView != null) {
            if (15 == data2.roleType || data2.uid == data2.ownerId) {
                this.mRoleView.setVisibility(0);
                this.mRoleView.setImageResource(R.drawable.icon_group_host);
            } else if (10 == data2.roleType) {
                this.mRoleView.setVisibility(0);
                this.mRoleView.setImageResource(R.drawable.icon_group_administrator);
            } else if (data2.isMember) {
                this.mRoleView.setVisibility(0);
                if (data2.isAnchor) {
                    this.mRoleView.setImageResource(R.drawable.icon_room_host);
                } else {
                    this.mRoleView.setImageResource(R.drawable.icon_group_member);
                }
            } else {
                this.mRoleView.setVisibility(8);
            }
        }
        if (this.mUserGenderView != null) {
            if (data2.userInfo.sex == 0) {
                this.mUserGenderView.setImageResource(R.drawable.icon_female);
                this.mGenderAndAgeContainer.setBackgroundResource(R.drawable.bg_channel_online_age_and_sex_female);
            } else {
                this.mUserGenderView.setImageResource(R.drawable.icon_male);
                this.mGenderAndAgeContainer.setBackgroundResource(R.drawable.bg_channel_online_age_and_sex_male);
            }
        }
        if (this.mTvLocation != null) {
            String address = "";
            if (data2.userInfo.hideLocation != 1L) {
                address = StringUtils.isNotEmpty((String)data2.userInfo.lastLoginLocation) ? data2.userInfo.lastLoginLocation : ResourceUtils.getString((int)R.string.profile_no_location);
            }
            this.mTvLocation.setText((CharSequence)address);
            int age = DateUtils.getAge((String)data2.userInfo.birthday);
            this.mTvAge.setText((CharSequence)String.valueOf(age));
        }
        this.mIvStatusBadge.setBackgroundDrawable(StatusUtil.getStatusBadge((int)data2.status));
        if (this.mMedalsLayout != null && null != data2.wearingInfos) {
            for (final HonorBean honorBean : data2.wearingInfos) {
                ViewGroup.LayoutParams layoutParams;
                if (honorBean == null) continue;
                if (honorBean.getUrl().endsWith(".svga")) {
                    final YYSvgaImageView svgaImageView = new YYSvgaImageView(this.mContext);
                    svgaImageView.setFillMode(SVGAImageView.FillMode.Forward);
                    layoutParams = new ViewGroup.LayoutParams(ResolutionUtils.dip2Px((float)(honorBean.getWidth() * 14 / honorBean.getHeight())), ResolutionUtils.dip2Px((float)14.0f));
                    this.mMedalsLayout.addView((View)svgaImageView, this.mMedalsLayout.getChildCount() - 2, layoutParams);
                    SvgaLoader.load((SVGAImageView)svgaImageView, (String)honorBean.getUrl(), (ISvgaLoadCallback)new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                            if (svgaVideoEntity != null) {
                                SVGADrawable svgaDrawable = new SVGADrawable(svgaVideoEntity);
                                svgaImageView.setImageDrawable((Drawable)svgaDrawable);
                                svgaImageView.setSVGADrawable(svgaDrawable);
                                svgaImageView.startAnimation();
                            }
                        }

                        public void onFailed(Exception e) {
                            MLog.error((Object)TAG, (String)"loadSvga failed,url:%s,exception:%s", (Object[])new Object[]{honorBean.getUrl(), e.toString()});
                            svgaImageView.stopAnimation();
                        }
                    });
                    svgaImageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (OnlineItemView.this.mOnlineListCallback != null) {
                                // empty if block
                            }
                        }
                    });
                    continue;
                }
                RecycleImageView imageView = new RecycleImageView(this.mContext);
                layoutParams = new ViewGroup.LayoutParams(ResolutionUtils.dip2Px((float)(honorBean.getWidth() * 14 / honorBean.getHeight())), ResolutionUtils.dip2Px((float)14.0f));
                this.mMedalsLayout.addView((View)imageView, this.mMedalsLayout.getChildCount() - 2, layoutParams);
                ImageLoader.loadImage((ImageView)imageView, (String)honorBean.getUrl());
                imageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (OnlineItemView.this.mOnlineListCallback != null) {
                            // empty if block
                        }
                    }
                });
            }
        }
        this.updateActionBtn(data2);
        if (this.mOnlineListCallback != null && (mvpContext = this.mOnlineListCallback.getMvpContext()) != null) {
            ChannelUserStatusInfo defaultUserChannelStatusInfo = ((GameChannelInfoPresenter)mvpContext.getPresenter(GameChannelInfoPresenter.class)).getDefaultUserChannelStatusInfo(data2.uid);
            this.gameChannelFollow.bindInfo(defaultUserChannelStatusInfo);
        }
        if (data2.potentialFlag == ComerFlag.CF_FIRST_RECHARGE.getValue()) {
            this.mChargeTag.setVisibility(0);
        }
    }

    private void setNationFlag(UserInfoKS userInfo) {
        if (userInfo != null && !TextUtils.isEmpty((CharSequence)userInfo.country)) {
            String url = NationalFlagUtils.INSTANCE.getNationalFlag(userInfo.country);
            if (StringUtils.isNotEmpty((String)url)) {
                this.mNationFlagIv.setVisibility(0);
                ImageLoader.loadImage((ImageView)this.mNationFlagIv, (String)url);
            }
        } else {
            this.mNationFlagIv.setVisibility(8);
        }
    }

    public void updateActionBtn(OnlineBean data2) {
        if (this.mItemListener != null) {
            this.mItemListener.onUpdateActionBtn(data2, (TextView)this.mActionBtn);
        }
    }

    public void setItemListener(OnItemListener itemListener) {
        this.mItemListener = itemListener;
    }

    public static interface OnItemListener {
        public void onAvatarClick(OnlineBean var1);

        public void onUpdateActionBtn(OnlineBean var1, TextView var2);
    }
}

