/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friendV2.header;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;

public class PlatformViewHolderV2
implements View.OnClickListener {
    private final HashMap<View, Integer> animationTimesMap = new HashMap();
    private final LinearLayout llRoot;
    private final IChannel mChannel;
    @Nullable
    private OnPlatformShareListener platformShareListener;

    private PlatformViewHolderV2(LinearLayout itemView, IChannel channel) {
        this.llRoot = itemView;
        this.mChannel = channel;
    }

    public void setPlatformShareListener(@Nullable OnPlatformShareListener platformShareListener) {
        this.platformShareListener = platformShareListener;
    }

    private void startGuideAnimation(View guideView) {
        Integer guideViewTimesInteger = this.animationTimesMap.get(guideView);
        int guideViewTimes = guideViewTimesInteger == null ? 0 : guideViewTimesInteger;
        guideView.animate().cancel();
        if (guideViewTimes >= 12) {
            guideView.animate().alpha(0.0f).setDuration(1000L).withEndAction(() -> guideView.setVisibility(8)).start();
            return;
        }
        if (guideView.getAlpha() == 0.0f) {
            guideView.animate().alpha(1.0f).setDuration(1000L).withEndAction(() -> this.startGuideAnimation(guideView)).start();
        } else {
            guideView.animate().alpha(0.0f).setDuration(1000L).withEndAction(() -> this.startGuideAnimation(guideView)).start();
        }
        this.animationTimesMap.put(guideView, guideViewTimes + 1);
    }

    private void addView(int idResId, @DrawableRes int iconResId, @StringRes int strResId, @ColorInt int guideColor) {
        if (idResId > 0) {
            View guideView = null;
            if (guideColor != 0) {
                guideView = new View(this.llRoot.getContext());
                FrameLayout.LayoutParams guideViewLp = new FrameLayout.LayoutParams(ResolutionUtils.dip2Px((float)50.0f), ResolutionUtils.dip2Px((float)50.0f));
                guideViewLp.gravity = 49;
                guideViewLp.topMargin = ResolutionUtils.dip2Px((float)5.0f);
                guideView.setLayoutParams((ViewGroup.LayoutParams)guideViewLp);
                GradientDrawable sd = new GradientDrawable();
                sd.setColor(guideColor);
                sd.setShape(1);
                guideView.setBackground((Drawable)sd);
            }
            YYImageView ivChannel = new YYImageView(this.llRoot.getContext());
            FrameLayout.LayoutParams ivLp = new FrameLayout.LayoutParams(ResolutionUtils.dip2Px((float)40.0f), ResolutionUtils.dip2Px((float)40.0f));
            ivLp.topMargin = ResolutionUtils.dip2Px((float)10.0f);
            ivLp.gravity = 49;
            ivChannel.setLayoutParams((ViewGroup.LayoutParams)ivLp);
            ivChannel.setBackgroundResource(iconResId);
            YYTextView tv = new YYTextView(this.llRoot.getContext());
            FrameLayout.LayoutParams tvLp = new FrameLayout.LayoutParams(-2, -2);
            tvLp.gravity = 81;
            tvLp.bottomMargin = ResolutionUtils.dip2Px((float)10.0f);
            tv.setLayoutParams((ViewGroup.LayoutParams)tvLp);
            tv.setMaxLines(1);
            tv.setTextColor(-6710887);
            tv.setTextSize(11.0f);
            tv.setText(strResId);
            tv.setEllipsize(TextUtils.TruncateAt.END);
            YYFrameLayout item = new YYFrameLayout(this.llRoot.getContext());
            LinearLayout.LayoutParams itemLp = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)80.0f), ResolutionUtils.dip2Px((float)78.0f));
            item.setLayoutParams((ViewGroup.LayoutParams)itemLp);
            if (guideView != null) {
                item.addView(guideView);
            }
            item.addView((View)ivChannel);
            item.addView((View)tv);
            item.setId(idResId);
            this.llRoot.addView((View)item);
            item.setOnClickListener((View.OnClickListener)this);
            if (guideView != null) {
                guideView.setAlpha(0.0f);
                this.startGuideAnimation(guideView);
            }
        }
    }

    private void addChannel(BaseShareChannel channel) {
        if (channel == null) {
            return;
        }
        boolean isBaseMode = this.mChannel.getPluginService().getCurPluginData().getMode() == 1;
        int idResId = 0;
        int iconResId = 0;
        int strResId = 0;
        int guideColor = 0;
        switch (channel.getId()) {
            case 2: {
                idResId = R.id.share_platform_whatsapp;
                iconResId = isBaseMode ? R.drawable.select_share_whatsapp_channel_bg : R.drawable.select_share_whatsapp_bg;
                strResId = R.string.share_platform_whatsapp;
                break;
            }
            case 5: {
                idResId = R.id.share_platform_facebook;
                iconResId = isBaseMode ? R.drawable.select_share_fb_channel_bg : R.drawable.select_share_fb_bg;
                strResId = R.string.share_platform_facebook;
                break;
            }
            case 3: {
                idResId = R.id.share_platform_instagram;
                iconResId = R.drawable.select_share_ins_bg;
                strResId = R.string.share_platform_instagram;
                break;
            }
            case 1: {
                idResId = R.id.share_platform_line;
                iconResId = isBaseMode ? R.drawable.select_share_line_channel_bg : R.drawable.select_share_line_bg;
                strResId = R.string.share_platform_line;
                break;
            }
            case 6: {
                idResId = R.id.share_platform_messenger;
                iconResId = R.drawable.select_share_messenger_bg;
                strResId = R.string.share_platform_messenger;
                break;
            }
            case 9: {
                idResId = R.id.share_platform_vk;
                iconResId = R.drawable.select_share_vk_bg;
                strResId = R.string.share_platform_vk;
                break;
            }
            case 10: {
                idResId = R.id.share_copy_link;
                iconResId = isBaseMode ? R.drawable.select_share_copy_channel_bg : R.drawable.select_share_copy_bg;
                strResId = R.string.title_share_copy_link;
                break;
            }
            case 13: {
                idResId = R.id.share_native;
                iconResId = isBaseMode ? R.drawable.select_share_native_channel_bg : R.drawable.select_share_native_bg;
                strResId = R.string.string_friends;
                break;
            }
            case 17: {
                idResId = R.id.share_room_to_bbs;
                iconResId = R.drawable.select_share_post;
                strResId = R.string.short_tips_post;
                if (!SettingFlags.getBoolean((String)"key_shre_room_to_post_gudie", (boolean)true)) break;
                guideColor = 1291829506;
                break;
            }
        }
        this.addView(idResId, iconResId, strResId, guideColor);
    }

    private void addFamilyCall() {
        int idResId = R.id.channel_family_call;
        int iconResId = R.drawable.icon_family_call_room_launch;
        this.addView(idResId, iconResId, R.string.home_drawer_page_family, 0);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080028").put("function_id", "entry_show"));
    }

    public void setData(PlatformShareData data2) {
        this.llRoot.removeAllViews();
        if (data2 == null || data2.getChannelList() == null) {
            return;
        }
        for (BaseShareChannel channel : data2.getChannelList()) {
            this.addChannel(channel);
        }
        if (data2.canSendFamilyCall()) {
            this.addFamilyCall();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (this.platformShareListener == null) {
            return;
        }
        if (id2 == R.id.channel_family_call) {
            this.platformShareListener.onSendFamilyCall();
        } else {
            int channelId = ShareChannelIdDef.getChannelIdByViewId((int)id2);
            if (channelId != -1) {
                if (channelId == 17) {
                    SettingFlags.setBoolean((String)"key_shre_room_to_post_gudie", (boolean)false);
                }
                this.platformShareListener.onPlatformShare(channelId);
            }
        }
    }

    public static PlatformViewHolderV2 inflate(@NonNull ViewGroup parent, @Nullable OnPlatformShareListener platformShareListener, @NonNull IChannel channel) {
        YYLinearLayout llRoot = new YYLinearLayout(parent.getContext());
        llRoot.setOrientation(0);
        ViewGroup.LayoutParams rootLP = new ViewGroup.LayoutParams(-1, -2);
        llRoot.setLayoutParams(rootLP);
        HorizontalScrollView scrollView = new HorizontalScrollView(parent.getContext());
        scrollView.addView((View)llRoot);
        scrollView.setHorizontalScrollBarEnabled(false);
        parent.addView((View)scrollView, -1, -2);
        PlatformViewHolderV2 viewHolder = new PlatformViewHolderV2((LinearLayout)llRoot, channel);
        viewHolder.setPlatformShareListener(platformShareListener);
        return viewHolder;
    }

    public static interface OnPlatformShareListener {
        public void onPlatformShare(int var1);

        public void onSendFamilyCall();
    }
}

