/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.viewholder;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;

public class PlatformViewHolder
extends BaseItemBinder.ViewHolder<PlatformShareData>
implements View.OnClickListener {
    private final HashMap<View, Integer> animationTimesMap = new HashMap();
    private LinearLayout llRoot;
    private OnPlatformShareListener platformShareListener;
    private IChannel mChannel;

    private PlatformViewHolder(ViewGroup itemView, IChannel channel) {
        super((View)itemView);
        this.llRoot = (LinearLayout)itemView.getChildAt(0);
        this.mChannel = channel;
    }

    public void setData(PlatformShareData data2) {
        super.setData((Object)data2);
        this.llRoot.removeAllViews();
        if (data2 == null && data2.getChannelList() != null) {
            return;
        }
        for (BaseShareChannel channel : data2.getChannelList()) {
            this.addChannel(channel);
        }
        if (data2.canSendFamilyCall()) {
            this.addFamilyCall();
        }
    }

    public void setPlatformShareListener(OnPlatformShareListener platformShareListener) {
        this.platformShareListener = platformShareListener;
    }

    private void addChannel(BaseShareChannel channel) {
        if (channel == null) {
            return;
        }
        boolean isBaseMode = this.mChannel.getPluginService().getCurPluginData().getMode() == 1;
        int idResId = 0;
        int iconResId = 0;
        int guideColor = 0;
        switch (channel.getId()) {
            case 2: {
                idResId = R.id.share_platform_whatsapp;
                if (isBaseMode) {
                    iconResId = R.drawable.select_share_whatsapp_channel_bg;
                    break;
                }
                iconResId = R.drawable.select_share_whatsapp_bg;
                break;
            }
            case 5: {
                idResId = R.id.share_platform_facebook;
                if (isBaseMode) {
                    iconResId = R.drawable.select_share_fb_channel_bg;
                    break;
                }
                iconResId = R.drawable.select_share_fb_bg;
                break;
            }
            case 3: {
                idResId = R.id.share_platform_instagram;
                iconResId = R.drawable.select_share_ins_bg;
                break;
            }
            case 1: {
                idResId = R.id.share_platform_line;
                if (isBaseMode) {
                    iconResId = R.drawable.select_share_line_channel_bg;
                    break;
                }
                iconResId = R.drawable.select_share_line_bg;
                break;
            }
            case 6: {
                idResId = R.id.share_platform_messenger;
                iconResId = R.drawable.select_share_messenger_bg;
                break;
            }
            case 9: {
                idResId = R.id.share_platform_vk;
                iconResId = R.drawable.select_share_vk_bg;
                break;
            }
            case 10: {
                idResId = R.id.share_copy_link;
                if (isBaseMode) {
                    iconResId = R.drawable.select_share_copy_channel_bg;
                    break;
                }
                iconResId = R.drawable.select_share_copy_bg;
                break;
            }
            case 13: {
                idResId = R.id.share_native;
                if (isBaseMode) {
                    iconResId = R.drawable.select_share_native_channel_bg;
                    break;
                }
                iconResId = R.drawable.select_share_native_bg;
                break;
            }
            case 17: {
                idResId = R.id.share_room_to_bbs;
                iconResId = R.drawable.select_share_post;
                if (!SettingFlags.getBoolean((String)"key_shre_room_to_post_gudie", (boolean)true)) break;
                guideColor = 1291829506;
                break;
            }
        }
        this.addView(idResId, iconResId, guideColor);
    }

    private void addFamilyCall() {
        int idResId = R.id.channel_family_call;
        int iconResId = R.drawable.icon_family_call_room_launch;
        this.addView(idResId, iconResId, 0);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080028").put("function_id", "entry_show"));
    }

    private void startGuideAnimation(View guideView) {
        Integer guideViewTimesInteger = this.animationTimesMap.get(guideView);
        int guideViewTimes = guideViewTimesInteger == null ? 0 : guideViewTimesInteger;
        guideView.animate().cancel();
        if (guideViewTimes >= 12) {
            guideView.animate().alpha(0.0f).setDuration(1000L).withEndAction(() -> guideView.setVisibility(8)).start();
            return;
        }
        if (guideView.getAlpha() == 0.0f) {
            guideView.animate().alpha(1.0f).setDuration(1000L).withEndAction(() -> this.startGuideAnimation(guideView)).start();
        } else {
            guideView.animate().alpha(0.0f).setDuration(1000L).withEndAction(() -> this.startGuideAnimation(guideView)).start();
        }
        this.animationTimesMap.put(guideView, guideViewTimes + 1);
    }

    private void addView(int idResId, int iconResId, @ColorInt int guideColor) {
        if (idResId > 0) {
            View guideView = null;
            if (guideColor != 0) {
                guideView = new View(this.llRoot.getContext());
                FrameLayout.LayoutParams guideViewLp = new FrameLayout.LayoutParams(ResolutionUtils.dip2Px((float)50.0f), ResolutionUtils.dip2Px((float)50.0f));
                guideViewLp.gravity = 49;
                guideViewLp.topMargin = ResolutionUtils.dip2Px((float)5.0f);
                guideView.setLayoutParams((ViewGroup.LayoutParams)guideViewLp);
                GradientDrawable sd = new GradientDrawable();
                sd.setColor(guideColor);
                sd.setShape(1);
                guideView.setBackground((Drawable)sd);
            }
            YYImageView ivChannel = new YYImageView(this.llRoot.getContext());
            FrameLayout.LayoutParams ivLp = new FrameLayout.LayoutParams(ResolutionUtils.dip2Px((float)40.0f), ResolutionUtils.dip2Px((float)40.0f));
            ivLp.topMargin = ResolutionUtils.dip2Px((float)10.0f);
            ivLp.gravity = 49;
            ivChannel.setLayoutParams((ViewGroup.LayoutParams)ivLp);
            ivChannel.setBackgroundResource(iconResId);
            boolean isBaseMode = this.mChannel.getPluginService().getCurPluginData().getMode() == 1;
            YYFrameLayout item = new YYFrameLayout(this.llRoot.getContext());
            LinearLayout.LayoutParams itemLp = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)60.0f), ResolutionUtils.dip2Px((float)60.0f));
            if (isBaseMode) {
                itemLp.weight = 1.0f;
            }
            item.setLayoutParams((ViewGroup.LayoutParams)itemLp);
            if (guideView != null) {
                item.addView(guideView);
            }
            item.addView((View)ivChannel);
            item.setId(idResId);
            this.llRoot.addView((View)item);
            item.setOnClickListener((View.OnClickListener)this);
            if (guideView != null) {
                guideView.setAlpha(0.0f);
                this.startGuideAnimation(guideView);
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (this.platformShareListener == null) {
            return;
        }
        if (id2 == R.id.channel_family_call) {
            this.platformShareListener.onSendFamilyCall();
        } else {
            int channelId = ShareChannelIdDef.getChannelIdByViewId((int)id2);
            if (channelId != -1) {
                if (channelId == 17) {
                    SettingFlags.setBoolean((String)"key_shre_room_to_post_gudie", (boolean)false);
                }
                this.platformShareListener.onPlatformShare(channelId);
            }
        }
    }

    public static BaseItemBinder getItemBinder(final OnPlatformShareListener platformShareListener, final IChannel channel) {
        return new BaseItemBinder<PlatformShareData, PlatformViewHolder>(){

            @NonNull
            protected PlatformViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                YYLinearLayout llRoot = new YYLinearLayout(parent.getContext());
                llRoot.setOrientation(0);
                ViewGroup.LayoutParams rootLP = new ViewGroup.LayoutParams(-1, -2);
                llRoot.setLayoutParams(rootLP);
                HorizontalScrollView scrollView = new HorizontalScrollView(parent.getContext());
                scrollView.addView((View)llRoot);
                scrollView.setHorizontalScrollBarEnabled(false);
                PlatformViewHolder viewHolder = new PlatformViewHolder((ViewGroup)scrollView, channel);
                viewHolder.setPlatformShareListener(platformShareListener);
                return viewHolder;
            }
        };
    }

    public static interface OnPlatformShareListener {
        public void onPlatformShare(int var1);

        public void onSendFamilyCall();
    }
}

