/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.behavior;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.util.RegionUtils;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.invite.callback.IInviteAllCallback;
import com.yy.hiyo.channel.component.invite.callback.IInviteFriendCallback;
import com.yy.hiyo.channel.component.invite.friend.behavior.AbsFriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.share.ChannelShareDataProvider;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.dataprovider.ShareDataProvider;
import java.util.List;
import net.ihago.channel.srv.mgr.GetInviteIDReq;
import net.ihago.channel.srv.mgr.GetInviteIDRes;
import net.ihago.room.srv.follow.EPath;
import net.ihago.room.srv.follow.InviteFansReq;
import net.ihago.room.srv.follow.InviteFansRes;

public class DefaultFriendInviteBehavior
extends AbsFriendInviteBehavior {
    private static final String TAG = "FTVoiceRoomDefaultFriendInviteBehavior";
    private PlatformShareData mPlatformShareData;
    private ChannelShareDataProvider mShareDataProvider;
    private InvitePresenter.InviteClickListener listener;

    public DefaultFriendInviteBehavior(IMvpContext mvpContext, InvitePresenter.InviteClickListener listener2) {
        super(mvpContext);
        this.listener = listener2;
    }

    @Override
    public void onInviteFriend(final InviteFriendData data2, final IInviteFriendCallback callback2) {
        MLog.info((Object)TAG, (String)"onInviteFriend, uid=%d", (Object[])new Object[]{data2.mFriend.getUid()});
        if (this.getInviteData().inviteInterceptor != null && !this.getInviteData().inviteInterceptor.canInvite()) {
            if (callback2 != null) {
                callback2.onFail(2);
            }
            return;
        }
        if (this.listener != null && data2.mFriend != null) {
            this.listener.onInvite(data2.mFriend.getUid());
        }
        if (this.getInviteData().inviteInterceptor != null && !this.getInviteData().inviteInterceptor.canCrossRegionInvite()) {
            ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).requestUserInfoFromServer(data2.mFriend.getUid(), new OnKSProfileListCallback(){

                public void onUISuccess(@NonNull List<UserInfoKS> userInfo) {
                    if (FP.empty(userInfo)) {
                        if (callback2 != null) {
                            callback2.onFail(3);
                        }
                        return;
                    }
                    UserInfoKS targetUserInfo = userInfo.get(0);
                    String userRegion = targetUserInfo.region;
                    String channelRegion = DefaultFriendInviteBehavior.this.getInviteData().channelRegion;
                    MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"channelRegion=%s,userRegion=%s", (Object[])new Object[]{channelRegion, userRegion});
                    if (!FP.empty((CharSequence)userRegion) && RegionUtils.isNotSame((String)channelRegion, (String)userRegion)) {
                        if (callback2 != null) {
                            callback2.onFail(4);
                        }
                    } else {
                        DefaultFriendInviteBehavior.this.realInviteFriend(data2, callback2);
                    }
                }

                public void onError(String reason, long code) {
                    if (callback2 != null) {
                        callback2.onFail(3);
                    }
                }
            });
        } else {
            this.realInviteFriend(data2, callback2);
        }
    }

    private void realInviteFriend(final InviteFriendData data2, final IInviteFriendCallback callback2) {
        this.getInviteData().tokenProvider.getToken((DataCallback<String>)((DataCallback)token -> ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(this.getInviteData().ownerUid, new OnProfileCallback((String)token){
            final /* synthetic */ String val$token;
            {
                this.val$token = string2;
            }

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (FP.empty(userInfoKSList)) {
                    MLog.error((Object)DefaultFriendInviteBehavior.TAG, (String)"onInviteFriend get owner info error, list empty", (Object[])new Object[0]);
                    if (callback2 != null) {
                        callback2.onFail(3);
                    }
                    return;
                }
                if ("base".equals(DefaultFriendInviteBehavior.this.getInviteData().pluginId) && DefaultFriendInviteBehavior.this.getInviteData().roleType >= 5) {
                    DefaultFriendInviteBehavior.this.getInviteId(data2, this.val$token, userInfoKSList.get(0), callback2);
                } else {
                    DefaultFriendInviteBehavior.this.sendInviteMsg(data2, this.val$token, userInfoKSList.get(0), "", callback2);
                }
            }

            public void onFail(int id2, String msg, String response) {
                MLog.error((Object)DefaultFriendInviteBehavior.TAG, (String)("onInviteFriend get owner info error, " + msg), (Object[])new Object[0]);
                if (callback2 != null) {
                    callback2.onFail(3);
                }
            }
        })));
    }

    private void sendInviteMsg(InviteFriendData data2, String token, UserInfoKS userInfoKS, String invitedId, IInviteFriendCallback callback2) {
        YYTaskExecutor.execute(() -> {
            Pair pair = ImDataFactory.INSTANCE.sendVioceRoomInviteMsg(data2.mFriend.getUid(), data2.mFriend.getAvatar(), data2.mFriend.getNick(), this.getInviteData().channelId, this.getInviteData().channelName, userInfoKS.avatar, token, this.getInviteData().isSameCity, this.getInviteData().sameCityInfo != null ? this.getInviteData().sameCityInfo.getLocationTude() : "", this.getFamilyDetailUrl(this.getInviteData().channelId), data2.msg, this.getInviteData().channelSource, data2.transKey, data2.transInfo, this.getInviteData().pluginId, invitedId);
            ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().sendOldIMToDbMsg((ImMsgReqParam)pair.first, (ImMessageDBBean)pair.second, null);
        });
        if (callback2 != null) {
            callback2.onSuccess();
        }
    }

    void getInviteId(final InviteFriendData data2, final String token, final UserInfoKS userInfoKS, final IInviteFriendCallback callback2) {
        MLog.info((Object)TAG, (String)"getInviteId", (Object[])new Object[0]);
        GetInviteIDReq req = new GetInviteIDReq.Builder().cid(this.getInviteData().channelId).invitee_uid(Long.valueOf(data2.mFriend.getUid())).build();
        ProtoManager.getInstance().sendHttp(this.getInviteData().channelId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetInviteIDRes>(){

            public void onResponse(@NonNull GetInviteIDRes message, long code, String msg) {
                MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"getInviteId onResponse, code=%s, msg=%s", (Object[])new Object[]{code, msg});
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.debug((Object)DefaultFriendInviteBehavior.TAG, (String)"getInviteId invitedId=%s", (Object[])new Object[]{message.invite_id});
                    DefaultFriendInviteBehavior.this.sendInviteMsg(data2, token, userInfoKS, message.invite_id, callback2);
                } else if (callback2 != null) {
                    callback2.onFail(5);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"getInviteId retryWhenTimeout, canRetry=%s", (Object[])new Object[]{canRetry});
                if (callback2 != null) {
                    callback2.onFail(5);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"getInviteId retryWhenError, canRetry=%s, reason=%s, code=%s", (Object[])new Object[]{canRetry, reason, code});
                if (callback2 != null) {
                    callback2.onFail(5);
                }
                return false;
            }
        });
    }

    @Override
    public void inviteAllFans(final String channelId, final String pid, final IInviteAllCallback callback2) {
        MLog.info((Object)TAG, (String)"inviteAllFans, channelId=%s, pid=%s", (Object[])new Object[]{channelId, pid});
        if (!TextUtils.isEmpty((CharSequence)pid)) {
            InviteFansReq req = new InviteFansReq.Builder().pid(pid).path(Integer.valueOf(EPath.PATH_CHANNEL.getValue())).build();
            ProtoManager.getInstance().sendHttp(channelId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<InviteFansRes>(){

                public void onResponse(@NonNull InviteFansRes message, long code, String msg) {
                    MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"onResponse, code=%s, msg=%s", (Object[])new Object[]{code, msg});
                    if (ProtoManager.isSuccessCode((long)code)) {
                        if (callback2 != null) {
                            callback2.onSuccess(channelId, pid);
                        }
                    } else if (callback2 != null) {
                        callback2.onError((int)code);
                    }
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    if (callback2 != null) {
                        callback2.onError(-1);
                    }
                    MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"retryWhenTimeout, canRetry=%s", (Object[])new Object[]{canRetry});
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    if (callback2 != null) {
                        callback2.onError(code);
                    }
                    MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"retryWhenError, canRetry=%s, reason=%s, code=%s", (Object[])new Object[]{canRetry, reason, code});
                    return false;
                }
            });
        }
    }

    @Override
    public void onPlatformShare(int platformId) {
        super.onPlatformShare(platformId);
        if (platformId == 10) {
            RoomTrack.INSTANCE.reportCopyLinkInviteClick(this.getInviteData().channelId);
        } else {
            RoomTrack.INSTANCE.reportPlatformInviteClick(this.getInviteData().channelId, platformId);
        }
    }

    @Override
    public String getInviteTitle() {
        return ResourceUtils.getString((int)R.string.short_title_channel_invite_to_channel);
    }

    @Override
    public ShareDataProvider getShareDataProvider() {
        if (this.mShareDataProvider == null) {
            this.mShareDataProvider = new ChannelShareDataProvider();
            this.mShareDataProvider.setShareData(this.getPlatformShareData());
        }
        return this.mShareDataProvider;
    }

    @Override
    public PlatformShareData getPlatformShareData() {
        if (this.mPlatformShareData == null) {
            this.mPlatformShareData = new PlatformShareData();
            this.mPlatformShareData.setInviteData(this.getInviteData());
            List channelList = ((IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class)).getChannelsByPage(() -> "voice_room_enter_invite");
            this.mPlatformShareData.setChannelList(channelList);
        }
        return this.mPlatformShareData;
    }
}

