/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.behavior;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.FamilyInfoBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IFamilyService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.component.familygroup.familycall.FamilyCallHelper;
import com.yy.hiyo.channel.component.invite.friend.behavior.FriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.data.InviteData;
import com.yy.hiyo.channel.component.invite.friend.share.ChannelPlatformShareHelper;
import com.yy.hiyo.mvp.base.IMvpContext;

public abstract class AbsFriendInviteBehavior
implements FriendInviteBehavior {
    private static final String TAG = "AbsFriendInviteBehavior";
    private IMvpContext mMvpContext;
    private InviteData mInviteData;
    private ChannelPlatformShareHelper mShareHelper;

    public AbsFriendInviteBehavior(IMvpContext mvpContext) {
        this.mMvpContext = mvpContext;
    }

    @Override
    public void attachBaseInviteData(InviteData data2) {
        this.mInviteData = data2;
    }

    public InviteData getInviteData() {
        return this.mInviteData;
    }

    @Override
    public void onPlatformShare(int platformId) {
        if (this.getInviteData().inviteInterceptor != null && !this.getInviteData().inviteInterceptor.canInvite()) {
            return;
        }
        InviteData inviteData = this.getInviteData();
        inviteData.targetShare = platformId;
        this.getShareHelper().share(platformId, this.getInviteData());
    }

    @Override
    public void onInviteChannel(String toCid) {
        InviteData inviteData = this.getInviteData();
        inviteData.targetShare = 16;
        this.getShareHelper().shareToNativeChannel(this.getInviteData(), toCid);
    }

    public ChannelPlatformShareHelper getShareHelper() {
        if (this.mShareHelper == null) {
            this.mShareHelper = new ChannelPlatformShareHelper(this.mMvpContext, this.getShareDataProvider());
        }
        return this.mShareHelper;
    }

    @Override
    public String getFamilyDetailUrl(String channelId) {
        AConfigData configData;
        String familyDetailUrl = "";
        if (this.getInviteData() != null && this.getInviteData().isFamily && (configData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG)) instanceof CommonConfig) {
            CommonConfigData data2 = ((CommonConfig)configData).getData();
            familyDetailUrl = channelId != null ? URLUtils.addParam((String)String.format(data2.familyDetailUrl, channelId), (String)"useNativeDetail", (String)"true") : data2.familyDetailUrl;
        }
        return familyDetailUrl;
    }

    @Override
    public void getSendFamilyCallPermission(final DataCallback<Boolean> callback2) {
        if (this.getInviteData() == null) {
            callback2.onResult((Object)false);
            return;
        }
        if (!FamilyCallHelper.INSTANCE.enableFamilyCall()) {
            callback2.onResult((Object)false);
            return;
        }
        if ("base".equals(this.getInviteData().pluginId)) {
            callback2.onResult((Object)false);
            return;
        }
        if ("multivideo".equals(this.getInviteData().pluginId)) {
            callback2.onResult((Object)false);
            return;
        }
        IFamilyService familyService = this.getInviteData().familyService;
        if (familyService == null) {
            callback2.onResult((Object)false);
            return;
        }
        familyService.getFamilyByUid(AccountUtil.getUid(), (ICommonCallback)new ICommonCallback<FamilyInfoBean>(){

            public void onSuccess(FamilyInfoBean familyInfoBean, Object ... ext) {
                String fid = familyInfoBean.getFid();
                if (StringUtils.isEmpty((String)fid)) {
                    callback2.onResult((Object)false);
                    return;
                }
                IChannel family = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(fid);
                if (family == null) {
                    callback2.onResult((Object)false);
                    return;
                }
                family.getRoleService().getMyRole(new IRoleService.IGetRoleCallBack(){

                    public void onSuccess(String channelId, int roleType) {
                        if (roleType == 15 || roleType == 10) {
                            callback2.onResult((Object)true);
                        } else {
                            callback2.onResult((Object)false);
                        }
                    }

                    public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                        MLog.error((Object)AbsFriendInviteBehavior.TAG, (String)"getRole failed code: %s", (Object[])new Object[]{errorCode});
                        callback2.onResult((Object)false);
                    }
                });
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                MLog.error((Object)AbsFriendInviteBehavior.TAG, (String)"getFamily failed code: %s", (Object[])new Object[]{errCode});
                callback2.onResult((Object)false);
            }
        });
    }
}

