/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite;

import android.content.Context;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.yy.appbase.common.DataCallback;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.base.ui.widget.DimBgPanel;
import com.yy.hiyo.channel.component.invite.friend.FriendListCallback;
import com.yy.hiyo.channel.component.invite.friend.behavior.FriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.channel.component.invite.friend.viewholder.PlatFormInviteViewHolder;
import java.util.ArrayList;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;

public class PlatFormInvitePanel
extends DimBgPanel
implements PlatFormInviteViewHolder.OnPlatformShareListener {
    private View mView;
    private RecyclerView mRecyclerView;
    private MultiTypeAdapter mAdapter;
    private List<Object> mList = new ArrayList<Object>();
    private FriendInviteBehavior mFriendInviteBehavior;
    private FriendListCallback mListCallback;

    public PlatFormInvitePanel(Context context) {
        super(context);
        this.createViews();
        this.registerViewHolder();
    }

    @Override
    protected void onShow() {
        super.onShow();
        this.loadData();
    }

    @Override
    protected void onHide() {
        super.onHide();
    }

    private void createViews() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.dialog_platfom_invite_panel, null);
        this.setContent(this.mView);
        this.mRecyclerView = (RecyclerView)this.mView.findViewById(R.id.rv_platform_list);
        this.mAdapter = new MultiTypeAdapter(this.mList);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        if (this.mRecyclerView.getItemAnimator() instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator)this.mRecyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
        }
        this.findViewById(R.id.iv_platform_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view2) {
                if (PlatFormInvitePanel.this.mListCallback != null) {
                    PlatFormInvitePanel.this.mListCallback.onCloseClick();
                }
            }
        });
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mView.getLayoutParams();
        lp.width = -1;
        lp.height = ResolutionUtils.dip2Px((float)170.0f);
        lp.addRule(12);
        this.setShowAnim(this.createBottomShowAnimation());
        this.setHideAnim(this.createBottomHideAnimation());
    }

    private void registerViewHolder() {
        this.mAdapter.register(PlatformShareData.class, (ItemViewBinder)PlatFormInviteViewHolder.getItemBinder(this));
    }

    @Override
    public void onPlatformShare(int channelId) {
        if (this.mListCallback != null) {
            this.mListCallback.onPlatformShareClick(channelId);
        }
    }

    @Override
    public void onReportClick() {
        if (this.mListCallback != null) {
            this.mListCallback.onReportClick();
        }
    }

    private void loadData() {
        this.mList.clear();
        this.mFriendInviteBehavior.getSendFamilyCallPermission((DataCallback<Boolean>)((DataCallback)hasPermission -> {
            PlatformShareData platformShareData = this.mFriendInviteBehavior.getPlatformShareData();
            boolean canSendFamilyCall = false;
            if (hasPermission != null) {
                canSendFamilyCall = hasPermission;
            }
            platformShareData.setCanSendFamilyCall(canSendFamilyCall);
            this.mList.add(platformShareData);
            this.mAdapter.notifyDataSetChanged();
        }));
    }

    public void setFriendInviteBehavior(FriendInviteBehavior friendInviteBehavior) {
        this.mFriendInviteBehavior = friendInviteBehavior;
    }

    public void setListCallback(FriendListCallback listCallback) {
        this.mListCallback = listCallback;
    }
}

