/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.familygroup.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.component.familygroup.views.OnAnimListener;
import com.yy.hiyo.channel.component.familygroup.views.ViewAnimator;
import javax.annotation.Nullable;

public class MyFlipperView
extends ViewAnimator {
    private static final String TAG = "ViewFlipper";
    private static final boolean LOGD = true;
    private static final int DEFAULT_INTERVAL = 3000;
    private int mFlipInterval = 3000;
    private boolean mRunning = false;
    private OnAnimListener mOnAnimListener;
    private final Runnable mFlipRunnable = new Runnable(){

        @Override
        public void run() {
            if (MyFlipperView.this.mRunning) {
                int index = MyFlipperView.this.mWhichChild;
                boolean hasShowNext = MyFlipperView.this.showNext();
                String s = StringUtils.format((String)"mWhichChild :%d, count:%d, hasShowNext:%b", (Object[])new Object[]{index, MyFlipperView.this.getChildCount(), hasShowNext});
                if (hasShowNext) {
                    MyFlipperView.this.postDelayed(MyFlipperView.this.mFlipRunnable, MyFlipperView.this.mFlipInterval);
                } else {
                    s = s + "mRUning false";
                    MyFlipperView.this.mRunning = false;
                    if (MyFlipperView.this.mOnAnimListener != null) {
                        View v = null;
                        if (index < MyFlipperView.this.getChildCount()) {
                            v = MyFlipperView.this.getChildAt(index);
                        }
                        MyFlipperView.this.mOnAnimListener.onAnmiToLastItem(v);
                    }
                }
                MLog.info((Object)MyFlipperView.TAG, (String)s, (Object[])new Object[0]);
            }
        }
    };
    private AnimRnnable mFisteExit = new AnimRnnable();

    public MyFlipperView(Context context) {
        super(context);
    }

    public MyFlipperView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setFlipInterval(int milliseconds) {
        this.mFlipInterval = milliseconds;
    }

    public void setAOnAnimListener(OnAnimListener onAnimListener) {
        this.mFisteExit.mOnAnimListener = this.mOnAnimListener = onAnimListener;
    }

    public void stopFlipping() {
        this.mRunning = false;
        this.mWhichChild = 0;
        this.removeCallbacks(this.mFlipRunnable);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        MLog.info((Object)TAG, (String)"addView index:%d, mWhichChild:%d, count:%d, mRUninng:%b", (Object[])new Object[]{index, this.mWhichChild, this.getChildCount(), this.mRunning});
        if (this.getChildCount() == 1) {
            this.mWhichChild = 0;
            child.setVisibility(0);
            this.mFisteExit.mView = child;
            this.postDelayed(this.mFisteExit, this.mFlipInterval);
        } else {
            this.mFisteExit.mView = null;
            this.removeCallbacks(this.mFisteExit);
            child.setVisibility(8);
            if (!this.mRunning) {
                this.mRunning = true;
                this.postDelayed(this.mFlipRunnable, this.mFlipInterval);
            }
        }
    }

    @Override
    public void removeAllViews() {
        super.removeAllViews();
        this.stopFlipping();
    }

    public void addView(View view2, boolean removeAll) {
        MLog.info((Object)TAG, (String)"addView remove:%b", (Object[])new Object[]{removeAll});
        if (removeAll) {
            this.removeAllViews();
        }
        super.addView(view2);
    }

    private static class AnimRnnable
    implements Runnable {
        @Nullable
        View mView;
        @Nullable
        OnAnimListener mOnAnimListener;

        private AnimRnnable() {
        }

        @Override
        public void run() {
            if (this.mOnAnimListener != null) {
                this.mOnAnimListener.onAnmiToLastItem(this.mView);
            }
        }
    }
}

