/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.familygroup;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.yy.appbase.service.IHomePlanService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.utils.preference.RoomSetting;
import com.yy.hiyo.channel.component.act.ActivityContainer;
import com.yy.hiyo.channel.component.act.rightbanner.RightBannerActivityMvp;
import com.yy.hiyo.channel.component.act.rightbanner.viewmanager.BaseViewManager;
import com.yy.hiyo.channel.component.act.rightbanner.viewmanager.EmbedWebViewManager;
import com.yy.hiyo.channel.component.act.rightbanner.viewmanager.ImageViewManager;
import com.yy.hiyo.channel.component.act.rightbanner.viewmanager.SvgaViewManager;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.hiyo.wallet.base.action.ActionManager;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionList;
import com.yy.hiyo.wallet.base.action.ActivityActionWrapper;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;
import com.yy.hiyo.wallet.base.action.RoomActivityActionList;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.ihago.money.api.appconfigcenter.BannerLocation;
import net.ihago.money.api.appconfigcenter.PluginSubType;
import org.jetbrains.annotations.NotNull;

public class FamilyBannerActivityPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements RightBannerActivityMvp.IPresenter,
BaseViewManager.OnActivityActionClickListener,
IHolderPresenter {
    private static final String TAG = "FTVoiceRoom FamilyBannerActivityPresenter";
    private MutableLiveData<RoomActivityActionList> mFamilyActionData;
    private MutableLiveData<Boolean> mShowData;
    private IActivityService.OnActivityUpdateListener mOnActivityUpdateListener;
    private ImageViewManager mImageViewManager;
    private SvgaViewManager mSvgaViewManager;
    private EmbedWebViewManager mEmbedWebViewManager;
    @SuppressLint(value={"StaticFieldLeak"})
    private ActivityContainer mActivityPanel;
    @SuppressLint(value={"StaticFieldLeak"})
    protected FrameLayout mParentContainer;
    private ISeatUpdateListener mSeatUpdateListener = new ISeatUpdateListener(){

        public void onSeatUpdate(List<SeatUser> seatUserList) {
            List hasUserSeatList = FamilyBannerActivityPresenter.this.getChannel().getSeatService().getHasUserSeatList();
            if (FP.empty((Collection)hasUserSeatList)) {
                FamilyBannerActivityPresenter.this.showActivityPanel();
            } else {
                FamilyBannerActivityPresenter.this.hideActivityPanel();
            }
        }
    };
    private int pluginMode;
    private final List<Long> hadReportedActivityIdList = new ArrayList<Long>(6);
    private IActivityService.OnRightBannerPushListener mOnRightBannerPushListener = new IActivityService.OnRightBannerPushListener(){

        public ActivityTagInfo getRoomTagId(String roomId) {
            if (FamilyBannerActivityPresenter.this.getRoomId() != null && FamilyBannerActivityPresenter.this.getRoomId().equals(roomId)) {
                return FamilyBannerActivityPresenter.this.getRoomTag();
            }
            return null;
        }

        public String roomId() {
            return FamilyBannerActivityPresenter.this.getRoomId();
        }
    };
    private Runnable refreshTask = () -> {
        MLog.info((Object)TAG, (String)"refreshTask", (Object[])new Object[0]);
        this.requestFamilyActivities();
    };

    public void onInit(IChannelPageContext<AbsPage> mvpContext) {
        super.onInit(mvpContext);
        this.pluginMode = mvpContext.getPluginData().mode;
        this.mFamilyActionData = new SafeLiveData();
        this.mShowData = new SafeLiveData();
        this.requestFamilyActivities(true);
    }

    public void onMyRoleChanged(String channelId, int newRoleType) {
        this.requestFamilyActivities(true);
    }

    public void onPageAttach(@NonNull AbsPage page, boolean isReAttach) {
        int currentPluginMode;
        super.onPageAttach(page, isReAttach);
        if (this.mActivityPanel == null) {
            this.mActivityPanel = new ActivityContainer((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            this.mActivityPanel.setPresenter(this);
        }
        if (this.mParentContainer != null && this.mActivityPanel.getParent() == null) {
            this.mParentContainer.addView((View)this.mActivityPanel);
        }
        if ((currentPluginMode = this.getChannel().getPluginService().getCurPluginData().mode) == 1) {
            this.getChannel().getSeatService().addSeatUpdateListener(this.mSeatUpdateListener);
        }
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        this.getChannel().getSeatService().removeSeatUpdateListener(this.mSeatUpdateListener);
        if (this.mParentContainer != null) {
            this.mParentContainer.removeAllViews();
            this.mActivityPanel = null;
        }
        if (this.mEmbedWebViewManager != null) {
            this.mEmbedWebViewManager.onDestroy();
            this.mEmbedWebViewManager = null;
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onResume() {
        MLog.debug((Object)TAG, (String)"onResume %s", (Object[])new Object[]{this});
        if (this.mActivityPanel != null) {
            this.mActivityPanel.onResume();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void onPause() {
        MLog.debug((Object)TAG, (String)"onPause %s", (Object[])new Object[]{this});
        if (this.mActivityPanel != null) {
            this.mActivityPanel.onPause();
        }
    }

    protected void requestFamilyActivities(final boolean isInit) {
        final int location = this.pluginMode == 1 ? BannerLocation.FamilyActivity.getValue() : BannerLocation.FamilyChattingWindow.getValue();
        ActivityTagInfo tag = this.getRoomTag();
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).fetchActivityBannerInfo(this.getRoomId(), tag, location, null);
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).setOnRightBannerPushListener(this.mOnRightBannerPushListener);
        if (this.mOnActivityUpdateListener == null) {
            this.mOnActivityUpdateListener = new IActivityService.OnActivityUpdateListener(){

                public void onActivityBannerUpdate(List<ActivityActionWrapper<ActivityActionList>> data2) {
                    String roomId = FamilyBannerActivityPresenter.this.getRoomId();
                    ActivityTagInfo tag = FamilyBannerActivityPresenter.this.getRoomTag();
                    final ActivityActionWrapper item = ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).find(data2, roomId, tag, location);
                    MLog.info((Object)FamilyBannerActivityPresenter.TAG, (String)"onFamilyActivityUpdate list size %d, item %s", (Object[])new Object[]{FP.size(data2), item});
                    if (isInit) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FamilyBannerActivityPresenter.this.onFamilyActionUpdate(item != null ? (ActivityActionList)item.action : null);
                            }
                        }, (long)100L);
                    } else {
                        FamilyBannerActivityPresenter.this.onFamilyActionUpdate(item != null ? (ActivityActionList)item.action : null);
                    }
                    YYTaskExecutor.removeTask((Runnable)FamilyBannerActivityPresenter.this.refreshTask);
                    if (item != null && item.action != null) {
                        int minute = ((ActivityActionList)item.action).getMiniRefreshMin();
                        MLog.info((Object)FamilyBannerActivityPresenter.TAG, (String)"getMiniRefreshMin=%d", (Object[])new Object[]{minute});
                        if (minute > 0 && minute < Integer.MAX_VALUE) {
                            YYTaskExecutor.postToMainThread((Runnable)FamilyBannerActivityPresenter.this.refreshTask, (long)(minute * 60 * 1000));
                        }
                    }
                }
            };
            ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).addOnActivityUpdateListener(this.mOnActivityUpdateListener);
        }
    }

    private void requestFamilyActivities() {
        this.requestFamilyActivities(false);
    }

    private void onFamilyActionUpdate(@Nullable ActivityActionList data2) {
        MLog.info((Object)TAG, (String)"onFamilyActionUpdate %s", (Object[])new Object[]{data2});
        if (data2 == null || FP.empty((Collection)data2.list)) {
            this.hideActivityPanel();
        } else {
            this.showActivityPanel();
        }
        if (data2 != null) {
            this.filterMinorDisabled(data2.list);
        }
        ActivityActionList familyActivityActionList = this.filterFamilyActionData(data2);
        this.initLowPhoneActivity(familyActivityActionList);
        RoomActivityActionList roomActivityActionList = RoomActivityActionList.from((ActivityActionList)data2);
        this.mFamilyActionData.setValue((Object)roomActivityActionList);
    }

    private void initLowPhoneActivity(ActivityActionList roomActivityActionList) {
        if (roomActivityActionList == null || roomActivityActionList.list == null) {
            return;
        }
        for (int i = 0; i < roomActivityActionList.list.size(); ++i) {
            ActivityAction activityAction = (ActivityAction)roomActivityActionList.list.get(i);
            if (activityAction.pictureType != ActivityAction.PictureType.H5 || RuntimeContext.getPhoneType() > 1 || !StringUtils.isNotEmpty((String)activityAction.lowEndUrl)) continue;
            activityAction.iconUrl = activityAction.lowEndUrl;
            activityAction.pictureType = ActivityAction.PictureType.IMAGE;
        }
    }

    private void filterMinorDisabled(List<ActivityAction> list2) {
        IHomePlanService homePlanService;
        if (!FP.empty(list2) && (homePlanService = (IHomePlanService)ServiceManagerProxy.getServiceManager().getService(IHomePlanService.class)).isMyselfMinorProtect()) {
            Iterator<ActivityAction> it = list2.iterator();
            while (it.hasNext()) {
                ActivityAction action = it.next();
                if (!homePlanService.isHideActivity(String.valueOf(action.id))) continue;
                it.remove();
            }
        }
    }

    private ActivityActionList filterFamilyActionData(ActivityActionList data2) {
        ArrayList<ActivityAction> filterList = null;
        if (data2 != null && !FP.empty((Collection)data2.list)) {
            filterList = new ArrayList<ActivityAction>();
            for (ActivityAction familyActivityAction : data2.list) {
                boolean isSelected = false;
                if (familyActivityAction == null) continue;
                long clickAt = RoomSetting.getPreference().getLong("room_activity_click_at" + familyActivityAction.id, 0L);
                MLog.info((Object)TAG, (String)"filterFamilyActionData clickAt %d", (Object[])new Object[]{clickAt});
                switch (familyActivityAction.showLogic) {
                    case ALWAYS: {
                        isSelected = true;
                        break;
                    }
                    case ONLY_ONCE: {
                        if (clickAt > 0L) break;
                        isSelected = true;
                        break;
                    }
                    case ONCE_PER_DAY: {
                        if (clickAt > 0L) {
                            Calendar calendar = Calendar.getInstance();
                            int now = calendar.get(6);
                            calendar.setTimeInMillis(clickAt);
                            int clickDay = calendar.get(6);
                            MLog.info((Object)TAG, (String)"filterFamilyActionData ONCE_PER_DAY, now %d, clickDay %d", (Object[])new Object[]{now, clickDay});
                            if (now <= clickDay) break;
                            isSelected = true;
                            break;
                        }
                        isSelected = true;
                        break;
                    }
                }
                if (!isSelected || !this.isEffectTime(familyActivityAction)) continue;
                filterList.add(familyActivityAction);
            }
            data2.list.clear();
            data2.list.addAll(filterList);
        }
        return data2;
    }

    private boolean isEffectTime(ActivityAction activityAction) {
        long time = 0L;
        if (time <= 0L) {
            time = System.currentTimeMillis();
        }
        return activityAction != null && activityAction.startTime < time / 1000L && activityAction.endTime > time / 1000L;
    }

    @NotNull
    private ActivityTagInfo getRoomTag() {
        ChannelTagItem tag = this.getChannelDetailInfo().baseInfo.tag.getFirstTag();
        ActivityTagInfo info = new ActivityTagInfo("" + tag.getTagId(), tag.getName());
        info.setPluginType(this.getChannel().getPluginService().getCurPluginData().mode);
        info.setPluginSubType(this.getChannel().getPluginService().getCurPluginData().isVideoMode() ? PluginSubType.PluginSubTypeVideo.getValue() : PluginSubType.PluginSubTypeAudio.getValue());
        info.setChannelRole(this.getChannel().getRoleService().getMyRoleCache());
        return info;
    }

    @Override
    public LiveData<RoomActivityActionList> getRoomAction() {
        return this.mFamilyActionData;
    }

    @Override
    public LiveData<Boolean> getShowData() {
        return this.mShowData;
    }

    @Override
    public BaseViewManager getViewManager(ActivityAction.PictureType pictureType) {
        if (pictureType == ActivityAction.PictureType.IMAGE) {
            return this.getImageViewManager();
        }
        if (pictureType == ActivityAction.PictureType.SVGA) {
            return this.getSvgaViewManager();
        }
        if (pictureType == ActivityAction.PictureType.H5) {
            return this.getEmbedWebViewManager();
        }
        return null;
    }

    @Override
    public String getRoomId() {
        return this.getChannelDetailInfo().baseInfo.gid;
    }

    @Override
    public void onBannerShow(int position, @Nullable RoomActivityAction activityAction) {
        if (activityAction != null && !this.isMinimize() && RuntimeContext.sIsForeground && !this.hadReportedActivityIdList.contains(activityAction.id)) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "lower_right _activity_entry_show").put("activity_id", String.valueOf(activityAction.id)).put("pg_location", this.pluginMode == 1 ? "1" : "2"));
            this.hadReportedActivityIdList.add(activityAction.id);
        }
    }

    @Override
    public void onActionClick(ActivityAction action) {
        this.onActivityActionClick(action);
    }

    @Override
    public boolean isMinimize() {
        return false;
    }

    private BaseViewManager getImageViewManager() {
        if (this.mImageViewManager == null) {
            this.mImageViewManager = new ImageViewManager(this);
        }
        return this.mImageViewManager;
    }

    private BaseViewManager getSvgaViewManager() {
        if (this.mSvgaViewManager == null) {
            this.mSvgaViewManager = new SvgaViewManager(this);
        }
        return this.mSvgaViewManager;
    }

    private BaseViewManager getEmbedWebViewManager() {
        if (this.mEmbedWebViewManager == null) {
            this.mEmbedWebViewManager = new EmbedWebViewManager(this);
            this.mEmbedWebViewManager.setIsOwner(this.getChannel().getRoleService().isMeOwner() || this.getChannel().getRoleService().isMeAnchor());
        }
        return this.mEmbedWebViewManager;
    }

    public void onComboShow(boolean show) {
        if (this.mShowData != null) {
            this.mShowData.setValue((Object)(!show ? 1 : 0));
        }
    }

    @Override
    public void onActivityActionClick(ActivityAction action) {
        MLog.info((Object)TAG, (String)"onActivityActionClick %s", (Object[])new Object[]{action});
        if (action == null) {
            return;
        }
        ActionManager.obtain().onAction(action);
        RoomSetting.getPreference().edit().putLong("room_activity_click_at" + action.id, System.currentTimeMillis()).apply();
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "lower_right _activity_entry_click").put("activity_id", String.valueOf(action.id)).put("pg_location", this.pluginMode == 1 ? "1" : "2"));
    }

    public void setContainer(@NonNull View container) {
        if (!(container instanceof YYPlaceHolderView)) {
            return;
        }
        if (this.mParentContainer == null) {
            this.mParentContainer = new YYFrameLayout((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        }
        ((YYPlaceHolderView)container).inflate((View)this.mParentContainer);
        if (this.mActivityPanel != null) {
            this.mParentContainer.addView((View)this.mActivityPanel);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mEmbedWebViewManager != null) {
            this.mEmbedWebViewManager.onDestroy();
            this.mEmbedWebViewManager = null;
        }
        if (this.mImageViewManager != null) {
            this.mImageViewManager.onDestroy();
            this.mImageViewManager = null;
        }
        if (this.mSvgaViewManager != null) {
            this.mSvgaViewManager.onDestroy();
            this.mSvgaViewManager = null;
        }
        if (this.mActivityPanel != null) {
            this.mActivityPanel.onDestroy();
        }
        this.getChannel().getSeatService().removeSeatUpdateListener(this.mSeatUpdateListener);
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).removeOnActivityUpdateListener(this.mOnActivityUpdateListener);
        YYTaskExecutor.removeTask((Runnable)this.refreshTask);
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).setOnRightBannerPushListener(null);
    }

    private void showActivityPanel() {
        if (this.mActivityPanel != null && this.mActivityPanel.getVisibility() != 0) {
            this.mActivityPanel.onResume();
            this.mActivityPanel.setVisibility(0);
        }
    }

    private void hideActivityPanel() {
        if (this.mActivityPanel != null && this.mActivityPanel.getVisibility() == 0) {
            this.mActivityPanel.onPause();
            this.mActivityPanel.setVisibility(8);
        }
    }
}

