/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.contribution;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.money.api.contribrank.GetTopConfReq;
import net.ihago.money.api.contribrank.GetTopConfRes;
import net.ihago.money.api.contribrank.RankConf;

public enum ContributionDataManager {
    Instance;

    public static final String TAG = "GiftContributionPresenter";
    private List<RankConf> mDayRankConfList = new ArrayList<RankConf>();
    private List<RankConf> mWeekRankConfList = new ArrayList<RankConf>();
    private Map<Long, Integer> mDayTopUserMap = new HashMap<Long, Integer>();
    private Map<Long, Integer> mWeekTopUserMap = new HashMap<Long, Integer>();

    public void requestData() {
        if (this.mDayRankConfList.size() > 0 && this.mWeekRankConfList.size() > 0) {
            MLog.info((Object)TAG, (String)"requestData hasCache", (Object[])new Object[0]);
            return;
        }
        GetTopConfReq getTopConfReq = new GetTopConfReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getTopConfReq, (IProtoCallback)new IProtoCallback<GetTopConfRes>(){

            public void onResponse(@NonNull GetTopConfRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    List dayConfList = message.day_confs;
                    List weekConfList = message.week_confs;
                    if (dayConfList != null && dayConfList.size() > 0) {
                        ContributionDataManager.this.mDayRankConfList.clear();
                        ContributionDataManager.this.mDayRankConfList.addAll(dayConfList);
                    }
                    if (weekConfList != null && weekConfList.size() > 0) {
                        ContributionDataManager.this.mWeekRankConfList.clear();
                        ContributionDataManager.this.mWeekRankConfList.addAll(weekConfList);
                    }
                    MLog.info((Object)ContributionDataManager.TAG, (String)("requestData, dayRank:" + ContributionDataManager.this.mDayRankConfList + "weekRank:" + ContributionDataManager.this.mWeekRankConfList), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)ContributionDataManager.TAG, (String)"requestData timeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)ContributionDataManager.TAG, (String)("requestData fail:code" + code + ", reason:" + reason), (Object[])new Object[0]);
                return false;
            }
        });
    }

    public void clear() {
        this.mDayTopUserMap.clear();
        this.mWeekTopUserMap.clear();
    }

    public void addDayTopUser(long uid, int rank) {
        this.mDayTopUserMap.put(uid, rank);
    }

    public void addWeekTopUser(long uid, int rank) {
        this.mWeekTopUserMap.put(uid, rank);
    }

    public RankConf getDayTopRankInfo(long uid) {
        if (this.mDayTopUserMap.containsKey(uid)) {
            int rank = this.mDayTopUserMap.get(uid);
            if (this.mDayRankConfList.size() > rank) {
                return this.mDayRankConfList.get(rank);
            }
            return null;
        }
        return null;
    }

    public RankConf getWeekTopRankInfo(long uid) {
        if (this.mWeekTopUserMap.containsKey(uid)) {
            int rank = this.mWeekTopUserMap.get(uid);
            if (this.mWeekRankConfList.size() > rank) {
                return this.mWeekRankConfList.get(rank);
            }
            return null;
        }
        return null;
    }
}

