/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bottombar.quickanswer.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.utils.LanguageUtils;
import java.util.ArrayList;
import java.util.List;

public class FlowLayout
extends ViewGroup {
    private static final String TAG = "FlowLayout";
    private List<List<View>> mAllViews = new ArrayList<List<View>>();
    private List<Integer> mLineHeight = new ArrayList<Integer>();

    public FlowLayout(Context context) {
        this(context, null);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = 0;
        int height = 0;
        int lineWidth = 0;
        int lineHeight = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            if (lineWidth + childWidth > sizeWidth - this.getPaddingLeft() - this.getPaddingRight()) {
                width = Math.max(width, childWidth);
                lineWidth = childWidth;
                height += lineHeight;
                lineHeight = childHeight;
            } else {
                lineWidth += childWidth;
                lineHeight = Math.max(lineHeight, childHeight);
            }
            if (i != childCount - 1) continue;
            width = Math.max(width, lineWidth);
            height += lineHeight;
        }
        this.setMeasuredDimension(modeWidth == 0x40000000 ? sizeWidth : width + this.getPaddingLeft() + this.getPaddingRight(), modeHeight == 0x40000000 ? sizeHeight : height + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mAllViews.clear();
        this.mLineHeight.clear();
        int width = this.getWidth();
        int lineWidth = 0;
        int lineHeight = 0;
        List<Object> lineViews = new ArrayList();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (childWidth + lp.leftMargin + lp.rightMargin + lineWidth > width - this.getPaddingLeft() - this.getPaddingRight()) {
                this.mLineHeight.add(lineHeight);
                this.mAllViews.add(lineViews);
                lineWidth = 0;
                lineViews = new ArrayList();
                lineHeight = 0;
            }
            lineWidth += childWidth + lp.leftMargin + lp.rightMargin;
            lineHeight = Math.max(lineHeight, childHeight + lp.topMargin + lp.bottomMargin);
            lineViews.add(child);
        }
        this.mLineHeight.add(lineHeight);
        this.mAllViews.add(lineViews);
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int right = this.getMeasuredWidth() - this.getPaddingRight();
        int lineNums = this.mAllViews.size();
        for (int i = 0; i < lineNums; ++i) {
            lineViews = this.mAllViews.get(i);
            lineHeight = this.mLineHeight.get(i);
            for (int j = 0; j < lineViews.size(); ++j) {
                int bc;
                View child = (View)lineViews.get(j);
                if (child.getVisibility() == 8) continue;
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                if (LanguageUtils.isLtr()) {
                    int lc = left + lp.leftMargin;
                    int tc = top + lp.topMargin;
                    int rc = lc + child.getMeasuredWidth();
                    bc = tc + child.getMeasuredHeight();
                    child.layout(lc, tc, rc, bc);
                    left += child.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
                    continue;
                }
                int rc = right - lp.rightMargin;
                int lc = rc - child.getMeasuredWidth();
                int tc = top + lp.topMargin;
                bc = tc + child.getMeasuredHeight();
                child.layout(lc, tc, rc, bc);
                right = lc - lp.leftMargin;
            }
            left = this.getPaddingLeft();
            top += lineHeight;
            right = this.getMeasuredWidth() - this.getPaddingRight();
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }
}

