/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bigface;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.common.Callback;
import com.yy.appbase.data.FaceDbBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.status.LoadingStatusLayout;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.bigface.IRoomBigFaceServices;
import com.yy.hiyo.bigface.base.data.bean.BigFaceTabInfoBean;
import com.yy.hiyo.bigface.base.data.bean.BigFaceTabTipBean;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.callback.bigface.IBigFaceFilter;
import com.yy.hiyo.channel.base.callback.bigface.OnFaceClickListener;
import com.yy.hiyo.channel.component.bigface.FaceCommonPresenter;
import com.yy.hiyo.channel.component.bigface.ICommonFaceMvp;
import com.yy.hiyo.channel.component.bigface.adpater.FaceItemAdapter;
import com.yy.hiyo.channel.component.bigface.view.BigFaceTabTipView;
import java.util.ArrayList;
import java.util.List;

public class FacePage
extends YYFrameLayout
implements ICommonFaceMvp.IView,
FaceItemAdapter.FaceClickListener,
View.OnClickListener {
    private LoadingStatusLayout mLoadingLayout;
    private FaceItemAdapter mAdapter;
    private DissmissDialogCallBack mDissmissDialogCallBack;
    private OnFaceClickListener mOnFaceClickCallBack;
    private RecyclerView mRecyclerView;
    private BigFaceTabTipView mTipView;
    private ICommonFaceMvp.IPresenter mIPresenter;
    private IBigFaceFilter mIBigFaceFilter;
    private String channelId;
    private long tabId;
    boolean hasAutoRequest = true;
    boolean isShowNotAvailable = false;
    boolean isTabMode = false;
    private KvoBinder mBinder = new KvoBinder((Object)this);

    public FacePage(@NonNull Context context, OnFaceClickListener dissmissDialogCallBack) {
        super(context);
        this.createView();
        this.mOnFaceClickCallBack = dissmissDialogCallBack;
    }

    private void createView() {
        FacePage.inflate((Context)this.getContext(), (int)R.layout.layout_face_panel_channel, (ViewGroup)this);
        this.mIPresenter = new FaceCommonPresenter();
        this.mIPresenter.setView(this);
        this.mLoadingLayout = (LoadingStatusLayout)this.findViewById(R.id.lsl_loading);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_face_list);
        this.mAdapter = new FaceItemAdapter(this.getContext(), new ArrayList<FaceDbBean>());
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_face_list);
        this.mTipView = (BigFaceTabTipView)this.findViewById(R.id.tipsView);
        GridLayoutManager layoutManager = new GridLayoutManager(this.getContext(), 4, 1, false);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setmListener(this);
        this.mTipView.setCallback(new BigFaceTabTipView.ITipViewCallback(){

            @Override
            public void onJumpClick() {
                if (FacePage.this.mOnFaceClickCallBack != null) {
                    FacePage.this.mOnFaceClickCallBack.onTipsBtnClick(Long.valueOf(FacePage.this.tabId));
                }
            }
        });
    }

    @Override
    public void onClickFace(FaceDbBean faceDbBean) {
        if (!faceDbBean.isAvailable()) {
            ToastUtils.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.not_obtained_not_available), (int)0);
        } else {
            if (this.mDissmissDialogCallBack != null) {
                this.mDissmissDialogCallBack.hideDialog();
            }
            if (this.mOnFaceClickCallBack != null) {
                this.mOnFaceClickCallBack.onSendClick(faceDbBean);
            }
        }
    }

    public boolean hasAutoRequest() {
        return this.hasAutoRequest;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.hasAutoRequest()) {
            if (!this.isTabMode) {
                this.requestData();
            } else {
                ServiceManagerProxy.getInstance().observeService(IRoomBigFaceServices.class, (Callback)new Callback<IRoomBigFaceServices>(){

                    public void onResponse(IRoomBigFaceServices data2) {
                        data2.requestBigFaceTabTip(FacePage.this.tabId);
                        BigFaceTabInfoBean bigFaceTabInfoBean = data2.getTabInfoById(FacePage.this.tabId);
                        if (bigFaceTabInfoBean != null) {
                            FacePage.this.mBinder.singleBindSourceTo((KvoSource)bigFaceTabInfoBean);
                            FacePage.this.mBinder.singleBindSourceTo((KvoSource)data2.bigFaceTabTipInfo(FacePage.this.tabId));
                        }
                    }
                });
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBinder.clearAllKvoConnections();
    }

    @KvoMethodAnnotation(name="bigface_page_list", sourceClass=BigFaceTabInfoBean.class)
    public void updateTabList(KvoEventIntent eventIntent) {
        this.finishStartLoading();
        this.setData((List)eventIntent.newValue());
    }

    @KvoMethodAnnotation(name="title", sourceClass=BigFaceTabTipBean.class)
    public void updateTip(KvoEventIntent eventIntent) {
        this.finishStartLoading();
        if (this.mTipView != null) {
            BigFaceTabTipBean bigFaceTabTipBean = (BigFaceTabTipBean)eventIntent.source();
            if (StringUtils.isNotEmpty((String)bigFaceTabTipBean.getTitle())) {
                this.mTipView.updateTipView((BigFaceTabTipBean)eventIntent.source());
            } else {
                this.mTipView.setVisibility(8);
            }
        }
    }

    @KvoMethodAnnotation(name="desc", sourceClass=BigFaceTabTipBean.class)
    public void updateTipDesc(KvoEventIntent eventIntent) {
        String desc;
        if (this.mTipView != null && StringUtils.isNotEmpty((String)(desc = (String)eventIntent.newValue()))) {
            this.mTipView.updateTipView((BigFaceTabTipBean)eventIntent.source());
        }
    }

    public void requestData() {
        if (!TextUtils.isEmpty((CharSequence)this.channelId)) {
            this.mIPresenter.requestData(this.channelId, null);
        }
    }

    @Override
    public void setData(List<FaceDbBean> list2) {
        this.mAdapter.update(this.pickAvailableFace(list2));
        this.finishStartLoading();
    }

    @Override
    public void finishStartLoading() {
        this.mLoadingLayout.setVisibility(8);
    }

    @Override
    public void showStartLoading() {
        this.mLoadingLayout.setVisibility(0);
    }

    @Override
    public void onDismiss() {
        this.finishStartLoading();
    }

    public void onClick(View view2) {
    }

    public void setDissmissDialogCallBack(DissmissDialogCallBack dissmissDialogCallBack) {
        this.mDissmissDialogCallBack = dissmissDialogCallBack;
    }

    public void setBigFaceFilter(IBigFaceFilter filter2) {
        this.mIBigFaceFilter = filter2;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    private List<FaceDbBean> pickAvailableFace(List<FaceDbBean> list2) {
        ArrayList<FaceDbBean> result = new ArrayList<FaceDbBean>();
        if (list2 != null) {
            for (FaceDbBean faceDbBean : list2) {
                boolean filter2 = true;
                if (this.mIBigFaceFilter != null) {
                    filter2 = this.mIBigFaceFilter.filter(faceDbBean);
                }
                if (!filter2 || faceDbBean == null) continue;
                result.add(faceDbBean);
            }
        }
        return result;
    }

    public void setTabId(long tabId) {
        this.tabId = tabId;
    }

    public void setTabMode(boolean tabMode) {
        this.isTabMode = tabMode;
    }

    public void setShowNotAvailable(boolean showNotAvailable) {
        this.isShowNotAvailable = showNotAvailable;
    }

    static interface DissmissDialogCallBack {
        public void hideDialog();
    }
}

