/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bigface;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.common.FacePoint;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.ISeatLocationProvider;
import com.yy.hiyo.channel.component.bigface.IFaceMvp;
import com.yy.hiyo.game.service.IGameCenterService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FaceGamePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IFaceMvp.IFaceGamePresenter {
    private static final String TAG = "BigFace";
    private Map<Long, FacePoint> mSeatPointMap = new HashMap<Long, FacePoint>();
    private ViewGroup mGameContainer;

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
    }

    private ViewGroup getGameContainer() {
        if (null == this.mGameContainer) {
            this.mGameContainer = (ViewGroup)this.getPage().getPageView().findViewById(R.id.gameContainerHolder);
        }
        return this.mGameContainer;
    }

    @Override
    public void setFaceGameLocationCallback(ISeatLocationProvider callback2) {
        callback2.getCommonSeatLocation().observe((LifecycleOwner)this.getLifeCycleOwner(), (Observer)new Observer<Map<Long, FacePoint>>(){

            public void onChanged(@Nullable Map<Long, FacePoint> longFacePointMap) {
                if (longFacePointMap != null) {
                    FaceGamePresenter.this.mSeatPointMap.clear();
                    for (long uid : longFacePointMap.keySet()) {
                        FacePoint facePoint = longFacePointMap.get(uid);
                        FacePoint newFacePoint = new FacePoint();
                        if (facePoint.getType() == 2) {
                            int x = facePoint.x - facePoint.getWidth() / 2;
                            int y = facePoint.y - facePoint.getHeight() / 2;
                            newFacePoint.set(x, y);
                        } else {
                            newFacePoint.set(facePoint.x, facePoint.y);
                        }
                        newFacePoint.setWidth(facePoint.getWidth());
                        newFacePoint.setHeight(facePoint.getHeight());
                        FaceGamePresenter.this.mSeatPointMap.put(uid, newFacePoint);
                    }
                } else {
                    FaceGamePresenter.this.mSeatPointMap.clear();
                }
            }
        });
    }

    @Override
    public void addFaceView(long uid, boolean isGameMode, Map<String, Bitmap> value, File svgaFile, FaceSvgaAnimCallBack callBack) {
        if (this.mSeatPointMap.containsKey(uid)) {
            this.startSvgaViewAnim(uid, isGameMode, value, svgaFile, callBack);
        } else if (callBack != null) {
            callBack.onNoLocation();
        }
    }

    public void startSvgaViewAnim(long fromUid, boolean isGameMode, Map<String, Bitmap> map, File file, FaceSvgaAnimCallBack faceSvgaAnimCallBack) {
        FacePoint point = this.mSeatPointMap.get(fromUid);
        if (null == point) {
            MLog.error((Object)TAG, (String)"point=null", (Object[])new Object[0]);
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"gameFace x %d, y %d", (Object[])new Object[]{point.x, point.y});
        }
        SVGAImageView svgaImageView = new SVGAImageView((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        if (((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).isPlaying() && this.getChannel().getPluginService().getCurPluginData().getMode() != 100 && this.getChannel().getPluginService().getCurPluginData().getMode() != 300) {
            if (this.getGameContainer() != null) {
                SVGAImageView beforeSvga = (SVGAImageView)this.getGameContainer().findViewById((int)fromUid);
                if (beforeSvga != null) {
                    beforeSvga.stopAnimation();
                    this.getGameContainer().removeView((View)beforeSvga);
                }
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(point.getWidth(), point.getHeight());
                svgaImageView.setLayoutParams((ViewGroup.LayoutParams)params);
                int transplant = ((IChannelPageContext)this.getMvpContext()).getDeviceManager().isSysStatusBarShowing() ? point.y - (this.getGameLocationY() - SystemUtils.getStatusBarHeight((Context)RuntimeContext.sApplicationContext)) : point.y - this.getGameLocationY();
                this.setSvgaImageViewTrans(svgaImageView, point.x - point.getWidth() / 2, transplant - point.getHeight() / 2);
                this.getGameContainer().addView((View)svgaImageView);
            }
        } else {
            RelativeLayout faceContainer = null;
            if (this.getPage() != null) {
                faceContainer = (RelativeLayout)this.getPage().getPageView().findViewById(R.id.faceContainer);
            }
            if (faceContainer != null) {
                SVGAImageView beforeSvga = (SVGAImageView)faceContainer.findViewById((int)fromUid);
                if (beforeSvga != null) {
                    beforeSvga.stopAnimation();
                    faceContainer.removeView((View)beforeSvga);
                }
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(point.getWidth(), point.getHeight());
                svgaImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                faceContainer.addView((View)svgaImageView);
                if (LanguageUtils.isRtl()) {
                    svgaImageView.setX((float)point.x + (float)point.getWidth() / 2.0f);
                } else {
                    svgaImageView.setX((float)point.x - (float)point.getWidth() / 2.0f);
                }
                svgaImageView.setY((float)point.y - (float)point.getHeight() / 2.0f);
            }
        }
        svgaImageView.setId((int)fromUid);
        this.showSvga(svgaImageView, map, file, faceSvgaAnimCallBack);
    }

    private void showSvga(final SVGAImageView svgaImageView, final Map<String, Bitmap> map, final File file, final FaceSvgaAnimCallBack faceSvgaAnimCallBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                FaceGamePresenter.this.showSvgaInner(svgaImageView, map, file, faceSvgaAnimCallBack);
            }
        });
    }

    private void showSvgaInner(final SVGAImageView svgaImageView, final Map<String, Bitmap> map, File file, final FaceSvgaAnimCallBack faceSvgaAnimCallBack) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5 \u8fdb\u5165\u52a0\u8f7d svag \u7684\u65b9\u6cd5", (Object[])new Object[0]);
        }
        SVGAParser svgaParser = new SVGAParser((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        FileInputStream inputStream = null;
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5 svga \u89e3\u6790 inputStream \u51fa\u9519", (Object[])new Object[0]);
                e.printStackTrace();
            }
        } else {
            MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5 svga \u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        if (null == inputStream) {
            MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5 svga  \u7684 inputstream is null", (Object[])new Object[0]);
            return;
        }
        svgaParser.decodeFromInputStream((InputStream)inputStream, file.getName(), new SVGAParser.ParseCompletion(){

            public void onError2(@org.jetbrains.annotations.Nullable Throwable throwable, @NotNull String s) {
            }

            public void onComplete(@NotNull SVGAVideoEntity svgaVideoEntity) {
                if (svgaImageView.isAnimating()) {
                    svgaImageView.stopAnimation();
                }
                svgaImageView.setVisibility(0);
                svgaImageView.setDrawingCacheEnabled(true);
                svgaImageView.setCallback(new SVGACallback(){

                    public void onPause() {
                    }

                    public void onFinished() {
                        MLog.info((Object)FaceGamePresenter.TAG, (String)"\u5927\u8868\u60c5 svga   onFinish", (Object[])new Object[0]);
                        faceSvgaAnimCallBack.onSvgaComplete();
                    }

                    public void onRepeat() {
                    }

                    public void onStep(int i, double v) {
                        if (v == 1.0) {
                            Bitmap bitmap = null;
                            if (map != null && map.size() > 0) {
                                try {
                                    MLog.info((Object)FaceGamePresenter.TAG, (String)"\u5927\u8868\u60c5 svga   get bitmap", (Object[])new Object[0]);
                                    bitmap = Bitmap.createBitmap((Bitmap)svgaImageView.getDrawingCache());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (faceSvgaAnimCallBack != null) {
                                MLog.info((Object)FaceGamePresenter.TAG, (String)"\u5927\u8868\u60c5 bitmap \u56de\u8c03, bitmap=%s", (Object[])new Object[]{bitmap != null});
                                faceSvgaAnimCallBack.onSvgaAnimFinish(bitmap);
                            } else {
                                MLog.info((Object)FaceGamePresenter.TAG, (String)"\u5927\u8868\u60c5 faceSvgaAnimCallBack  is null", (Object[])new Object[0]);
                            }
                            svgaImageView.setVisibility(8);
                        }
                    }
                });
                SVGADynamicEntity dynamicItem = null;
                if (map != null && map.size() > 0) {
                    dynamicItem = new SVGADynamicEntity();
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        Bitmap bitmap = (Bitmap)entry.getValue();
                        if (bitmap == null) continue;
                        dynamicItem.setDynamicImage(bitmap, key);
                    }
                }
                SVGADrawable drawable2 = dynamicItem != null ? new SVGADrawable(svgaVideoEntity, dynamicItem) : new SVGADrawable(svgaVideoEntity);
                svgaImageView.setImageDrawable((Drawable)drawable2);
                svgaImageView.setLoops(1);
                svgaImageView.startAnimation();
            }

            public void onError() {
                MLog.error((Object)FaceGamePresenter.TAG, (String)"\u5927\u8868\u60c5 svga parser fail", (Object[])new Object[0]);
            }
        }, true, null, file.getName());
    }

    public void setSvgaImageViewTrans(SVGAImageView view2, int transX, int transY) {
        view2.setTranslationX((float)transX);
        view2.setTranslationY((float)transY);
    }

    private int getGameLocationY() {
        int[] location = new int[2];
        if (this.getGameContainer() != null) {
            this.getGameContainer().getLocationOnScreen(location);
            return location[1];
        }
        return 0;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mGameContainer = null;
    }

    public static interface FaceSvgaAnimCallBack {
        public void onSvgaAnimFinish(Bitmap var1);

        public void onSvgaComplete();

        public void onNoLocation();
    }
}

