/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.announcement.ui;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import com.yy.base.memoryrecycle.views.YYTextView;

public class NoticeCountView
extends YYTextView {
    private int mMaxCount;

    public void setMaxCount(int maxCount) {
        this.mMaxCount = maxCount;
    }

    public NoticeCountView(Context context) {
        super(context);
    }

    public NoticeCountView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public NoticeCountView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setCurEditCount(int count) {
        if (count > this.mMaxCount) {
            count = this.mMaxCount;
        }
        if (count < 0) {
            count = 0;
        }
        this.setTextStringSpannable(count);
    }

    private void setTextStringSpannable(int count) {
        String content = count + "/" + this.mMaxCount;
        SpannableString spannableString = new SpannableString((CharSequence)content);
        ForegroundColorSpan graySpan = new ForegroundColorSpan(Color.parseColor((String)"#3f3f3f"));
        if (count < this.mMaxCount) {
            spannableString.setSpan((Object)graySpan, 0, content.length(), 17);
            this.setText((CharSequence)spannableString);
        } else {
            String strCount = String.valueOf(count);
            spannableString.setSpan((Object)graySpan, strCount.length(), content.length(), 17);
            ForegroundColorSpan redSpan = new ForegroundColorSpan(Color.parseColor((String)"#ff001f"));
            spannableString.setSpan((Object)redSpan, 0, strCount.length(), 17);
            this.setText((CharSequence)spannableString);
        }
    }
}

