/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.act.rightbanner;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.tools.actweb.IActWebService;
import com.yy.hiyo.channel.cbase.tools.actweb.data.IActWebData;
import com.yy.hiyo.channel.cbase.tools.actweb.data.OpenWebPanelParam;
import com.yy.hiyo.channel.cbase.utils.preference.RoomSetting;
import com.yy.hiyo.channel.component.act.ActHelper;
import com.yy.hiyo.channel.component.act.ActivityContainer;
import com.yy.hiyo.channel.component.act.BaseActWebPresenter;
import com.yy.hiyo.channel.component.act.rightbanner.RightBannerActivityMvp;
import com.yy.hiyo.channel.component.act.rightbanner.viewmanager.BaseViewManager;
import com.yy.hiyo.channel.component.act.rightbanner.viewmanager.ImageViewManager;
import com.yy.hiyo.channel.component.act.rightbanner.viewmanager.SvgaViewManager;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.hiyo.wallet.base.action.ActionManager;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionWrapper;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;
import com.yy.hiyo.wallet.base.action.RoomActivityActionList;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.appconfigcenter.PluginSubType;
import org.jetbrains.annotations.NotNull;

public class RightBannerActivityPresenter
extends BaseActWebPresenter
implements RightBannerActivityMvp.IPresenter,
BaseViewManager.OnActivityActionClickListener,
IHolderPresenter {
    private static final String TAG = "FTVoiceRoom RightBannerActivityPresenter";
    private MutableLiveData<RoomActivityActionList> mRoomActionData;
    private MutableLiveData<Boolean> mShowData;
    private IActivityService.OnActivityUpdateListener mOnActivityUpdateListener;
    private BaseViewManager mImageViewManager;
    private BaseViewManager mSvgaViewManager;
    private List<Callback<int[]>> locationListeners = new ArrayList<Callback<int[]>>();
    private int[] location;
    private ActivityContainer mActivityPanel;
    protected FrameLayout mParentContainer;
    private IPluginService.IPluginDataChangedCallBack mPluginChangedCallBack = new IPluginService.IPluginDataChangedCallBack(){

        public void onPluginModeChanged(String cid, ChannelPluginData pluginData, ChannelPluginData beforePlugin) {
            MLog.info((Object)RightBannerActivityPresenter.TAG, (String)"onModeChanged", (Object[])new Object[0]);
            RightBannerActivityPresenter.this.requestRoomActivities();
        }

        public void onPluginInfoChanged(String cid, ChannelPluginData pluginData) {
        }
    };
    private IActivityService.OnRightBannerPushListener mOnRightBannerPushListener = new IActivityService.OnRightBannerPushListener(){

        public ActivityTagInfo getRoomTagId(String roomId) {
            if (RightBannerActivityPresenter.this.getRoomId() != null && RightBannerActivityPresenter.this.getRoomId().equals(roomId)) {
                return RightBannerActivityPresenter.this.getRoomTag();
            }
            return null;
        }

        public String roomId() {
            return RightBannerActivityPresenter.this.getRoomId();
        }
    };
    private Runnable refreshTask = new Runnable(){

        @Override
        public void run() {
            MLog.info((Object)RightBannerActivityPresenter.TAG, (String)"refreshTask", (Object[])new Object[0]);
            RightBannerActivityPresenter.this.requestRoomActivities();
        }
    };

    public void onInit(IChannelPageContext<AbsPage> mvpContext) {
        super.onInit(mvpContext);
        this.mRoomActionData = new SafeLiveData();
        this.mShowData = new SafeLiveData();
        this.requestRoomActivities(true);
    }

    public void onMyRoleChanged(String channelId, int newRoleType) {
        MLog.info((Object)TAG, (String)"onMyRoleChanged channelId=%s, newRoleType =%s", (Object[])new Object[]{channelId, newRoleType});
        this.requestRoomActivities(true);
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        this.getChannel().getPluginService().addPluginDataListener(this.mPluginChangedCallBack);
        if (this.mActivityPanel == null) {
            this.mActivityPanel = new ActivityContainer((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            this.mActivityPanel.setPresenter(this);
        }
        if (this.mParentContainer != null && this.mActivityPanel.getParent() == null) {
            this.mParentContainer.addView((View)this.mActivityPanel);
        }
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        this.getChannel().getPluginService().removePluginDataListener(this.mPluginChangedCallBack);
        if (this.mParentContainer != null) {
            this.mParentContainer.removeAllViews();
            if (this.mActivityPanel != null) {
                this.mActivityPanel.onDestroy();
                this.mActivityPanel = null;
            }
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onResume() {
        MLog.debug((Object)TAG, (String)"onResume %s", (Object[])new Object[]{this});
        if (this.mActivityPanel != null) {
            this.mActivityPanel.onResume();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void onPause() {
        MLog.debug((Object)TAG, (String)"onPause %s", (Object[])new Object[]{this});
        if (this.mActivityPanel != null) {
            this.mActivityPanel.onPause();
        }
    }

    protected void requestRoomActivities(final boolean isInit) {
        ActivityTagInfo tag = this.getRoomTag();
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).fetchRoomActivities(this.getRoomId(), tag, null);
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).setOnRightBannerPushListener(this.mOnRightBannerPushListener);
        if (this.mOnActivityUpdateListener == null) {
            this.mOnActivityUpdateListener = new IActivityService.OnActivityUpdateListener(){

                public void onRoomActivityUpdate(List<ActivityActionWrapper<RoomActivityActionList>> data2) {
                    String roomId = RightBannerActivityPresenter.this.getRoomId();
                    ActivityTagInfo tag = RightBannerActivityPresenter.this.getRoomTag();
                    final ActivityActionWrapper item = ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).find(data2, roomId, tag);
                    MLog.info((Object)RightBannerActivityPresenter.TAG, (String)"onRoomActivityUpdate list size %d, item %s", (Object[])new Object[]{FP.size(data2), item});
                    if (isInit) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                RightBannerActivityPresenter.this.onRoomActionUpdate(item != null ? (RoomActivityActionList)item.action : null);
                            }
                        }, (long)100L);
                    } else {
                        RightBannerActivityPresenter.this.onRoomActionUpdate(item != null ? (RoomActivityActionList)item.action : null);
                    }
                    YYTaskExecutor.removeTask((Runnable)RightBannerActivityPresenter.this.refreshTask);
                    if (item != null && item.action != null) {
                        int minute = ((RoomActivityActionList)item.action).getMiniRefreshMin();
                        MLog.info((Object)RightBannerActivityPresenter.TAG, (String)"getMiniRefreshMin=%d", (Object[])new Object[]{minute});
                        if (minute > 0 && minute < Integer.MAX_VALUE) {
                            YYTaskExecutor.postToMainThread((Runnable)RightBannerActivityPresenter.this.refreshTask, (long)(minute * 60 * 1000));
                        }
                    }
                }
            };
            ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).addOnActivityUpdateListener(this.mOnActivityUpdateListener);
        }
    }

    private void requestRoomActivities() {
        this.requestRoomActivities(false);
    }

    private void onRoomActionUpdate(@Nullable RoomActivityActionList data2) {
        MLog.info((Object)TAG, (String)"onRoomActionUpdate %s", (Object[])new Object[]{data2});
        if (data2 != null) {
            ActHelper.INSTANCE.filterMinorDisabled(data2.list);
        }
        RoomActivityActionList roomActivityActionList = ActHelper.INSTANCE.filterRoomActionData(data2);
        this.initLowPhoneActivity(roomActivityActionList);
        this.mRoomActionData.setValue((Object)roomActivityActionList);
        IActWebService actWebService = (IActWebService)ServiceManagerProxy.getService(IActWebService.class);
        if (actWebService != null) {
            List<IActWebData> actWebData = this.getActWebData(roomActivityActionList != null ? roomActivityActionList.list : null);
            actWebService.getActWebData().getRoomRightData().clear();
            actWebService.getActWebData().getRoomRightData().addAll(actWebData);
        }
    }

    private void initLowPhoneActivity(RoomActivityActionList roomActivityActionList) {
        if (roomActivityActionList == null || roomActivityActionList.list == null) {
            return;
        }
        for (int i = 0; i < roomActivityActionList.list.size(); ++i) {
            RoomActivityAction activityAction = (RoomActivityAction)roomActivityActionList.list.get(i);
            if (activityAction.pictureType != ActivityAction.PictureType.H5 || RuntimeContext.getPhoneType() > 1 || !StringUtils.isNotEmpty((String)activityAction.lowEndUrl)) continue;
            activityAction.iconUrl = activityAction.lowEndUrl;
            activityAction.pictureType = ActivityAction.PictureType.IMAGE;
        }
    }

    @NotNull
    private ActivityTagInfo getRoomTag() {
        ChannelTagItem tag = this.getChannelDetailInfo().baseInfo.tag.getFirstTag();
        ActivityTagInfo info = new ActivityTagInfo("" + tag.getTagId(), tag.getName());
        info.setPluginType(this.getChannel().getPluginService().getCurPluginData().mode);
        info.setPluginSubType(this.getChannel().getPluginService().getCurPluginData().isVideoMode() ? PluginSubType.PluginSubTypeVideo.getValue() : PluginSubType.PluginSubTypeAudio.getValue());
        info.setChannelRole(this.getChannel().getRoleService().getMyRoleCache());
        return info;
    }

    @Override
    public LiveData<RoomActivityActionList> getRoomAction() {
        return this.mRoomActionData;
    }

    @Override
    public LiveData<Boolean> getShowData() {
        return this.mShowData;
    }

    @Override
    public BaseViewManager getViewManager(ActivityAction.PictureType pictureType) {
        if (pictureType == ActivityAction.PictureType.IMAGE) {
            return this.getImageViewManager();
        }
        if (pictureType == ActivityAction.PictureType.SVGA) {
            return this.getSvgaViewManager();
        }
        if (pictureType == ActivityAction.PictureType.H5) {
            return this.getWebManager();
        }
        return null;
    }

    @Override
    public String getRoomId() {
        return this.getChannelDetailInfo().baseInfo.gid;
    }

    @Override
    public void onActionClick(ActivityAction action) {
        this.onActivityActionClick(action);
    }

    @Override
    public boolean isMinimize() {
        return false;
    }

    private BaseViewManager getImageViewManager() {
        if (this.mImageViewManager == null) {
            this.mImageViewManager = new ImageViewManager(this);
        }
        return this.mImageViewManager;
    }

    private BaseViewManager getSvgaViewManager() {
        if (this.mSvgaViewManager == null) {
            this.mSvgaViewManager = new SvgaViewManager(this);
        }
        return this.mSvgaViewManager;
    }

    public void onComboShow(boolean show) {
        if (this.mShowData != null) {
            this.mShowData.setValue((Object)(!show ? 1 : 0));
        }
    }

    @Override
    public void onActivityActionClick(ActivityAction action) {
        MLog.info((Object)TAG, (String)"onActivityActionClick %s", (Object[])new Object[]{action});
        if (action == null) {
            return;
        }
        IActWebService actWebService = (IActWebService)ServiceManagerProxy.getService(IActWebService.class);
        if (actWebService != null && actWebService.isUsePanelTabOpen(action.originType + "")) {
            OpenWebPanelParam panelParam = new OpenWebPanelParam();
            panelParam.setId(String.valueOf(action.originType));
            panelParam.setJumpUrl(action.linkUrl);
            MsgDispatcher.getInstance().sendMessage(ChannelMsgDef.OPEN_ACT_WEB, (Object)panelParam);
        } else {
            ActionManager.obtain().onAction(action);
        }
        RoomSetting.getPreference().edit().putLong("room_activity_click_at" + action.id, System.currentTimeMillis()).apply();
        RoomTrack.INSTANCE.roomRightBottomActClick(this.getRoomId(), action.id, action.linkUrl);
    }

    public void setContainer(@NonNull View container) {
        if (container instanceof YYPlaceHolderView) {
            if (this.mParentContainer == null) {
                this.mParentContainer = new YYFrameLayout((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            }
            ((YYPlaceHolderView)container).inflate((View)this.mParentContainer);
        } else if (this.mParentContainer == null && container instanceof YYFrameLayout) {
            this.mParentContainer = (YYFrameLayout)container;
            if (this.mParentContainer.getChildCount() > 0) {
                this.mParentContainer.removeAllViews();
            }
        }
        if (this.mActivityPanel != null) {
            this.mParentContainer.addView((View)this.mActivityPanel);
        }
    }

    @Override
    public void onLocationChange(int[] loca) {
        this.location = loca;
        for (Callback<int[]> listener2 : this.locationListeners) {
            listener2.onResponse((Object)this.location);
        }
    }

    public void addLocationListener(Callback<int[]> listener2) {
        this.locationListeners.add(listener2);
        if (this.location != null) {
            listener2.onResponse((Object)this.location);
        }
    }

    public void removeLocationListener(Callback<int[]> listener2) {
        this.locationListeners.add(listener2);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mImageViewManager != null) {
            this.mImageViewManager.onDestroy();
            this.mImageViewManager = null;
        }
        if (this.mSvgaViewManager != null) {
            this.mSvgaViewManager.onDestroy();
            this.mSvgaViewManager = null;
        }
        this.getChannel().getPluginService().removePluginDataListener(this.mPluginChangedCallBack);
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).removeOnActivityUpdateListener(this.mOnActivityUpdateListener);
        YYTaskExecutor.removeTask((Runnable)this.refreshTask);
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).setOnRightBannerPushListener(null);
        if (this.mActivityPanel != null) {
            this.mActivityPanel.onDestroy();
            if (this.mParentContainer != null && this.mParentContainer.getChildCount() > 0) {
                this.mParentContainer.removeAllViews();
            }
        }
    }
}

