/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.teamup;

import android.app.Activity;
import android.os.Build;
import android.util.Base64;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.config.ChannelTeamUpDDLConfig;
import com.yy.appbase.unifyconfig.config.ChannelTeamUpGameAuthorityConfig;
import com.yy.appbase.unifyconfig.config.ChannelTeamUpGameFloatWinConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.TeamUpInfoBean;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ITeamUpService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IMsgItemFactory;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.ihago.channel.srv.amongus.ReportEventReq;
import net.ihago.channel.srv.amongus.ReportEventRes;
import net.ihago.channel.srv.amongus.ReportSeatStatusReq;
import net.ihago.channel.srv.amongus.ReportSeatStatusRes;
import net.ihago.channel.srv.amongus.SeatReportType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016JH\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001d2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0007H\u0016J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u001dH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/yy/hiyo/channel/service/teamup/TeamUpService;", "Lcom/yy/hiyo/channel/service/BaseService;", "Lcom/yy/hiyo/channel/base/service/ITeamUpService;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;)V", "canShowFlowWin", "", "canShowFloatWin", "getDecodeDeeplink", "", "base64Str", "getGameInfo", "Lcom/yy/hiyo/game/base/bean/GameInfo;", "getGameName", "getGamePkgName", "getMLBBDeepLink", "hasFloatWinPermission", "interceptOnBackClick", "", "isAuthorityMethod", "isTeamUpGame", "needShowFloatWinPermission", "onDestroy", "reportSeatStatus", "cid", "reportType", "Lnet/ihago/channel/srv/amongus/SeatReportType;", "time", "", "index", "", "gid", "lastStageTs", "callback", "Lcom/yy/appbase/callback/ICommonCallback;", "sendInviteTeamUpMsg", "info", "Lcom/yy/hiyo/channel/base/bean/TeamUpInfoBean;", "setHasShowFloatWin", "setShowFloatWin", "show", "startGameReport", "seatIndex", "Companion", "channel-components_debug"})
public final class TeamUpService
extends BaseService
implements ITeamUpService {
    private boolean canShowFlowWin;
    @NotNull
    public static final String TAG = "TeamUpService";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getGamePkgName() {
        GameInfo gameInfo;
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String gid = channelPluginData.getPluginId();
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        GameInfo gameInfo2 = gameInfo = iServiceManager != null && (iServiceManager = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) != null ? iServiceManager.getGameInfoByGid(gid) : null;
        String pkgName = gameInfo2 != null ? gameInfo2.getGamePkgName() : null;
        String string2 = pkgName;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public String getGameName() {
        GameInfo gameInfo;
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String gid = channelPluginData.getPluginId();
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        GameInfo gameInfo2 = gameInfo = iServiceManager != null && (iServiceManager = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) != null ? iServiceManager.getGameInfoByIdWithType(gid, GameInfoSource.IN_VOICE_ROOM) : null;
        String gameName = gameInfo2 != null ? gameInfo2.getGname() : null;
        String string2 = gameName;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public String getMLBBDeepLink() {
        String dataEncoder;
        StringBuilder stringBuilder = new StringBuilder().append("room_id=");
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        String gameData2 = stringBuilder.append(iChannel.getChannelId()).append("&").append("user_id=").append(AccountUtil.getUid()).toString();
        String string2 = dataEncoder = URLEncoder.encode(gameData2, "UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dataEncoder");
        String string3 = string2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String base64Data = Base64.encodeToString((byte[])byArray, (int)0);
        String deepLink = "mobilelegends://appinvites/hago/" + base64Data;
        MLog.info((Object)TAG, (String)("getMLBBDeepLink:" + deepLink), (Object[])new Object[0]);
        return deepLink;
    }

    public boolean isAuthorityMethod() {
        String gid;
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String string2 = gid = channelPluginData.getPluginId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gid");
        return ChannelTeamUpGameAuthorityConfig.Companion.isAuthority(string2);
    }

    public boolean isTeamUpGame() {
        GameInfo gameInfo;
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String gid = channelPluginData.getPluginId();
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        GameInfo gameInfo2 = gameInfo = iServiceManager != null && (iServiceManager = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) != null ? iServiceManager.getGameInfoByIdWithType(gid, GameInfoSource.IN_VOICE_ROOM) : null;
        return gameInfo2 != null ? gameInfo2.getIsOutterGame() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canShowFloatWin() {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String gid = channelPluginData.getPluginId();
        if (!this.canShowFlowWin) return false;
        String string2 = gid;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gid");
        if (ChannelTeamUpGameFloatWinConfig.Companion.forceClosed(string2)) return false;
        return true;
    }

    public void setShowFloatWin(boolean show) {
        this.canShowFlowWin = show;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.canShowFlowWin = false;
    }

    public boolean hasFloatWinPermission() {
        if (Build.VERSION.SDK_INT < 23) {
            MLog.info((Object)TAG, (String)("Build.VERSION_CODES" + Build.VERSION.SDK_INT), (Object[])new Object[0]);
            return true;
        }
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        if (PermissionHelper.hasFloatWinPermission((Activity)iChannel.getContext())) {
            MLog.info((Object)TAG, (String)"hasFloatWinPermission", (Object[])new Object[0]);
            return true;
        }
        return false;
    }

    public boolean needShowFloatWinPermission() {
        String gid;
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String string2 = gid = channelPluginData.getPluginId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gid");
        if (ChannelTeamUpGameFloatWinConfig.Companion.forceClosed(string2)) {
            MLog.info((Object)TAG, (String)("forceClosed float win:" + gid), (Object[])new Object[0]);
            return false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            MLog.info((Object)TAG, (String)("Build.VERSION_CODES" + Build.VERSION.SDK_INT), (Object[])new Object[0]);
            return false;
        }
        IChannel iChannel2 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
        if (PermissionHelper.hasFloatWinPermission((Activity)iChannel2.getContext())) {
            MLog.info((Object)TAG, (String)"hasFloatWinPermission", (Object[])new Object[0]);
            return false;
        }
        return !SettingFlags.getBoolean((String)"key_channel_game_has_show_float_win_per", (boolean)false);
    }

    public void setHasShowFloatWin() {
        SettingFlags.setBoolean((String)"key_channel_game_has_show_float_win_per", (boolean)true);
    }

    public void sendInviteTeamUpMsg(@NotNull TeamUpInfoBean info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        MLog.info((Object)TAG, (String)"sendInviteTeamUpMsg", (Object[])new Object[0]);
        IMsgItemFactory iMsgItemFactory = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory();
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        String string2 = iChannel.getChannelId();
        IChannel iChannel2 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
        IRoleService iRoleService = iChannel2.getRoleService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iRoleService, (String)"channel.roleService");
        BaseImMsg baseImMsg = iMsgItemFactory.generateTeamUpMsg(string2, iRoleService.getMyRoleCache(), AccountUtil.getUid(), info);
        boolean bl = false;
        boolean bl2 = false;
        BaseImMsg it = baseImMsg;
        boolean bl3 = false;
        IChannel iChannel3 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
        iChannel3.getMsgService().sendMsg(it);
    }

    public void startGameReport(long seatIndex) {
        MLog.info((Object)TAG, (String)"startGameReport", (Object[])new Object[0]);
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String gid = channelPluginData.getPluginId();
        ReportEventReq.Builder builder = new ReportEventReq.Builder().gid(gid);
        IChannel iChannel2 = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
        ReportEventReq req = builder.cid(iChannel2.getChannelId()).event_type(Integer.valueOf(1)).seat(Long.valueOf(seatIndex)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<ReportEventRes>(){

            public void onResponse(@NotNull ReportEventRes message, long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)"TeamUpService", (String)("onResponse code:" + code + " msg:" + msg), (Object[])new Object[0]);
            }

            public void onError(@NotNull String reason, int code) {
                Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                super.onError(reason, code);
                MLog.error((Object)"TeamUpService", (String)"onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
            }
        });
    }

    @NotNull
    public String getDecodeDeeplink(@NotNull String base64Str) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)base64Str, (String)"base64Str");
        try {
            byte[] base64Decode = Base64.decode((String)base64Str, (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)base64Decode, (String)"base64Decode");
            byte[] byArray = base64Decode;
            boolean bl = false;
            String decodeStr = new String(byArray, Charsets.UTF_8);
            MLog.debug((Object)TAG, (String)("base64Decode:" + decodeStr), (Object[])new Object[0]);
            String dataDeoder = URLDecoder.decode(decodeStr, "UTF-8");
            MLog.info((Object)TAG, (String)("dataDeoder:" + dataDeoder), (Object[])new Object[0]);
            String string3 = dataDeoder;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dataDeoder");
            string2 = string3;
        }
        catch (IllegalArgumentException e) {
            MLog.error((Object)TAG, (String)"joinMLBB decode exception", (Object[])new Object[0]);
            e.printStackTrace();
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public GameInfo getGameInfo() {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String gid = channelPluginData.getPluginId();
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        return iServiceManager != null && (iServiceManager = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) != null ? iServiceManager.getGameInfoByIdWithType(gid, GameInfoSource.IN_VOICE_ROOM) : null;
    }

    public void interceptOnBackClick() {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        IPluginService iPluginService = iChannel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        if (ChannelDefine.isBaseMode((int)iPluginService.getCurPluginData().mode)) {
            IChannel iChannel2 = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
            EnterParam enterParam = iChannel2.getEnterParam();
            if ((enterParam != null ? enterParam.entry : 0) == ChannelDefine.JoinChannelFrom.SE_TEAM_UP_DDL) {
                IChannel iChannel3 = this.channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel3, (String)"channel");
                Object object = iChannel3.getEnterParam().getExtra("need_handle_back", (Object)false);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"channel.enterParam.getEx\u2026_NEED_HANDLE_BACK, false)");
                if (((Boolean)object).booleanValue()) {
                    ChannelTeamUpDDLConfig.Companion.jumpToTeamUpH5();
                    IChannel iChannel4 = this.channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel4, (String)"channel");
                    iChannel4.getEnterParam().setExtra("need_handle_back", (Object)false);
                }
            }
        }
    }

    public void reportSeatStatus(@NotNull String cid, @NotNull SeatReportType reportType, long time, int index, @NotNull String gid, long lastStageTs, @Nullable ICommonCallback<Boolean> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        Intrinsics.checkParameterIsNotNull((Object)reportType, (String)"reportType");
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        ReportSeatStatusReq reportSeatStatusReq = new ReportSeatStatusReq.Builder().cid(cid).sequence(Long.valueOf(System.currentTimeMillis())).report_type(reportType).ts(Long.valueOf(time)).seat(Long.valueOf(index)).gid(gid).last_stage_ts(Long.valueOf(lastStageTs)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)reportSeatStatusReq, (IProtoCallback)new SimpleProtoCallback<ReportSeatStatusRes>(callback2){
            final /* synthetic */ ICommonCallback $callback;

            public void onResponse(@NotNull ReportSeatStatusRes res, long code, @Nullable String msgTip) {
                block1: {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                        MLog.debug((Object)"TeamUpService", (String)("reportSeatStatus onResponse = " + res), (Object[])new Object[0]);
                        if (!this.isSuccess(code)) break block0;
                        ICommonCallback iCommonCallback = this.$callback;
                        if (iCommonCallback == null) break block1;
                        iCommonCallback.onSuccess((Object)true, new Object[0]);
                        break block1;
                    }
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block1;
                    iCommonCallback.onFail((int)code, msgTip, new Object[0]);
                }
            }

            public void onError(@NotNull String reason, int code) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                    MLog.info((Object)"TeamUpService", (String)("reportSeatStatus onError = " + reason), (Object[])new Object[0]);
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block0;
                    iCommonCallback.onFail(code, reason, new Object[0]);
                }
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public TeamUpService(@NotNull IChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(channel);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/service/teamup/TeamUpService$Companion;", "", "()V", "TAG", "", "channel-components_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

