/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.seat;

import android.content.Context;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.SeatData;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IBeforeSeatUpdateListener;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.component.base.util.ToastErrorUtil;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.mgr.AcceptSitdownReq;
import net.ihago.channel.srv.mgr.AcceptSitdownRes;
import net.ihago.channel.srv.mgr.ChangeSeatReq;
import net.ihago.channel.srv.mgr.ChangeSeatRes;
import net.ihago.channel.srv.mgr.ECode;
import net.ihago.channel.srv.mgr.LockSeatReq;
import net.ihago.channel.srv.mgr.LockSeatRes;
import net.ihago.channel.srv.mgr.SitdownPlzReq;
import net.ihago.channel.srv.mgr.SitdownPlzRes;
import net.ihago.channel.srv.mgr.SitdownReq;
import net.ihago.channel.srv.mgr.SitdownRes;
import net.ihago.channel.srv.mgr.StandupReq;
import net.ihago.channel.srv.mgr.StandupRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\n2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001c2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001bH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\b\u0010(\u001a\u00020\u0010H\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020$H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u0010\u0010,\u001a\u00020$2\u0006\u0010*\u001a\u00020$H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020$0&H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020$0&H\u0016J\b\u0010/\u001a\u00020\nH\u0016J\u0010\u00100\u001a\u00020\n2\u0006\u0010*\u001a\u00020$H\u0016J\u0010\u00101\u001a\u00020\n2\u0006\u0010*\u001a\u00020$H\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u0010*\u001a\u00020$H\u0016J\u0010\u00103\u001a\u00020\n2\u0006\u0010*\u001a\u00020$H\u0016J\b\u00104\u001a\u00020\nH\u0016J\b\u00105\u001a\u00020\nH\u0016J\u0010\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\u001cH\u0016J\b\u00108\u001a\u00020\nH\u0016J\"\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\n2\u0006\u00107\u001a\u00020\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010;H\u0016J\"\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020$2\b\u0010\u001a\u001a\u0004\u0018\u00010;H\u0016J\u001a\u0010>\u001a\u00020\u00122\u0006\u0010*\u001a\u00020$2\b\u0010\u001a\u001a\u0004\u0018\u00010;H\u0016J\b\u0010?\u001a\u00020\u0012H\u0016J \u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00122\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010J\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\u0010\u0010K\u001a\u00020\u00122\u0006\u0010L\u001a\u00020\nH\u0016J \u0010M\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u001c2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0016J\u0018\u0010N\u001a\u00020\u00122\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001bH\u0016J\u001e\u0010O\u001a\u00020\u00122\f\u0010P\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010Q\u001a\u00020\nH\u0016J\u0016\u0010R\u001a\u00020\u00122\f\u0010S\u001a\b\u0012\u0004\u0012\u00020$0&H\u0016R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/yy/hiyo/channel/service/seat/SeatService;", "Lcom/yy/hiyo/channel/service/BaseService;", "Lcom/yy/hiyo/channel/base/service/ISeatService;", "mChannelId", "", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Ljava/lang/String;Lcom/yy/hiyo/channel/base/service/IChannel;)V", "TAG", "cameraForbidByAgeLimited", "", "getMChannelId", "()Ljava/lang/String;", "setMChannelId", "(Ljava/lang/String;)V", "mSeatData", "Lcom/yy/hiyo/channel/base/bean/SeatData;", "addBeforeUpdateSeatListener", "", "listener", "Lcom/yy/hiyo/channel/base/service/IBeforeSeatUpdateListener;", "addSeatUpdateListener", "Lcom/yy/hiyo/channel/base/service/ISeatUpdateListener;", "applySitDownPlz", "plzId", "accept", "callback", "Lcom/yy/appbase/common/Callback;", "", "cameraIsForbidByLimited", "changeSeat", "seat", "clearCacheAnchor", "clearSeatData", "getFirstEmptySeatIndex", "getFirstNotEmptySeatUid", "", "getHasUserSeatList", "", "Lcom/yy/hiyo/channel/base/bean/SeatUser;", "getSeatData", "getSeatIndex", "uid", "getSeatList", "getSeatStatus", "getSeatStatusList", "getSeatUidsList", "hasUserInSeat", "isInFirstSeat", "isInSeat", "isInSeatAboutGift", "isOnlyInOtherSeat", "isSeatFull", "isSeatFullWithLocked", "isSeatLocked", "seatIndex", "lastAnchorIsOwner", "lockSeat", "lock", "Lcom/yy/hiyo/channel/base/service/IOperationCallback;", "makeSitDown", "index", "makeStandUp", "onDestroy", "onJoined", "rejoin", "info", "Lcom/yy/hiyo/channel/base/bean/ChannelDetailInfo;", "data", "Lcom/yy/hiyo/channel/base/bean/EnterChannelData;", "onNotify", "notify", "Lcom/yy/hiyo/channel/base/bean/ChannelNotify;", "removeBeforeUpdateSeatListener", "removeSeatUpdateListener", "setVideosForbidByLimited", "forbid", "sitDown", "standUp", "update", "seatList", "notifyChanged", "updateSeatStatusList", "seatStatusList", "channel-components_debug"})
public final class SeatService
extends BaseService
implements ISeatService {
    private final String TAG = "SeatService";
    private SeatData mSeatData;
    private boolean cameraForbidByAgeLimited;
    @NotNull
    private String mChannelId;

    public void lockSeat(boolean lock, int seatIndex, @Nullable IOperationCallback callback2) {
        MLog.info((Object)this.TAG, (String)("lockSeat " + lock + ",  " + seatIndex), (Object[])new Object[0]);
        LockSeatReq req = new LockSeatReq.Builder().cid(this.mChannelId).lock(Boolean.valueOf(lock)).seat(Integer.valueOf(seatIndex)).build();
        ProtoManager.getInstance().sendRpc(this.mChannelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<LockSeatRes>(this, callback2, this.TAG + " lockSeat"){
            final /* synthetic */ SeatService this$0;
            final /* synthetic */ IOperationCallback $callback;

            public void onResponse(@NotNull LockSeatRes message, long code, @NotNull String msg) {
                block2: {
                    block4: {
                        block3: {
                            block1: {
                                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                                super.onResponse((AndroidMessage)message, code, msg);
                                if (!ProtoManager.isSuccessCode((long)code)) break block1;
                                IOperationCallback iOperationCallback = this.$callback;
                                if (iOperationCallback == null) break block2;
                                iOperationCallback.onSuccess();
                                break block2;
                            }
                            if (code != (long)ECode.NO_PERMIT.getValue()) break block3;
                            IOperationCallback iOperationCallback = this.$callback;
                            if (iOperationCallback == null) break block2;
                            iOperationCallback.onFail(1L);
                            break block2;
                        }
                        if (code != (long)ECode.OTHER_PEOPLE_ON_SEAT.getValue()) break block4;
                        IOperationCallback iOperationCallback = this.$callback;
                        if (iOperationCallback != null) {
                            iOperationCallback.onFail(2L);
                        }
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.short_tips_lock_fail), (int)0);
                        break block2;
                    }
                    IOperationCallback iOperationCallback = this.$callback;
                    if (iOperationCallback == null) break block2;
                    iOperationCallback.onFail(2L);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block0: {
                    super.onError(reason, code);
                    IOperationCallback iOperationCallback = this.$callback;
                    if (iOperationCallback == null) break block0;
                    iOperationCallback.onFail(2L);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    public void sitDown(int seatIndex, @Nullable Callback<Integer> callback2) {
        if (GuestLoginUtils.checkAndShowGuide((int)12)) {
            Callback<Integer> callback3 = callback2;
            if (callback3 != null) {
                callback3.onResponse(null);
            }
            return;
        }
        MLog.info((Object)this.TAG, (String)"sitDown index: %d", (Object[])new Object[]{seatIndex});
        SitdownReq req = new SitdownReq.Builder().cid(this.mChannelId).seat(Integer.valueOf(seatIndex)).build();
        ProtoManager.getInstance().sendRpc(this.mChannelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SitdownRes>(this, callback2, this.TAG + " sitDown"){
            final /* synthetic */ SeatService this$0;
            final /* synthetic */ Callback $callback;

            public void onResponse(@NotNull SitdownRes message, long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)SeatService.access$getTAG$p(this.this$0), (String)("sitDown message: " + message), (Object[])new Object[0]);
                boolean isOk = ProtoManager.isSuccessCode((long)code) && Intrinsics.compare((int)message.seat, (int)0) >= 0;
                ToastErrorUtil.toast(code);
                if (isOk) {
                    Callback callback2 = this.$callback;
                    if (callback2 != null) {
                        callback2.onResponse((Object)message.seat);
                    }
                } else {
                    Callback callback3 = this.$callback;
                    if (callback3 != null) {
                        callback3.onResponse((Object)-1);
                    }
                }
                Boolean bl = message.forbid_age;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"message.forbid_age");
                SeatService.access$setCameraForbidByAgeLimited$p(this.this$0, bl);
            }

            public void onError(@NotNull String reason, int code) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                    super.onError(reason, code);
                    Callback callback2 = this.$callback;
                    if (callback2 == null) break block0;
                    callback2.onResponse(null);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    public void standUp(@Nullable Callback<Boolean> callback2) {
        MLog.info((Object)this.TAG, (String)"standUp uid %s", (Object[])new Object[]{AccountUtil.getUid()});
        StandupReq req = new StandupReq.Builder().cid(this.mChannelId).build();
        ProtoManager.getInstance().sendRpc(this.mChannelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<StandupRes>(this, callback2, this.TAG + " standUp"){
            final /* synthetic */ SeatService this$0;
            final /* synthetic */ Callback $callback;

            public void onResponse(@NotNull StandupRes message, long code, @NotNull String msg) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                    super.onResponse((AndroidMessage)message, code, msg);
                    Callback callback2 = this.$callback;
                    if (callback2 == null) break block0;
                    callback2.onResponse((Object)true);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    public void makeStandUp(long uid, @Nullable IOperationCallback callback2) {
        MLog.info((Object)this.TAG, (String)"makeStandUp %d", (Object[])new Object[]{uid});
        StandupReq req = new StandupReq.Builder().cid(this.mChannelId).uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc(this.mChannelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<StandupRes>(this, callback2, this.TAG + " makeStandUp"){
            final /* synthetic */ SeatService this$0;
            final /* synthetic */ IOperationCallback $callback;

            public void onResponse(@NotNull StandupRes message, long code, @NotNull String msg) {
                block1: {
                    block2: {
                        block0: {
                            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                            super.onResponse((AndroidMessage)message, code, msg);
                            boolean isOk = ProtoManager.isSuccessCode((long)code);
                            MLog.info((Object)SeatService.access$getTAG$p(this.this$0), (String)"makeStandUp onResponse %b, code %s", (Object[])new Object[]{isOk, code});
                            if (!isOk) break block0;
                            IOperationCallback iOperationCallback = this.$callback;
                            if (iOperationCallback == null) break block1;
                            iOperationCallback.onSuccess();
                            break block1;
                        }
                        if (code != (long)ECode.NO_PERMIT.getValue()) break block2;
                        IOperationCallback iOperationCallback = this.$callback;
                        if (iOperationCallback == null) break block1;
                        iOperationCallback.onFail(1L);
                        break block1;
                    }
                    IOperationCallback iOperationCallback = this.$callback;
                    if (iOperationCallback == null) break block1;
                    iOperationCallback.onFail(2L);
                }
            }

            public void onError(@NotNull String reason, int code) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                    super.onError(reason, code);
                    MLog.info((Object)SeatService.access$getTAG$p(this.this$0), (String)"makeStandUp onError reason: %s, code: %d", (Object[])new Object[]{reason, code});
                    IOperationCallback iOperationCallback = this.$callback;
                    if (iOperationCallback == null) break block0;
                    iOperationCallback.onFail(2L);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    public void makeSitDown(int index, long uid, @Nullable IOperationCallback callback2) {
        MLog.info((Object)this.TAG, (String)"makeSitDown index %d, uid %d, callback %s", (Object[])new Object[]{index, uid, callback2});
        SitdownPlzReq req = new SitdownPlzReq.Builder().cid(this.mChannelId).seat(Integer.valueOf(index)).uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc(this.mChannelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SitdownPlzRes>(this, callback2, this.TAG + " makeSitDown"){
            final /* synthetic */ SeatService this$0;
            final /* synthetic */ IOperationCallback $callback;

            public void onResponse(@NotNull SitdownPlzRes message, long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    IOperationCallback iOperationCallback = this.$callback;
                    if (iOperationCallback != null) {
                        iOperationCallback.onSuccess();
                    }
                } else if (code == (long)ECode.NO_PERMIT.getValue()) {
                    IOperationCallback iOperationCallback = this.$callback;
                    if (iOperationCallback != null) {
                        iOperationCallback.onFail(1L);
                    }
                } else {
                    IOperationCallback iOperationCallback = this.$callback;
                    if (iOperationCallback != null) {
                        iOperationCallback.onFail(2L);
                    }
                }
                ToastErrorUtil.toast(code);
            }

            public void onError(@NotNull String reason, int code) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                    super.onError(reason, code);
                    IOperationCallback iOperationCallback = this.$callback;
                    if (iOperationCallback == null) break block0;
                    iOperationCallback.onFail(2L);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    public void changeSeat(int seat, @Nullable Callback<Boolean> callback2) {
        MLog.info((Object)this.TAG, (String)"changeSeat seat %d, callback %s", (Object[])new Object[]{seat, callback2});
        ChangeSeatReq req = new ChangeSeatReq.Builder().cid(this.mChannelId).seat(Integer.valueOf(seat)).build();
        ProtoManager.getInstance().sendRpc(this.mChannelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<ChangeSeatRes>(this, callback2, this.TAG + " changeSeat"){
            final /* synthetic */ SeatService this$0;
            final /* synthetic */ Callback $callback;

            public void onResponse(@NotNull ChangeSeatRes message, long code, @NotNull String msg) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                    super.onResponse((AndroidMessage)message, code, msg);
                    ToastErrorUtil.toast(code);
                    Callback callback2 = this.$callback;
                    if (callback2 == null) break block0;
                    callback2.onResponse((Object)ProtoManager.isSuccessCode((long)code));
                }
            }

            public void onError(@NotNull String reason, int code) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                    super.onError(reason, code);
                    Callback callback2 = this.$callback;
                    if (callback2 == null) break block0;
                    callback2.onResponse((Object)false);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    public void applySitDownPlz(@NotNull String plzId, boolean accept, @Nullable Callback<Integer> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)plzId, (String)"plzId");
        if (GuestLoginUtils.checkAndShowGuide((int)12)) {
            Callback<Integer> callback3 = callback2;
            if (callback3 != null) {
                callback3.onResponse(null);
            }
            return;
        }
        MLog.info((Object)this.TAG, (String)"acceptSitDownPlz plzId %s, accept %b, callback %s", (Object[])new Object[]{plzId, accept, callback2});
        AcceptSitdownReq req = new AcceptSitdownReq.Builder().cid(this.mChannelId).accept(Boolean.valueOf(accept)).plz_id(plzId).build();
        ProtoManager.getInstance().sendRpc(this.mChannelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<AcceptSitdownRes>(this, callback2, this.TAG + " acceptSitDownPlz"){
            final /* synthetic */ SeatService this$0;
            final /* synthetic */ Callback $callback;

            public void onResponse(@NotNull AcceptSitdownRes message, long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)SeatService.access$getTAG$p(this.this$0), (String)("applySitDownPlz message: " + message), (Object[])new Object[0]);
                boolean isOk = ProtoManager.isSuccessCode((long)code) && Intrinsics.compare((int)message.seat, (int)0) > 0;
                IChannel iChannel = SeatService.access$getChannel$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                IPluginService iPluginService = iChannel.getPluginService();
                Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
                if (iPluginService.getCurPluginData().mode == 15 && ECode.SEAT_FULL.getValue() == (int)code) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_multivideo_full_seat), (int)0);
                } else {
                    ToastErrorUtil.toast(code);
                }
                if (isOk) {
                    Callback callback2 = this.$callback;
                    if (callback2 != null) {
                        callback2.onResponse((Object)message.seat);
                    }
                } else {
                    Callback callback3 = this.$callback;
                    if (callback3 != null) {
                        callback3.onResponse(null);
                    }
                }
                Boolean bl = message.forbid_age;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"message.forbid_age");
                SeatService.access$setCameraForbidByAgeLimited$p(this.this$0, bl);
            }

            public void onError(@NotNull String reason, int code) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                    super.onError(reason, code);
                    Callback callback2 = this.$callback;
                    if (callback2 == null) break block0;
                    callback2.onResponse(null);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    @Override
    public void onJoined(boolean rejoin2, @NotNull ChannelDetailInfo info, @NotNull EnterChannelData data2) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        super.onJoined(rejoin2, info, data2);
        this.mSeatData.update(data2.seatList, true);
    }

    @Override
    public void onNotify(@NotNull ChannelNotify notify2) {
        Intrinsics.checkParameterIsNotNull((Object)notify2, (String)"notify");
        if (ChannelNotify.Uri.UriSetMicNotify == notify2.uri) {
            if (1 == notify2.notify.setMic.micBan && this.isInSeat(AccountUtil.getUid()) && notify2.notify.setMic.uid == AccountUtil.getUid()) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_open_room_mic_forbid), (int)0);
            }
        } else if (ChannelNotify.Uri.UriSetVideoNotify == notify2.uri) {
            if (1 == notify2.notify.setVideo.videoBan && this.isInSeat(AccountUtil.getUid()) && notify2.notify.setVideo.uid == AccountUtil.getUid()) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_open_video_forbid), (int)0);
            }
        } else if (ChannelNotify.Uri.UriSeatsChange == notify2.uri) {
            List list2 = notify2.notify.seatsChange.seatList;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"notify.notify.seatsChange.seatList");
            this.update(list2, true);
        } else if (ChannelNotify.Uri.UriForbidCameraByAgeLimited == notify2.uri) {
            this.cameraForbidByAgeLimited = false;
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mSeatData.clear();
    }

    @NotNull
    public List<SeatUser> getSeatList() {
        List list2 = this.mSeatData.getSeatList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"mSeatData.seatList");
        return list2;
    }

    @NotNull
    public List<SeatUser> getHasUserSeatList() {
        List list2 = this.mSeatData.getHasUserSeatList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"mSeatData.hasUserSeatList");
        return list2;
    }

    public boolean hasUserInSeat() {
        return this.mSeatData.hasUserInSeat();
    }

    @NotNull
    public List<Long> getSeatUidsList() {
        List list2 = this.mSeatData.getSeatUidsList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"mSeatData.seatUidsList");
        return list2;
    }

    @NotNull
    public List<Long> getSeatStatusList() {
        List list2 = this.mSeatData.getSeatStatusList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"mSeatData.seatStatusList");
        return list2;
    }

    public int getSeatIndex(long uid) {
        return this.mSeatData.getSeatIndex(uid);
    }

    public long getSeatStatus(long uid) {
        return this.mSeatData.getSeatStatus(uid);
    }

    public int getFirstEmptySeatIndex() {
        return this.mSeatData.getFirstEmptySeatIndex();
    }

    public boolean isInFirstSeat(long uid) {
        return 1 == this.getSeatIndex(uid);
    }

    public boolean lastAnchorIsOwner() {
        Long l = this.mSeatData.getLastValidFirstSeatUid();
        return l != null && AccountUtil.getUid() == l;
    }

    public void clearCacheAnchor() {
        this.mSeatData.clearLastValidFirstSeatUid();
    }

    public boolean isInSeat(long uid) {
        return this.mSeatData.isInSeat(uid);
    }

    public boolean isInSeatAboutGift(long uid) {
        return this.mSeatData.isInSeat(uid) || this.mSeatData.isInOtherSeat(uid);
    }

    public boolean isOnlyInOtherSeat(long uid) {
        return this.mSeatData.isOnlyInOtherSeat(uid);
    }

    public boolean isSeatFull() {
        return this.mSeatData.isSeatFull();
    }

    public boolean isSeatLocked(int seatIndex) {
        return this.mSeatData.isSeatLocked(seatIndex);
    }

    public boolean isSeatFullWithLocked() {
        return this.mSeatData.isSeatFullWithLocked();
    }

    public void update(@NotNull List<? extends SeatUser> seatList, boolean notifyChanged) {
        Intrinsics.checkParameterIsNotNull(seatList, (String)"seatList");
        this.mSeatData.update(seatList, notifyChanged);
    }

    public void updateSeatStatusList(@NotNull List<Long> seatStatusList) {
        Intrinsics.checkParameterIsNotNull(seatStatusList, (String)"seatStatusList");
        this.mSeatData.updateSeatStatusList(seatStatusList);
    }

    public void addSeatUpdateListener(@Nullable ISeatUpdateListener listener2) {
        this.mSeatData.addSeatUpdateListener(listener2);
    }

    public void removeSeatUpdateListener(@NotNull ISeatUpdateListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.mSeatData.removeSeatUpdateListener(listener2);
    }

    public void addBeforeUpdateSeatListener(@NotNull IBeforeSeatUpdateListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.mSeatData.addBeforeUpdateSeatListener(listener2);
    }

    public void removeBeforeUpdateSeatListener(@NotNull IBeforeSeatUpdateListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.mSeatData.removeBeforeUpdateSeatListener(listener2);
    }

    @NotNull
    public SeatData getSeatData() {
        return this.mSeatData;
    }

    public void clearSeatData() {
        this.mSeatData.clear();
    }

    public boolean cameraIsForbidByLimited() {
        return this.cameraForbidByAgeLimited;
    }

    public void setVideosForbidByLimited(boolean forbid) {
        this.cameraForbidByAgeLimited = forbid;
    }

    public long getFirstNotEmptySeatUid() {
        return this.mSeatData.getFirstNotEmptySeatUid();
    }

    @NotNull
    public final String getMChannelId() {
        return this.mChannelId;
    }

    public final void setMChannelId(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.mChannelId = string2;
    }

    public SeatService(@NotNull String mChannelId, @NotNull IChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)mChannelId, (String)"mChannelId");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(channel);
        this.mChannelId = mChannelId;
        this.TAG = "SeatService";
        this.mSeatData = new SeatData();
    }

    public boolean isFirstSeatIndex(int index) {
        return ISeatService.DefaultImpls.isFirstSeatIndex((ISeatService)this, (int)index);
    }

    public boolean isMeInSeat() {
        return ISeatService.DefaultImpls.isMeInSeat((ISeatService)this);
    }

    public boolean isMeReady() {
        return ISeatService.DefaultImpls.isMeReady((ISeatService)this);
    }

    public static final /* synthetic */ String access$getTAG$p(SeatService $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ boolean access$getCameraForbidByAgeLimited$p(SeatService $this) {
        return $this.cameraForbidByAgeLimited;
    }

    public static final /* synthetic */ void access$setCameraForbidByAgeLimited$p(SeatService $this, boolean bl) {
        $this.cameraForbidByAgeLimited = bl;
    }

    public static final /* synthetic */ IChannel access$getChannel$p(SeatService $this) {
        return $this.channel;
    }
}

