/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.role;

import biz.ChannelMember;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.util.StatusUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelListData;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.data.local.ChannelMembers;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import com.yy.hiyo.channel.service.role.MemBerData;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.ihago.online.srv.online.OnlineStatus;

public class ChannelRoleModel {
    private static final String TAG = "ChannelRoleModel";
    private final MemBerData memBerData = new MemBerData();
    private String memberDataUseGroupId;
    private int myRoleType = -1000;
    private ILocalDataModel localDataManager;
    private ChannelRequestManager requestManager;
    private ArrayList<DataUpdateListener> dataListeners;
    private IGroupRoleModelCallBack callBack;
    private ChannelUser myRolerInThisChannel;

    public ChannelRoleModel(String memberDataUseGroupId, ILocalDataModel localGroupDataManager, IGroupRoleModelCallBack callBack) {
        this.localDataManager = localGroupDataManager;
        this.memberDataUseGroupId = memberDataUseGroupId;
        this.callBack = callBack;
        this.requestManager = new ChannelRequestManager();
    }

    public void getAllMemberList(final String groupId, final IRoleService.IGetAllMemberListCallBack callBack) {
        if (this.memBerData.hasSynced) {
            if (YYTaskExecutor.isMainThread()) {
                if (callBack != null) {
                    callBack.onSuccess(groupId, this.memBerData.members);
                }
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onSuccess(groupId, ((ChannelRoleModel)ChannelRoleModel.this).memBerData.members);
                        }
                    }
                });
            }
            return;
        }
        this.getAllMemberListFromServer(groupId, callBack);
    }

    public void getAllMemberListFromServer(final String groupId, final IRoleService.IGetAllMemberListCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final ChannelMembers members = !((ChannelRoleModel)ChannelRoleModel.this).memBerData.hasLoaded && ChannelRoleModel.this.localDataManager != null ? ChannelRoleModel.this.localDataManager.getGroupMembers(groupId) : null;
                ((ChannelRoleModel)ChannelRoleModel.this).memBerData.hasLoaded = true;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (members != null) {
                            ((ChannelRoleModel)ChannelRoleModel.this).memBerData.members = members.users;
                            ((ChannelRoleModel)ChannelRoleModel.this).memBerData.membersVer = members.ver;
                        }
                        ChannelRoleModel.this.doGetAllMemberListFromServer(groupId, callBack);
                    }
                });
            }
        });
    }

    private void doGetAllMemberListFromServer(final String groupId, final IRoleService.IGetAllMemberListCallBack callBack) {
        long requestVer = this.memBerData.hasPullAll ? this.memBerData.membersVer : 0L;
        this.requestManager.getAllMembers(this.memberDataUseGroupId, requestVer, new BaseRequestManager.IGetAllMembersCallBack(){

            public void onSuccess(String gid, long ver, List<ChannelMember> theMembers, List<OnlineStatus> statues) {
                ((ChannelRoleModel)ChannelRoleModel.this).memBerData.hasSynced = true;
                ((ChannelRoleModel)ChannelRoleModel.this).memBerData.lastSyncTime = System.currentTimeMillis();
                if (ver > 0L && ver == ((ChannelRoleModel)ChannelRoleModel.this).memBerData.membersVer && ((ChannelRoleModel)ChannelRoleModel.this).memBerData.hasPullAll) {
                    ((ChannelRoleModel)ChannelRoleModel.this).memBerData.hasPullAll = true;
                    if (callBack != null) {
                        ArrayList<ChannelUser> members = ((ChannelRoleModel)ChannelRoleModel.this).memBerData.members;
                        if (members.size() > 0 && statues.size() == members.size()) {
                            for (int i = 0; i < members.size(); ++i) {
                                members.get((int)i).status = StatusUtil.parseStatus((OnlineStatus)statues.get(i));
                            }
                        }
                        callBack.onSuccess(groupId, ((ChannelRoleModel)ChannelRoleModel.this).memBerData.members);
                    }
                    if (RuntimeContext.isInGray()) {
                        MLog.info((Object)ChannelRoleModel.TAG, (String)"GetAllMember ver equal:%s!", (Object[])new Object[]{String.valueOf(ver)});
                    }
                    return;
                }
                ((ChannelRoleModel)ChannelRoleModel.this).memBerData.hasPullAll = true;
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)ChannelRoleModel.TAG, (String)"GetAllMember newver:%s, oldver:%s!", (Object[])new Object[]{String.valueOf(ver), String.valueOf(((ChannelRoleModel)ChannelRoleModel.this).memBerData.membersVer)});
                }
                if (theMembers != null && theMembers.size() > 0) {
                    ArrayList<ChannelUser> groupUsers = new ArrayList<ChannelUser>(theMembers.size());
                    for (int i = 0; i < theMembers.size() && i < statues.size(); ++i) {
                        ChannelMember member = theMembers.get(i);
                        if (member.uid > 0L) {
                            ChannelUser channelUser = ChannelUser.obtain((ChannelMember)member);
                            OnlineStatus status = statues.get(i);
                            channelUser.status = StatusUtil.parseStatus((OnlineStatus)status);
                            groupUsers.add(channelUser);
                            continue;
                        }
                        if (!RuntimeContext.sIsDebuggable) continue;
                        throw new RuntimeException("\u670d\u52a1\u5668\u8fd4\u56de\u7684\u6570\u636e\u6709\u95ee\u9898\uff0cuid\u65e0\u6548\uff0c" + member.toString());
                    }
                    ChannelRoleModel.this.handleMemberListChange(ver, groupUsers);
                    if (callBack != null) {
                        callBack.onSuccess(groupId, groupUsers);
                    }
                } else {
                    ChannelRoleModel.this.handleMemberListChange(ver, new ArrayList(0));
                    if (callBack != null) {
                        callBack.onSuccess(groupId, new ArrayList(0));
                    }
                }
            }

            public void onTopGroupNotExist(String gid, int errorCode) {
                if (((ChannelRoleModel)ChannelRoleModel.this).memBerData.members == null || ((ChannelRoleModel)ChannelRoleModel.this).memBerData.members.size() <= 0) {
                    ((ChannelRoleModel)ChannelRoleModel.this).memBerData.hasSynced = true;
                    ((ChannelRoleModel)ChannelRoleModel.this).memBerData.lastSyncTime = System.currentTimeMillis();
                }
                if (callBack != null) {
                    callBack.onError(groupId, errorCode, "", new Exception("topGroupNotExist!"));
                }
            }

            public void onError(String gid, int errorCode, String errorTips, Exception e) {
                if (((ChannelRoleModel)ChannelRoleModel.this).memBerData.members != null && ((ChannelRoleModel)ChannelRoleModel.this).memBerData.members.size() > 0) {
                    if (callBack != null) {
                        callBack.onSuccess(groupId, ((ChannelRoleModel)ChannelRoleModel.this).memBerData.members);
                    }
                } else if (callBack != null) {
                    callBack.onError(groupId, errorCode, errorTips, e);
                }
            }
        });
    }

    public int getRole(final long uid, String groupId, final IRoleService.IGetRoleCallBack callBack) {
        this.getAllMemberList(groupId, new IRoleService.IGetAllMemberListCallBack(){

            public void onSuccess(String channelId, ArrayList<ChannelUser> theMembers) {
                if (theMembers != null && theMembers.size() > 0) {
                    for (ChannelUser member : theMembers) {
                        ChannelDetailInfo detailInfo;
                        if (member == null || member.uid != uid) continue;
                        if (RuntimeContext.sIsDebuggable && member.roleType <= 0) {
                            MLog.error((Object)ChannelRoleModel.TAG, (String)("\u53d1\u73b0\u662f\u6210\u5458\uff0c\u4f46\u662froleType \u65e0\u6548\uff1a" + theMembers.toString()), (Object[])new Object[0]);
                        }
                        int role = member.roleType;
                        if (uid == AccountUtil.getUid() && role <= 0 && (detailInfo = ChannelRoleModel.this.callBack.getDataService().getChannelDetailInfo(null)) != null && detailInfo.baseInfo.ownerUid == uid && uid > 0L) {
                            role = 15;
                        }
                        if (callBack != null) {
                            callBack.onSuccess(channelId, role);
                        }
                        if (!ChannelDefine.sUnEnableLog) {
                            MLog.info((Object)"FTRoomGroupRoleService", (String)(channelId + ",getPermission roleType:%d"), (Object[])new Object[]{member.roleType});
                        }
                        return;
                    }
                }
                if (callBack != null) {
                    callBack.onSuccess(channelId, ChannelRoleModel.this.getRoleCache(uid));
                    if (!ChannelDefine.sUnEnableLog) {
                        MLog.info((Object)"FTRoomGroupRoleService", (String)(channelId + ",getPermission roleType:%d"), (Object[])new Object[]{1});
                    }
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                int role = ChannelRoleModel.this.getRoleCache(uid);
                if (role != -1) {
                    if (callBack != null) {
                        callBack.onSuccess(channelId, role);
                    }
                } else if (callBack != null) {
                    callBack.onError(channelId, errorCode, "", e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(channelId + ",getPermission errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
        return this.getRoleCache(uid);
    }

    private HashMap<Long, Integer> getRolesFromCache(List<Long> uids) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(uids.size());
        ArrayList<ChannelUser> members = this.memBerData.members;
        if (members != null && members.size() > 0) {
            for (Long uid : uids) {
                boolean find = false;
                for (ChannelUser member : members) {
                    if (member == null || member.uid != uid) continue;
                    result.put(uid, member.roleType);
                    find = true;
                    break;
                }
                if (find) continue;
                result.put(uid, 1);
            }
        }
        return result;
    }

    private HashMap<Long, ChannelUser> getUsersFromCache(List<Long> uids) {
        HashMap<Long, ChannelUser> result = new HashMap<Long, ChannelUser>(uids.size());
        ArrayList<ChannelUser> members = this.memBerData.members;
        if (members != null && members.size() > 0) {
            for (Long uid : uids) {
                boolean find = false;
                for (ChannelUser member : members) {
                    if (member == null || member.uid != uid) continue;
                    result.put(uid, member);
                    find = true;
                    break;
                }
                if (find) continue;
                result.put(uid, ChannelUser.obtain((long)uid, (int)1));
            }
        }
        return result;
    }

    public HashMap<Long, ChannelUser> getUsers(String groupId, final List<Long> uids, final IRoleService.IGetRoleUsersCallBack callBack) {
        this.getAllMemberList(groupId, new IRoleService.IGetAllMemberListCallBack(){

            public void onSuccess(String channelId, ArrayList<ChannelUser> theMembers) {
                HashMap result = ChannelRoleModel.this.getUsersFromCache(uids);
                if (callBack != null) {
                    callBack.onSuccess(channelId, result);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channelId, errorCode, "", e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(channelId + ",getPermission errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
        return this.getUsersFromCache(uids);
    }

    public HashMap<Long, Integer> getRoles(String groupId, final List<Long> uids, final IRoleService.IGetRolesCallBack callBack) {
        this.getAllMemberList(groupId, new IRoleService.IGetAllMemberListCallBack(){

            public void onSuccess(String channelId, ArrayList<ChannelUser> theMembers) {
                HashMap result = ChannelRoleModel.this.getRolesFromCache(uids);
                if (callBack != null) {
                    callBack.onSuccess(channelId, result);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channelId, errorCode, "", e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(channelId + ",getPermission errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
        return this.getRolesFromCache(uids);
    }

    public void getRoleList(final IChannel channel, String groupId, final int roleType, final int num, final int offset, final IRoleService.IGetUserListCallBack callBack) {
        this.getAllMemberList(groupId, new IRoleService.IGetAllMemberListCallBack(){

            public void onSuccess(String channelId, ArrayList<ChannelUser> members) {
                ArrayList<ChannelUser> thisRolers = new ArrayList<ChannelUser>();
                if (members != null && members.size() > 0) {
                    for (ChannelUser user : members) {
                        if (user == null || user.roleType != roleType) continue;
                        thisRolers.add(user);
                    }
                }
                long total = thisRolers.size();
                if (offset >= thisRolers.size()) {
                    if (callBack != null) {
                        callBack.onSuccess(channel, total, new ArrayList());
                    }
                } else if (num >= 0 && thisRolers.size() > 0) {
                    int toIndex;
                    int n = toIndex = num + offset >= thisRolers.size() ? thisRolers.size() : num + offset;
                    if (callBack != null) {
                        callBack.onSuccess(channel, total, thisRolers.subList(offset, toIndex));
                    }
                } else if (callBack != null) {
                    callBack.onSuccess(channel, total, thisRolers);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channel, errorCode, errorTips, e);
                }
            }
        });
    }

    public void onJoined(boolean rejoin2, ChannelDetailInfo info, EnterChannelData data2) {
        if (data2 != null && data2.memberInThisChannel != null && data2.memberInThisChannel.uid == AccountUtil.getUid() && data2.memberInThisChannel.roleType > 0) {
            this.myRolerInThisChannel = data2.memberInThisChannel;
        }
        if (rejoin2) {
            this.getAllMemberListFromServer(info.baseInfo.getChannelId(), null);
        }
    }

    public int getRoleCache(long uid) {
        ChannelDetailInfo detailInfo;
        ArrayList<ChannelUser> members = this.memBerData.members;
        if (members != null && members.size() > 0) {
            for (ChannelUser member : members) {
                if (member == null || member.uid != uid) continue;
                return member.roleType;
            }
        } else if (!this.memBerData.hasSynced) {
            this.getAllMemberList(this.memberDataUseGroupId, new IRoleService.IGetAllMemberListCallBack(){

                public void onSuccess(String channelId, ArrayList<ChannelUser> members) {
                }

                public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                }
            });
        }
        if (uid == AccountUtil.getUid() && (detailInfo = this.callBack.getDataService().getCacheDetail()) != null && detailInfo.baseInfo.ownerUid == uid && uid > 0L) {
            return 15;
        }
        if (this.myRolerInThisChannel != null && this.myRolerInThisChannel.uid == uid) {
            return this.myRolerInThisChannel.roleType;
        }
        if (this.memBerData.hasSynced) {
            return 1;
        }
        return -1;
    }

    public void onTopAndSubGroupListChange(String channelId, ChannelListData data2) {
        if (StringUtils.isNotEmpty((String)channelId) && (this.memBerData.members == null || this.memBerData.members.size() <= 0) && this.memBerData.hasSynced) {
            this.memBerData.hasSynced = false;
        }
    }

    public void notifySpeakBanned(long uid, boolean banned, long time) {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        ArrayList<DataUpdateListener> listeners = new ArrayList<DataUpdateListener>(this.dataListeners);
        IRoleService.IMemberOrMasterChangeListener listener2 = null;
        for (DataUpdateListener item : listeners) {
            if (item == null || item.listener == null || (listener2 = (IRoleService.IMemberOrMasterChangeListener)item.listener.get()) == null) continue;
            listener2.onSpeakBanned(uid, banned);
        }
    }

    public void onDoNotDisturbChanged(long uid, int mode) {
        ArrayList<ChannelUser> members = this.memBerData.members;
        ChannelUser memberFind = null;
        if (members != null && members.size() > 0) {
            for (ChannelUser member : members) {
                if (member == null || member.uid != uid) continue;
                memberFind = member;
                break;
            }
        }
        if (memberFind == null) {
            return;
        }
        if (memberFind.msgReceiveMode == mode) {
            return;
        }
        memberFind.msgReceiveMode = mode;
        if (this.localDataManager != null) {
            this.localDataManager.updateMembers(this.memberDataUseGroupId, this.memBerData.membersVer, this.memBerData.members);
        }
    }

    public void onRoleSeted(String gid, long uid, long ver, long time, int roleType) {
        if (this.myRolerInThisChannel != null && this.myRolerInThisChannel.uid == uid) {
            this.myRolerInThisChannel.roleType = roleType;
        }
        ArrayList<ChannelUser> members = this.memBerData.members;
        ChannelUser memberFind = null;
        if (members != null && members.size() > 0) {
            for (ChannelUser member : members) {
                if (member == null || member.uid != uid) continue;
                memberFind = member;
                break;
            }
        }
        if (this.memBerData.members == null) {
            this.memBerData.members = new ArrayList();
        }
        if (memberFind != null && memberFind.roleType == roleType) {
            return;
        }
        if (memberFind != null) {
            if (1 == roleType) {
                members.remove(memberFind);
            } else {
                memberFind.roleType = roleType;
            }
        } else if (uid > 0L && roleType != 1 && roleType != -1) {
            this.memBerData.members.add(ChannelUser.obtain((long)uid, (long)time, (int)roleType));
        }
        this.notifyMemberChanged(uid, roleType);
        this.handleMemberListChange(this.memBerData.membersVer, this.memBerData.members);
    }

    private void notifyMemberChanged(long uid, int roleType) {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        ArrayList<DataUpdateListener> listeners = new ArrayList<DataUpdateListener>(this.dataListeners);
        IRoleService.IMemberOrMasterChangeListener listener2 = null;
        for (DataUpdateListener item : listeners) {
            if (item == null || item.listener == null || (listener2 = (IRoleService.IMemberOrMasterChangeListener)item.listener.get()) == null) continue;
            listener2.onRoleChanged(item.groupId, uid, roleType);
        }
    }

    private void handleMemberListChange(long ver, ArrayList<ChannelUser> newMembers) {
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"handleMemberListChange ver:%s, member size:%d!", (Object[])new Object[]{String.valueOf(ver), newMembers != null ? newMembers.size() : 0});
        }
        this.memBerData.membersVer = ver;
        this.memBerData.members = newMembers;
        int oldMyRoleType = this.myRoleType;
        this.myRoleType = this.getRoleCache(AccountUtil.getUid());
        this.notifyMemberListChanged();
        if (this.myRoleType != -1000 && this.myRoleType != oldMyRoleType) {
            this.notifyMyRoleChanged(this.myRoleType);
            this.notifyMemberChanged(AccountUtil.getUid(), this.myRoleType);
        }
        if (this.localDataManager != null) {
            this.localDataManager.updateMembers(this.memberDataUseGroupId, this.memBerData.membersVer, this.memBerData.members);
        }
    }

    private void notifyMemberListChanged() {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        ArrayList<DataUpdateListener> listeners = new ArrayList<DataUpdateListener>(this.dataListeners);
        IRoleService.IMemberOrMasterChangeListener listener2 = null;
        for (DataUpdateListener item : listeners) {
            if (item == null || item.listener == null || (listener2 = (IRoleService.IMemberOrMasterChangeListener)item.listener.get()) == null) continue;
            listener2.onMemberListChanged(item.groupId, this.memBerData.members);
        }
    }

    private void notifyMyRoleChanged(int newRoleType) {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        ArrayList<DataUpdateListener> listeners = new ArrayList<DataUpdateListener>(this.dataListeners);
        IRoleService.IMemberOrMasterChangeListener listener2 = null;
        for (DataUpdateListener item : listeners) {
            if (item == null || item.listener == null || (listener2 = (IRoleService.IMemberOrMasterChangeListener)item.listener.get()) == null) continue;
            listener2.onMyRoleChanged(item.groupId, newRoleType);
        }
    }

    public synchronized void addDataListener(String groupId, IRoleService.IMemberOrMasterChangeListener listener2) {
        if (SystemUtils.isShowEnvSetting() && !YYTaskExecutor.isMainThread()) {
            throw new IllegalStateException("Not in main thread!");
        }
        if (listener2 == null) {
            return;
        }
        boolean isAdd = false;
        if (this.dataListeners == null) {
            this.dataListeners = new ArrayList(36);
        } else {
            Iterator<DataUpdateListener> itr = this.dataListeners.iterator();
            while (itr.hasNext()) {
                DataUpdateListener item = itr.next();
                IRoleService.IMemberOrMasterChangeListener listenerReal = null;
                if (item != null && item.listener != null) {
                    listenerReal = (IRoleService.IMemberOrMasterChangeListener)item.listener.get();
                }
                if (listenerReal == null) {
                    itr.remove();
                    continue;
                }
                if (listenerReal != listener2 || !StringUtils.equal((String)groupId, (String)item.groupId)) continue;
                isAdd = true;
            }
        }
        if (!isAdd) {
            this.dataListeners.add(new DataUpdateListener(groupId, listener2));
        }
    }

    public synchronized void removeDataListener(String groupId, IRoleService.IMemberOrMasterChangeListener listener2) {
        if (SystemUtils.isShowEnvSetting() && !YYTaskExecutor.isMainThread()) {
            throw new IllegalStateException("Not in main thread!");
        }
        if (listener2 == null) {
            return;
        }
        if (this.dataListeners == null) {
            return;
        }
        IRoleService.IMemberOrMasterChangeListener listenerReal = null;
        for (DataUpdateListener item : this.dataListeners) {
            if (item == null || item.listener == null || (listenerReal = (IRoleService.IMemberOrMasterChangeListener)item.listener.get()) != listener2 || !StringUtils.equal((String)groupId, (String)item.groupId)) continue;
            this.dataListeners.remove(item);
            return;
        }
    }

    public void onWsConnect(boolean flag) {
        if (!flag) {
            this.memBerData.hasSynced = false;
        }
    }

    public void onLeaveGroup() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChannelRoleModel.this.callBack != null) {
                    ((ChannelRoleModel)ChannelRoleModel.this).memBerData.hasSynced = false;
                }
            }
        }, (long)1000L);
    }

    private static class DataUpdateListener {
        String groupId;
        WeakReference<IRoleService.IMemberOrMasterChangeListener> listener;

        public DataUpdateListener(String groupId, IRoleService.IMemberOrMasterChangeListener listener2) {
            this.groupId = groupId;
            this.listener = new WeakReference<IRoleService.IMemberOrMasterChangeListener>(listener2);
        }
    }

    public static interface IGroupRoleModelCallBack {
        public boolean hasGroupJoined(String var1);

        public IDataService getDataService();
    }
}

