/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelLeaveResp;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.bean.SameCityInfo;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.rolepermission.IRolePermissionService;
import com.yy.hiyo.channel.base.service.IBaseRoomGameService;
import com.yy.hiyo.channel.base.service.IBottomDynaService;
import com.yy.hiyo.channel.base.service.ICalculatorService;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelBarrageService;
import com.yy.hiyo.channel.base.service.IChannelMemberService;
import com.yy.hiyo.channel.base.service.IChannelTitleBgService;
import com.yy.hiyo.channel.base.service.IConfigService;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IFamilyService;
import com.yy.hiyo.channel.base.service.IGameOperationService;
import com.yy.hiyo.channel.base.service.IGetCrawlerService;
import com.yy.hiyo.channel.base.service.IGroupPlayService;
import com.yy.hiyo.channel.base.service.IInviteService;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.base.service.IOnlineUserSearchService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ITagService;
import com.yy.hiyo.channel.base.service.ITeamUpService;
import com.yy.hiyo.channel.base.service.IVoiceFilterService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.base.service.pluginservice.IChannelPluginService;
import com.yy.hiyo.channel.base.service.pluginservice.IChannelPluginServiceCreator;
import com.yy.hiyo.channel.cbase.context.NotifyDispatcher;
import com.yy.hiyo.channel.cbase.module.ChannelModuleLoader;
import com.yy.hiyo.channel.component.barrage.BarrageService;
import com.yy.hiyo.channel.component.bottombar.v2.BottomDynaService;
import com.yy.hiyo.channel.component.invite.online.search.OnlineUserSearchService;
import com.yy.hiyo.channel.component.publicscreen.MsgService;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.channel.service.IChannelCallBack;
import com.yy.hiyo.channel.service.assistgame.GameOperationService;
import com.yy.hiyo.channel.service.calculator.CalculatorService;
import com.yy.hiyo.channel.service.channelgroup.BaseRoomGameService;
import com.yy.hiyo.channel.service.channelgroup.EmptyRoomGameService;
import com.yy.hiyo.channel.service.channelgroup.GroupPlayService;
import com.yy.hiyo.channel.service.channeltitle.ChannelTitleBgService;
import com.yy.hiyo.channel.service.config.ConfigService;
import com.yy.hiyo.channel.service.crawler.CrawlerService;
import com.yy.hiyo.channel.service.data.DataService;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.family.FamilyService;
import com.yy.hiyo.channel.service.invite.InviteService;
import com.yy.hiyo.channel.service.media.MediaServiceImpl;
import com.yy.hiyo.channel.service.member.ChannelMemberService;
import com.yy.hiyo.channel.service.notify.ChannelNotifyInterceptor;
import com.yy.hiyo.channel.service.notify.IChannelNotifyHandler;
import com.yy.hiyo.channel.service.plugin.PluginService;
import com.yy.hiyo.channel.service.pluginservice.ChannelPluginServiceManager;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import com.yy.hiyo.channel.service.request.join.JoinRequestManager;
import com.yy.hiyo.channel.service.role.RoleService;
import com.yy.hiyo.channel.service.rolepermission.RolePermissionServiceImpl;
import com.yy.hiyo.channel.service.seat.SeatService;
import com.yy.hiyo.channel.service.tag.TagService;
import com.yy.hiyo.channel.service.teamup.TeamUpService;
import com.yy.hiyo.channel.service.voicefilter.VoiceFilterService;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class Channel
implements IChannel,
IChannelNotifyHandler {
    private final String tag;
    private DataService dataService;
    private RoleService roleService;
    private MsgService msgService;
    private ILocalDataModel localDataManager;
    private RolePermissionServiceImpl mRolePermissionService;
    private SeatService mSeatService;
    private MediaServiceImpl mediaService;
    private CalculatorService mCalculatorService;
    private VoiceFilterService mVoiceFilterService;
    private TagService mTagService;
    private FamilyService mFamilyService;
    private CrawlerService mCrawlerService;
    private ChannelMemberService mChannelMemberService;
    private ChannelTitleBgService mChannelTitleBgService;
    private ConfigService mConfigService;
    private BarrageService mBarrageService;
    private GroupPlayService mGroupPlayService;
    private TeamUpService mTeamUpService;
    private InviteService mInviteService;
    private GameOperationService mGameOperationService;
    private IBaseRoomGameService mBaseRoomGameService;
    private OnlineUserSearchService mOnlineUserSearchService;
    private BottomDynaService mDynaService;
    private ChannelRequestManager requestManager;
    private ChannelNotifyInterceptor mNotifyInterceptor;
    private List<BaseService> services = new CopyOnWriteArrayList<BaseService>();
    private PluginService pluginService;
    private HashMap<String, IChannel> subGroups;
    private IChannel parent;
    private String id;
    private boolean joined;
    private IChannelCallBack callBack;
    private NotifyDispatcher notifyDispatcher;
    private EnterParam enterParam;
    private EnterChannelData mEnterChannelData;
    private Environment mEnvironment;
    private int index;
    private ChannelModuleLoader mChannelModuleLoader;
    private ChannelPluginServiceManager mPluginServiceManager;

    public Channel(String groupId, IChannel parent, ILocalDataModel localDataManager, Environment environment) {
        this.tag = "FTRoomGroup" + groupId;
        this.id = groupId;
        this.parent = parent;
        this.localDataManager = localDataManager;
        this.requestManager = new ChannelRequestManager();
        this.notifyDispatcher = new NotifyDispatcher(groupId);
        this.mNotifyInterceptor = new ChannelNotifyInterceptor(this);
        this.services.add(this.mNotifyInterceptor);
        this.mEnvironment = environment;
        this.mPluginServiceManager = new ChannelPluginServiceManager(this);
        this.mChannelModuleLoader = new ChannelModuleLoader((IChannel)this);
        this.getDataService();
        this.getRoleService();
    }

    void setIndex(int index) {
        this.index = index;
    }

    int getIndex() {
        return this.index;
    }

    public void setCallBack(IChannelCallBack callBack) {
        this.callBack = callBack;
    }

    public ChannelModuleLoader getModuleLoader() {
        return this.mChannelModuleLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMsgService getMsgService() {
        if (this.msgService != null) {
            return this.msgService;
        }
        this.msgService = new MsgService(this.callBack.getMsgModel(), this);
        this.msgService.setCallBack(this.callBack);
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            this.services.add(this.msgService);
        }
        return this.msgService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRoleService getRoleService() {
        if (this.roleService != null) {
            return this.roleService;
        }
        this.getDataService();
        this.roleService = new RoleService(this, this.localDataManager);
        this.roleService.setCallBack(this.callBack);
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            this.services.add(1, this.roleService);
        }
        return this.roleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataService getDataService() {
        if (this.dataService != null) {
            return this.dataService;
        }
        this.dataService = new DataService(this, this.localDataManager);
        this.dataService.setCallBack(this.callBack);
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            this.services.add(0, this.dataService);
        }
        return this.dataService;
    }

    public IRolePermissionService getPermissionService() {
        if (this.mRolePermissionService == null) {
            this.mRolePermissionService = new RolePermissionServiceImpl(this);
            this.services.add(this.mRolePermissionService);
        }
        this.mRolePermissionService.setCallBack(this.callBack);
        return this.mRolePermissionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISeatService getSeatService() {
        if (this.mSeatService == null) {
            this.mSeatService = new SeatService(this.getChannelId(), this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mSeatService);
            }
        }
        return this.mSeatService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaService getMediaService() {
        if (this.mediaService != null) {
            return this.mediaService;
        }
        this.getPluginService();
        this.mediaService = new MediaServiceImpl(this, this.localDataManager);
        this.mediaService.setContext((Activity)this.mEnvironment.getActivity());
        this.mediaService.setCallBack(this.callBack);
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            this.services.add(this.mediaService);
        }
        return this.mediaService;
    }

    public ICalculatorService getCalculatorService() {
        if (this.mCalculatorService == null) {
            this.mCalculatorService = new CalculatorService(this);
        }
        return this.mCalculatorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFamilyService getFamilyService() {
        if (this.mFamilyService == null) {
            this.mFamilyService = new FamilyService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mFamilyService);
            }
        }
        return this.mFamilyService;
    }

    public IChannelBarrageService getBarrageService() {
        if (this.mBarrageService == null) {
            this.mBarrageService = new BarrageService(this);
        }
        return this.mBarrageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVoiceFilterService getVoiceFilterService() {
        if (this.mVoiceFilterService == null) {
            this.mVoiceFilterService = new VoiceFilterService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mVoiceFilterService);
            }
        }
        return this.mVoiceFilterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITagService getTagService() {
        if (this.mTagService == null) {
            this.mTagService = new TagService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mTagService);
            }
        }
        return this.mTagService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPluginService getPluginService() {
        if (this.pluginService != null) {
            return this.pluginService;
        }
        this.getDataService();
        this.pluginService = new PluginService(this);
        this.pluginService.setCallBack(this.callBack);
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            this.services.add(this.pluginService);
        }
        return this.pluginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGetCrawlerService getCrawlerService() {
        if (this.mCrawlerService == null) {
            this.mCrawlerService = new CrawlerService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mCrawlerService);
            }
        }
        return this.mCrawlerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChannelMemberService getChannelMemberService() {
        if (this.mChannelMemberService == null) {
            this.mChannelMemberService = new ChannelMemberService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mChannelMemberService);
            }
        }
        return this.mChannelMemberService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConfigService getConfigService() {
        if (this.mConfigService == null) {
            this.mConfigService = new ConfigService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mConfigService);
            }
        }
        return this.mConfigService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGroupPlayService getGroupPlayService() {
        if (this.mGroupPlayService == null) {
            this.mGroupPlayService = new GroupPlayService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mGroupPlayService);
            }
        }
        return this.mGroupPlayService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITeamUpService getTeamUpService() {
        if (this.mTeamUpService == null) {
            this.mTeamUpService = new TeamUpService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mTeamUpService);
            }
        }
        return this.mTeamUpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInviteService getInviteService() {
        if (this.mInviteService == null) {
            this.mInviteService = new InviteService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mInviteService);
            }
        }
        return this.mInviteService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGameOperationService getGameOperationService() {
        if (this.mGameOperationService == null) {
            this.mGameOperationService = new GameOperationService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mGameOperationService);
            }
        }
        return this.mGameOperationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBaseRoomGameService getBaseRoomGameService() {
        if (this.mBaseRoomGameService == null) {
            if (RuntimeContext.isHagoPartySdk()) {
                this.mBaseRoomGameService = new EmptyRoomGameService();
            } else {
                this.mBaseRoomGameService = new BaseRoomGameService(this);
                List<BaseService> list2 = this.services;
                synchronized (list2) {
                    this.services.add((BaseService)this.mBaseRoomGameService);
                }
            }
        }
        return this.mBaseRoomGameService;
    }

    public <T extends IChannelPluginService> void registerPluginServiceCreator(Class<T> cls, IChannelPluginServiceCreator<T> creator) {
        this.mPluginServiceManager.registerPluginServiceCreator(cls, creator);
    }

    public <T extends IChannelPluginService> T getPluginService(Class<T> cls) {
        return this.mPluginServiceManager.getPluginService(cls);
    }

    public IChannel getSubChannel(String subChannelId) {
        IChannel group = null;
        if (this.subGroups == null) {
            this.subGroups = new HashMap();
        } else {
            group = this.subGroups.get(subChannelId);
        }
        if (group != null) {
            return group;
        }
        MLog.info((Object)"Channel", (String)"createChannel parentId:%s, cid: %s", (Object[])new Object[]{this.getChannelId(), subChannelId});
        Channel subGroup = new Channel(subChannelId, this, this.localDataManager, this.mEnvironment);
        subGroup.setCallBack(this.callBack);
        this.subGroups.put(subGroup.getChannelId(), subGroup);
        return subGroup;
    }

    public void join(EnterParam enterParams, IChannel.IJoinCallBack callBack) {
        this.joinChannel(enterParams, callBack, false);
    }

    public void joinBroadcastGroup(EnterParam enterParams, IChannel.IJoinCallBack callBack) {
        this.joinChannel(enterParams, callBack, true);
    }

    private void joinChannel(final EnterParam enterParams, IChannel.IJoinCallBack callBack, boolean broadCast) {
        if (!this.joined) {
            this.onPreJoin(enterParams);
        }
        IChannel.JoinCallBackEx myCallback = new IChannel.JoinCallBackEx(callBack){

            public void onSuccess(EnterParam requestParams, ChannelDetailInfo info, EnterChannelData data2) {
                Channel.this.callBack.updateChannelParent(info.baseInfo.gid, info.baseInfo.pid);
                Channel.this.onJoined(false, info, data2, enterParams);
                Channel.this.joined = true;
                super.onSuccess(requestParams, info, data2);
            }
        };
        if (broadCast) {
            JoinRequestManager.joinBaseBroadcastGroup(enterParams, (IChannel.IJoinCallBack)myCallback);
        } else {
            JoinRequestManager.joinGroup(enterParams, (IChannel.IJoinCallBack)myCallback);
        }
    }

    private void leaveChannel(final @Nullable IChannel.ILeaveCallBack callBack, boolean broadCast) {
        IChannel.ILeaveCallBack myback = new IChannel.ILeaveCallBack(){

            public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                Channel.this.onLeaveRequestFinish();
                if (callBack != null) {
                    callBack.onSuccess(channelId, leaveResp);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                Channel.this.onLeaveRequestFinish();
                if (callBack != null) {
                    callBack.onError(errorCode, errorTips, e);
                }
            }
        };
        this.joined = false;
        String groupId = this.getChannelId();
        this.onLeaved(groupId);
        if (broadCast) {
            JoinRequestManager.leaveBaseBroadcastGroup(groupId, myback);
        } else {
            this.leave(groupId, myback);
        }
    }

    public void leaveBroadcastGroup(IChannel.ILeaveCallBack callBack) {
        this.leaveChannel(callBack, true);
    }

    public void handleJoinSuccess(boolean rejoin2, EnterParam enterParams, ChannelDetailInfo channelDetailInfo, EnterChannelData data2) {
        this.onJoined(rejoin2, channelDetailInfo, data2, enterParams);
        this.joined = true;
    }

    public void leave(@Nullable IChannel.ILeaveCallBack callBack) {
        this.leaveChannel(callBack, false);
    }

    public void leave(final String groupId, final IChannel.ILeaveCallBack callBack) {
        ChannelRequestManager.leaveGroup(groupId, new IChannel.ILeaveCallBack(){

            public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(groupId + ",leaveGroup success!"), (Object[])new Object[0]);
                }
                if (callBack != null) {
                    callBack.onSuccess(channelId, leaveResp);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)"FTRoomGroup", (String)(groupId + ",leave eror, errorCode:%d errorTips:%s!"), (Object[])new Object[]{errorCode, errorTips});
                }
                if (callBack != null) {
                    callBack.onError(errorCode, errorTips, e);
                }
            }
        });
    }

    public void createChannel(CreateChannelParams params, final IChannel.ICreateCallBack callBack) {
        this.requestManager.createSubGroup(this.getParent() != null ? this.getParent().getChannelId() : "", params, new IChannel.ICreateCallBack(){

            public void onSuccess(ChannelDetailInfo subGroupInfo) {
                Channel.this.onSubGroupAdded(subGroupInfo);
                if (Channel.this.subGroups == null) {
                    Channel.this.subGroups = new HashMap();
                }
                MLog.info((Object)"Channel", (String)"createChannel2 parentId:%s, cid: %s", (Object[])new Object[]{Channel.this.getChannelId(), subGroupInfo.baseInfo.gid});
                Channel subGroup = new Channel(subGroupInfo.baseInfo.gid, Channel.this, Channel.this.localDataManager, Channel.this.mEnvironment);
                subGroup.setCallBack(Channel.this.callBack);
                Channel.this.subGroups.put(subGroup.getChannelId(), subGroup);
                if (callBack != null) {
                    callBack.onSuccess(subGroupInfo);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",createChannel Success sub:%s!"), (Object[])new Object[]{subGroupInfo});
                }
            }

            public void onFailByGroupNumLimit(String msgTip) {
                if (callBack != null) {
                    callBack.onFailByGroupNumLimit(msgTip);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",createChannel eror,onFailByGroupNumLimit!"), (Object[])new Object[0]);
                }
            }

            public void onContainSensitiveWord(CreateChannelParams params, String msgTip) {
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",createChannel eror,onContainSensitiveWord!"), (Object[])new Object[0]);
                }
                if (callBack != null) {
                    callBack.onContainSensitiveWord(params, msgTip);
                }
            }

            public void onNoPermission(String msgTip) {
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",createChannel eror,onNoPermission!"), (Object[])new Object[0]);
                }
                if (callBack != null) {
                    callBack.onNoPermission(msgTip);
                }
            }

            public void onNoUseOldVersion(String msgTip) {
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",createChannel eror,onNoUseOldVersion!"), (Object[])new Object[0]);
                }
                if (callBack != null) {
                    callBack.onNoUseOldVersion(msgTip);
                }
            }

            public void onOtherError(String msgTip) {
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",createChannel eror,onOtherError!"), (Object[])new Object[0]);
                }
                if (callBack != null) {
                    callBack.onOtherError(msgTip);
                }
            }

            public void onError(int errorCode, String msgTip, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, msgTip, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",createChannel eror, errorCode:%d errorTips:%s!"), (Object[])new Object[]{errorCode, msgTip});
                }
            }
        });
    }

    public void disbandChannel(String groupId, final IChannel.IDisbandCallBack callBack) {
        if (StringUtils.isEmpty((String)groupId)) {
            if (callBack != null) {
                callBack.onError(groupId, 101, "", new Exception());
            }
            return;
        }
        this.requestManager.disbandSubGroup(groupId, new IChannel.IDisbandCallBack(){

            public void onSuccess(String channelId) {
                if (Channel.this.subGroups != null) {
                    Channel.this.subGroups.remove(channelId);
                }
                Channel.this.onSubGroupDisbanded(channelId, -1L);
                if (callBack != null) {
                    callBack.onSuccess(channelId);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",disbandChannel success:%s!"), (Object[])new Object[]{channelId});
                }
            }

            public void onFailByStillHasOthersIn(String channelId) {
                if (callBack != null) {
                    callBack.onFailByStillHasOthersIn(channelId);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",disbandChannel eror,onFailByStillHasOthersIn!"), (Object[])new Object[0]);
                }
            }

            public void onFailByCannotDeleteTopChannel(String channelId) {
                if (callBack != null) {
                    callBack.onFailByCannotDeleteTopChannel(channelId);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",disbandChannel eror,onFailByCannotDeleteTopChannel!"), (Object[])new Object[0]);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channelId, errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",disbandChannel eror, errorCode:%d errorTips:%s!"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void kickoff(final long uid, final IChannel.IKickOffCallBack callBack) {
        this.requestManager.kickOff(this.getChannelId(), uid, new IChannel.IKickOffCallBack(){

            public void onSuccess(String gid, long uid2, long onlineNum) {
                if (callBack != null) {
                    callBack.onSuccess(gid, uid2, onlineNum);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",kickoff success uid:%s,online:%s!"), (Object[])new Object[]{uid2, String.valueOf(onlineNum)});
                }
                if (onlineNum > 0L) {
                    Channel.this.handleNotifyOnline(Channel.this.getChannelId(), onlineNum);
                }
            }

            public void onNoPermission() {
                if (callBack != null) {
                    callBack.onNoPermission();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + "," + uid + ",kickoff eror, errorCode:%d errorTips:%s!"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void pullBlackThisChannel(IChannel.IPullBackCallBack callBack) {
        this.requestManager.pullBlackThisChannel(this.getChannelId(), callBack);
    }

    @Nullable
    IChannel getParent() {
        ChannelInfo info;
        if (this.parent == null && (info = this.localDataManager.getChannelInfoFromMem(this.id)) != null && !FP.empty((CharSequence)info.getParentId())) {
            this.parent = this.getCenterService().getChannel(info.getParentId());
        }
        return this.parent;
    }

    public String getChannelId() {
        return this.id;
    }

    public String getVCid() {
        if (this.dataService != null && this.dataService.getCacheDetail() != null && this.dataService.getCacheDetail().baseInfo != null) {
            return this.dataService.getCacheDetail().baseInfo.cvid;
        }
        return null;
    }

    public void addNotifyHandler(INotifyDispatchService.INotifyHandler handler) {
        NotifyDispatcher notifyDispatcher = this.getNotifyDispatcher();
        if (notifyDispatcher != null && handler != null) {
            notifyDispatcher.addHandler(handler);
        }
    }

    public void removeNotifyHandler(INotifyDispatchService.INotifyHandler handler) {
        NotifyDispatcher notifyDispatcher = this.getNotifyDispatcher();
        if (notifyDispatcher != null && handler != null) {
            notifyDispatcher.removeHandler(handler);
        }
    }

    @Override
    public void handleNotifyOnline(String channelId, long onlineNum) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> services = group.getServices();
        if (services.size() > 0) {
            for (BaseService service : services) {
                service.handleNotifyOnline(onlineNum);
            }
        }
        group.mPluginServiceManager.handleNotifyOnline(onlineNum);
    }

    @Override
    public void handleNotifyBanned(String channelId, long operUid, boolean banned, long time) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> services = group.getServices();
        if (services.size() > 0) {
            for (BaseService service : services) {
                service.handleNotifyBanned(operUid, banned, time);
            }
        }
        group.mPluginServiceManager.handleNotifyBanned(operUid, banned, time);
    }

    @Override
    public void handleNotifyDisbandChannel(String channelId, NotifyDataDefine.DisbandGroup data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        this.onSubGroupDisbanded(data2.cid, data2.getSignalVer());
    }

    @Override
    public void handleNotifyCreateChannel(String channelId, NotifyDataDefine.CreateGroup data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> services = group.getServices();
        if (services.size() > 0) {
            for (BaseService service : services) {
                service.handleNotifyCreateGroup(data2);
            }
        }
        group.mPluginServiceManager.handleNotifyCreateGroup(data2);
    }

    @Override
    public void handleNotifySetSpeakMode(String channelId, NotifyDataDefine.SetSpeakMode data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> services = group.getServices();
        if (services.size() > 0) {
            for (BaseService service : services) {
                service.handleNotifySetSpeakMode(data2);
            }
        }
        group.mPluginServiceManager.handleNotifySetSpeakMode(data2);
    }

    @Override
    public void handleNotifySetVoiceEnterMode(String channelId, NotifyDataDefine.SetVoiceEnterMode data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> services = group.getServices();
        if (services.size() > 0) {
            for (BaseService service : services) {
                service.handleNotifySetVoiceEnterMode(data2);
            }
        }
        group.mPluginServiceManager.handleNotifySetVoiceEnterMode(data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotifySetGuestSpeakLimit(String channelId, NotifyDataDefine.SetGuestSpeakLimit data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            List<BaseService> services = group.getServices();
            if (services.size() > 0) {
                for (BaseService service : services) {
                    service.handleNotifySetGuestSpeakLimit(data2);
                }
            }
        }
        group.mPluginServiceManager.handleNotifySetGuestSpeakLimit(data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotifySetName(String channelId, NotifyDataDefine.SetName data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            List<BaseService> services = group.getServices();
            if (services.size() > 0) {
                for (BaseService service : services) {
                    service.handleNotifySetName(data2);
                }
            }
        }
        group.mPluginServiceManager.handleNotifySetName(data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotifySetJoinMode(String channelId, NotifyDataDefine.SetJoinMode data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            List<BaseService> services = group.getServices();
            if (services.size() > 0) {
                for (BaseService service : services) {
                    service.handleNotifySetJoinMode(data2);
                }
            }
        }
        group.mPluginServiceManager.handleNotifySetJoinMode(data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotifySetAnnouncement(String channelId, NotifyDataDefine.SetAnnouncement data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            List<BaseService> services = group.getServices();
            if (services.size() > 0) {
                for (BaseService service : services) {
                    service.handleNotifySetAnnouncement(data2);
                }
            }
        }
        group.mPluginServiceManager.handleNotifySetAnnouncement(data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotifySetRole(String channelId, NotifyDataDefine.SetRole data2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            List<BaseService> services = group.getServices();
            if (services.size() > 0) {
                for (BaseService service : services) {
                    service.handleNotifySetRole(data2);
                }
            }
        }
        group.mPluginServiceManager.handleNotifySetRole(data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotifyReceiveMsg(String channelId, String msgId, BaseImMsg msgItem) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            List<BaseService> services = group.getServices();
            if (services.size() > 0) {
                for (BaseService service : services) {
                    service.handleNotifyReceiveMsg(msgId, msgItem);
                }
            }
        }
        group.mPluginServiceManager.handleNotifyReceiveMsg(msgId, msgItem);
    }

    @Override
    public void handleTagUpdates(String channelId, @Nullable List<String> tags) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        String tagId = !FP.empty(tags) ? tags.get(0) : "";
        ChannelDetailInfo info = group.getDataService().getChannelDetailInfo(null);
        if (info != null && info.baseInfo != null && info.baseInfo.tag != null) {
            info.baseInfo.tag.update(new ChannelTagItem(tagId), true, null);
        }
        this.getTagService().onTagUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotify(String channelId, ChannelNotify notify2) {
        Channel group = this.findSubGroup(channelId);
        if (group == null) {
            return;
        }
        if (notify2.uri == ChannelNotify.Uri.UriProbe && StringUtils.equal((String)this.callBack.getJoinedChannel(), (String)this.getChannelId())) {
            this.requestManager.sendProbeRequest(this.getChannelId(), notify2.notify.probeNotify.data);
            return;
        }
        if (notify2.uri == ChannelNotify.Uri.UriLeaveAndReJoinNotify && StringUtils.equal((String)this.callBack.getJoinedChannel(), (String)this.getChannelId())) {
            MLog.info((Object)"FTRoomGroup", (String)(this.getChannelId() + ",UriLeaveAndReJoinNotify!"), (Object[])new Object[0]);
            final Runnable command = new Runnable(){

                @Override
                public void run() {
                    if (!StringUtils.equal((String)Channel.this.callBack.getJoinedChannel(), (String)Channel.this.getChannelId())) {
                        MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",UriLeaveAndReJoinNotify cur channel changed!"), (Object[])new Object[0]);
                        return;
                    }
                    MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",UriLeaveAndReJoinNotify leave and join!"), (Object[])new Object[0]);
                    EnterParam myEnterParam = Channel.this.enterParam;
                    if (myEnterParam == null) {
                        myEnterParam = new EnterParam();
                        myEnterParam.roomId = Channel.this.getChannelId();
                    }
                    JoinRequestManager.joinGroup(myEnterParam, (IChannel.IJoinCallBack)new IChannel.JoinCallBackEx(null){

                        public void onSuccess(EnterParam requestParams, ChannelDetailInfo info, EnterChannelData data2) {
                            Channel.this.onJoined(true, info, data2, requestParams);
                            MLog.info((Object)"FTRoomGroup", (String)(Channel.this.getChannelId() + ",UriLeaveAndReJoinNotify leave and join success!"), (Object[])new Object[0]);
                        }
                    });
                }
            };
            this.leave(this.getChannelId(), new IChannel.ILeaveCallBack(){

                public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                    command.run();
                }

                public void onError(int errorCode, String errorTips, Exception e) {
                    command.run();
                }
            });
            return;
        }
        if (notify2.uri == ChannelNotify.Uri.UriChannelLockNotify) {
            if (this.isValidNotify()) {
                this.handleLockChanged(notify2.notify.channelLock);
            }
        } else if (notify2.uri == ChannelNotify.Uri.UriSwitchLBSNotify) {
            NotifyDataDefine.SwitchLBSNotify switchLBSNotify = notify2.notify.switchLBSNotify;
            ChannelDetailInfo info = group.getDataService().getChannelDetailInfo(null);
            if (info != null) {
                info.baseInfo.isSameCity = switchLBSNotify.isOpen;
                if (switchLBSNotify.isOpen) {
                    String locationTude = switchLBSNotify.longitude + "_" + switchLBSNotify.latitude;
                    info.baseInfo.sameCityInfo = new SameCityInfo(locationTude, "", "", "");
                }
            }
        } else if (notify2.uri == ChannelNotify.Uri.UriGlobalLeaveNotify) {
            this.handleGlobalLeave(channelId, notify2.notify.globalLeaveNotify);
        }
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services != null && this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onNotify(notify2);
                }
            }
        }
        group.mPluginServiceManager.onNotify(notify2);
        group.getNotifyDispatcher().onNotify(notify2);
    }

    private void handleLockChanged(NotifyDataDefine.ChannelLockNotify notify2) {
        this.enterParam.pwdToken = notify2.pwdToken;
        this.enterParam.setExtra("IS_ENTER_BY_PWD", (Object)notify2.lock);
    }

    private void handleGlobalLeave(@NonNull String channelId, NotifyDataDefine.GlobalLeaveNotify notify2) {
        boolean isOwner = this.getDataService().getCacheDetail() != null && this.getDataService().getCacheDetail().baseInfo.ownerUid == AccountUtil.getUid();
        boolean isForceQuit = !isOwner && notify2.isForceQuit(notify2.pluginMode, notify2.pluginId);
        MLog.info((Object)"FTRoomGroup", (String)"handleGlobalLeave \u9000\u623f, cid %s, isOwner %s, notify %s, forceQuit: %s", (Object[])new Object[]{channelId, isOwner, notify2, isForceQuit});
        if (isForceQuit) {
            this.dataService.isSameRegion(AccountUtil.getUid(), (Callback<Boolean>)((Callback)isSame -> {
                MLog.info((Object)"FTRoomGroup", (String)"handleGlobalLeave \u9000\u623f, %s, isSameRegion\uff1a %s", (Object[])new Object[]{channelId, isSame});
                if (!Boolean.TRUE.equals(isSame)) {
                    ((IRoomService)ServiceManagerProxy.getService(IRoomService.class)).exitRoom(channelId);
                    ToastUtils.showToast((Context)this.mEnvironment.getContext(), (int)R.string.short_tips_gloabal_force_leave, (int)0);
                }
            }));
        }
    }

    public final NotifyDispatcher getNotifyDispatcher() {
        return this.notifyDispatcher;
    }

    public EnterParam getEnterParam() {
        return this.enterParam;
    }

    public EnterChannelData getEnterChannelData() {
        return this.mEnterChannelData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChannelTitleBgService getChannelTitleBgService() {
        if (this.mChannelTitleBgService == null) {
            this.mChannelTitleBgService = new ChannelTitleBgService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mChannelTitleBgService);
            }
        }
        return this.mChannelTitleBgService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOnlineUserSearchService getOnlineUserSearchService() {
        if (this.mOnlineUserSearchService == null) {
            this.mOnlineUserSearchService = new OnlineUserSearchService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mOnlineUserSearchService);
            }
        }
        return this.mOnlineUserSearchService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBottomDynaService getDynaService() {
        if (this.mDynaService == null) {
            this.mDynaService = new BottomDynaService(this);
            List<BaseService> list2 = this.services;
            synchronized (list2) {
                this.services.add(this.mDynaService);
            }
        }
        return this.mDynaService;
    }

    Channel findSubGroup(String id2) {
        if (StringUtils.equal((String)id2, (String)this.getChannelId())) {
            return this;
        }
        if (this.subGroups == null) {
            return null;
        }
        IChannel group = this.subGroups.get(id2);
        return group != null ? (Channel)group : null;
    }

    void addSubGroup(Channel channel) {
        IChannel group;
        if (channel == null) {
            return;
        }
        if (this.subGroups == null) {
            this.subGroups = new HashMap();
        }
        if ((group = this.subGroups.get(channel.getChannelId())) != null) {
            if (group != channel) {
                this.removeSubGroup(group);
                this.subGroups.put(channel.getChannelId(), channel);
            }
        } else {
            this.subGroups.put(channel.getChannelId(), channel);
        }
    }

    void removeSubGroup(IChannel channel) {
        if (channel == null) {
            return;
        }
        if (this.subGroups == null) {
            return;
        }
        this.subGroups.remove(channel);
        IChannel group = this.subGroups.get(channel.getChannelId());
        if (group != null) {
            this.subGroups.remove(group);
        }
    }

    private List<BaseService> getServices() {
        return this.services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSubGroupAdded(ChannelDetailInfo subGroupInfo) {
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onSubGroupAdded(subGroupInfo);
                }
            }
        }
        this.mPluginServiceManager.onSubGroupAdded(subGroupInfo);
        if (this.callBack != null && subGroupInfo != null) {
            this.callBack.getMyJoinedChannels().onChannelAdd(subGroupInfo.baseInfo.gid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSubGroupDisbanded(String groupId, long ver) {
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onSubGroupDisbanded(groupId, ver);
                }
            }
        }
        this.mPluginServiceManager.onSubGroupDisbanded(groupId, ver);
        if (this.callBack != null) {
            this.callBack.getMyJoinedChannels().handleNotifyDisbandChannel(groupId, new NotifyDataDefine.DisbandGroup());
            YYTaskExecutor.execute(() -> {
                this.callBack.getChannelPermissionModel().updateCanCreateGroup(false);
                this.callBack.getFamilyGroupPermitModel().groupChanged();
            }, (long)2000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onJoined(boolean rejoin2, ChannelDetailInfo info, EnterChannelData data2, EnterParam enterParam) {
        MLog.debug((Object)"Channel", (String)"onJoined enterParam:%s, cid:%s", (Object[])new Object[]{enterParam, info != null ? info.baseInfo.getChannelId() : ""});
        this.enterParam = enterParam;
        this.mEnterChannelData = data2;
        this.getDataService();
        this.getRoleService();
        this.getMsgService();
        ISeatService seatService2 = this.getSeatService();
        seatService2.clearSeatData();
        this.getPluginService();
        this.getMediaService();
        this.getVoiceFilterService();
        this.getTagService();
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onJoined(rejoin2, info, data2);
                }
            }
        }
        this.mChannelModuleLoader.onChannelJoined(rejoin2, info, data2, enterParam);
        this.mPluginServiceManager.onJoined(rejoin2, info, data2);
        if (!RuntimeContext.isHagoPartySdk()) {
            MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.ON_CHANNEL_JOIN_SUCCESS);
            int pluginMode = 0;
            if (data2 != null && data2.pluginData != null) {
                pluginMode = data2.pluginData.mode;
            }
            MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.ON_CHANNEL_JOIN_SUCCESS, pluginMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreJoin(EnterParam enterParam) {
        MLog.debug((Object)"Channel", (String)("onPreJoin enterParam=" + enterParam), (Object[])new Object[0]);
        this.enterParam = enterParam;
        this.getMediaService();
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onPreJoin(enterParam);
                }
            }
        }
        this.mChannelModuleLoader.onChannelPreJoin(enterParam);
        this.mPluginServiceManager.onPreJoin(enterParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLeaved(String groupId) {
        this.mChannelModuleLoader.onChannelLeaved(groupId);
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onLeaved();
                }
            }
        }
        this.mPluginServiceManager.onLeaved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaveRequestFinish() {
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onLeaveRequestFinished();
                }
            }
        }
        this.mPluginServiceManager.onLeaveRequestFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.joined) {
            this.leave(null);
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("no call leave!");
            }
        }
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onDestroy();
                }
            }
        }
        this.mPluginServiceManager.onDestroy();
        if (this.subGroups != null) {
            Set<String> keys = this.subGroups.keySet();
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    IChannel group = this.subGroups.get(key);
                    if (group == null) continue;
                    group.leave(null);
                    ((Channel)group).destroy();
                }
            }
            this.subGroups.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWsConnect(boolean flag) {
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onWsConnect(flag);
                }
            }
        }
        this.mPluginServiceManager.onWsConnect(flag);
    }

    public Activity getContext() {
        return this.mEnvironment.getActivity();
    }

    private boolean isValidNotify() {
        return this.callBack != null && StringUtils.equal((String)this.callBack.getJoinedChannel(), (String)this.getChannelId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFamilyMemberShow(String gid, NotifyDataDefine.FamilyShowNotify data2) {
        List<BaseService> list2 = this.services;
        synchronized (list2) {
            if (this.services.size() > 0) {
                for (BaseService service : this.services) {
                    service.onFamilyMemberShow(gid, data2);
                }
            }
        }
        this.mPluginServiceManager.onFamilyMemberShow(gid, data2);
    }
}

