/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.search;

import android.content.Context;
import androidx.lifecycle.MutableLiveData;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.config.GroupChatClassificationData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.module.search.ChannelSearchVM;
import com.yy.hiyo.channel.module.search.data.ChannelSearchResult;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.location.LocationInfo;
import common.Page;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ihago.channel.srv.csearch.ChannelResult;
import net.ihago.channel.srv.csearch.EFilterType;
import net.ihago.channel.srv.csearch.SearchChannelReq;
import net.ihago.channel.srv.csearch.SearchChannelRes;
import net.ihago.room.api.rrec.ECategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bJ\u0006\u0010\u001f\u001a\u00020\u0006J\u0006\u0010 \u001a\u00020\u0006J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\bJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\bJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\bJ\u0006\u0010$\u001a\u00020\u0016J\u0006\u0010%\u001a\u00020\u001cJ\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0018H\u0002J(\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/yy/hiyo/channel/module/search/ChannelSearchVM;", "", "filterType", "Lnet/ihago/channel/srv/csearch/EFilterType;", "(Lnet/ihago/channel/srv/csearch/EFilterType;)V", "TAG", "", "channelBeanLiveData", "Landroidx/lifecycle/MutableLiveData;", "", "Lcom/yy/hiyo/channel/module/search/data/ChannelSearchResult;", "curSearchContent", "getFilterType", "()Lnet/ihago/channel/srv/csearch/EFilterType;", "loadMoreContent", "locationInfo", "Lcom/yy/location/LocationInfo;", "getLocationInfo", "()Lcom/yy/location/LocationInfo;", "locationInfo$delegate", "Lkotlin/Lazy;", "mPage", "Lcommon/Page;", "netErrorStatusLiveData", "", "noMoreLiveData", "noSearchResultLiveData", "fetchSearchChannelData", "", "searchContent", "getChannelBeanLiveData", "getCurSearchContent", "getLoadMoreSearchContent", "getNetErrorStateData", "getNoMoreData", "getNoSearchResultData", "getPageData", "loadMoreSearchData", "requestChannelSearchData", "isLoadMore", "requestChannelSearchFromServer", "page", "channel-components_debug"})
public final class ChannelSearchVM {
    private final String TAG = "ChannelSearchVM";
    private final Lazy locationInfo$delegate;
    private Page mPage;
    private String curSearchContent;
    private String loadMoreContent;
    private final MutableLiveData<Boolean> netErrorStatusLiveData;
    private final MutableLiveData<Boolean> noSearchResultLiveData;
    private final MutableLiveData<Boolean> noMoreLiveData;
    private final MutableLiveData<List<ChannelSearchResult>> channelBeanLiveData;
    @NotNull
    private final EFilterType filterType;

    private final LocationInfo getLocationInfo() {
        Lazy lazy = this.locationInfo$delegate;
        ChannelSearchVM channelSearchVM = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LocationInfo)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<List<ChannelSearchResult>> getChannelBeanLiveData() {
        return this.channelBeanLiveData;
    }

    @NotNull
    public final MutableLiveData<Boolean> getNetErrorStateData() {
        return this.netErrorStatusLiveData;
    }

    @NotNull
    public final MutableLiveData<Boolean> getNoSearchResultData() {
        return this.noSearchResultLiveData;
    }

    @NotNull
    public final MutableLiveData<Boolean> getNoMoreData() {
        return this.noMoreLiveData;
    }

    @NotNull
    public final String getCurSearchContent() {
        return this.curSearchContent;
    }

    @NotNull
    public final String getLoadMoreSearchContent() {
        return this.loadMoreContent;
    }

    @NotNull
    public final Page getPageData() {
        return this.mPage;
    }

    public final void fetchSearchChannelData(@NotNull String searchContent) {
        Intrinsics.checkParameterIsNotNull((Object)searchContent, (String)"searchContent");
        Page page = new Page.Builder().offset(Long.valueOf(-1L)).limit(Long.valueOf(-1L)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"Page.Builder().offset(-1).limit(-1).build()");
        this.mPage = page;
        this.curSearchContent = searchContent;
        this.requestChannelSearchData(searchContent, false);
    }

    public final void loadMoreSearchData() {
        this.loadMoreContent = this.curSearchContent;
        this.requestChannelSearchData(this.loadMoreContent, true);
    }

    private final void requestChannelSearchData(String searchContent, boolean isLoadMore) {
        if (!isLoadMore && !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.netErrorStatusLiveData.setValue((Object)true);
            return;
        }
        if (isLoadMore) {
            long l = this.mPage.offset;
            Long l2 = this.mPage.total;
            Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"mPage.total");
            if (l >= l2) {
                this.noMoreLiveData.setValue((Object)true);
                return;
            }
        }
        this.requestChannelSearchFromServer(searchContent, this.mPage, this.filterType, isLoadMore);
    }

    private final void requestChannelSearchFromServer(String searchContent, Page page, EFilterType filterType, boolean isLoadMore) {
        String string2 = searchContent;
        SearchChannelReq.Builder builder = new SearchChannelReq.Builder();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        SearchChannelReq.Builder req = builder.keyword(string4).page(page).filter_type(Integer.valueOf(filterType.getValue()));
        LocationInfo locationInfo2 = this.getLocationInfo();
        if (locationInfo2 != null) {
            string2 = locationInfo2;
            bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"it");
            req.latitude = string5.getLatitude();
            req.longitude = it.getLongitude();
        }
        ProtoManager.getInstance().sendRpc((AndroidMessage)req.build(), (IProtoCallback)new IProtoCallback<SearchChannelRes>(this, searchContent, isLoadMore){
            final /* synthetic */ ChannelSearchVM this$0;
            final /* synthetic */ String $searchContent;
            final /* synthetic */ boolean $isLoadMore;

            public void onResponse(@NotNull SearchChannelRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (Intrinsics.areEqual((Object)this.$searchContent, (Object)ChannelSearchVM.access$getCurSearchContent$p(this.this$0)) ^ true) {
                        return;
                    }
                    SearchChannelRes searchChannelRes = message;
                    boolean bl = false;
                    boolean bl2 = false;
                    SearchChannelRes message2 = searchChannelRes;
                    boolean bl3 = false;
                    Page page = message2.page;
                    Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"message.page");
                    ChannelSearchVM.access$setMPage$p(this.this$0, page);
                    boolean bl4 = false;
                    List resultList = new ArrayList<E>();
                    List list2 = message2.channels;
                    if (list2 != null) {
                        List list3 = list2;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        List it = list3;
                        boolean bl7 = false;
                        Iterable $this$forEach$iv = it;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ChannelResult data2 = (ChannelResult)element$iv;
                            boolean bl8 = false;
                            String string2 = data2.cid;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.cid");
                            String string3 = data2.vcid;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.vcid");
                            String string4 = data2.avatar;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"data.avatar");
                            String string5 = data2.name;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"data.name");
                            Integer n = data2.onlines;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"data.onlines");
                            int n2 = n;
                            Boolean bl9 = data2.joined;
                            Intrinsics.checkExpressionValueIsNotNull((Object)bl9, (String)"data.joined");
                            boolean bl10 = bl9;
                            Long l = data2.dist;
                            Integer n3 = data2.dist > 0L ? Integer.valueOf(ECategory.ESameCity.getValue()) : null;
                            String string6 = data2.channel_avatar;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"data.channel_avatar");
                            long l2 = data2.top_onlines.intValue();
                            Integer n4 = data2.version;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"data.version");
                            int n5 = n4;
                            Integer n6 = data2.role_limit;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n6, (String)"data.role_limit");
                            int n7 = n6;
                            Integer n8 = data2.role_count;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n8, (String)"data.role_count");
                            ChannelSearchResult channelSearchData = new ChannelSearchResult(string2, string3, string4, string5, n2, bl10, l, n3, string6, l2, n5, n7, n8, null, 8192, null);
                            int tagId = 0;
                            Integer n9 = data2.first_type;
                            if (n9 == null || n9 != 0) {
                                Integer n10 = data2.first_type;
                                Intrinsics.checkExpressionValueIsNotNull((Object)n10, (String)"data.first_type");
                                tagId = n10;
                            } else {
                                Integer n11 = data2.second_type;
                                if (n11 == null || n11 != 0) {
                                    Integer n12 = data2.second_type;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)n12, (String)"data.second_type");
                                    tagId = n12;
                                }
                            }
                            GroupChatClassificationData groupData = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getGroupCategoryFromCache(tagId);
                            channelSearchData.setClassificationData(groupData);
                            resultList.add(channelSearchData);
                        }
                    }
                    ChannelSearchVM.access$getChannelBeanLiveData$p(this.this$0).setValue((Object)resultList);
                    if (!this.$isLoadMore && resultList.isEmpty()) {
                        ChannelSearchVM.access$getNoSearchResultLiveData$p(this.this$0).setValue((Object)true);
                    }
                } else {
                    MutableLiveData mutableLiveData = ChannelSearchVM.access$getChannelBeanLiveData$p(this.this$0);
                    boolean bl = false;
                    List list4 = new ArrayList<E>();
                    mutableLiveData.postValue((Object)list4);
                    if (!this.$isLoadMore) {
                        ChannelSearchVM.access$getNetErrorStatusLiveData$p(this.this$0).postValue((Object)true);
                    }
                    MLog.info((Object)ChannelSearchVM.access$getTAG$p(this.this$0), (String)("requestChannelSearch failed, code: " + code), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.info((Object)ChannelSearchVM.access$getTAG$p(this.this$0), (String)("requestChannelSearch retryWhenError, code: " + code + " reason: " + reason), (Object[])new Object[0]);
                MutableLiveData mutableLiveData = ChannelSearchVM.access$getChannelBeanLiveData$p(this.this$0);
                boolean bl = false;
                List list2 = new ArrayList<E>();
                mutableLiveData.postValue((Object)list2);
                if (!this.$isLoadMore) {
                    ChannelSearchVM.access$getNetErrorStatusLiveData$p(this.this$0).postValue((Object)true);
                }
                return false;
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)ChannelSearchVM.access$getTAG$p(this.this$0), (String)"requestChannelSearch retryWhenTimeout", (Object[])new Object[0]);
                MutableLiveData mutableLiveData = ChannelSearchVM.access$getChannelBeanLiveData$p(this.this$0);
                boolean bl = false;
                List list2 = new ArrayList<E>();
                mutableLiveData.postValue((Object)list2);
                if (!this.$isLoadMore) {
                    ChannelSearchVM.access$getNetErrorStatusLiveData$p(this.this$0).postValue((Object)true);
                }
                return false;
            }
            {
                this.this$0 = $outer;
                this.$searchContent = $captured_local_variable$1;
                this.$isLoadMore = $captured_local_variable$2;
            }
        });
    }

    @NotNull
    public final EFilterType getFilterType() {
        return this.filterType;
    }

    public ChannelSearchVM(@NotNull EFilterType filterType) {
        Intrinsics.checkParameterIsNotNull((Object)filterType, (String)"filterType");
        this.filterType = filterType;
        this.TAG = "ChannelSearchVM";
        this.locationInfo$delegate = LazyKt.lazy((Function0)locationInfo.2.INSTANCE);
        Page page = new Page.Builder().offset(Long.valueOf(-1L)).limit(Long.valueOf(-1L)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"Page.Builder().offset(-1).limit(-1).build()");
        this.mPage = page;
        this.curSearchContent = "";
        this.loadMoreContent = "";
        this.netErrorStatusLiveData = new MutableLiveData();
        this.noSearchResultLiveData = new MutableLiveData();
        this.noMoreLiveData = new MutableLiveData();
        this.channelBeanLiveData = new MutableLiveData();
    }

    public static final /* synthetic */ String access$getCurSearchContent$p(ChannelSearchVM $this) {
        return $this.curSearchContent;
    }

    public static final /* synthetic */ void access$setCurSearchContent$p(ChannelSearchVM $this, String string2) {
        $this.curSearchContent = string2;
    }

    public static final /* synthetic */ Page access$getMPage$p(ChannelSearchVM $this) {
        return $this.mPage;
    }

    public static final /* synthetic */ void access$setMPage$p(ChannelSearchVM $this, Page page) {
        $this.mPage = page;
    }

    public static final /* synthetic */ MutableLiveData access$getChannelBeanLiveData$p(ChannelSearchVM $this) {
        return $this.channelBeanLiveData;
    }

    public static final /* synthetic */ MutableLiveData access$getNoSearchResultLiveData$p(ChannelSearchVM $this) {
        return $this.noSearchResultLiveData;
    }

    public static final /* synthetic */ MutableLiveData access$getNetErrorStatusLiveData$p(ChannelSearchVM $this) {
        return $this.netErrorStatusLiveData;
    }

    public static final /* synthetic */ String access$getTAG$p(ChannelSearchVM $this) {
        return $this.TAG;
    }
}

