/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.roomrecordpage.historyrecord.model;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.VoiceRoomHistoryDbBean;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.module.roomrecordpage.historyrecord.bean.DateTitleBean;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ihago.channel.srv.mgr.GetHistoryChannelReq;
import net.ihago.channel.srv.mgr.GetHistoryChannelRes;
import net.ihago.channel.srv.mgr.HistoryChannel;

public class RoomHistoryRepository {
    private static final String TAG = "VoiceRoomHistoryRepository";
    private final IServiceManager mServiceManager;
    private final Map<String, Long> mDbRoomsMap = new ConcurrentHashMap<String, Long>();
    private final IDBService mDbService;

    public RoomHistoryRepository(IServiceManager iServiceManager) {
        this.mServiceManager = iServiceManager;
        this.mDbService = (IDBService)this.mServiceManager.getService(IDBService.class);
    }

    public void getHistoryRoom(DataCallback<List<Object>> callBack) {
        FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryRepositorygetHistoryRoomDbDataStart", (Object[])new Object[0]);
        this.getLocalVoiceRoomHistory((DataCallback<List<String>>)((DataCallback)data2 -> {
            if (data2.size() > 0) {
                this.getHistoryRoomInner(callBack, (List<String>)data2);
            } else {
                callBack.onResult(Collections.emptyList());
            }
        }));
    }

    public void getHistoryRoomInner(DataCallback<List<Object>> callBack, List<String> roomIds) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            callBack.onResult(null);
            return;
        }
        FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryRepositorygetHistoryRoomServerDataRequestStart" + roomIds.size()), (Object[])new Object[0]);
        this.requestChannelHistory(callBack, roomIds);
    }

    private void requestChannelHistory(final DataCallback<List<Object>> callBack, List<String> roomIds) {
        final long startTime = SystemClock.uptimeMillis();
        GetHistoryChannelReq getHistoryChannelReq = new GetHistoryChannelReq.Builder().cids(roomIds).ret_top_onlines(Boolean.valueOf(true)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getHistoryChannelReq, (IProtoCallback)new SimpleProtoCallback<GetHistoryChannelRes>(){

            public void onResponse(@NonNull GetHistoryChannelRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                    if (message != null) {
                        List mHisRooms = message.history_channels;
                        if (mHisRooms != null && mHisRooms.size() > 0) {
                            FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryRepository getHistoryRoomServerDataRequestResult" + mHisRooms.size()), (Object[])new Object[0]);
                            List<Object> totalDatas = RoomHistoryRepository.this.addChannelDate(mHisRooms);
                            FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryRepository getHistoryRoomServerDataRequestResult" + totalDatas.size()), (Object[])new Object[0]);
                            if (totalDatas.size() > 0) {
                                callBack.onResult(totalDatas);
                            } else {
                                callBack.onResult(Collections.emptyList());
                            }
                        } else {
                            callBack.onResult(Collections.emptyList());
                        }
                    } else {
                        callBack.onResult(null);
                    }
                } else {
                    callBack.onResult(null);
                    BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                YYTaskExecutor.postToMainThread(() -> callBack.onResult(null));
                return super.retryWhenTimeout(canRetry);
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                YYTaskExecutor.postToMainThread(() -> callBack.onResult(null));
                return super.retryWhenError(canRetry, reason, code);
            }
        });
    }

    public void updateLocalVoiceRoomHistory(String roomId) {
        FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryRepositoryupdateLocalVoiceRoomHistory " + roomId), (Object[])new Object[0]);
        MyBox box = this.mDbService.boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null != box) {
            VoiceRoomHistoryDbBean bean2 = new VoiceRoomHistoryDbBean(roomId, System.currentTimeMillis());
            box.updateItem((BaseDBBean)bean2, true);
        }
    }

    public void deleteLocalVoiceRoomHistory(String roomId) {
        FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryRepositorydeleteLocalVoiceRoomHistory " + roomId), (Object[])new Object[0]);
        MyBox box = this.mDbService.boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null != box) {
            VoiceRoomHistoryDbBean bean2 = new VoiceRoomHistoryDbBean(roomId, System.currentTimeMillis());
            box.deleteItem((BaseDBBean)bean2);
        }
    }

    public void getRoomRecordCount(DataCallback<Integer> callBack) {
        MyBox box = this.mDbService.boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null == box) {
            callBack.onResult((Object)0);
            return;
        }
        box.getAll(datas -> callBack.onResult((Object)datas.size()));
    }

    public void getLocalVoiceRoomHistory(final DataCallback<List<String>> callBack) {
        final ArrayList roomIds = new ArrayList();
        MyBox box = this.mDbService.boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null == box) {
            callBack.onResult(roomIds);
            return;
        }
        box.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<VoiceRoomHistoryDbBean>(){

            public void onLoaded(ArrayList<VoiceRoomHistoryDbBean> datas) {
                Collections.sort(datas);
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryRepositorygetHistoryRoomDbDataResult" + datas.size()), (Object[])new Object[0]);
                ArrayList data1 = RoomHistoryRepository.this.handeMax(datas);
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryRepositorygetHistoryRoomDbDataResultMax" + data1.size()), (Object[])new Object[0]);
                ArrayList data2 = RoomHistoryRepository.this.handleServenData(data1);
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryRepositorygetHistoryRoomDbDataSeven" + data2.size()), (Object[])new Object[0]);
                if (data2.size() > 0) {
                    for (int i = 0; i < data2.size(); ++i) {
                        VoiceRoomHistoryDbBean bean2 = (VoiceRoomHistoryDbBean)data2.get(i);
                        String roomId = bean2.getRoomId();
                        roomIds.add(roomId);
                        RoomHistoryRepository.this.mDbRoomsMap.put(roomId, bean2.getTimestamp());
                    }
                }
                callBack.onResult((Object)roomIds);
            }
        });
    }

    public void deleteLocalVoiceRoomHistory() {
        MyBox box = ((IDBService)this.mServiceManager.getService(IDBService.class)).boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null != box) {
            box.deleteAll();
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelNotifyDef.CLEAR_ROOM_RECORD));
        }
    }

    public void clearData() {
        this.mDbRoomsMap.clear();
    }

    public List<Object> addChannelDate(List<HistoryChannel> data1) {
        ArrayList<Object> data2 = new ArrayList<Object>();
        String roomId = data1.get((int)0).cid;
        long time = this.mDbRoomsMap.get(roomId);
        data2.add(this.getDateBean(time));
        Date currentDate = new Date(time);
        for (int i = 0; i < data1.size(); ++i) {
            HistoryChannel item = data1.get(i);
            long itemTime = this.mDbRoomsMap.get(item.cid);
            if (this.isSameDay(currentDate, new Date(itemTime))) {
                data2.add(item);
                continue;
            }
            DateTitleBean dateBean = this.getDateBean(itemTime);
            data2.add(dateBean);
            data2.add(item);
            currentDate = new Date(itemTime);
        }
        DateTitleBean dateBean = new DateTitleBean();
        data2.add(dateBean);
        return data2;
    }

    private boolean isSameDay(Date one, Date two) {
        SimpleDateFormat simpleDateFormat;
        if (one == null && two == null) {
            return true;
        }
        return one != null && two != null && (simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd")).format(one).equals(simpleDateFormat.format(two));
    }

    private DateTitleBean getDateBean(long time) {
        String strDate = "";
        strDate = DateUtils.isToday((Calendar)Calendar.getInstance(), (long)time) ? ResourceUtils.getString((int)R.string.short_summary_today) : (this.isYesterday(Calendar.getInstance(), time) ? ResourceUtils.getString((int)R.string.short_summary_yestoday) : (DateUtils.isThisYear((Calendar)Calendar.getInstance(), (long)time) ? this.timeStampToDate(time, "dd/MM") : this.timeStampToDate(time, "dd-MM-yyyy")));
        DateTitleBean showBean = new DateTitleBean();
        showBean.setDate(strDate);
        return showBean;
    }

    private boolean isYesterday(Calendar cal, long timestamp) {
        Calendar c = cal;
        this.clearCalendar(c, 11, 12, 13, 14);
        c.add(5, -1);
        long firstOfDay = c.getTimeInMillis();
        c.setTimeInMillis(timestamp);
        this.clearCalendar(c, 11, 12, 13, 14);
        return firstOfDay == c.getTimeInMillis();
    }

    private void clearCalendar(Calendar c, int ... fields) {
        for (int f : fields) {
            c.set(f, 0);
        }
    }

    public String timeStampToDate(long time, String format) {
        if (format == null || format.isEmpty()) {
            format = "yyyy-MM-dd";
        }
        return new SimpleDateFormat(format).format(new Date(time));
    }

    private ArrayList<VoiceRoomHistoryDbBean> handeMax(ArrayList<VoiceRoomHistoryDbBean> datas) {
        if (datas.size() > 100) {
            ArrayList<VoiceRoomHistoryDbBean> newDatas = new ArrayList<VoiceRoomHistoryDbBean>();
            for (int i = 0; i < 100; ++i) {
                VoiceRoomHistoryDbBean dbBean = datas.get(i);
                newDatas.add(dbBean);
            }
            return newDatas;
        }
        return datas;
    }

    private ArrayList<VoiceRoomHistoryDbBean> handleServenData(ArrayList<VoiceRoomHistoryDbBean> datas) {
        ArrayList<VoiceRoomHistoryDbBean> newDatas = new ArrayList<VoiceRoomHistoryDbBean>();
        for (int i = 0; i < datas.size(); ++i) {
            VoiceRoomHistoryDbBean bean2 = datas.get(i);
            boolean isSeven = this.isSevenInner(bean2.getTimestamp());
            if (!isSeven) continue;
            newDatas.add(bean2);
        }
        return newDatas;
    }

    private boolean isSevenInner(long time) {
        long current = System.currentTimeMillis();
        int sub = (int)((current - time) / 86400000L);
        return sub < 7;
    }
}

