/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.roomrecordpage.historyrecord.model;

import android.content.Context;
import android.os.Message;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.roomrecordpage.historyrecord.model.RoomHistoryRepository;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import java.util.Collections;
import java.util.List;
import net.ihago.channel.srv.mgr.HistoryChannel;

public class HistoryRoomRecordModel {
    private static final String TAG = "VoiceRoomHistoryModel";
    private MutableLiveData<List<Object>> mHistoryList;
    private final RoomHistoryRepository mModel;
    private final IMvpContext mMvpContext;
    private DialogLinkManager mDialogLinkManager;

    public HistoryRoomRecordModel(IMvpContext mvpContext) {
        this.mMvpContext = mvpContext;
        this.mModel = new RoomHistoryRepository(ServiceManagerProxy.getServiceManager());
    }

    public LiveData<List<Object>> getVoiceRoomHistory() {
        if (this.mHistoryList == null) {
            this.mHistoryList = new MutableLiveData();
        }
        return this.mHistoryList;
    }

    public void showDeleteDialog() {
        FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryModelshow delete dialog", (Object[])new Object[0]);
        RoomTrack.INSTANCE.onVoiceRoomHistoryListDeleteClick();
        String strTitle = ResourceUtils.getString((int)R.string.title_voice_room_history_delete);
        String strCancel = ResourceUtils.getString((int)R.string.btn_voice_room_history_cancel);
        String strOK = ResourceUtils.getString((int)R.string.btn_voice_room_history_sure);
        OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)strTitle, (CharSequence)strOK, (CharSequence)strCancel, true, true, new OkCancelDialogListener(){

            public void onCancel() {
                RoomTrack.INSTANCE.onVoiceRoomHistoryListDeleteCancel();
                FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryModeldelete cancel", (Object[])new Object[0]);
            }

            public void onOk() {
                RoomTrack.INSTANCE.onVoiceRoomHistoryListDeleteSure();
                FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryModeldelete ok", (Object[])new Object[0]);
                HistoryRoomRecordModel.this.mModel.deleteLocalVoiceRoomHistory();
                HistoryRoomRecordModel.this.mHistoryList.setValue(Collections.emptyList());
            }
        });
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager((Context)this.getMvpContext());
        }
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
        RoomTrack.INSTANCE.onVoiceRoomHistoryListDeleteDialogShow();
    }

    public void requestVoiceHistoryRecord() {
        this.mModel.getHistoryRoom(new DataCallback<List<Object>>(){

            public void onResult(List<Object> data2) {
                if (HistoryRoomRecordModel.this.mHistoryList == null) {
                    return;
                }
                HistoryRoomRecordModel.this.mHistoryList.setValue(data2);
            }
        });
    }

    public void onItemClick(HistoryChannel channel) {
        if (channel != null && channel.plugin_info != null) {
            this.enterVoiceRoom(channel.cid, channel.plugin_info.type);
        } else {
            this.enterVoiceRoom(channel.cid, -1);
        }
    }

    public void enterVoiceRoom(String roomId, int pluginType) {
        EnterParam enterParam = EnterParam.obtain((String)roomId, (int)9, (String)"");
        enterParam.entryInfo = new EntryInfo(FirstEntType.HISTORY, null, null);
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        message.obj = enterParam;
        enterParam.setExtra("pluginType", (Object)pluginType);
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public void gotoProfile(long uid) {
        ProfileReportBean reportBean = new ProfileReportBean();
        reportBean.setUid(Long.valueOf(uid));
        reportBean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getHistoryRecordPage()));
        reportBean.setSource(27);
        MsgDispatcher.getInstance().sendMessage(UserMsgDef.OPEN_WINDOW_NEW_PROFILE, -1, -1, (Object)reportBean);
    }

    public void clearData() {
        this.mHistoryList = null;
        this.mModel.clearData();
    }

    private FragmentActivity getMvpContext() {
        return (FragmentActivity)this.mMvpContext.getContext();
    }
}

