/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.notice;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.callback.IChannelNotifyListener;
import com.yy.hiyo.channel.module.notice.ChannelMessageCreator;
import com.yy.hiyo.im.base.ChannelNoticeMessage;
import java.util.ArrayList;
import java.util.List;

public class ChannelNoticeReceiver {
    private List<String> mMsgIdList = new ArrayList<String>();
    private IChannelNotifyListener mNotifyListener = new IChannelNotifyListener(){

        public void handleNotify(String channelId, ChannelNotify notify2) {
            if (notify2.uri == ChannelNotify.Uri.UriJoinApplyNotify) {
                FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:joinApply, time:%s, msgId:%s, cname:%s", (Object[])new Object[]{notify2.notify.joinApply.getTime(), notify2.notify.joinApply.getMsgId(), notify2.notify.joinApply.getCname()});
                NotifyDataDefine.JoinApply joinApply = notify2.notify.joinApply;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createJoinApplyMsg(joinApply);
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                channelNoticeMessage.setExtObj((Object)joinApply);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriJoinApproveNotify) {
                FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:joinApprove", (Object[])new Object[0]);
                NotifyDataDefine.JoinApprove joinApprove = notify2.notify.joinApprove;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createJoinApproveMsg(joinApprove);
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                channelNoticeMessage.setExtObj((Object)joinApprove);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriSetRoleNotify) {
                FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:setRole:%s\uff0c %s", (Object[])new Object[]{notify2.notify.setRole.toString(), notify2.notify.toString()});
                NotifyDataDefine.SetRole setRole2 = notify2.notify.setRole;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createSetRoleMsg(setRole2);
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriUserRoleChangeNotify) {
                FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:userRoleChange:%s\uff0c %s", (Object[])new Object[]{notify2.notify.userRoleChange.toString(), notify2.notify.toString()});
                NotifyDataDefine.UserRoleChange userRoleChange = notify2.notify.userRoleChange;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createUserRoleChangeMsg(userRoleChange);
                if (userRoleChange.roleType == 1 && userRoleChange.uid == AccountUtil.getUid()) {
                    ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(notify2.cid);
                }
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriAcceptRoleNotify) {
                FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:acceptRole:%s\uff0c %s", (Object[])new Object[]{notify2.notify.acceptRole.toString(), notify2.notify.toString()});
                NotifyDataDefine.AcceptRole acceptRole = notify2.notify.acceptRole;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createAcceptRoleMsg(acceptRole);
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriDisbandChannel) {
                FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:disband:%s\uff0c %s", (Object[])new Object[]{notify2.notify.disbandGroup.toString(), notify2.notify.toString()});
                NotifyDataDefine.DisbandGroup disbandGroup = notify2.notify.disbandGroup;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createDisbandChannelMsg(disbandGroup);
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_DISBAND_MSG, (Object)notify2.cid));
            } else if (notify2.uri == ChannelNotify.Uri.UriChannelInviteApprove) {
                FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:inviteApprove:%s,  %s", (Object[])new Object[]{notify2.notify.inviteApprove.toString(), notify2.notify.toString()});
                NotifyDataDefine.InviteApprove inviteApprove = notify2.notify.inviteApprove;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createInviteApproveMsg(inviteApprove);
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriChannelInviteApproveStatus) {
                FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:inviteApproveStatus:%s,  %s", (Object[])new Object[]{notify2.notify.inviteApproveStatus.toString(), notify2.notify.toString()});
                NotifyDataDefine.InviteApproveStatus inviteApproveStatus = notify2.notify.inviteApproveStatus;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createInviteApproveStatusMsg(inviteApproveStatus);
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            }
        }
    };

    public void register() {
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).addNotifyListener(this.mNotifyListener);
    }

    public void unRegister() {
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).removeNotifyListener(this.mNotifyListener);
    }

    private boolean canMsgShow(ChannelNoticeMessage msg) {
        return !FP.eq((Object)"hago.game", (Object)msg.getChannelSource());
    }

    private void checkMsgValid(ChannelNoticeMessage channelNoticeMessage) {
        if (channelNoticeMessage == null) {
            return;
        }
        if (this.mMsgIdList.contains(channelNoticeMessage.getMsgId())) {
            FeatureLog.d((String)"FTChannelNotice", (String)"checkMsgValid:%s", (Object[])new Object[]{channelNoticeMessage.getMsgId()});
            channelNoticeMessage.setExtCounts(-1);
        } else {
            channelNoticeMessage.setExtCounts(0);
            this.mMsgIdList.add(channelNoticeMessage.getMsgId());
        }
    }
}

