/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.mycreated.ui;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.ViewPager;

public class ZoomOutSlideTransformer
implements ViewPager.PageTransformer {
    private static final float MIN_SCALE = 0.8f;
    private static final float MIN_ALPHA = 0.5f;

    public void transformPage(@NonNull View view2, float position) {
        if (position >= -1.0f || position <= 1.0f) {
            float height = view2.getHeight();
            float width = view2.getWidth();
            float scaleFactor = Math.max(0.8f, 1.0f - Math.abs(position));
            float vertMargin = height * (1.0f - scaleFactor) / 2.0f;
            float horzMargin = width * (1.0f - scaleFactor) / 2.0f;
            view2.setPivotY(0.5f * height);
            view2.setPivotX(0.5f * width);
            if (position < 0.0f) {
                view2.setTranslationX(horzMargin - vertMargin / 2.0f);
            } else {
                view2.setTranslationX(-horzMargin + vertMargin / 2.0f);
            }
            view2.setScaleX(scaleFactor);
            view2.setScaleY(scaleFactor);
            view2.setAlpha(0.5f + (scaleFactor - 0.8f) / 0.19999999f * 0.5f);
        }
    }
}

