/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.mini;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.extension.ViewExtensionKt;
import com.yy.appbase.extlayer.IExtViewService;
import com.yy.appbase.extlayer.IHagoFloatView;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.room.INoRoomMiniWindow;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.SeatData;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.bean.video.LiveVideoStreamInfo;
import com.yy.hiyo.channel.base.callback.IChannelMiniListener;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.base.utils.ChannelCoverUtils;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.cbase.module.ktv.base.IActsWebWindow;
import com.yy.hiyo.channel.cbase.module.ktv.base.IKTVScanLocalMusicWindow;
import com.yy.hiyo.channel.cbase.module.ktv.base.IKTVSearchWindow;
import com.yy.hiyo.channel.cbase.module.ktv.base.IKTVUploadMusicWindow;
import com.yy.hiyo.channel.cbase.module.radio.RadioNotifyDef;
import com.yy.hiyo.channel.cbase.module.radio.live.IRadioPlayPresenter;
import com.yy.hiyo.channel.cbase.module.radio.live.IRadioPlayView;
import com.yy.hiyo.channel.cbase.module.radio.live.VideoStreamCallback;
import com.yy.hiyo.channel.component.music.addmusic.AddMusicWindow;
import com.yy.hiyo.channel.component.music.playlist.PlaylistWindow;
import com.yy.hiyo.channel.component.music.searchmusic.SearchMusicWindow;
import com.yy.hiyo.channel.module.main.ChannelWindow;
import com.yy.hiyo.channel.module.mini.ChannelMiniManager;
import com.yy.hiyo.channel.module.mini.MiniCloseListener;
import com.yy.hiyo.channel.module.mini.MiniMvp;
import com.yy.hiyo.channel.module.mini.MiniView;
import com.yy.hiyo.channel.module.mini.MiniViewNew;
import com.yy.hiyo.channel.module.mini.SizeLocation;
import com.yy.hiyo.channel.module.recommend.base.bean.MiniInfo;
import com.yy.hiyo.mixmodule.base.minilist.IMiniListCallBack;
import com.yy.hiyo.mixmodule.base.minilist.IMiniListService;
import com.yy.hiyo.multivideo.MultiVideoMiniViewBean;
import com.yy.hiyo.multivideo.MultiVideoNotifyDef;
import com.yy.hiyo.voice.base.bean.VideoPositionWrapper;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.OnVideoLayoutChangeListener;
import com.yy.webservice.webwindow.IWebUi;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChannelMiniController
extends DefaultController
implements MiniMvp.IPresenter,
INotify,
ISeatUpdateListener,
IPluginService.IPluginDataChangedCallBack {
    private static final String TAG = "FTVoice ChannelMiniController";
    private MiniView mRoomMiniView;
    private MiniViewNew mMiniViewNew;
    private IHagoFloatView mIFloatView;
    private CircleImageView mMiniNewImg;
    private AbstractWindowManager mWindowManager;
    private static final int MAX_LEFT = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext) - ResolutionUtils.dip2Px((float)98.0f);
    private static final int MULTI_VIDEO_MAX_LEFT = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext) - ResolutionUtils.dip2Px((float)118.0f);
    private static final int MAX_TOP = ResolutionUtils.getScreenHeight((Context)RuntimeContext.sApplicationContext) - ResolutionUtils.dip2Px((float)220.0f) - SystemUtils.getStatusBarHeight((Context)RuntimeContext.sApplicationContext);
    private static SizeLocation mViewLocation = new SizeLocation(MAX_LEFT, MAX_TOP, ResourceUtils.getDimen((int)R.dimen.channel_mini_video_width), ResourceUtils.getDimen((int)R.dimen.channel_mini_video_height));
    private DefaultWindow.IGlobalWindowMonitor mWindowMonitor;
    private MiniInfo mMiniInfo;
    private MiniCloseListener mMiniCloseListeners = null;
    private IRadioPlayPresenter mIRadioPlayPresenter;
    private IRadioPlayView mRadioPlayView;
    private ChannelMiniManager mChannelMiniManager;
    private boolean lastLandscape = false;
    private FrameLayout mMultiVideoOriginalParent;
    private FrameLayout mMultiVideoView;
    private int mMultiVideoViewIndex = -1;
    private FrameLayout mMultiVideoMicOriginalParent;
    private FrameLayout mMultiVideoMicView;
    private int mMultiVideoMicViewIndex = -1;
    private int mLinkMicType = 0;
    private IPluginService.IPluginDataChangedCallBack mPluginDataChangedCallBack = new IPluginService.IPluginDataChangedCallBack(){

        public void onVideoModeChanged(String channelId, boolean isVideoMode) {
            ChannelMiniController.this.handleVideoChanged(isVideoMode);
        }
    };
    private VideoStreamCallback mVideoStreamCallback = new VideoStreamCallback(){

        public void onVideoStart(long anchorId, int width, int height, boolean isCdn) {
            boolean isLandscape = ChannelMiniController.this.mIRadioPlayPresenter != null && ChannelMiniController.this.mIRadioPlayPresenter.isLinkMicTwoSourceVideoMode() ? true : width > height;
            YYTaskExecutor.postToMainThread(() -> ChannelMiniController.this.adjustViewSize(isLandscape));
        }

        public void videoStreamOpen(long anchorId, LiveVideoStreamInfo streamInfo) {
            ChannelMiniController.this.handleVideoStreamOpen(anchorId);
        }

        public void videoStreamClose(long anchorId) {
            if (YYTaskExecutor.isMainThread()) {
                ChannelMiniController.this.showNormalView();
            } else {
                YYTaskExecutor.postToMainThread(() -> ChannelMiniController.this.showNormalView());
            }
        }

        public void onVideoSizeChange(long anchorId, int width, int height, int rotation) {
            boolean isLandscape;
            boolean bl = isLandscape = width > height;
            if (ChannelMiniController.this.mIRadioPlayPresenter != null && ChannelMiniController.this.mRoomMiniView != null) {
                if (ChannelMiniController.this.mIRadioPlayPresenter.isLinkMicTwoSourceVideoMode()) {
                    ChannelMiniController.this.mRoomMiniView.setVideoRatio((float)ChannelMiniController.this.mIRadioPlayPresenter.getCurrentStreanWidth() * 2.0f / (float)ChannelMiniController.this.mIRadioPlayPresenter.getCurrentStreamHeight());
                } else {
                    ChannelMiniController.this.mRoomMiniView.setVideoRatio((float)ChannelMiniController.this.mIRadioPlayPresenter.getCurrentStreanWidth() * 1.0f / (float)ChannelMiniController.this.mIRadioPlayPresenter.getCurrentStreamHeight());
                }
            }
            if (ChannelMiniController.this.mIRadioPlayPresenter != null && ChannelMiniController.this.mIRadioPlayPresenter.isLinkMicTwoSourceVideoMode()) {
                return;
            }
            YYTaskExecutor.postToMainThread(() -> ChannelMiniController.this.adjustViewSize(isLandscape));
        }
    };
    private OnVideoLayoutChangeListener mVideoLayoutChangeListener = new OnVideoLayoutChangeListener(){

        public void onVideoLayoutChange(@NotNull List<VideoPositionWrapper> layoutInfo) {
            if (null != ChannelMiniController.this.mRoomMiniView) {
                ChannelMiniController.this.mRoomMiniView.updateMultiVideoSeat(layoutInfo);
                IKtvLiveServiceExtend liveService = (IKtvLiveServiceExtend)ChannelMiniController.this.getServiceManager().getService(IKtvLiveServiceExtend.class);
                if (null != liveService) {
                    liveService.updateMultiVideoMini((FrameLayout)ChannelMiniController.this.mRoomMiniView.getMultiVideoContainer(), true);
                }
            }
        }
    };

    private void handleVideoStreamOpen(long anchorId) {
        if (YYTaskExecutor.isMainThread()) {
            this.showVideoView();
        } else {
            YYTaskExecutor.postToMainThread(() -> this.showVideoView());
        }
    }

    public ChannelMiniController(Environment env) {
        super(env);
        MLog.info((Object)TAG, (String)"ChannelMiniController init", (Object[])new Object[0]);
        this.setWindowManager(this.getEnvironment().getWindowManager());
        this.addWindowMonitor();
        this.registerMessage(ChannelMsgDef.CHANGE_ACT_WEB_MODE);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(RadioNotifyDef.RADIO_PASS_PLAY_MANAGER, (INotify)this);
        NotificationCenter.getGlobalInstance().register(RadioNotifyDef.RADIO_PASS_PLAY_VIEW, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_WEB_WINDOW_INSTANT_CLOSE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(MultiVideoNotifyDef.INSTANCE.getMULTIVIDEO_JOIN_ROOM(), (INotify)this);
        NotificationCenter.getGlobalInstance().register(MultiVideoNotifyDef.INSTANCE.getMULTIVIDEO_LEAVE_ROOM(), (INotify)this);
    }

    @Override
    public void showMiniUi() {
        if (this.mMiniInfo == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"showMiniUi mRoomMiniView %s, cid: %s", (Object[])new Object[]{this.mRoomMiniView, this.mMiniInfo.getChannelId()});
        this.setMinimize(true);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED, (Object)this.mMiniInfo));
        if (this.mRoomMiniView == null) {
            this.mRoomMiniView = new MiniView(RuntimeContext.sApplicationContext);
            this.mIFloatView = new IHagoFloatView(){

                public void onReAttachWindow() {
                    ChannelMiniController.this.resumeAnim();
                }

                public void hideView() {
                    ChannelMiniController.this.mRoomMiniView.clickClose();
                }

                public View getFloatView() {
                    return ChannelMiniController.this.mRoomMiniView;
                }
            };
            this.mRoomMiniView.setPresenter(this);
            this.mRoomMiniView.setRoomId(this.mMiniInfo.getChannelId());
            if (this.mMiniInfo != null) {
                IChannel channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.mMiniInfo.getChannelId());
                if (channel.getRoleService().isMeAnchor()) {
                    this.mRoomMiniView.setLocation(ChannelMiniController.mViewLocation.x, ChannelMiniController.mViewLocation.y);
                    ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addFloatContent(this.mIFloatView);
                    this.showNormalView();
                } else if (channel.getPluginService().getCurPluginData().getMode() == 15) {
                    Object result;
                    if (null == this.mMultiVideoView && (result = this.sendMessageSync(ChannelBaseMsgDef.MULTIVIDEO_MINI_SHOW_GET_VIDEO_VIEW)) instanceof MultiVideoMiniViewBean) {
                        MultiVideoMiniViewBean bean2 = (MultiVideoMiniViewBean)result;
                        this.mMultiVideoView = bean2.getVideoContainer();
                        this.mMultiVideoMicView = bean2.getVideoMicContainer();
                    }
                    if (null != this.mMultiVideoView) {
                        this.mRoomMiniView.setLocation(Math.min(ChannelMiniController.mViewLocation.x, MULTI_VIDEO_MAX_LEFT), ChannelMiniController.mViewLocation.y);
                        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addFloatContent(this.mIFloatView);
                        this.showMultiVideoView();
                    } else {
                        this.mRoomMiniView.setLocation(ChannelMiniController.mViewLocation.x, ChannelMiniController.mViewLocation.y);
                        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addFloatContent(this.mIFloatView);
                        this.showNormalView();
                    }
                } else {
                    this.mRoomMiniView.setLocation(ChannelMiniController.mViewLocation.x, ChannelMiniController.mViewLocation.y);
                    ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addFloatContent(this.mIFloatView);
                    channel.getPluginService().addPluginDataListener(this.mPluginDataChangedCallBack);
                    this.handleVideoChanged(channel.getPluginService().getCurPluginData().isVideoMode());
                }
            } else {
                this.mRoomMiniView.setLocation(ChannelMiniController.mViewLocation.x, ChannelMiniController.mViewLocation.y);
                ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addFloatContent(this.mIFloatView);
                this.showNormalView();
            }
        } else {
            MLog.warn((Object)TAG, (String)"showMiniUi \u6700\u5c0f\u5316\u5df2\u663e\u793a, \u4e0d\u91cd\u590d\u6267\u884c", (Object[])new Object[0]);
        }
    }

    @Override
    public void showNewMiniUi() {
        if (this.mMiniInfo == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"showMiniUi showNewMiniUi", (Object[])new Object[0]);
        this.setMinimize(true);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED, (Object)this.mMiniInfo));
        if (this.mMiniViewNew == null) {
            this.mMiniViewNew = new MiniViewNew(this.mContext, this, this.mMiniInfo.getChannelId());
            this.mMiniNewImg = new CircleImageView(this.mContext);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(DpToPxDef.RESOLUTION_40_DP, DpToPxDef.RESOLUTION_40_DP);
            this.mMiniNewImg.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mMiniNewImg.setBorderColor(ResourceUtils.getColor((int)R.color.white));
            this.mMiniNewImg.setBorderWidth(ResolutionUtils.dip2Px((float)2.0f));
            ((IMiniListService)this.getServiceManager().getService(IMiniListService.class)).addView(9, new IMiniListCallBack(){

                public void onHidden() {
                    ChannelMiniController.this.showMiniUi();
                    if (ChannelMiniController.this.mRoomMiniView != null) {
                        ChannelMiniController.this.mRoomMiniView.startAnim();
                        ChannelMiniController.this.mRoomMiniView.setVisibility(0);
                    }
                }

                public void onShow() {
                    if (ChannelMiniController.this.mRoomMiniView != null) {
                        ChannelMiniController.this.mRoomMiniView.stopAnim();
                        ChannelMiniController.this.mRoomMiniView.setVisibility(8);
                    }
                }

                public void onForceClose() {
                    ChannelMiniController.this.realRemoveOldView();
                    ChannelMiniController.this.mMiniViewNew = null;
                    ChannelMiniController.this.mMiniNewImg = null;
                }

                @NotNull
                public View getMiniView() {
                    return ChannelMiniController.this.mMiniNewImg;
                }

                @NotNull
                public View getFloatView() {
                    return ChannelMiniController.this.mMiniViewNew;
                }
            });
            IChannel channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.mMiniInfo.getChannelId());
            this.updateChannelView(channel);
            if (channel.getPluginService().getCurPluginData().mode != 1) {
                this.updateRoomView();
            }
        } else {
            MLog.warn((Object)TAG, (String)"showMiniUi \u6700\u5c0f\u5316\u5df2\u663e\u793a, \u4e0d\u91cd\u590d\u6267\u884c", (Object[])new Object[0]);
        }
    }

    private void adjustViewSize(boolean isLandscape) {
        if (this.lastLandscape == isLandscape) {
            return;
        }
        this.lastLandscape = isLandscape;
        this.showVideoView();
    }

    private void registerLinkMicTypeChangedListener() {
        if (this.mIRadioPlayPresenter == null) {
            return;
        }
        this.mIRadioPlayPresenter.setOnLinkMicTypeChangedListener((isVideoMode, type) -> {
            if (!isVideoMode) {
                this.mLinkMicType = type;
                return;
            }
            if (this.mLinkMicType != type) {
                this.mLinkMicType = type;
                if (this.mWindowManager != null && this.mWindowManager.getCurrentWindow() instanceof ChannelWindow) {
                    return;
                }
                this.handleVideoChanged(true);
            }
        });
    }

    private void handleVideoChanged(boolean videoMode) {
        if (videoMode) {
            if (this.mIRadioPlayPresenter != null && this.mRadioPlayView != null && this.mRoomMiniView != null) {
                this.lastLandscape = this.mIRadioPlayPresenter.isLandscape();
                this.mIRadioPlayPresenter.setVideoStreamCallback(this.mVideoStreamCallback);
                this.mIRadioPlayPresenter.setMode(2);
                View playView = this.mRadioPlayView.getPlayView();
                if (this.mIRadioPlayPresenter.isLoopMicRoomAndNoLiving()) {
                    if (YYTaskExecutor.isMainThread()) {
                        this.showNormalView();
                    } else {
                        YYTaskExecutor.postToMainThread(() -> this.showNormalView());
                    }
                } else {
                    this.handleVideoStreamOpen(this.mMiniInfo == null ? 0L : this.mMiniInfo.getChannelShowUser());
                }
                ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
                this.mLinkMicType = this.mIRadioPlayPresenter.getLinkMicType();
                if (this.mIRadioPlayPresenter.isLinkMicTwoSourceVideoMode()) {
                    ViewExtensionKt.removeSelfFromParent((View)playView);
                    View otherLiveContainer = this.mRadioPlayView.getOtherLiveContainer(this.mIRadioPlayPresenter.isLinkMicAudience(), true);
                    ViewExtensionKt.removeSelfFromParent((View)otherLiveContainer);
                    YYLinearLayout ly = new YYLinearLayout((Context)this.mRadioPlayView.getActivity());
                    LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -1);
                    layoutParams.weight = 1.0f;
                    ly.addView(playView, (ViewGroup.LayoutParams)layoutParams);
                    LinearLayout.LayoutParams layoutParams1 = new LinearLayout.LayoutParams(0, -1);
                    layoutParams1.weight = 1.0f;
                    ly.addView(otherLiveContainer, (ViewGroup.LayoutParams)layoutParams1);
                    this.adjustViewSize(true);
                    this.mRoomMiniView.getVideoContainer().addView((View)ly, lp);
                    MLog.info((Object)TAG, (String)"add link mic mini view", (Object[])new Object[0]);
                } else if (playView.getParent() != null) {
                    ViewExtensionKt.removeSelfFromParent((View)playView);
                    this.mRoomMiniView.getVideoContainer().addView(playView, lp);
                    this.mRoomMiniView.setVideoRatio((float)this.mIRadioPlayPresenter.getCurrentStreanWidth() * 1.0f / (float)this.mIRadioPlayPresenter.getCurrentStreamHeight());
                    this.mIRadioPlayPresenter.reusePlay(this.mRadioPlayView.getPlayView());
                    MLog.info((Object)TAG, (String)"add radio mini view", (Object[])new Object[0]);
                }
            }
        } else {
            this.showNormalView();
        }
    }

    private void showMultiVideoView() {
        if (null != this.mRoomMiniView && null != this.mMultiVideoView) {
            IKtvLiveServiceExtend liveService;
            this.mRoomMiniView.setMiniViewType(4);
            this.mRoomMiniView.post(() -> {
                if (this.mRoomMiniView != null) {
                    this.mRoomMiniView.adjustmentLocation();
                }
            });
            float ratio = (float)this.mMultiVideoView.getWidth() * 1.0f / (float)this.mMultiVideoView.getHeight();
            int showWidth = ResolutionUtils.dip2Px((float)82.0f);
            int showHeight = ratio <= 0.0f ? ResolutionUtils.dip2Px((float)114.0f) : (int)((float)showWidth / ratio);
            if (null != this.mMultiVideoView.getParent() && this.mMultiVideoView.getParent() instanceof ViewGroup) {
                this.mMultiVideoOriginalParent = (FrameLayout)this.mMultiVideoView.getParent();
                this.mMultiVideoViewIndex = ((ViewGroup)this.mMultiVideoView.getParent()).indexOfChild((View)this.mMultiVideoView);
                ((ViewGroup)this.mMultiVideoView.getParent()).removeView((View)this.mMultiVideoView);
            }
            ConstraintLayout.LayoutParams rootLp = (ConstraintLayout.LayoutParams)this.mRoomMiniView.getMultiVideoContainer().getLayoutParams();
            rootLp.width = showWidth;
            rootLp.height = showHeight;
            this.mRoomMiniView.getMultiVideoContainer().setLayoutParams((ViewGroup.LayoutParams)rootLp);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
            this.mRoomMiniView.getMultiVideoContainer().addView((View)this.mMultiVideoView, lp);
            if (null != this.mMultiVideoMicView) {
                if (null != this.mMultiVideoMicView.getParent() && this.mMultiVideoMicView.getParent() instanceof ViewGroup) {
                    this.mMultiVideoMicOriginalParent = (FrameLayout)this.mMultiVideoMicView.getParent();
                    this.mMultiVideoMicViewIndex = ((ViewGroup)this.mMultiVideoMicView.getParent()).indexOfChild((View)this.mMultiVideoMicView);
                    ((ViewGroup)this.mMultiVideoMicView.getParent()).removeView((View)this.mMultiVideoMicView);
                }
                this.mRoomMiniView.getMultiVideoContainer().addView((View)this.mMultiVideoMicView, lp);
            }
            if (null != (liveService = (IKtvLiveServiceExtend)this.getServiceManager().getService(IKtvLiveServiceExtend.class))) {
                liveService.registerMultiVideoLayoutChangeListener(this.mVideoLayoutChangeListener, true);
                liveService.updateMultiVideoMini((FrameLayout)this.mRoomMiniView.getMultiVideoContainer(), true);
            }
        }
    }

    private void showVideoView() {
        if (null != this.mRoomMiniView) {
            if (this.lastLandscape) {
                this.mRoomMiniView.setMiniViewType(3);
            } else {
                this.mRoomMiniView.setMiniViewType(2);
            }
        }
    }

    private void showNormalView() {
        if (null != this.mRoomMiniView && this.mMiniInfo != null) {
            IChannel channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.mMiniInfo.getChannelId());
            MLog.info((Object)TAG, (String)"showNormalView cid: %s, channel: %s", (Object[])new Object[]{this.mMiniInfo.getChannelId(), channel});
            if (null != channel) {
                if (channel.getPluginService().getCurPluginData().mode == 1) {
                    this.mRoomMiniView.setMiniViewType(1);
                    this.mRoomMiniView.post(() -> {
                        if (this.mRoomMiniView != null) {
                            this.mRoomMiniView.adjustmentLocation();
                        }
                    });
                    this.updateChannelView(channel);
                } else {
                    this.mRoomMiniView.setMiniViewType(0);
                    this.updateRoomView();
                    this.mRoomMiniView.post(() -> {
                        if (this.mRoomMiniView != null) {
                            this.mRoomMiniView.adjustmentLocation();
                            this.mRoomMiniView.startAnim();
                        }
                    });
                }
            }
        }
    }

    private void updateChannelView(final IChannel channel) {
        MLog.info((Object)TAG, (String)"updateChannelView", (Object[])new Object[0]);
        channel.getDataService().fetchChannelDetailInfo(new IDataService.IGetDetailInfoCallBack(){

            public void onSuccess(String channelId, ChannelDetailInfo info) {
                MLog.info((Object)ChannelMiniController.TAG, (String)"updateChannelView fetchChannelDetailInfo success", (Object[])new Object[0]);
                if (channel.getPluginService().getCurPluginData().mode == 1) {
                    if (ChannelMiniController.this.mMiniNewImg != null) {
                        ChannelCoverUtils.INSTANCE.showChannelCover(info.baseInfo.version, info.baseInfo.avatar, info.baseInfo.ownerUid, (RecycleImageView)ChannelMiniController.this.mMiniNewImg);
                    }
                    if (ChannelMiniController.this.mMiniViewNew != null) {
                        ChannelMiniController.this.mMiniViewNew.setChannelCover(info);
                        ChannelMiniController.this.mMiniViewNew.setChannelInfo(info.baseInfo);
                    }
                    if (ChannelMiniController.this.mRoomMiniView != null) {
                        ChannelMiniController.this.mRoomMiniView.setChannelCover(info.baseInfo.avatar, info.baseInfo.version, info.baseInfo.ownerUid);
                    }
                } else if (ChannelMiniController.this.mMiniViewNew != null) {
                    ChannelMiniController.this.mMiniViewNew.setChannelInfo(info.baseInfo);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
            }
        });
    }

    private void updateRoomView() {
        MLog.info((Object)TAG, (String)"updateRoomView", (Object[])new Object[0]);
        if (null == this.mMiniInfo) {
            return;
        }
        IChannel channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.mMiniInfo.getChannelId());
        ChannelDetailInfo channelDetailInfo = channel.getDataService().getCacheDetail();
        if (channelDetailInfo != null && "hago.amongus".equals(channelDetailInfo.baseInfo.source)) {
            if (this.mRoomMiniView != null) {
                this.mRoomMiniView.setAvatarLocal(R.drawable.icon_among_us_robot);
            }
            return;
        }
        final long owner = this.mMiniInfo.getChannelShowUser();
        IUserInfoService service = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        UserInfoKS userInfo = service.getUserInfo(owner);
        this.updateAvatar(owner, userInfo);
        service.requestUserInfoFromServer(owner, new OnKSProfileListCallback(){

            public void onUISuccess(@NonNull List<UserInfoKS> userInfos) {
                if (ChannelMiniController.this.mMiniInfo != null && ChannelMiniController.this.mMiniInfo.getChannelShowUser() == owner && !userInfos.isEmpty()) {
                    ChannelMiniController.this.updateAvatar(owner, userInfos.get(0));
                }
            }

            public void onError(@NonNull String reason, long code) {
            }
        });
    }

    private void updateAvatar(long owner, UserInfoKS userInfo) {
        if (userInfo != null) {
            if (this.mMiniViewNew != null && this.mMiniNewImg != null) {
                this.mMiniViewNew.setAvatar(userInfo.avatar, owner);
                ImageLoader.loadImage((ImageView)this.mMiniNewImg, (String)(userInfo.avatar + YYImageUtils.getThumbnailPostfix((int)75)));
            }
            if (this.mRoomMiniView != null) {
                this.mRoomMiniView.setAvatar(userInfo.avatar, owner);
            }
        }
    }

    @Override
    public void hideMiniUi() {
        if (this.mMiniInfo == null) {
            return;
        }
        this.removeNewMiniView();
        this.removeOldMiniView();
        this.checkMultiVideoViewAttachOriginParent();
    }

    private void removeNewMiniView() {
        MLog.info((Object)TAG, (String)"hideMiniUi", (Object[])new Object[0]);
        if (this.mMiniInfo.isMinimized() && this.mMiniViewNew != null) {
            ((IMiniListService)this.getServiceManager().getService(IMiniListService.class)).removeView(9);
            this.mMiniViewNew = null;
            this.mMiniNewImg = null;
        }
    }

    private void removeOldMiniView() {
        MLog.info((Object)TAG, (String)"hideMiniUi", (Object[])new Object[0]);
        if (this.mMiniInfo.isMinimized()) {
            this.setMinimize(false);
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED, (Object)this.mMiniInfo));
            this.realRemoveOldView();
        }
    }

    private void setMinimize(boolean isMinimize) {
        this.mMiniInfo.setMinimized(isMinimize);
        this.getChannelMiniManager().setIsMini(isMinimize);
    }

    private void realRemoveOldView() {
        if (this.mIRadioPlayPresenter != null) {
            this.mIRadioPlayPresenter.unregisterVideoStreamCallback(this.mVideoStreamCallback);
        }
        if (this.mRoomMiniView != null) {
            this.mRoomMiniView.stopAnim();
            if (this.mIFloatView != null) {
                ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).removeFloatContent(this.mIFloatView);
            }
            this.mRoomMiniView = null;
        }
        ((IKtvLiveServiceExtend)this.getServiceManager().getService(IKtvLiveServiceExtend.class)).unRegisterMultiVideoLayoutChangeListener(this.mVideoLayoutChangeListener);
        IChannel channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.mMiniInfo.getChannelId());
        channel.getPluginService().removePluginDataListener(this.mPluginDataChangedCallBack);
    }

    @Override
    public void exitRoom() {
        this.getChannelMiniManager().showMiniExitChannelDialog(new IChannelMiniListener(){

            public void onClickExitChannel(boolean exit, boolean afterShowDialog) {
                if (exit) {
                    if (ChannelMiniController.this.mMiniCloseListeners == null) {
                        ChannelMiniController.this.realExitRoom();
                    } else {
                        ChannelMiniController.this.mMiniCloseListeners.notifyMiniClose();
                    }
                }
            }
        }, null, null == this.mMiniInfo ? "" : this.mMiniInfo.getChannelId());
    }

    private void realExitRoom() {
        if (this.mMiniInfo == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"exitRoom", (Object[])new Object[0]);
        Bundle bundle = new Bundle();
        bundle.putInt("channel_exit_type", 1);
        Message msg = new Message();
        msg.what = AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL;
        msg.arg1 = -1;
        msg.arg2 = -1;
        msg.obj = this.mMiniInfo.getChannelId();
        msg.setData(bundle);
        this.sendMessage(msg);
        this.mMiniCloseListeners = null;
        this.releaseRadio();
    }

    private void releaseRadio() {
        this.mRadioPlayView = null;
        if (this.mIRadioPlayPresenter != null) {
            this.mIRadioPlayPresenter.unregisterVideoStreamCallback(this.mVideoStreamCallback);
        }
        this.mIRadioPlayPresenter = null;
        this.lastLandscape = false;
        this.mLinkMicType = 0;
    }

    private void releaseMultiVideo() {
        this.mMultiVideoOriginalParent = null;
        this.mMultiVideoView = null;
        this.mMultiVideoMicOriginalParent = null;
        this.mMultiVideoMicView = null;
    }

    @Override
    public void enterRoom() {
        if (this.mMiniInfo == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"enterRoom", (Object[])new Object[0]);
        Message msg = new Message();
        msg.what = AppbaseMsgDef.ChannelMsgDef.RESUME_CUR_CHANNEL;
        msg.arg1 = -1;
        msg.arg2 = -1;
        msg.obj = this.mMiniInfo.getChannelId();
        Context context = this.mRoomMiniView.getContext();
        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).msgJump(msg, context);
    }

    private void checkMultiVideoViewAttachOriginParent() {
        ViewGroup.LayoutParams lp;
        if (null != this.mMultiVideoMicView && null != this.mMultiVideoMicOriginalParent) {
            if (null != this.mMultiVideoMicView.getParent() && this.mMultiVideoMicView.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.mMultiVideoMicView.getParent()).removeView((View)this.mMultiVideoMicView);
            }
            lp = new ViewGroup.LayoutParams(-1, -1);
            if (-1 != this.mMultiVideoMicViewIndex) {
                this.mMultiVideoMicOriginalParent.addView((View)this.mMultiVideoMicView, this.mMultiVideoMicViewIndex, lp);
            } else {
                this.mMultiVideoMicOriginalParent.addView((View)this.mMultiVideoMicView, lp);
            }
        }
        if (null != this.mMultiVideoView && null != this.mMultiVideoOriginalParent) {
            if (null != this.mMultiVideoView.getParent() && this.mMultiVideoView.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.mMultiVideoView.getParent()).removeView((View)this.mMultiVideoView);
            }
            lp = new ViewGroup.LayoutParams(-1, -1);
            if (-1 != this.mMultiVideoViewIndex) {
                this.mMultiVideoOriginalParent.addView((View)this.mMultiVideoView, this.mMultiVideoViewIndex, lp);
            } else {
                this.mMultiVideoOriginalParent.addView((View)this.mMultiVideoView, lp);
            }
            IKtvLiveServiceExtend liveService = (IKtvLiveServiceExtend)this.getServiceManager().getService(IKtvLiveServiceExtend.class);
            if (null != liveService) {
                liveService.updateMultiVideoMini(this.mMultiVideoOriginalParent, false);
            }
        }
    }

    @Override
    public void setLocation(int left, int top, int width, int height) {
        mViewLocation = new SizeLocation(left, top, width, height);
    }

    @Override
    public void setLocation(int left, int top) {
        mViewLocation = new SizeLocation(left, top, ChannelMiniController.mViewLocation.width, ChannelMiniController.mViewLocation.height);
    }

    @Override
    public SizeLocation getLocation() {
        return mViewLocation;
    }

    @Override
    public void stopAnim() {
        MLog.info((Object)TAG, (String)"stopAnim", (Object[])new Object[0]);
        if (this.mRoomMiniView != null) {
            this.mRoomMiniView.stopAnim();
        }
    }

    @Override
    public void resumeAnim() {
        MLog.info((Object)TAG, (String)"resumeAnim", (Object[])new Object[0]);
        if (this.mRoomMiniView != null) {
            this.mRoomMiniView.startAnim();
        }
    }

    private void setWindowManager(AbstractWindowManager windowManager) {
        MLog.info((Object)TAG, (String)"setWindowManager %s", (Object[])new Object[]{windowManager});
        this.mWindowManager = windowManager;
    }

    private void addWindowMonitor() {
        MLog.info((Object)TAG, (String)"addWindowMonitor", (Object[])new Object[0]);
        this.mWindowMonitor = new DefaultWindow.IGlobalWindowMonitor(){

            public void onWindowCreate(DefaultWindow window) {
            }

            public void onShown(DefaultWindow window) {
                ChannelMiniController.this.showOrHideMiniView(window);
            }

            public void onHidden(DefaultWindow window) {
                MLog.info((Object)ChannelMiniController.TAG, (String)"WindowMonitor onHidden %s", (Object[])new Object[]{window.getName()});
            }

            public void onLayout(boolean changed, int left, int top, int right, int bottom) {
            }
        };
        DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.mWindowMonitor);
    }

    private void showOrHideMiniView(DefaultWindow windowShown) {
        if (this.mMiniInfo == null || windowShown == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"WindowMonitor onShown %s", (Object[])new Object[]{windowShown.getName()});
        DefaultWindow currentWindow = windowShown;
        if (currentWindow instanceof INoRoomMiniWindow && ((INoRoomMiniWindow)currentWindow).isDisableChannelMini() || currentWindow instanceof AddMusicWindow || currentWindow instanceof PlaylistWindow || currentWindow instanceof SearchMusicWindow || currentWindow instanceof IKTVSearchWindow || currentWindow instanceof IKTVUploadMusicWindow || currentWindow instanceof IKTVScanLocalMusicWindow || currentWindow instanceof IActsWebWindow && ((IActsWebWindow)currentWindow).isHalfScreenMode() || currentWindow instanceof ChannelWindow && !StringUtils.equal((String)((ChannelWindow)currentWindow).getCoexistenceVoiceChannel(), (String)this.mMiniInfo.getChannelId()) || StringUtils.equal((String)currentWindow.getName(), (String)"Game") || StringUtils.equal((String)currentWindow.getName(), (String)"MicUpResultWindow") || StringUtils.equal((String)currentWindow.getName(), (String)"MicUpGuideWindow") || StringUtils.equal((String)currentWindow.getName(), (String)"ChannelCoverRoomWindow") || currentWindow instanceof IWebUi && currentWindow.isTransparent() && this.mWindowManager.getWindowBehind((AbstractWindow)currentWindow) instanceof ChannelWindow) {
            if (this.mMiniInfo.isMinimized()) {
                this.hideMiniUi();
            }
        } else if (!(this.mMiniInfo.isMinimized() || currentWindow instanceof IWebUi && (currentWindow.isTransparent() && !currentWindow.isSingleTop() || ((IWebUi)currentWindow).getWebEnvSettings() != null && ((IWebUi)currentWindow).getWebEnvSettings().isTransparentBg()) || this.isSupportWindows(currentWindow))) {
            this.showNewMiniUi();
        }
    }

    private boolean isSupportWindows(DefaultWindow currentWindow) {
        if (currentWindow == null) {
            return false;
        }
        return StringUtils.equal((String)currentWindow.getName(), (String)"ChangeRoomLoadingWindow");
    }

    private void removeWindowMonitor() {
        DefaultWindow.removeGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.mWindowMonitor);
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            boolean isForeground = (Boolean)notification.extObj;
            if (isForeground) {
                this.resumeAnim();
            } else {
                this.stopAnim();
            }
        } else if (notification.id == NotificationIdDef.CHANNEL_ENTERED) {
            if (notification.extObj instanceof String) {
                String channelId = (String)notification.extObj;
                this.handleChannelEntered(channelId);
            }
        } else if (notification.id == NotificationIdDef.CHANNEL_EXITED) {
            if (notification.extObj instanceof String) {
                this.handleChannelExited((String)notification.extObj);
            }
        } else if (notification.id == RadioNotifyDef.RADIO_PASS_PLAY_MANAGER) {
            if (notification.extObj instanceof IRadioPlayPresenter) {
                this.mIRadioPlayPresenter = (IRadioPlayPresenter)notification.extObj;
                this.lastLandscape = this.mIRadioPlayPresenter.isLandscape();
                this.registerLinkMicTypeChangedListener();
            }
        } else if (notification.id == RadioNotifyDef.RADIO_PASS_PLAY_VIEW) {
            if (notification.extObj instanceof IRadioPlayView) {
                this.mRadioPlayView = (IRadioPlayView)notification.extObj;
            }
        } else if (notification.id == NotificationDef.N_WEB_WINDOW_INSTANT_CLOSE) {
            this.hideMiniUi();
        } else if (notification.id == MultiVideoNotifyDef.INSTANCE.getMULTIVIDEO_JOIN_ROOM()) {
            if (notification.extObj instanceof MultiVideoMiniViewBean) {
                MultiVideoMiniViewBean multiVideoMiniViewBean = (MultiVideoMiniViewBean)notification.extObj;
                this.mMultiVideoView = multiVideoMiniViewBean.getVideoContainer();
                this.mMultiVideoMicView = multiVideoMiniViewBean.getVideoMicContainer();
            }
        } else if (notification.id == MultiVideoNotifyDef.INSTANCE.getMULTIVIDEO_LEAVE_ROOM()) {
            this.mMultiVideoView = null;
            this.mMultiVideoMicView = null;
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.ADD_EXIT_CHANNEL_INTERCEPTOR) {
            if (msg.obj instanceof MiniCloseListener) {
                this.mMiniCloseListeners = (MiniCloseListener)msg.obj;
            }
        } else if (msg.what == BaseMsgDef.REAL_EXIT_CHANNEL) {
            this.realExitRoom();
        } else if (msg.what == BaseMsgDef.SHOW_MINI_EXIT_CHANNEL_DIALOG) {
            Serializable obj;
            IChannelMiniListener listener2 = null;
            if (msg.obj instanceof IChannelMiniListener) {
                listener2 = (IChannelMiniListener)msg.obj;
            }
            EnterParam enterParam = null;
            if (msg.getData() != null && (obj = msg.getData().getSerializable("enter_param")) instanceof EnterParam) {
                enterParam = (EnterParam)obj;
            }
            this.getChannelMiniManager().showMiniExitChannelDialog(listener2, enterParam, null == this.mMiniInfo ? "" : this.mMiniInfo.getChannelId());
        } else if (msg.what == ChannelMsgDef.MSG_MINI_UPDATE_CHANNEL_INFO) {
            if (msg.obj instanceof String) {
                MLog.info((Object)TAG, (String)"update channelInfo:%s", (Object[])new Object[]{(String)msg.obj});
                this.handleChannelEntered((String)msg.obj);
            }
            if (this.mWindowMonitor != null) {
                this.mWindowMonitor.onShown((DefaultWindow)this.mWindowManager.getCurrentWindow());
            }
        } else if (msg.what == ChannelMsgDef.MSG_TWO_USER_LINK_PK_NEED_UPDATE) {
            this.handleVideoChanged(true);
        } else if (msg.what == ChannelMsgDef.MSG_TWO_USER_UNLINK_PK_NEED_UPDATE) {
            this.handleVideoChanged(true);
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.MINI_CHANNEL) {
            this.showMiniUi();
        } else if (msg.what == ChannelMsgDef.CHANGE_ACT_WEB_MODE) {
            if (this.getCurrentWindow() instanceof DefaultWindow) {
                this.showOrHideMiniView((DefaultWindow)this.getCurrentWindow());
            } else {
                MLog.debug((Object)TAG, (String)"is not DefaultWindow", (Object[])new Object[0]);
            }
        }
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == ChannelBaseMsgDef.CHANNEL_MINIMISE_STATUS) {
            if (null == this.mMiniInfo) {
                return false;
            }
            return this.mMiniInfo.isMinimized();
        }
        return super.handleMessageSync(msg);
    }

    private void handleChannelEntered(String channelId) {
        Object subSid = MsgDispatcher.getInstance().sendMessageSync(AppbaseMsgDef.ChannelMsgDef.GET_SUB_CHANNEL);
        MLog.info((Object)TAG, (String)"update channel:%s, sub:%s, curMini:%s", (Object[])new Object[]{channelId, subSid, this.mMiniInfo != null ? this.mMiniInfo.getChannelId() : ""});
        if (this.mMiniInfo != null && subSid instanceof String && StringUtils.equals((String)((String)subSid), (String)this.mMiniInfo.getChannelId())) {
            return;
        }
        IChannel channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(channelId);
        ChannelDetailInfo channelDetailInfo = null;
        if (channel != null) {
            channelDetailInfo = channel.getDataService().getChannelDetailInfo(null);
        }
        if (channelDetailInfo != null && channelDetailInfo.baseInfo != null) {
            this.hideMiniUi();
            this.removeWindowMonitor();
            channel.getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
            channel.getPluginService().addPluginDataListener((IPluginService.IPluginDataChangedCallBack)this);
            this.mMiniInfo = new MiniInfo(channelId, channelDetailInfo.baseInfo.ownerUid);
            this.updateRoomData();
            this.addWindowMonitor();
        }
    }

    private void handleChannelExited(String channelId) {
        IChannel channel;
        MLog.info((Object)TAG, (String)"exit channel:%s", (Object[])new Object[]{channelId});
        if (this.mMiniInfo != null && StringUtils.equal((String)this.mMiniInfo.getChannelId(), (String)channelId)) {
            this.hideMiniUi();
            this.removeWindowMonitor();
            this.mMiniInfo = null;
            this.releaseRadio();
            this.releaseMultiVideo();
        }
        if ((channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(channelId)) != null) {
            channel.getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
            channel.getPluginService().removePluginDataListener((IPluginService.IPluginDataChangedCallBack)this);
        }
    }

    private ChannelMiniManager getChannelMiniManager() {
        if (this.mChannelMiniManager == null) {
            this.mChannelMiniManager = new ChannelMiniManager(this.getServiceManager(), this.mEnvironment, this.mDialogLinkManager);
        }
        return this.mChannelMiniManager;
    }

    private void updateRoomData() {
        SeatUser seatUser;
        if (this.mMiniInfo == null) {
            return;
        }
        long oldIconUser = this.mMiniInfo.getChannelShowUser();
        IChannel channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.mMiniInfo.getChannelId());
        if (channel == null) {
            return;
        }
        boolean baseMode = true;
        boolean isAudioPk = false;
        ChannelPluginData data2 = channel.getPluginService().getCurPluginData();
        if (data2 != null) {
            baseMode = data2.getMode() == 1;
            boolean bl = isAudioPk = data2.getMode() == 16;
            if (!isAudioPk) {
                isAudioPk = data2.getMode() == 17;
            }
        }
        this.mMiniInfo.setShowUserId(-1L);
        SeatData seatData = channel.getSeatService().getSeatData();
        if (!isAudioPk && seatData != null && seatData.hasUserInSeat() && (seatUser = seatData.getSeatByIndex(1)) != null && seatUser.uid > 0L && seatUser.uid != this.mMiniInfo.getChannelShowUser()) {
            this.mMiniInfo.setShowUserId(seatUser.uid);
        }
        if (baseMode) {
            return;
        }
        if (oldIconUser != this.mMiniInfo.getChannelShowUser()) {
            this.updateRoomView();
        }
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        this.updateRoomData();
    }

    public void onPluginModeChanged(String cid, ChannelPluginData pluginData, ChannelPluginData beforePlugin) {
        this.updateRoomData();
    }

    public void onPluginInfoChanged(String cid, ChannelPluginData pluginData) {
    }
}

