/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.content.Context;
import android.content.DialogInterface;
import android.os.SystemClock;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.bean.video.LiveVideoStreamInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.base.service.video.ILiveVideo;
import com.yy.hiyo.channel.base.service.video.ILiveVideoPlayer;
import com.yy.hiyo.channel.base.service.video.IStreamChangeCallback;
import com.yy.hiyo.channel.base.service.video.IVideoStatusCallback;
import com.yy.hiyo.channel.component.channelswipe.ChannelSwipePresenter;
import com.yy.hiyo.channel.component.channelswipe.ChatRoomSwipeData;
import com.yy.hiyo.channel.module.main.ChannelWindow;
import com.yy.hiyo.channel.module.main.IChannelWindowCallback;
import com.yy.hiyo.channel.module.main.enter.LoadingBgHellper;
import com.yy.hiyo.mvp.base.IMvpContext;
import java.util.List;

public class WindowShowManager {
    private String logTag = "";
    private ICallBack callback = null;
    private Context context;
    private ChannelWindow windowPreCreate;
    private boolean hasWindowCreated;
    private MyProgressDialog progressDialog;
    protected DialogLinkManager myDialogLinkManager;
    private IVideoStatusCallback liveCallback;
    private IStreamChangeCallback streamChangeCallback;
    private IPluginService.IPluginDataChangedCallBack pluginCallBack;
    private long mVideoShowPeopleReactionStartTime = 0L;
    private boolean windowDestroyed = false;
    private ChannelSwipePresenter channelSwipePresenter;
    private ChannelWindow curWindow = null;

    public WindowShowManager(Context context, String logTag, ICallBack callBack) {
        this.logTag = logTag;
        this.callback = callBack;
        this.context = context;
    }

    public void resetActivity() {
        this.progressDialog = null;
        this.myDialogLinkManager = null;
        this.hasWindowCreated = false;
        this.curWindow = null;
    }

    public ChannelWindow createWindow(IChannelWindowCallback callBacks, EnterParam enterParams) {
        ChannelWindow windowReal;
        if (this.windowPreCreate != null) {
            ChannelWindow window;
            this.curWindow = window = this.windowPreCreate;
            this.windowPreCreate = null;
            return window;
        }
        this.curWindow = windowReal = this.createWindowReal(callBacks, enterParams);
        return windowReal;
    }

    private void initSwipePresenter(ChannelWindow window) {
        if (this.channelSwipePresenter != null) {
            this.channelSwipePresenter.onDestroy();
        }
        this.channelSwipePresenter = new ChannelSwipePresenter();
        int mEntry = 0;
        boolean swipeEnd = false;
        if (this.callback.getChannel().getEnterParam() != null) {
            mEntry = this.callback.getChannel().getEnterParam().entry;
            swipeEnd = this.callback.getChannel().getEnterParam().swipeEnd;
        }
        this.channelSwipePresenter.onInit(window, this.callback.getChannel().getChannelId(), this.callback.isJoinSuccessed(), mEntry, swipeEnd, this.callback.getChannel());
        if (this.callback.getMvpContext() != null) {
            this.channelSwipePresenter.updateSwipeListener(this.callback.getMvpContext());
        }
    }

    public void beforeCallJoin(EnterParam enterParam) {
        this.mVideoShowPeopleReactionStartTime = SystemClock.uptimeMillis();
        LoadingBgHellper.preloadLoadingBgBy(this.context, enterParam);
    }

    public void afterCallJoin(final IChannelWindowCallback callBacks, final EnterParam enterParam) {
        if (WindowShowManager.needPreCreateWindow()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WindowShowManager.this.hasWindowCreated) {
                        return;
                    }
                    WindowShowManager.this.windowPreCreate = WindowShowManager.this.createWindowReal(callBacks, enterParam);
                }
            });
        }
        Runnable showLoading = new Runnable(){

            @Override
            public void run() {
                if (WindowShowManager.this.callback.isDestroy() || WindowShowManager.this.callback.isJoinSuccessed()) {
                    return;
                }
                if (WindowShowManager.this.myDialogLinkManager == null) {
                    WindowShowManager.this.myDialogLinkManager = new DialogLinkManager(WindowShowManager.this.context);
                }
                MLog.info((Object)WindowShowManager.this.logTag, (String)"enterChannel, show loading Dialog!", (Object[])new Object[0]);
                if (WindowShowManager.this.progressDialog != null) {
                    WindowShowManager.this.myDialogLinkManager.dismissDialog();
                }
                WindowShowManager.this.progressDialog = new MyProgressDialog("", true, false, null, new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog2) {
                        MLog.info((Object)WindowShowManager.this.logTag, (String)"enterChannel, loadingDialog cancel clicked!", (Object[])new Object[0]);
                        if (WindowShowManager.this.callback == null || WindowShowManager.this.callback.isDestroy()) {
                            return;
                        }
                        if (WindowShowManager.this.progressDialog != null && ((WindowShowManager)WindowShowManager.this).progressDialog.isJoinProgress) {
                            WindowShowManager.this.callback.onJoinCancel();
                        }
                    }
                });
                ((WindowShowManager)WindowShowManager.this).progressDialog.isJoinProgress = true;
                WindowShowManager.this.myDialogLinkManager.showDialog((BaseDialog)WindowShowManager.this.progressDialog);
                enterParam.joinLoadingHasShown = true;
            }
        };
        if (!this.isFromChannelSwitch()) {
            YYTaskExecutor.postToMainThread((Runnable)showLoading, (long)450L);
        }
    }

    public boolean isVideoMode() {
        ChannelPluginData pluginData = this.callback.getChannel().getPluginService().getCurPluginData();
        if (pluginData == null) {
            return false;
        }
        return pluginData.isVideoMode() && pluginData.mode != 15;
    }

    public void onJoinSuccess() {
        final ChannelPluginData pluginData = this.callback.getChannel().getPluginService().getCurPluginData();
        if (pluginData.mode != 15) {
            ILiveVideoPlayer liveVideoPlayer = this.callback.getChannel().getMediaService().getLiveVideoPlayer();
            liveVideoPlayer.join(this.callback.getChannel());
            boolean listen = this.listenVideo();
            if (!listen) {
                this.streamChangeCallback = new IStreamChangeCallback(){

                    public void onStreamAdd(LiveVideoStreamInfo info) {
                        if (WindowShowManager.this.progressDialog != null && ((WindowShowManager)WindowShowManager.this).progressDialog.isWaitingVideoProgress) {
                            WindowShowManager.this.listenVideo();
                        }
                    }

                    public void onStreamDelete(LiveVideoStreamInfo info) {
                    }

                    public void onStreamInfoUpdated(LiveVideoStreamInfo info, LiveVideoStreamInfo oldInfo) {
                    }
                };
                liveVideoPlayer.registerStreamListener(this.streamChangeCallback);
            }
            if (this.pluginCallBack == null) {
                this.pluginCallBack = new IPluginService.IPluginDataChangedCallBack(){

                    public void onVideoModeChanged(String channelId, boolean isVideoMode) {
                        if ((!isVideoMode || pluginData.mode == 15) && WindowShowManager.this.progressDialog != null && ((WindowShowManager)WindowShowManager.this).progressDialog.isWaitingVideoProgress) {
                            WindowShowManager.this.cancelLoadingDialog();
                        }
                    }
                };
            }
            this.callback.getChannel().getPluginService().addPluginDataListener(this.pluginCallBack);
            this.cancelLoadingDialog();
        } else {
            this.cancelLoadingDialog();
        }
        this.checkSlideAble();
    }

    private boolean listenVideo() {
        if (this.callback.getChannel() == null || this.callback.isDestroy()) {
            return false;
        }
        ChannelPluginData pluginData = this.callback.getChannel().getPluginService().getCurPluginData();
        if (pluginData.isVideoMode() && pluginData.mode != 15) {
            ILiveVideoPlayer liveVideoPlayer = this.callback.getChannel().getMediaService().getLiveVideoPlayer();
            LiveVideoStreamInfo info = null;
            List streamInfos = liveVideoPlayer.getStreams();
            if (streamInfos != null && streamInfos.size() > 0) {
                info = (LiveVideoStreamInfo)streamInfos.get(streamInfos.size() - 1);
            }
            if (info != null) {
                this.initLiveCallBack();
                liveVideoPlayer.getLiveVideo(info.getId()).registerListener(this.liveCallback);
                return true;
            }
        }
        return false;
    }

    public void onJoinError() {
        this.cancelLoadingDialog();
    }

    public void onDestroy() {
        if (this.pluginCallBack != null && this.callback.getChannel() != null) {
            this.callback.getChannel().getPluginService().removePluginDataListener(this.pluginCallBack);
        }
        this.cancelLoadingDialog();
        if (this.streamChangeCallback != null) {
            this.callback.getChannel().getMediaService().getLiveVideoPlayer().unregisterStreamListener(this.streamChangeCallback);
            this.streamChangeCallback = null;
        }
        if (this.callback.getChannel() != null) {
            this.callback.getChannel().getMediaService().getLiveVideoPlayer().exit();
            this.callback.getChannel().getMediaService().getLiveVideoPlayer().release();
        }
    }

    public void onWindowDestroyFinish() {
        if (this.windowDestroyed) {
            return;
        }
        this.windowDestroyed = true;
        if (this.channelSwipePresenter != null) {
            this.channelSwipePresenter.onDestroy();
            this.channelSwipePresenter = null;
        }
        this.curWindow = null;
    }

    public boolean isFromChannelSwitch() {
        return this.callback.getChannel() != null && this.callback.getChannel().getEnterParam() != null && this.callback.getChannel().getEnterParam().entry == 24;
    }

    public long getShowWindowDelay() {
        if (!this.isVideoMode()) {
            return 0L;
        }
        int time = WindowShowManager.getVideoShowReactionTime();
        if (time <= 0 || this.isFromChannelSwitch()) {
            return 50L;
        }
        long hasPastTime = SystemClock.uptimeMillis() - this.mVideoShowPeopleReactionStartTime;
        long timeDelayPushWindow = 0L;
        if (hasPastTime > 0L && hasPastTime < (long)time) {
            timeDelayPushWindow = (long)time - hasPastTime;
            MLog.info((Object)this.logTag, (String)"delay show Window:%d", (Object[])new Object[]{(int)timeDelayPushWindow});
        }
        return timeDelayPushWindow;
    }

    private void cancelLoadingDialog() {
        if (this.progressDialog != null) {
            MLog.info((Object)this.logTag, (String)"cancelLoadingDialog!", (Object[])new Object[0]);
            if (this.myDialogLinkManager != null) {
                this.myDialogLinkManager.dismissDialog();
            }
            this.progressDialog.setCancelListener(null);
            this.progressDialog = null;
        }
    }

    private ChannelWindow createWindowReal(IChannelWindowCallback callBacks, EnterParam enterParams) {
        this.hasWindowCreated = true;
        int pluginType = (Integer)enterParams.getExtra("pluginType", (Object)0);
        boolean fromRadioVideo = (Boolean)enterParams.getExtra("from_radio_video", (Object)false);
        boolean fromMultiVideo = pluginType == 15;
        boolean isSlidable = false;
        if (ChatRoomSwipeData.isEnable()) {
            isSlidable = true;
        } else if (enterParams.entry == 61 || enterParams.entry == 24 || fromRadioVideo || fromMultiVideo || enterParams.entry == 186) {
            isSlidable = true;
        }
        return new ChannelWindow(this.context, enterParams, callBacks, isSlidable);
    }

    private void initLiveCallBack() {
        if (this.liveCallback != null) {
            return;
        }
        this.liveCallback = new IVideoStatusCallback(){

            public void onVideoStarted(ILiveVideo video) {
                if (WindowShowManager.this.callback.isDestroy()) {
                    return;
                }
                if (WindowShowManager.this.progressDialog != null && ((WindowShowManager)WindowShowManager.this).progressDialog.isWaitingVideoProgress) {
                    WindowShowManager.this.cancelLoadingDialog();
                }
                if (WindowShowManager.this.callback != null) {
                    WindowShowManager.this.callback.pushWindowNow();
                }
            }

            public void onVideoReStarted(ILiveVideo video) {
            }

            public void onVideoStoped(ILiveVideo video) {
                if (WindowShowManager.this.callback.isDestroy()) {
                    return;
                }
                if (WindowShowManager.this.progressDialog != null && ((WindowShowManager)WindowShowManager.this).progressDialog.isWaitingVideoProgress) {
                    WindowShowManager.this.cancelLoadingDialog();
                }
            }
        };
    }

    private static int getVideoShowReactionTime() {
        int time;
        if (RuntimeContext.isInGray() && (time = SettingFlags.getIntValue((String)"videoshowtime", (int)-1)) > 0) {
            return time;
        }
        int defaultValue = SystemUtils.isShowEnvSetting() ? 1000 : 500;
        IAB joinTypeABValue = EnterParam.getJoinTypeABValue();
        if (joinTypeABValue != null && NAB.B.equals((Object)joinTypeABValue)) {
            defaultValue = 500;
        } else if (joinTypeABValue != null && NAB.C.equals((Object)joinTypeABValue)) {
            defaultValue = 800;
        } else if (joinTypeABValue != null && NAB.D.equals((Object)joinTypeABValue)) {
            defaultValue = 1000;
        } else if (joinTypeABValue != null && NAB.E.equals((Object)joinTypeABValue)) {
            defaultValue = RuntimeContext.getPhoneType() == 3 ? 500 : 800;
        }
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.PERFORMANCE_CONFIG);
        if (configData != null) {
            return configData.getIntValue("videoshowreactiontime", defaultValue);
        }
        return defaultValue;
    }

    private static boolean needPreCreateWindow() {
        return true;
    }

    public void onWindowShow() {
        if (this.callback != null && !this.callback.isDestroy() && this.curWindow != null && this.isFromChannelSwitch()) {
            YYTaskExecutor.postToMainThread(() -> {
                if (this.callback != null && !this.callback.isDestroy() && this.curWindow != null) {
                    this.initSwipePresenter(this.curWindow);
                }
            });
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WindowShowManager.this.callback != null && !WindowShowManager.this.callback.isDestroy() && WindowShowManager.this.curWindow != null) {
                        WindowShowManager.this.initSwipePresenter(WindowShowManager.this.curWindow);
                    }
                }
            }, (long)200L);
        }
    }

    private void checkSlideAble() {
        if (this.channelSwipePresenter != null) {
            this.channelSwipePresenter.checkSupport();
        }
    }

    public void updateSlideEnable(boolean enable) {
        if (this.channelSwipePresenter != null) {
            this.channelSwipePresenter.updateSlideEnable(enable);
        }
    }

    public void swipeEnable(boolean enable) {
        if (this.channelSwipePresenter != null) {
            this.channelSwipePresenter.swipeEnable(enable);
        }
    }

    public void continueScroll(int scrollType) {
        if (this.channelSwipePresenter != null) {
            this.channelSwipePresenter.continueScroll(scrollType);
        }
    }

    public void updateContext() {
        if (this.callback.getMvpContext() != null && this.channelSwipePresenter != null) {
            this.channelSwipePresenter.updateSwipeListener(this.callback.getMvpContext());
        }
    }

    public static interface ICallBack {
        public boolean isDestroy();

        public boolean isJoinSuccessed();

        public IChannel getChannel();

        public void onJoinCancel();

        public void pushWindowNow();

        public IMvpContext getMvpContext();
    }

    private static class MyProgressDialog
    extends ProgressDialog {
        boolean isJoinProgress;
        boolean isWaitingVideoProgress;

        public MyProgressDialog(String s, boolean b, boolean b1, DialogInterface.OnDismissListener dismissListener, DialogInterface.OnCancelListener onCancelListener) {
            super(s, b, b1, dismissListener, onCancelListener);
            this.setDimAmount(0.0f);
        }
    }
}

