/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.GrowthBusinessConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.module.main.enter.agreement.AgreementDialog;

public class ChannelJoinGuideUtils {
    private static final String TAG = "ChannelJoinGuideUtils";
    private static AgreementDialog dialog;

    public static void executeAfterPrivacyAgreementOrGuestLoginGuide(Context context, String windowName, Runnable continueCommand) {
        if (ChannelJoinGuideUtils.showGuestGuide()) {
            return;
        }
        boolean show = ChannelJoinGuideUtils.showPrivacyAgreementGuide(context, windowName, continueCommand::run);
        if (!show) {
            continueCommand.run();
        }
    }

    public static boolean showPrivacyAgreementGuide(Context context, String windowName, final IPrivacyAgreementGuideCallBack callBack) {
        boolean agreementShowed;
        if (ChannelJoinGuideUtils.showGuestGuide()) {
            return true;
        }
        if (RuntimeContext.isHagoPartySdk()) {
            return false;
        }
        boolean isIBossSwitchOn = false;
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.GROWTH_BUSINESS);
        if (configData instanceof GrowthBusinessConfig) {
            isIBossSwitchOn = ((GrowthBusinessConfig)configData).getData().getEnterChannelAgreementSwitch();
        }
        if (!(agreementShowed = SettingFlags.getBoolean((String)"key_voice_room_agreement_showed", (boolean)false)) && !isIBossSwitchOn) {
            if (dialog != null) {
                dialog.dismissByCancel();
            }
            MLog.info((Object)TAG, (String)"\u5f39\u534f\u8bae\u5f39\u7a97", (Object[])new Object[0]);
            dialog = new AgreementDialog(context, windowName);
            dialog.setWebService((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class));
            dialog.setOnCallback(new AgreementDialog.Callback(){

                @Override
                public void onClickAgree() {
                    MLog.info((Object)ChannelJoinGuideUtils.TAG, (String)"\u534f\u8bae\u5f39\u7a97\u70b9\u51fbagree", (Object[])new Object[0]);
                    SettingFlags.setBoolean((String)"key_voice_room_agreement_showed", (boolean)true);
                    if (callBack != null) {
                        callBack.onAgree();
                    }
                }

                @Override
                public void onCancel() {
                    if (callBack != null) {
                        callBack.onCancel();
                    }
                }
            });
            dialog.show();
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    dialog = null;
                }
            });
            return true;
        }
        return false;
    }

    public static boolean showGuestGuide() {
        if (!RuntimeContext.isHagoPartySdk() && AccountUtil.isLoginByGuest()) {
            String deeplink = SettingFlags.getStringValue((String)"key_deep_link");
            String mediaSource = SettingFlags.getStringValue((String)"key_dp_media_source");
            if (StringUtils.isNotEmpty((String)deeplink) && StringUtils.isNotEmpty((String)mediaSource) && !StringUtils.equal((String)mediaSource, (String)"googleadwords_int")) {
                AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.GROWTH_BUSINESS);
                boolean allow = false;
                if (configData instanceof GrowthBusinessConfig) {
                    allow = ((GrowthBusinessConfig)configData).getData().getDlGuestEnterRoomConfig().getEnterEnable();
                }
                if (allow && NewABDefine.DP_GUEST_ENTER_ROOM_TEST.matchB()) {
                    MLog.info((Object)TAG, (String)"guest can enter room, deeplink: %s, mediaSource: %s", (Object[])new Object[]{deeplink, mediaSource});
                    return false;
                }
                MLog.info((Object)TAG, (String)"guest enter room show guide, switch or ab is not allow", (Object[])new Object[0]);
            }
            Message message = new Message();
            message.what = BaseMsgDef.SHOW_GUIDE_DIALOG;
            MsgDispatcher.getInstance().sendMessage(message);
            return true;
        }
        return false;
    }

    public static interface IPrivacyAgreementGuideCallBack {
        public void onAgree();

        default public void onCancel() {
        }
    }
}

