/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main;

import android.app.Activity;
import android.os.Bundle;
import android.os.Message;
import android.view.KeyEvent;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.callback.IVoiceRoomExitCallback;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.home.DiscoverPageType;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.ui.widget.volume.VolumeViewManager;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.appbase.util.RemoveViewUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.sword.SwordHelper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelLeaveResp;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.hiido.ChannelBaseTrack;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.utils.ChannelPlayInfoService;
import com.yy.hiyo.channel.cbase.AbsChannelController;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.AbsPlugin;
import com.yy.hiyo.channel.cbase.IPluginCallBack;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.module.radio.IRadioPage;
import com.yy.hiyo.channel.cbase.utils.perf.ChannelPathLog;
import com.yy.hiyo.channel.cbase.widget.IChannelDrawerManager;
import com.yy.hiyo.channel.cbase.widget.IChannelDrawerService;
import com.yy.hiyo.channel.cbase.widget.IChannelListDrawer;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.channelswipe.PreCreateRadioPage;
import com.yy.hiyo.channel.component.familygroup.FamilyGroupPresenter;
import com.yy.hiyo.channel.component.profile.entranceshow.EntranceShowManager;
import com.yy.hiyo.channel.growth.IInterceptMiniCallaback;
import com.yy.hiyo.channel.module.main.ChannelWindow;
import com.yy.hiyo.channel.module.main.IChannelWindowCallback;
import com.yy.hiyo.channel.module.main.IChannelWindowController;
import com.yy.hiyo.channel.module.main.PluginManager;
import com.yy.hiyo.channel.module.main.enter.ChannelKeepAliveService;
import com.yy.hiyo.channel.module.main.enter.EnterStatsHelper;
import com.yy.hiyo.channel.module.main.enter.MyChannelJoinCallback;
import com.yy.hiyo.channel.module.main.enter.WindowShowManager;
import com.yy.hiyo.channel.module.main.exit.ExitResultHelper;
import com.yy.hiyo.channel.module.main.exit.MiniHelper;
import com.yy.hiyo.channel.module.main.game.MyChannelGameFilter;
import com.yy.hiyo.channel.module.main.web.ChannelLifecycle;
import com.yy.hiyo.game.base.FilterRunnable;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;
import java.util.ArrayList;
import java.util.Map;

public class ChannelWindowController
extends AbsChannelController
implements IChannelWindowController,
IPluginCallBack,
IChannelWindowCallback {
    private static String TAG_PRE = "Channel_WindowController_";
    private String logTag = "ChannelWindowController";
    private static int sIndex = 0;
    private ICallback callback;
    private IChannel channel;
    private EnterParam enterParams;
    protected ChannelWindow window;
    private boolean showPageAfterWindowShown = false;
    private boolean onWindowShowned = false;
    private Runnable showPageCommand;
    protected boolean destroyed;
    private boolean destroyFinished;
    private boolean joinSuccessed;
    private ArrayList<IVoiceRoomExitCallback> destroyCallback;
    private IChannelDrawerManager drawerManager;
    protected MyChannelGameFilter gameFilter;
    private MiniHelper miniHelper;
    private PluginManager curPluginManager;
    WindowShowManager windowShowManager;
    private Runnable pushWindowRunnable = null;
    private boolean isWindowPushing = false;
    private IChannelWindowController.IIntercepter intercepter;
    private boolean isDelayShowWindow = false;

    public ChannelWindowController(Environment environment, ICallback callback2) {
        super(environment);
        this.callback = callback2;
        this.curPluginManager = new PluginManager(this.createPluginCallBack());
        this.logTag = TAG_PRE + ++sIndex;
        if (RuntimeContext.isHagoPartySdk()) {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_MAIN_ACTIVITY_STOP, (INotify)this);
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_PARTY_SDK_ACTIVITY_RESUME, (INotify)this);
        }
        MLog.info((Object)this.logTag, (String)"create!", (Object[])new Object[0]);
    }

    private PluginManager.IPluginManagerCallBack createPluginCallBack() {
        return new PluginManager.IPluginManagerCallBack(){

            @Override
            public IChannel getChannel() {
                return ChannelWindowController.this.channel;
            }

            @Override
            public ChannelWindow getChannelWindow() {
                return ChannelWindowController.this.window;
            }

            @Override
            public Environment getEnvironment() {
                return ChannelWindowController.this.getEnvironment();
            }

            @Override
            public EnterParam getEnterParams() {
                return ChannelWindowController.this.enterParams;
            }

            @Override
            public void initChannelListDrawer() {
                if (ChannelWindowController.this.drawerManager == null) {
                    ChannelWindowController.this.drawerManager = ((IChannelDrawerService)ServiceManagerProxy.getService(IChannelDrawerService.class)).newDrawerManager(ChannelWindowController.this.channel);
                    ChannelWindowController.this.drawerManager.initDrawer(ChannelWindowController.this.getContext(), ChannelWindowController.this.window.getRightContainer(), ChannelWindowController.this.window.getDrawerLayout());
                    ChannelWindowController.this.drawerManager.setOnDrawerListener(new IChannelListDrawer.OnDrawerListener(){

                        public void onClose() {
                            if (ChannelWindowController.this.windowShowManager != null) {
                                ChannelWindowController.this.windowShowManager.updateSlideEnable(true);
                            }
                        }

                        public void onOpen() {
                            if (ChannelWindowController.this.windowShowManager != null) {
                                ChannelWindowController.this.windowShowManager.updateSlideEnable(false);
                            }
                        }
                    });
                    if (ChannelWindowController.this.channel.getDataService().useOldRoomStyle()) {
                        ChannelWindowController.this.window.getDrawerLayout().setDrawerLockMode(1, 0x800005);
                    }
                }
                ChannelWindowController.this.windowShowManager.updateContext();
            }

            @Override
            public boolean isDestroyed() {
                return ChannelWindowController.this.destroyed;
            }

            @Override
            public IPluginCallBack getPluginCallBack() {
                return ChannelWindowController.this;
            }
        };
    }

    private void initWindowShowManager() {
        this.windowShowManager = new WindowShowManager(this.getEnvironment().getContext(), this.logTag, new WindowShowManager.ICallBack(){

            @Override
            public boolean isDestroy() {
                return ChannelWindowController.this.destroyed;
            }

            @Override
            public boolean isJoinSuccessed() {
                return ChannelWindowController.this.joinSuccessed;
            }

            @Override
            public IChannel getChannel() {
                return ChannelWindowController.this.getChannel();
            }

            @Override
            public void onJoinCancel() {
                ChannelWindowController.this.destroy(true);
            }

            @Override
            public void pushWindowNow() {
                if (ChannelWindowController.this.pushWindowRunnable != null) {
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)ChannelWindowController.this.pushWindowRunnable);
                    ChannelWindowController.this.pushWindowRunnable.run();
                }
            }

            @Override
            public IMvpContext getMvpContext() {
                return ChannelWindowController.this.getPageContext();
            }
        });
    }

    private IChannel.IJoinCallBack getJoinCallBack() {
        return new MyChannelJoinCallback(this.getEnvironment().getContext(), this.logTag, new MyChannelJoinCallback.ICallBack(){

            @Override
            public boolean isDestroy() {
                return ChannelWindowController.this.destroyed;
            }

            @Override
            public EnterParam getEnterParam() {
                return ChannelWindowController.this.enterParams;
            }

            @Override
            public IChannel.IJoinCallBack getJoinErrorHandler(EnterParam enterParam) {
                return ChannelWindowController.this.callback.getJoinErrorHandler(enterParam);
            }

            @Override
            public void onJoinSuccess(EnterParam requestParams, EnterChannelData data2, IChannel channel) {
                ChannelWindowController.this.onJoinSuccess(requestParams, data2, channel);
            }

            @Override
            public void onJoinError(int errorCode, String errorTips) {
                ChannelWindowController.this.onJoinError(errorCode, errorTips);
            }
        }).getJoinCallBack();
    }

    @Override
    public void enterChannel(EnterParam enterParam, boolean showWindowAfterJoinSuccess, boolean callJoinRequest, boolean callJoinBaseBroadcast) {
        MLog.info((Object)this.logTag, (String)"enterChannel, cid:%s,gameId:%s,showWindowAfterJoinSucces:%s!", (Object[])new Object[]{enterParam.roomId, enterParam.gameInfo != null ? enterParam.gameInfo.gid : "", showWindowAfterJoinSuccess ? "true" : "false"});
        this.initWindowShowManager();
        this.windowShowManager.beforeCallJoin(enterParam);
        enterParam.mChannelTimingStat.start(enterParam.roomId);
        this.enterParams = enterParam;
        IChannel channel = null;
        if (StringUtils.isEmpty((String)this.enterParams.roomId)) {
            showWindowAfterJoinSuccess = true;
        } else {
            channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.enterParams.roomId);
        }
        this.channel = channel;
        MLog.info((Object)("ChannelWindow__" + enterParam.roomId), (String)("showWindowAfterJoinSuccess " + showWindowAfterJoinSuccess), (Object[])new Object[0]);
        if (!showWindowAfterJoinSuccess) {
            this.showWindow(channel, this.enterParams);
        } else {
            MLog.info((Object)"xxxxxxx", (String)"", (Object[])new Object[0]);
        }
        this.onPreJoin(enterParam);
        ChannelDetailInfo channelDetailInfo = null;
        if (channel != null) {
            channelDetailInfo = channel.getDataService().getCacheDetail();
        }
        if (callJoinRequest || channel == null || channelDetailInfo == null) {
            if (StringUtils.isNotEmpty((String)this.enterParams.roomId)) {
                if (callJoinBaseBroadcast) {
                    channel.joinBroadcastGroup(this.enterParams, this.getJoinCallBack());
                } else {
                    this.requestJoinChannel(channel, this.enterParams);
                }
            } else {
                this.requestJoinChannel(this.enterParams);
            }
        } else {
            this.getJoinCallBack().onSuccess(this.enterParams, channelDetailInfo, channel.getEnterChannelData());
        }
        this.windowShowManager.afterCallJoin(this, this.enterParams);
    }

    @Override
    public void enterChannel(EnterParam enterParam, boolean showWindowAfterJoinSuccess, boolean callJoinRequest) {
        this.enterChannel(enterParam, showWindowAfterJoinSuccess, callJoinRequest, false);
    }

    @Override
    public boolean isActivityDestroy() {
        return this.window != null && this.window.getContext() instanceof Activity && ((Activity)this.window.getContext()).isDestroyed();
    }

    @Override
    public void bringWindowToFront(EnterParam enterParam) {
        MLog.info((Object)this.logTag, (String)"bringWindowToFront param: %s, window: %s, currentWindow: %s", (Object[])new Object[]{enterParam, this.window, this.getCurrentWindow()});
        if (this.enterParams == null) {
            this.enterParams = enterParam;
        } else {
            this.enterParams.setExtra("bring_to_front_params", (Object)enterParam);
        }
        if (this.pushWindowRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.pushWindowRunnable);
            if (this.window != null) {
                this.pushWindowRunnable.run();
                return;
            }
        }
        if (this.window == null) {
            if (enterParam != null && enterParam != this.enterParams) {
                enterParam.setExtra("show_window_animation", enterParam.getExtra("show_window_animation", (Object)true));
            }
            this.showWindow(this.channel, enterParam);
        } else if (this.getCurrentWindow() != this.window) {
            if (this.mWindowMgr.isWinInStack((AbstractWindow)this.window)) {
                while (this.mWindowMgr.getCurrentWindow() != this.window) {
                    this.mWindowMgr.popWindow(false, this.mWindowMgr.getCurrentWindow());
                }
            } else {
                try {
                    this.mWindowMgr.pushWindow((AbstractWindow)this.window, (Boolean)enterParam.getExtra("show_window_animation", (Object)true) != false && this.enableAni() && enterParam.entry != 24);
                }
                catch (Exception e) {
                    MLog.error((Object)this.logTag, (Throwable)e);
                }
            }
        }
        if (this.channel != null) {
            ChannelLifecycle.INSTANCE.onMaximize(this.channel);
        }
    }

    @Override
    public void bringWindowToBackGround(boolean ani) {
        MLog.info((Object)this.logTag, (String)"bringWindowToBackGround:%d", (Object[])new Object[]{ani ? 1 : 0});
        if (this.pushWindowRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.pushWindowRunnable);
        }
        this.pushWindowRunnable = null;
        if (this.window != null && !this.destroyed && this.joinSuccessed && this.mWindowMgr.isWinInStack((AbstractWindow)this.window)) {
            this.mWindowMgr.popWindow(ani && this.enableAni(), (AbstractWindow)this.window);
        }
    }

    protected void requestJoinChannel(@NonNull IChannel channel, EnterParam enterParams) {
        channel.join(enterParams, this.getJoinCallBack());
    }

    protected void requestJoinChannel(EnterParam enterParams) {
        ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).join(enterParams, this.getJoinCallBack());
    }

    private Runnable getPushWindowRunnable() {
        if (this.pushWindowRunnable != null) {
            return this.pushWindowRunnable;
        }
        this.pushWindowRunnable = new Runnable(){

            @Override
            public void run() {
                if (ChannelWindowController.this.isWindowPushing || ChannelWindowController.this.destroyed) {
                    return;
                }
                ChannelWindowController.this.isWindowPushing = true;
                if (ChannelWindowController.this.window != null) {
                    AbstractWindow curWindow = ChannelWindowController.this.mWindowMgr.getCurrentWindow();
                    if (curWindow != null && (StringUtils.equal((String)curWindow.getName(), (String)"ChannelEndPage") || StringUtils.equal((String)curWindow.getName(), (String)"ChangeRoomLoadingWindow"))) {
                        ChannelWindowController.this.mWindowMgr.popToWindow(curWindow, false);
                        ChannelWindowController.this.mWindowMgr.pushWindow((AbstractWindow)ChannelWindowController.this.window, false);
                        ChannelWindowController.this.mWindowMgr.pushWindow(curWindow, false);
                    } else {
                        ChannelWindowController.this.mWindowMgr.pushWindow((AbstractWindow)ChannelWindowController.this.window, ChannelWindowController.this.enableAni() && (Boolean)ChannelWindowController.this.enterParams.getExtra("show_window_animation", (Object)(((ChannelWindowController)ChannelWindowController.this).enterParams.entry != 24 ? 1 : 0)) != false);
                    }
                    if (((ChannelWindowController)ChannelWindowController.this).enterParams.entry == 24) {
                        AbstractWindow behindWin = ChannelWindowController.this.mWindowMgr.getWindowBehind((AbstractWindow)ChannelWindowController.this.window);
                        if (behindWin instanceof ChannelWindow) {
                            ChannelWindowController.this.mWindowMgr.removeWindow(behindWin, true);
                        }
                    } else if (((ChannelWindowController)ChannelWindowController.this).enterParams.entry == 123) {
                        MLog.debug((Object)"UserGuideManager", (String)"\u89e6\u53d1\u62c9\u8d77\u793c\u7269\u9762\u677f", (Object[])new Object[0]);
                        YYTaskExecutor.postToMainThread(() -> {
                            BottomPresenter bottomPresenter;
                            IMvpContext mvpContext;
                            AbsPlugin<AbsPage, IChannelPageContext<AbsPage>> plugin;
                            if (ChannelWindowController.this.curPluginManager != null && (plugin = ChannelWindowController.this.curPluginManager.getCurPlugin()) != null && (mvpContext = plugin.getMvpContext()) != null && (bottomPresenter = (BottomPresenter)mvpContext.getPresenter(BottomPresenter.class)) != null) {
                                MLog.debug((Object)"UserGuideManager", (String)"showGiftPanel", (Object[])new Object[0]);
                                bottomPresenter.showGiftPanel();
                            }
                        }, (long)500L);
                    }
                }
                ChannelWindowController.this.pushWindowRunnable = null;
                ChannelPathLog.getEnterChannelLogger((String)ChannelWindowController.this.getChannelId()).add("Window After Show!", new Object[0]);
            }
        };
        return this.pushWindowRunnable;
    }

    private void showWindow(IChannel channel, EnterParam enterParam) {
        IRadioPage page;
        this.channel = channel;
        this.window = this.windowShowManager.createWindow(this, this.enterParams);
        if (!this.needShowWindowAfterJoinSuccess(enterParam) && (page = PreCreateRadioPage.INSTANCE.preCreateRadioPage(enterParam.roomId, this.window)) instanceof AbsPage) {
            AbsPage rp = (AbsPage)page;
            PreCreateRadioPage.INSTANCE.registerOnVideoSizeChange(enterParam.roomId, (String)enterParam.getExtra("live_cover_url", (Object)""));
            this.window.setMainPage(rp);
        }
        this.isDelayShowWindow = false;
        long delayTime = this.windowShowManager.getShowWindowDelay();
        if (delayTime > 0L && !RuntimeContext.isHagoPartySdk()) {
            IAB joinTypeABValue = EnterParam.getJoinTypeABValue();
            if (joinTypeABValue != null && (NAB.B.equals((Object)joinTypeABValue) || NAB.C.equals((Object)joinTypeABValue) || NAB.D.equals((Object)joinTypeABValue) || NAB.E.equals((Object)joinTypeABValue))) {
                this.sendMessageSync(MixBaseMsgDef.HANDLE_SURFACE_PRELOAD);
                this.isDelayShowWindow = true;
                AbstractWindow curWin = this.mWindowMgr.getCurrentRootWindow();
                this.mWindowMgr.insertWindowAfter((AbstractWindow)this.window, curWin);
                this.window.setVisibility(0);
            }
            YYTaskExecutor.postToMainThread((Runnable)this.getPushWindowRunnable(), (long)delayTime);
        } else {
            this.getPushWindowRunnable().run();
        }
        EnterStatsHelper.onChannelWindow(channel, enterParam);
        this.ensureGameFilter().onEnterChannel();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public String getChannelId() {
        if (this.channel != null) {
            return this.channel.getChannelId();
        }
        return this.enterParams.roomId;
    }

    @Override
    public IChannel getChannel() {
        return this.channel;
    }

    @Override
    public EnterParam getEnterParams() {
        return this.enterParams;
    }

    private void onPreJoin(EnterParam enterParam) {
        EntranceShowManager.INSTANCE.registerNotify();
    }

    private void onJoinSuccess(final EnterParam requestParams, final EnterChannelData data2, final IChannel channel) {
        ChannelPathLog.getEnterChannelLogger((String)requestParams.roomId).add("Window Join Success!", new Object[0]);
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                ((ChannelWindowController)ChannelWindowController.this).enterParams.mChannelTimingStat.onJoinChannelRequestEnd();
                if (ChannelWindowController.this.destroyed) {
                    MLog.error((Object)ChannelWindowController.this.logTag, (String)"onJoinSuccess but destroyed,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                    if (requestParams == ChannelWindowController.this.enterParams) {
                        MLog.info((Object)ChannelWindowController.this.logTag, (String)"play leave channel request by onJoinSuccess but destroyed!", (Object[])new Object[0]);
                        channel.leave(new IChannel.ILeaveCallBack(){

                            public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                            }

                            public void onError(int errorCode, String errorTips, Exception e) {
                            }
                        });
                    }
                    ChannelPathLog.getEnterChannelLogger((String)requestParams.roomId).end("End by Window destroy!", new Object[0]);
                    return;
                }
                MLog.info((Object)ChannelWindowController.this.logTag, (String)"onJoinSuccess hide dialog", (Object[])new Object[0]);
                ChannelWindowController.this.channel = channel;
                ChannelWindowController.this.windowShowManager.onJoinSuccess();
                if (((ChannelWindowController)ChannelWindowController.this).enterParams.callBack != null) {
                    ((ChannelWindowController)ChannelWindowController.this).enterParams.callBack.onSuccess();
                    ((ChannelWindowController)ChannelWindowController.this).enterParams.callBack = null;
                }
                ChannelPathLog.getEnterChannelLogger((String)requestParams.roomId).add("Window Pre Show!", new Object[0]);
                MLog.info((Object)ChannelWindowController.this.logTag, (String)"onJoinSuccess cid:%s!", (Object[])new Object[]{channel.getChannelId()});
                ChannelWindowController.this.joinSuccessed = true;
                if (ChannelWindowController.this.window == null) {
                    ChannelWindowController.this.showWindow(channel, ChannelWindowController.this.enterParams);
                } else if (RuntimeContext.sIsForeground) {
                    channel.getMsgService().inMsgPage();
                }
                ChannelWindowController.this.window.setRightPanel();
                ChannelInfo channelInfo = channel.getDataService().getChannelDetailInfo(null).baseInfo;
                if (data2.isUpgrade) {
                    IChannelCenterService service;
                    MLog.info((Object)ChannelWindowController.this.logTag, (String)"channel upgrade version:%s!", (Object[])new Object[]{channelInfo.version});
                    if (null != ServiceManagerProxy.getServiceManager() && null != (service = (IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class))) {
                        service.getMyJoinedChannels(null, true);
                        service.updateControlConfigFromServer(null);
                    }
                }
                ChannelWindowController.this.showPageCommand = new Runnable(){

                    @Override
                    public void run() {
                        if (ChannelWindowController.this.showPageAfterWindowShown && !ChannelWindowController.this.onWindowShowned) {
                            MLog.info((Object)ChannelWindowController.this.logTag, (String)"showpage window not shown, wait to shown cid:%s!", (Object[])new Object[]{channel.getChannelId()});
                            return;
                        }
                        if (ChannelWindowController.this.destroyed) {
                            MLog.info((Object)ChannelWindowController.this.logTag, (String)"showpage but destroyed, cid:%s!", (Object[])new Object[]{channel.getChannelId()});
                            return;
                        }
                        if (null != ChannelWindowController.this.curPluginManager) {
                            ChannelWindowController.this.curPluginManager.onInit(channel);
                        }
                        ChannelWindowController.this.showPageCommand = null;
                    }
                };
                if (ChannelWindowController.this.windowShowManager.isFromChannelSwitch() || !ChannelWindowController.this.windowShowManager.isVideoMode()) {
                    ChannelWindowController.this.showPageCommand.run();
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (ChannelWindowController.this.showPageCommand == null) {
                                return;
                            }
                            ChannelWindowController.this.showPageCommand.run();
                        }
                    });
                }
                if (ChannelWindowController.this.callback != null) {
                    ChannelWindowController.this.callback.onJoinSuccess(requestParams, data2, ChannelWindowController.this);
                }
                ChannelLifecycle.INSTANCE.onJoin(channel);
                ChannelPlayInfoService.Companion.enterChannel(channel);
                if (channelInfo.version == 0 && channel.getPluginService().getCurPluginData().mode == 1) {
                    ChannelTrack.INSTANCE.unUpdateChannelShow();
                }
                PrivilegeHelper.INSTANCE.enterRoom();
                if (channelInfo.isGroupParty() && null != channel.getRoleService() && channel.getRoleService().isMeAnchor()) {
                    channel.getDataService().getChannelDetailInfo(null).extInfo.isShareRoomToGroup = true;
                }
            }
        };
        if (this.callback != null) {
            this.callback.preJoinSuccess(this, runnable2, channel.getChannelId());
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((ChannelWindowController)ChannelWindowController.this).enterParams.mChannelTimingStat.onChannelPageFirstFrame();
                if (data2 != null && data2.pluginData != null && !data2.pluginData.isVideoMode() && data2.pluginData.mode != 15) {
                    ((ChannelWindowController)ChannelWindowController.this).enterParams.mChannelTimingStat.report(data2.pluginData.mode, data2.pluginData.getPluginId(), false, ((ChannelWindowController)ChannelWindowController.this).enterParams.entry);
                }
            }
        });
        this.reportFromPush(this.enterParams);
    }

    private void reportFromPush(EnterParam enterParam) {
        boolean needReport;
        if (enterParam != null && (needReport = ((Boolean)enterParam.getExtra("needPushReport", (Object)false)).booleanValue())) {
            String pushId = (String)enterParam.getExtra("pushId", (Object)"");
            String pushState = (String)enterParam.getExtra("pushState", (Object)"");
            ChannelBaseTrack.INSTANCE.reportPush("push_enter_room", pushId, pushState, this.getChannelId());
        }
    }

    private void onJoinError(int errorCode, String errorTips) {
        MLog.error((Object)this.logTag, (String)"onJoinError!", (Object[])new Object[0]);
        if (this.enterParams != null && this.enterParams.callBack != null) {
            this.enterParams.callBack.onError(errorCode, errorTips);
            this.enterParams.callBack = null;
        }
        this.windowShowManager.onJoinError();
        if (this.callback != null && !this.destroyed) {
            this.callback.onJoinError(this, errorCode);
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        if (!this.onWindowShowned) {
            this.onWindowShowned = true;
            if (this.showPageAfterWindowShown) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ChannelWindowController.this.showPageCommand != null) {
                                    ChannelWindowController.this.showPageCommand.run();
                                }
                            }
                        });
                    }
                });
            }
            final String cid = this.getChannelId();
            ChannelPathLog.getEnterChannelLogger((String)this.getChannelId()).add("Window Shown", new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ChannelPathLog.getEnterChannelLogger((String)cid).end("End By Window Shown 8\u79d2\u540e", new Object[0]);
                }
            }, (long)5000L);
        }
        if (this.gameFilter != null) {
            this.gameFilter.onChannelWindowShown();
        }
        if (RuntimeContext.sIsForeground && this.channel != null) {
            this.channel.getMsgService().inMsgPage();
            MLog.info((Object)this.logTag, (String)"onWindowShown set inMsgPage!", (Object[])new Object[0]);
        } else {
            MLog.info((Object)this.logTag, (String)"onWindowShown!", (Object[])new Object[0]);
        }
        if (this.windowShowManager != null) {
            this.windowShowManager.onWindowShow();
        }
        if (this.drawerManager != null) {
            this.drawerManager.onWindowShow();
        }
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        if (this.channel != null) {
            this.channel.getMsgService().exitMsgPage();
            MLog.info((Object)this.logTag, (String)"onWindowHidden set exitMsgPage!", (Object[])new Object[0]);
        } else {
            MLog.info((Object)this.logTag, (String)"onWindowHidden!", (Object[])new Object[0]);
        }
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        MLog.info((Object)this.logTag, (String)"onWindowAttach!", (Object[])new Object[0]);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_FORCE_LIVE_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_TASK_PAGE_EXIT, (INotify)this);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        MLog.info((Object)this.logTag, (String)"onWindowDetach!", (Object[])new Object[0]);
        super.onWindowDetach(abstractWindow);
        NotificationCenter.getGlobalInstance().unregister(NotificationIdDef.CHANNEL_FORCE_LIVE_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_TASK_PAGE_EXIT, (INotify)this);
        if (this.destroyed) {
            this.windowShowManager.onWindowDestroyFinish();
        }
        if (this.channel != null && this.channel.getEnterParam() != null) {
            this.channel.getMsgService().exitMsgPage();
            EnterParam extraParam = (EnterParam)this.channel.getEnterParam().getExtra("bring_to_front_params", null);
            EnterParam enterParam = extraParam == null ? this.channel.getEnterParam() : extraParam;
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.N_CHANNEL_BACK, (Object)enterParam));
        }
    }

    protected boolean onWindowBackKeyEvent() {
        MLog.info((Object)this.logTag, (String)"onWindowBackKeyEvent!", (Object[])new Object[0]);
        if (this.destroyed) {
            return super.onWindowBackKeyEvent();
        }
        if (this.channel != null) {
            RoomTrack.INSTANCE.leftUpClick(this.getChannelId(), RoomTrack.INSTANCE.getPluginId(this.channel));
        }
        if (null == this.curPluginManager) {
            return super.onWindowBackKeyEvent();
        }
        return this.curPluginManager.onBackClick();
    }

    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        if (keyCode == 24 && event.getAction() == 0) {
            MLog.info((Object)this.logTag, (String)"KEYCODE_VOLUME_UP", (Object[])new Object[0]);
            if (this.getServiceManager() != null && this.getServiceManager().getService(IGameCenterService.class) != null && ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
                VolumeViewManager.INSTANCE.showVolumeView((ViewGroup)this.getCurrentWindow().getExtLayer(), true, 2);
                return true;
            }
        } else if (keyCode == 25 && event.getAction() == 0) {
            MLog.info((Object)this.logTag, (String)"VOLUME_KEY_DOWN", (Object[])new Object[0]);
            if (this.getServiceManager() != null && this.getServiceManager().getService(IGameCenterService.class) != null && ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
                VolumeViewManager.INSTANCE.showVolumeView((ViewGroup)this.getCurrentWindow().getExtLayer(), false, 2);
                return true;
            }
        } else if (keyCode == 4 && event.getAction() == 1 && this.window != null && this.window.onBackKeyEvent()) {
            return true;
        }
        return super.onWindowKeyEvent(keyCode, event);
    }

    public void exitChannel(String channelID) {
        Bundle bundle = new Bundle();
        bundle.putInt("channel_exit_type", 1);
        Message msg = new Message();
        msg.what = AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL;
        msg.arg1 = 1;
        msg.arg2 = -1;
        msg.obj = channelID;
        msg.setData(bundle);
        this.sendMessage(msg);
    }

    protected IMvpContext getPageContext() {
        if (this.curPluginManager != null && this.curPluginManager.getCurPlugin() != null) {
            return this.curPluginManager.getCurPlugin().getMvpContext();
        }
        return null;
    }

    public void minimize() {
        MLog.info((Object)this.logTag, (String)"minimize", (Object[])new Object[0]);
        if (this.window == null || this.channel == null) {
            return;
        }
        if (!this.interceptMinimize()) {
            this.doMinimize();
        }
    }

    private boolean interceptMinimize() {
        IChannelCenterService channelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
        EnterParam enterParam = null;
        if (channelCenterService != null && channelCenterService.getCurrentChannel() != null) {
            enterParam = channelCenterService.getCurrentChannel().getEnterParam();
        }
        if (enterParam == null) {
            return false;
        }
        Bundle bundle = new Bundle();
        bundle.putString("channelId", enterParam.roomId);
        bundle.putLong("enterStartTime", enterParam.enterStartTime);
        Message msg = new Message();
        msg.what = GrowthMsgDef.ROOM_EXIT_RECOMD_INTERCEPT_MINIMIZE;
        msg.setData(bundle);
        msg.obj = () -> this.doMinimize();
        Object result = MsgDispatcher.getInstance().sendMessageSync(msg);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    private void doMinimize() {
        if (this.miniHelper == null) {
            this.miniHelper = new MiniHelper(this.logTag, new MiniHelper.ICallback(){

                @Override
                public void exitChannel(String channelID) {
                    ChannelWindowController.this.exitChannel(channelID);
                }

                @Override
                public IChannel getChannel() {
                    return ChannelWindowController.this.channel;
                }

                @Override
                public String getChannelId() {
                    return ChannelWindowController.this.getChannelId();
                }

                @Override
                public EnterParam getEnterParam() {
                    return ChannelWindowController.this.enterParams;
                }

                @Override
                public void popWindow(boolean ani) {
                    if (ChannelWindowController.this.window != null && ChannelWindowController.this.mWindowMgr.isWinInStack((AbstractWindow)ChannelWindowController.this.window)) {
                        ChannelWindowController.this.mWindowMgr.popWindow(ani && ChannelWindowController.this.enableAni(), (AbstractWindow)ChannelWindowController.this.window);
                    }
                }

                @Override
                public AbsPlugin<AbsPage, IChannelPageContext<AbsPage>> getPlugin() {
                    if (ChannelWindowController.this.curPluginManager == null) {
                        return null;
                    }
                    return ChannelWindowController.this.curPluginManager.getCurPlugin();
                }
            });
        }
        this.miniHelper.minimize();
        if (this.callback != null) {
            this.callback.onAfterMinimize(this.getChannelId());
        }
        if (this.enterParams != null && this.enterParams.extra != null && this.enterParams.extra.containsKey("goback") && "follow".equals(this.enterParams.extra.get("goback"))) {
            ((IHomeService)this.getServiceManager().getService(IHomeService.class)).toDiscover(DiscoverPageType.FOLLOW, false, -1, "");
        }
        if (this.channel != null) {
            this.channel.getTeamUpService().interceptOnBackClick();
        }
    }

    public void continueScroll(int scrollType) {
        if (this.windowShowManager != null) {
            this.windowShowManager.continueScroll(scrollType);
        }
    }

    public IChannelListDrawer getChannelListDrawerListener() {
        return this.drawerManager.getDrawer();
    }

    public void updateSwipeEnable(boolean enable) {
        if (this.windowShowManager != null) {
            this.windowShowManager.swipeEnable(enable);
        }
    }

    @Override
    public void destroy(boolean popWinAni) {
        ChannelPathLog.getEnterChannelLogger((String)this.getChannelId()).end("End By Destroy!", new Object[0]);
        this.destroy(popWinAni, null, null, false, null, 0);
    }

    @Override
    public void destroy(boolean popWinAni, IVoiceRoomExitCallback callbackWhenExited, Map<String, Object> extMap, boolean notLeaveRequest, String nextJoinSuccessChannel, int nextJoinSuccessEntry) {
        this.destroy(popWinAni, callbackWhenExited, extMap, notLeaveRequest, nextJoinSuccessChannel, nextJoinSuccessEntry, false);
    }

    @Override
    public void destroy(boolean popWinAni, IVoiceRoomExitCallback callbackWhenExited, Map<String, Object> extMap, boolean notLeaveRequest, String nextJoinSuccessChannel, int nextJoinSuccessEntry, boolean callLeaveBaseGroupcast) {
        this.intercepter = null;
        ChannelPluginData beforePluginData = null;
        if (this.curPluginManager != null && this.curPluginManager.getCurPlugin() != null) {
            beforePluginData = this.curPluginManager.getCurPlugin().getPluginData();
        }
        if (!this.destroyFinished && callbackWhenExited != null) {
            if (this.destroyCallback == null) {
                this.destroyCallback = new ArrayList();
            }
            this.destroyCallback.add(callbackWhenExited);
        } else if (callbackWhenExited != null) {
            callbackWhenExited.onExit(true);
        }
        MLog.info((Object)this.logTag, (String)"destroy! destroyed\uff1a%b", (Object[])new Object[]{this.destroyed});
        if (this.destroyed) {
            return;
        }
        if (this.callback != null) {
            this.callback.preDestroy(this);
        }
        this.destroyed = true;
        IMediaRoomService service = (IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class);
        if (service != null) {
            service.destroyRoom(this.enterParams.roomId);
        }
        final ChannelPluginData finalBeforePluginData = beforePluginData;
        PluginManager temPlug = this.curPluginManager;
        IChannelDrawerManager tempDrawer = this.drawerManager;
        Runnable destroyCommand = () -> {
            IChannel mainChannel;
            Object curPlayingGame;
            this.joinSuccessed = false;
            if (null != temPlug) {
                temPlug.preDestroy();
            }
            if (this.enterParams.callBack != null) {
                this.enterParams.callBack.onError(1000002, "");
                this.enterParams.callBack = null;
            }
            if (nextJoinSuccessEntry != 24 && this.window != null) {
                if (!this.window.isAttachToWindow()) {
                    MLog.error((Object)this.logTag, (String)"popWindow with no attach!!!!!", (Object[])new Object[0]);
                }
                if (this.mWindowMgr.isWinInStack((AbstractWindow)this.window)) {
                    try {
                        this.mWindowMgr.popWindow(popWinAni && this.enableAni(), (AbstractWindow)this.window);
                    }
                    catch (Exception e) {
                        MLog.error((Object)this.logTag, (Throwable)e);
                    }
                }
            }
            if (this.channel != null && !notLeaveRequest) {
                MLog.info((Object)this.logTag, (String)"play leave channel request!", (Object[])new Object[0]);
                if (callLeaveBaseGroupcast) {
                    this.channel.leaveBroadcastGroup(new IChannel.ILeaveCallBack(){

                        public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                            ChannelWindowController.checkShowResult(ChannelWindowController.this.channel, leaveResp, finalBeforePluginData);
                        }

                        public void onError(int errorCode, String errorTips, Exception e) {
                        }
                    });
                }
                this.channel.leave(new IChannel.ILeaveCallBack(){

                    public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                        ChannelWindowController.checkShowResult(ChannelWindowController.this.channel, leaveResp, finalBeforePluginData);
                    }

                    public void onError(int errorCode, String errorTips, Exception e) {
                    }
                });
            } else {
                MLog.info((Object)this.logTag, (String)"not play leave channel request!", (Object[])new Object[0]);
            }
            MLog.info((Object)this.logTag, (String)"enter params :%s", (Object[])new Object[]{this.enterParams});
            if (!(this.gameFilter == null || (curPlayingGame = ((IGameCenterService)ServiceManagerProxy.getInstance().getService(IGameCenterService.class)).getCurPlayingGame()) != null && this.enterParams != null && this.enterParams.entry == 23 && this.enterParams.mFromCreateParams != null && StringUtils.equals((String)this.enterParams.mFromCreateParams.source, (String)"hago.indiegame") || this.enterParams != null && EnterParam.isGameOpenEntry((int)this.enterParams.entry) && !this.enterParams.forceExitGame || RuntimeContext.getCoexistenceChannel() != null && StringUtils.equal((String)RuntimeContext.getCoexistenceChannel().getRoomId(), (String)this.channel.getChannelId()) && RuntimeContext.getCurMainChannel() != null && (mainChannel = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(RuntimeContext.getCurMainChannel().getRoomId())) != null && mainChannel.getBaseRoomGameService().getGameContextData() != null && mainChannel.getBaseRoomGameService().getGameContextData().getGamePlaying())) {
                this.gameFilter.onExitChannel();
            }
            if (this.channel != null) {
                ChannelLifecycle.INSTANCE.onExit(this.channel);
                ChannelPlayInfoService.Companion.exitChannel(this.channel);
            }
            ChannelKeepAliveService.stopForegroundService(this.getChannelId());
            if (this.callback != null) {
                this.callback.onChannelDestroyed(this);
            }
            if (this.destroyCallback != null && this.destroyCallback.size() > 0) {
                for (IVoiceRoomExitCallback callback2 : this.destroyCallback) {
                    callback2.onExit(true);
                }
                this.destroyCallback.clear();
                this.destroyCallback = null;
            }
            this.destroyFinished = true;
            this.destroy();
            MLog.info((Object)this.logTag, (String)"LeakCanary watch destroy window !", (Object[])new Object[0]);
            if (this.window != null) {
                SwordHelper.leakWatch((Object)((Object)this.window));
            }
            if (tempDrawer != null) {
                tempDrawer.onDestroy();
            }
            if (null != temPlug) {
                temPlug.destroy();
            }
            this.windowShowManager.onDestroy();
            if (this.window != null && !this.mWindowMgr.isWinInStack((AbstractWindow)this.window)) {
                this.windowShowManager.onWindowDestroyFinish();
            }
            if (nextJoinSuccessEntry != 24) {
                ChannelWindow fWindow = this.window;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable((AbstractWindow)fWindow){
                    final /* synthetic */ AbstractWindow val$fWindow;
                    {
                        this.val$fWindow = abstractWindow;
                    }

                    @Override
                    public void run() {
                        AbstractWindow viewGroup = this.val$fWindow;
                        if (viewGroup != null && (SystemUtils.isShowEnvSetting() || SettingFlags.getIntValue((String)"channelWindowrecycle", (int)1) == 1)) {
                            RemoveViewUtils.INSTANCE.removeAllViews((ViewGroup)viewGroup, true);
                        }
                    }
                });
                this.window = null;
            }
            if (this.enterParams != null && this.enterParams.guideGameConfig != null) {
                MLog.info((Object)this.logTag, (String)"start guide game:%s", (Object[])new Object[]{this.enterParams.guideGameConfig.gid});
                ((IYYUriService)ServiceManagerProxy.getService(IYYUriService.class)).handleUriString(StringUtils.formatWitUSLocal((String)"hago://channel/toGuideQuickJoin?gid=%s&%s=true", (Object[])new Object[]{this.enterParams.guideGameConfig.gid, "lightGuide"}));
            }
            MLog.info((Object)this.logTag, (String)"destroyed!", (Object[])new Object[0]);
        };
        if (null != this.curPluginManager && this.curPluginManager.getCurPlugin() != null) {
            this.curPluginManager.getCurPlugin().handlePreDestroy(destroyCommand::run);
        } else {
            destroyCommand.run();
        }
        this.drawerManager = null;
        this.curPluginManager = null;
        this.unregisterFromMsgDispatcher();
    }

    private void handleForeGround(boolean fore) {
        MLog.info((Object)this.logTag, (String)"handleForeGround:%s!", (Object[])new Object[]{fore ? "true" : "false"});
        if (this.window != null && this.mWindowMgr.getCurrentWindow() == this.window) {
            this.window.handleForeground(fore);
        }
        if (fore && this.mWindowMgr.getCurrentWindow() == this.window) {
            if (this.channel != null) {
                this.channel.getMsgService().inMsgPage();
            }
        } else if (this.channel != null) {
            this.channel.getMsgService().exitMsgPage();
        }
        if (!this.destroyed && this.channel != null) {
            if (fore) {
                MLog.info((Object)this.logTag, (String)"stopForegroundService:%s!", (Object[])new Object[0]);
                ChannelKeepAliveService.stopForegroundService(this.getChannelId());
            } else {
                this.startForegroundService();
            }
        }
    }

    protected void startForegroundService() {
        boolean should = true;
        if (this.intercepter != null) {
            should = this.intercepter.shouldStartForegroundService();
        }
        if (should) {
            MLog.info((Object)this.logTag, (String)"startForegroundService:%s!", (Object[])new Object[0]);
            ChannelDetailInfo detailInfo = this.channel.getDataService().getChannelDetailInfo(null);
            if (detailInfo != null && detailInfo.baseInfo != null && detailInfo.baseInfo.name != null) {
                ChannelKeepAliveService.startForegroundService(this.getChannelId(), detailInfo.baseInfo.name, this.getShowFloatWin());
            } else {
                ChannelKeepAliveService.startForegroundService(this.getChannelId(), "", this.getShowFloatWin());
            }
        }
    }

    private boolean getShowFloatWin() {
        boolean isTeamUpGame = this.channel.getTeamUpService().isTeamUpGame();
        boolean hasFloatWinPermission = PermissionHelper.hasFloatWinPermission((Activity)this.mEnvironment.getActivity()) || PermissionHelper.filterVivoDevice();
        boolean canShowFloatWin = this.channel.getTeamUpService().canShowFloatWin();
        return isTeamUpGame && hasFloatWinPermission && canShowFloatWin;
    }

    @Override
    public final void notify(Notification notification) {
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (!RuntimeContext.isHagoPartySdk() && notification.extObj != null) {
                this.handleForeGround((Boolean)notification.extObj);
            }
        } else if (notification.id == NotificationDef.N_MAIN_ACTIVITY_STOP) {
            this.handleForeGround(false);
        } else if (notification.id == NotificationDef.N_PARTY_SDK_ACTIVITY_RESUME) {
            this.handleForeGround(true);
        } else if (notification.id == NotificationIdDef.CHANNEL_FORCE_LIVE_MSG) {
            if (notification.extObj != null) {
                this.continueScroll((Integer)notification.extObj);
            }
        } else if (notification.id == NotificationDef.N_TASK_PAGE_EXIT) {
            ((FamilyGroupPresenter)this.getPageContext().getPresenter(FamilyGroupPresenter.class)).expandChatWindow();
        }
    }

    @Override
    public final void handleMessage(Message msg) {
        if (this.curPluginManager == null || msg == null) {
            MLog.error((Object)this.logTag, (String)"handleMessage msgId:%d, but no plugin handle!", (Object[])new Object[]{msg.what});
            return;
        }
        MLog.info((Object)this.logTag, (String)"handleMessage msgId:%d!", (Object[])new Object[]{msg.what});
        this.curPluginManager.handleMessage(msg);
    }

    @Override
    public final Object handleMessageSync(Message msg) {
        if (this.curPluginManager == null || msg == null) {
            MLog.error((Object)this.logTag, (String)"handleMessageSync msgId:%d, but no plugin handle!", (Object[])new Object[]{msg.what});
            return null;
        }
        MLog.info((Object)this.logTag, (String)"handleMessageSync msgId:%d!", (Object[])new Object[]{msg.what});
        if (msg.what == ChannelBaseMsgDef.MSG_CHECK_BACK && !(this.mWindowMgr.getCurrentWindow() instanceof ChannelWindow)) {
            return false;
        }
        return this.curPluginManager.handleMessageSync(msg);
    }

    static void checkShowResult(IChannel channel, ChannelLeaveResp leaveResp, ChannelPluginData beforePluginData) {
        ExitResultHelper.checkShowResult(channel, leaveResp, beforePluginData);
    }

    private MyChannelGameFilter ensureGameFilter() {
        if (this.gameFilter == null) {
            this.gameFilter = new MyChannelGameFilter(this.logTag, new MyChannelGameFilter.ICallback(){

                @Override
                public IChannel getChannel() {
                    return ChannelWindowController.this.channel;
                }

                @Override
                public boolean handleGameFilter(FilterRunnable runnable2) {
                    return ChannelWindowController.this.handleGameFilter(runnable2);
                }

                @Override
                public void exit() {
                    ChannelWindowController.this.destroy(false);
                }
            });
        }
        return this.gameFilter;
    }

    @Override
    public void setIntercepter(IChannelWindowController.IIntercepter intercepter) {
        this.intercepter = intercepter;
    }

    protected boolean handleGameFilter(FilterRunnable runnable2) {
        if (this.intercepter != null) {
            return this.intercepter.handleGameFilter(this, runnable2);
        }
        return this.handleGameFilterInner(this.gameFilter, runnable2);
    }

    protected boolean shouldHandle(FilterRunnable runnable2) {
        return MyChannelGameFilter.shouldHandle(runnable2);
    }

    protected boolean handleGameFilterInner(MyChannelGameFilter gameFilter, FilterRunnable runnable2) {
        return MyChannelGameFilter.handleGameFilterInner(gameFilter, runnable2);
    }

    private void showOpenListGuide(AbsPlugin plugin) {
        if (!this.destroyed && this.drawerManager != null && !SettingFlags.getBoolean((String)"key_channel_list_open_guide", (boolean)false)) {
            this.drawerManager.setPluginPage(plugin.providePage());
            SettingFlags.setBoolean((String)"key_channel_list_open_guide", (boolean)true);
        }
    }

    private void autoOpenChannelListDrawer() {
        if (this.enterParams != null && !this.enterParams.canAutoOpenDrawerList) {
            return;
        }
        YYTaskExecutor.postToMainThread(() -> {
            int hasOpenCount;
            CommonConfigData data2;
            int configCounts = 3;
            AConfigData config2 = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
            if (config2 instanceof CommonConfig && (data2 = ((CommonConfig)config2).getData()) != null) {
                configCounts = data2.autoOpenChannelListCount;
            }
            if (((hasOpenCount = SettingFlags.getIntValue((String)"key_channel_open_list_count", (int)0)) == 0 || hasOpenCount + 1 == configCounts) && this.drawerManager != null) {
                this.drawerManager.openChannelListDrawer();
            }
            if (hasOpenCount <= configCounts) {
                SettingFlags.setIntValue((String)"key_channel_open_list_count", (int)(hasOpenCount + 1));
            }
        }, (long)2000L);
    }

    private boolean enableAni() {
        IAB joinTypeABValue;
        if (RuntimeContext.getPhoneType() == 1) {
            return false;
        }
        if (RuntimeContext.getPhoneType() == 2 && (joinTypeABValue = EnterParam.getMiddlePhoneEnableAni()) != null && (NAB.B.equals((Object)joinTypeABValue) || NAB.D.equals((Object)joinTypeABValue))) {
            return false;
        }
        return !RuntimeContext.isHagoPartySdk() || !this.isDelayShowWindow;
    }

    public static interface ICallback {
        public void preJoinSuccess(IChannelWindowController var1, Runnable var2, String var3);

        public void onJoinSuccess(EnterParam var1, EnterChannelData var2, IChannelWindowController var3);

        default public void onJoinSuccess(EnterParam requestParams, EnterChannelData data2, IChannelWindowController controller, boolean resumeFromBg) {
        }

        public void onJoinError(IChannelWindowController var1, int var2);

        public IChannel.IJoinCallBack getJoinErrorHandler(EnterParam var1);

        public void preDestroy(IChannelWindowController var1);

        public void onChannelDestroyed(IChannelWindowController var1);

        public void onBeforeMinimize(IInterceptMiniCallaback var1);

        public void onAfterMinimize(String var1);
    }
}

