/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow.protocol;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.VersionData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.follow.IFollowProtoCallback;
import com.yy.hiyo.channel.follow.IFollowProtoService;
import com.yy.hiyo.channel.module.follow.protocol.ProtoHelper;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.util.List;
import net.ihago.room.srv.follow.GetNoticeUserChannelInfoReq;
import net.ihago.room.srv.follow.GetNoticeUserChannelInfoRes;
import net.ihago.room.srv.follow.PullFollowListReq;
import net.ihago.room.srv.follow.PullFollowListRes;
import net.ihago.room.srv.follow.PullNoticeChannelListReq;
import net.ihago.room.srv.follow.PullNoticeChannelListRes;
import net.ihago.room.srv.follow.Relation;
import net.ihago.room.srv.follow.User;

public class FollowProtoService
implements IFollowProtoService {
    private static final String TAG = "FollowProtoService";
    private VersionData<PullFollowListRes> followListData = new VersionData();

    public static FollowProtoService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private FollowProtoService() {
    }

    public void requestFollowListData(final long uid, final IFollowProtoCallback<PullFollowListRes> callback2) {
        boolean net = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        MLog.info((Object)TAG, (String)"requestFollowListData, uid= %d, net: %b", (Object[])new Object[]{uid, net});
        if (!net) {
            ProtoHelper.handleOnFail(callback2, 250, "network is invalid");
            return;
        }
        final long startTime = SystemClock.uptimeMillis();
        PullFollowListReq req = new PullFollowListReq.Builder().uid(Long.valueOf(uid)).version(Long.valueOf(this.followListData.getVersion())).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<PullFollowListRes>(){

            public void onResponse(@Nullable PullFollowListRes message) {
                long useTime = SystemClock.uptimeMillis() - startTime;
                if (message == null) {
                    FollowProtoService.statMetric("follow/followlist", useTime, false, 5002L);
                    ProtoHelper.handleOnFail(callback2, 5002, "result is null");
                } else if (ProtoHelper.isFail(message.err)) {
                    FollowProtoService.statMetric("follow/followlist", useTime, false, FP.orInt((Long)message.err.code));
                    ProtoHelper.handleOnFail(callback2, FP.orInt((Long)message.err.code), message.err.tips);
                } else {
                    FollowProtoService.statMetric("follow/followlist", useTime, true, 0L);
                    if (message.version.longValue() == FollowProtoService.this.followListData.getVersion()) {
                        FollowProtoService.this.followListData.setVersion(message.version.longValue());
                        ProtoHelper.handleOnSuccess(callback2, FollowProtoService.this.followListData.getData());
                    } else {
                        FollowProtoService.this.followListData.setVersion(message.version.longValue());
                        FollowProtoService.this.followListData.setData((Object)message);
                        ProtoHelper.handleOnSuccess(callback2, message);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)FollowProtoService.TAG, (String)"requestFollowListData, uid=%s, timeout", (Object[])new Object[]{uid});
                FollowProtoService.statMetric("follow/followlist", SystemClock.uptimeMillis() - startTime, false, 99L);
                ProtoHelper.handleOnFail(callback2, 5001, "request timeout");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)FollowProtoService.TAG, (String)"requestFollowListData, uid=%s, error code=%d, reason=%s", (Object[])new Object[]{uid, code, reason});
                FollowProtoService.statMetric("follow/followlist", SystemClock.uptimeMillis() - startTime, false, code);
                ProtoHelper.handleOnFail(callback2, code, reason);
                return false;
            }
        });
    }

    private static void statMetric(String key, long useTime, boolean success, long errorCode) {
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            if (!(success || ProtoManager.getInstance().isWSConnected() && NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext))) {
                HiidoStatis.reportAppMonitorReturnCode((String)key, (long)useTime, (String)String.valueOf(250));
            } else {
                HiidoStatis.reportAppMonitorReturnCode((String)key, (long)useTime, (String)String.valueOf(success ? 0L : errorCode));
            }
        }
    }

    private User getUser() {
        long uid = AccountUtil.getUid();
        String hid = HiidoUtils.getHdid();
        String os = "android";
        String lan = this.languageCode();
        String region = this.countryCode();
        int age = SettingFlags.getIntValue((String)"key_myself_age", (int)-1);
        int sex = SettingFlags.getIntValue((String)"key_myself_sex", (int)-1);
        User user = new User.Builder().uid(Long.valueOf(uid)).hdid(hid).os(os).lan(lan).region(region).age(Integer.valueOf(age)).sex(Integer.valueOf(sex)).build();
        return user;
    }

    private String countryCode() {
        String code = AccountUtil.realCountry();
        if (TextUtils.isEmpty((CharSequence)code)) {
            code = SystemUtils.getHagoCountry();
        }
        if (code == null) {
            return "";
        }
        return code.toUpperCase();
    }

    private String languageCode() {
        String code = SystemUtils.getLang();
        if (code == null) {
            return "";
        }
        return code.toLowerCase();
    }

    public void requestNoticeList(final IFollowProtoCallback<PullNoticeChannelListRes> callback2, final boolean needFriend) {
        MLog.info((Object)TAG, (String)"requestNoticeList needFriend:%d", (Object[])new Object[]{needFriend ? 1 : 0});
        PullNoticeChannelListReq req = new PullNoticeChannelListReq.Builder().user(this.getUser()).need_friends(Boolean.valueOf(needFriend)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<PullNoticeChannelListRes>(){

            public void onResponse(@NonNull PullNoticeChannelListRes message, long code, String msg) {
                if (message == null) {
                    ProtoHelper.handleOnFail(callback2, 5002, "result is null");
                } else if (!ProtoManager.isSuccessCode((long)code)) {
                    ProtoHelper.handleOnFail(callback2, (int)code, msg);
                } else {
                    MLog.info((Object)FollowProtoService.TAG, (String)"requestNoticeList needFriend:%d, success!", (Object[])new Object[]{needFriend ? 1 : 0});
                    ProtoHelper.handleOnSuccess(callback2, message);
                }
            }

            public void onResponse(@Nullable PullNoticeChannelListRes message) {
                super.onResponse((AndroidMessage)message);
                if (message != null) {
                    ProtoHelper.handleOnSuccess(callback2, message);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                ProtoHelper.handleOnFail(callback2, 5001, "request timeout");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                ProtoHelper.handleOnFail(callback2, code, reason);
                return false;
            }
        });
    }

    public void requestNoticeUserList(List<Long> uidList, final IFollowProtoCallback<GetNoticeUserChannelInfoRes> callback2) {
        GetNoticeUserChannelInfoReq req = new GetNoticeUserChannelInfoReq.Builder().uids(uidList).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetNoticeUserChannelInfoRes>(){

            public void onResponse(@NonNull GetNoticeUserChannelInfoRes message, long code, String msg) {
                if (message == null) {
                    ProtoHelper.handleOnFail(callback2, 5002, "result is null");
                } else if (!ProtoManager.isSuccessCode((long)code)) {
                    ProtoHelper.handleOnFail(callback2, (int)code, msg);
                } else {
                    ProtoHelper.handleOnSuccess(callback2, message);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                ProtoHelper.handleOnFail(callback2, 5001, "request timeout");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                ProtoHelper.handleOnFail(callback2, code, reason);
                return false;
            }
        });
    }

    public static interface IFollowStatusCallback {
        public void onSuccess(List<Long> var1, List<Relation> var2);

        public void onFailed(int var1, String var2);
    }

    private static final class InstanceHolder {
        static final FollowProtoService INSTANCE = new FollowProtoService();

        private InstanceHolder() {
        }
    }
}

