/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow.list.reminderlist;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.data.PageData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.ReminderDetails;
import com.yy.hiyo.channel.follow.IFollowProtoCallback;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ReminderListModel;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ReminderListMvp;
import com.yy.hiyo.channel.module.roomrecordpage.StreamerReminderRecordRepository;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ihago.channel.srv.edge.NoticeChannelInfo;
import org.jetbrains.annotations.NotNull;

public class ReminderListPresenter
extends BasePresenter<IMvpContext>
implements ReminderListMvp.IPresenter {
    private MutableLiveData<PageData<ReminderDetails>> mReminderNextPageData = new MutableLiveData();
    private MutableLiveData<Integer> mListTotalData = new MutableLiveData();
    private ReminderListMvp.IModel mReminderListModel = new ReminderListModel();
    private ReminderListMvp.IView mRemindrListView;

    public ReminderListPresenter(IMvpContext mvpContext, @NotNull ReminderListMvp.IView view2) {
        super(mvpContext);
        this.mRemindrListView = view2;
    }

    @Override
    public void onReminderListRefresh() {
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u5237\u65b0", (Object[])new Object[0]);
        this.mReminderListModel.reminderListRefresh(new IFollowProtoCallback<PageData<ReminderDetails>>(){

            public void onSuccess(@NotNull PageData<ReminderDetails> data2) {
                ReminderListPresenter.this.mRemindrListView.clearStatus();
                ReminderListPresenter.this.mReminderNextPageData.setValue(data2);
                ReminderListPresenter.this.mListTotalData.setValue((Object)data2.getTotal());
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u5237\u65b0\u6210\u529f, %s", (Object[])new Object[]{data2});
                List infos = data2.getData();
                if (!FP.empty((Collection)infos)) {
                    ArrayList<String> cids = new ArrayList<String>();
                    for (ReminderDetails next : infos) {
                        NoticeChannelInfo noticeUserInfo = next.getNoticeUserInfo();
                        if (noticeUserInfo == null || !StringUtils.isNotEmpty((String)noticeUserInfo.channel_id)) continue;
                        cids.add(noticeUserInfo.channel_id);
                    }
                    ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).preloadRoomMiddleInfos(cids);
                }
            }

            public void onFail(int code, String msg) {
                ReminderListPresenter.this.mRemindrListView.clearStatus();
                ReminderListPresenter.this.mReminderNextPageData.setValue(null);
                FeatureLog.e((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u5237\u65b0\u5931\u8d25, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    @Override
    public void onReminderListLoadmore(boolean isNeedPullNoInRoom) {
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875", (Object[])new Object[0]);
        this.mReminderListModel.reminderListNextPage(isNeedPullNoInRoom, new IFollowProtoCallback<PageData<ReminderDetails>>(){

            public void onSuccess(@NotNull PageData<ReminderDetails> data2) {
                ReminderListPresenter.this.mRemindrListView.clearStatus();
                ReminderListPresenter.this.mReminderNextPageData.setValue(data2);
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875\u6210\u529f, %s", (Object[])new Object[]{data2});
            }

            public void onFail(int code, String msg) {
                ReminderListPresenter.this.mRemindrListView.clearStatus();
                ReminderListPresenter.this.mReminderNextPageData.setValue(null);
                FeatureLog.e((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875\u5931\u8d25, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    @Override
    public LiveData<Integer> listTotal() {
        return this.mListTotalData;
    }

    @Override
    public LiveData<PageData<ReminderDetails>> nextPage() {
        return this.mReminderNextPageData;
    }

    public void addReminderRecord(long uid, DataCallback<Long> callback2) {
        StreamerReminderRecordRepository.INSTANCE.addRecord(uid, callback2);
    }

    public void addReminderRecordDb(long uid) {
        StreamerReminderRecordRepository.INSTANCE.addRecordItem(uid);
    }

    public void getTodayAllReminderRecord(DataCallback<List<Long>> callback2) {
        StreamerReminderRecordRepository.INSTANCE.getTodayAllRecord(callback2);
    }

    public boolean checkIsReminder(long uid) {
        return StreamerReminderRecordRepository.INSTANCE.checkIsReminder(uid);
    }
}

