/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator.partypage.item;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.play.game.GameListPresenter;
import com.yy.hiyo.channel.component.play.game.OnRoomGameItemClick;
import com.yy.hiyo.game.base.bean.GameInfo;

public class PartyGameViewHolder
extends RecyclerView.ViewHolder {
    private RoundConerImageView mGameIcon;
    private View mIvCover;
    private TextView mGameName;
    private GameInfo mGameInfo;
    private OnRoomGameItemClick mClickListener;

    public PartyGameViewHolder(View itemView) {
        super(itemView);
        this.mGameIcon = (RoundConerImageView)itemView.findViewById(R.id.iv_game_list_header);
        this.mIvCover = itemView.findViewById(R.id.iv_choosen_cover);
        this.mGameIcon.setAutoTransformToWebpFlag(false);
        this.mGameName = (TextView)itemView.findViewById(R.id.game_name);
        itemView.setOnClickListener(v -> {
            if (this.mClickListener != null) {
                this.mClickListener.onClick(this.mGameInfo);
            }
        });
    }

    public void bindView(GameInfo info, boolean selected) {
        this.mGameInfo = info;
        if (this.mGameInfo == null) {
            return;
        }
        this.mGameName.setText((CharSequence)this.mGameInfo.getGname());
        if (GameListPresenter.isComeSoonGame(this.mGameInfo)) {
            ImageLoader.loadImage((ImageView)this.mGameIcon, (int)R.drawable.icon_game_default);
        } else if (GameListPresenter.isTurnTableGame(this.mGameInfo)) {
            ImageLoader.loadImage((ImageView)this.mGameIcon, (int)R.drawable.game_turntable);
        } else {
            ImageLoader.loadImage((ImageView)this.mGameIcon, (String)this.mGameInfo.getIconUrl());
        }
        if (selected) {
            this.mIvCover.setVisibility(0);
            this.mIvCover.setScaleX(1.05f);
            this.mIvCover.setScaleY(1.05f);
            this.mGameIcon.setScaleX(1.05f);
            this.mGameIcon.setScaleY(1.05f);
        } else {
            this.mIvCover.setVisibility(8);
            this.mIvCover.setScaleX(1.0f);
            this.mIvCover.setScaleY(1.0f);
            this.mGameIcon.setScaleX(1.0f);
            this.mGameIcon.setScaleY(1.0f);
        }
    }

    public void setOnItemClick(OnRoomGameItemClick click) {
        this.mClickListener = click;
    }
}

