/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator.carouse;

import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.hiyo.channel.module.creator.carouse.ItemTransformation;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CarouselLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int INVALID_POSITION = -1;
    public static final int MAX_VISIBLE_ITEMS = 2;
    private static final boolean CIRCLE_LAYOUT = false;
    private boolean mDecoratedChildSizeInvalid;
    private Integer mDecoratedChildWidth;
    private Integer mDecoratedChildHeight;
    private final int mOrientation;
    private final boolean mCircleLayout;
    private int mPendingScrollPosition;
    private final LayoutHelper mLayoutHelper = new LayoutHelper(2);
    private PostLayoutListener mViewPostLayout;
    private final List<OnCenterItemSelectionListener> mOnCenterItemSelectionListeners = new ArrayList<OnCenterItemSelectionListener>();
    private int mCenterItemPosition = -1;
    private int mItemsCount;
    @Nullable
    private CarouselSavedState mPendingCarouselSavedState;

    public CarouselLayoutManager(int orientation) {
        this(orientation, false);
    }

    public CarouselLayoutManager(int orientation, boolean circleLayout) {
        if (0 != orientation && 1 != orientation) {
            throw new IllegalArgumentException("orientation should be HORIZONTAL or VERTICAL");
        }
        this.mOrientation = orientation;
        this.mCircleLayout = circleLayout;
        this.mPendingScrollPosition = -1;
    }

    public void setPostLayoutListener(@Nullable PostLayoutListener postLayoutListener) {
        this.mViewPostLayout = postLayoutListener;
        this.requestLayout();
    }

    @CallSuper
    public void setMaxVisibleItems(int maxVisibleItems) {
        if (0 >= maxVisibleItems) {
            throw new IllegalArgumentException("maxVisibleItems can't be less then 1");
        }
        this.mLayoutHelper.mMaxVisibleItems = maxVisibleItems;
        this.requestLayout();
    }

    public int getMaxVisibleItems() {
        return this.mLayoutHelper.mMaxVisibleItems;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public boolean canScrollHorizontally() {
        return 0 != this.getChildCount() && 0 == this.mOrientation;
    }

    public boolean canScrollVertically() {
        return 0 != this.getChildCount() && 1 == this.mOrientation;
    }

    public int getCenterItemPosition() {
        return this.mCenterItemPosition;
    }

    public void addOnItemSelectionListener(@NonNull OnCenterItemSelectionListener onCenterItemSelectionListener) {
        this.mOnCenterItemSelectionListeners.add(onCenterItemSelectionListener);
    }

    public void removeOnItemSelectionListener(@NonNull OnCenterItemSelectionListener onCenterItemSelectionListener) {
        this.mOnCenterItemSelectionListeners.remove(onCenterItemSelectionListener);
    }

    public void scrollToPosition(int position) {
        if (0 > position) {
            throw new IllegalArgumentException("position can't be less then 0. position is : " + position);
        }
        this.mPendingScrollPosition = position;
        this.requestLayout();
    }

    public void smoothScrollToPosition(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

            public int calculateDyToMakeVisible(View view2, int snapPreference) {
                if (!CarouselLayoutManager.this.canScrollVertically()) {
                    return 0;
                }
                return CarouselLayoutManager.this.getOffsetForCurrentView(view2);
            }

            public int calculateDxToMakeVisible(View view2, int snapPreference) {
                if (!CarouselLayoutManager.this.canScrollHorizontally()) {
                    return 0;
                }
                return CarouselLayoutManager.this.getOffsetForCurrentView(view2);
            }
        };
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
    }

    @Nullable
    public PointF computeScrollVectorForPosition(int targetPosition) {
        if (0 == this.getChildCount()) {
            return null;
        }
        float directionDistance = this.getScrollDirection(targetPosition);
        int direction = (int)(-Math.signum(directionDistance));
        if (0 == this.mOrientation) {
            return new PointF((float)direction, 0.0f);
        }
        return new PointF(0.0f, (float)direction);
    }

    private float getScrollDirection(int targetPosition) {
        float currentScrollPosition = CarouselLayoutManager.makeScrollPositionInRange0ToCount(this.getCurrentScrollPosition(), this.mItemsCount);
        if (this.mCircleLayout) {
            float t1 = currentScrollPosition - (float)targetPosition;
            float t2 = Math.abs(t1) - (float)this.mItemsCount;
            if (Math.abs(t1) > Math.abs(t2)) {
                return Math.signum(t1) * t2;
            }
            return t1;
        }
        return currentScrollPosition - (float)targetPosition;
    }

    public int scrollVerticallyBy(int dy, @NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state) {
        if (0 == this.mOrientation) {
            return 0;
        }
        return this.scrollBy(dy, recycler, state);
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (1 == this.mOrientation) {
            return 0;
        }
        return this.scrollBy(dx, recycler, state);
    }

    @CallSuper
    protected int scrollBy(int diff, @NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state) {
        int maxOffset;
        int resultScroll;
        if (null == this.mDecoratedChildWidth || null == this.mDecoratedChildHeight) {
            return 0;
        }
        if (0 == this.getChildCount() || 0 == diff) {
            return 0;
        }
        if (this.mCircleLayout) {
            LayoutHelper layoutHelper;
            resultScroll = diff;
            LayoutHelper layoutHelper2 = this.mLayoutHelper;
            layoutHelper2.mScrollOffset = layoutHelper2.mScrollOffset + resultScroll;
            maxOffset = this.getScrollItemSize() * this.mItemsCount;
            while (0 > this.mLayoutHelper.mScrollOffset) {
                layoutHelper = this.mLayoutHelper;
                layoutHelper.mScrollOffset = layoutHelper.mScrollOffset + maxOffset;
            }
            while (this.mLayoutHelper.mScrollOffset > maxOffset) {
                layoutHelper = this.mLayoutHelper;
                layoutHelper.mScrollOffset = layoutHelper.mScrollOffset - maxOffset;
            }
            layoutHelper = this.mLayoutHelper;
            layoutHelper.mScrollOffset = layoutHelper.mScrollOffset - resultScroll;
        } else {
            maxOffset = this.getMaxScrollOffset();
            resultScroll = 0 > this.mLayoutHelper.mScrollOffset + diff ? -this.mLayoutHelper.mScrollOffset : (this.mLayoutHelper.mScrollOffset + diff > maxOffset ? maxOffset - this.mLayoutHelper.mScrollOffset : diff);
        }
        if (0 != resultScroll) {
            LayoutHelper layoutHelper = this.mLayoutHelper;
            layoutHelper.mScrollOffset = layoutHelper.mScrollOffset + resultScroll;
            this.fillData(recycler, state);
        }
        return resultScroll;
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        this.mDecoratedChildSizeInvalid = true;
        super.onMeasure(recycler, state, widthSpec, heightSpec);
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        super.onAdapterChanged(oldAdapter, newAdapter);
        this.removeAllViews();
    }

    @CallSuper
    public void onLayoutChildren(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state) {
        if (0 == state.getItemCount()) {
            this.removeAndRecycleAllViews(recycler);
            this.selectItemCenterPosition(-1);
            return;
        }
        if (null == this.mDecoratedChildWidth || this.mDecoratedChildSizeInvalid) {
            View view2 = recycler.getViewForPosition(0);
            this.addView(view2);
            this.measureChildWithMargins(view2, 0, 0);
            int decoratedChildWidth = this.getDecoratedMeasuredWidth(view2);
            int decoratedChildHeight = this.getDecoratedMeasuredHeight(view2);
            this.removeAndRecycleView(view2, recycler);
            if (null != this.mDecoratedChildWidth && (this.mDecoratedChildWidth != decoratedChildWidth || this.mDecoratedChildHeight != decoratedChildHeight) && -1 == this.mPendingScrollPosition && null == this.mPendingCarouselSavedState) {
                this.mPendingScrollPosition = this.mCenterItemPosition;
            }
            this.mDecoratedChildWidth = decoratedChildWidth;
            this.mDecoratedChildHeight = decoratedChildHeight;
            this.mDecoratedChildSizeInvalid = false;
        }
        if (-1 != this.mPendingScrollPosition) {
            int itemsCount = state.getItemCount();
            int n = this.mPendingScrollPosition = 0 == itemsCount ? -1 : Math.max(0, Math.min(itemsCount - 1, this.mPendingScrollPosition));
        }
        if (-1 != this.mPendingScrollPosition) {
            this.mLayoutHelper.mScrollOffset = this.calculateScrollForSelectingPosition(this.mPendingScrollPosition, state);
            this.mPendingScrollPosition = -1;
            this.mPendingCarouselSavedState = null;
        } else if (null != this.mPendingCarouselSavedState) {
            this.mLayoutHelper.mScrollOffset = this.calculateScrollForSelectingPosition(this.mPendingCarouselSavedState.mCenterItemPosition, state);
            this.mPendingCarouselSavedState = null;
        } else if (state.didStructureChange() && -1 != this.mCenterItemPosition) {
            this.mLayoutHelper.mScrollOffset = this.calculateScrollForSelectingPosition(this.mCenterItemPosition, state);
        }
        this.fillData(recycler, state);
    }

    private int calculateScrollForSelectingPosition(int itemPosition, RecyclerView.State state) {
        int fixedItemPosition = itemPosition < state.getItemCount() ? itemPosition : state.getItemCount() - 1;
        return fixedItemPosition * (1 == this.mOrientation ? this.mDecoratedChildHeight : this.mDecoratedChildWidth);
    }

    private void fillData(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state) {
        float currentScrollPosition = this.getCurrentScrollPosition();
        this.generateLayoutOrder(currentScrollPosition, state);
        this.detachAndScrapAttachedViews(recycler);
        this.recyclerOldViews(recycler);
        int width = this.getWidthNoPadding();
        int height = this.getHeightNoPadding();
        if (1 == this.mOrientation) {
            this.fillDataVertical(recycler, width, height);
        } else {
            this.fillDataHorizontal(recycler, width, height);
        }
        recycler.clear();
        this.detectOnItemSelectionChanged(currentScrollPosition, state);
    }

    private void detectOnItemSelectionChanged(float currentScrollPosition, RecyclerView.State state) {
        float absCurrentScrollPosition = CarouselLayoutManager.makeScrollPositionInRange0ToCount(currentScrollPosition, state.getItemCount());
        final int centerItem = Math.round(absCurrentScrollPosition);
        if (this.mCenterItemPosition != centerItem) {
            this.mCenterItemPosition = centerItem;
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    CarouselLayoutManager.this.selectItemCenterPosition(centerItem);
                }
            });
        }
    }

    private void selectItemCenterPosition(int centerItem) {
        for (OnCenterItemSelectionListener onCenterItemSelectionListener : this.mOnCenterItemSelectionListeners) {
            onCenterItemSelectionListener.onCenterItemChanged(centerItem);
        }
    }

    private void fillDataVertical(RecyclerView.Recycler recycler, int width, int height) {
        int start = (width - this.mDecoratedChildWidth) / 2;
        int end = start + this.mDecoratedChildWidth;
        int centerViewTop = (height - this.mDecoratedChildHeight) / 2;
        int count = this.mLayoutHelper.mLayoutOrder.length;
        for (int i = 0; i < count; ++i) {
            LayoutOrder layoutOrder = this.mLayoutHelper.mLayoutOrder[i];
            int offset = this.getCardOffsetByPositionDiff(layoutOrder.mItemPositionDiff);
            int top = centerViewTop + offset;
            int bottom = top + this.mDecoratedChildHeight;
            this.fillChildItem(start, top, end, bottom, layoutOrder, recycler, i);
        }
    }

    private void fillDataHorizontal(RecyclerView.Recycler recycler, int width, int height) {
        int top = (height - this.mDecoratedChildHeight) / 2;
        int bottom = top + this.mDecoratedChildHeight;
        int centerViewStart = (width - this.mDecoratedChildWidth) / 2;
        int count = this.mLayoutHelper.mLayoutOrder.length;
        for (int i = 0; i < count; ++i) {
            LayoutOrder layoutOrder = this.mLayoutHelper.mLayoutOrder[i];
            int offset = this.getCardOffsetByPositionDiff(layoutOrder.mItemPositionDiff);
            int start = centerViewStart + offset;
            int end = start + this.mDecoratedChildWidth;
            this.fillChildItem(start, top, end, bottom, layoutOrder, recycler, i);
        }
    }

    private void fillChildItem(int start, int top, int end, int bottom, @NonNull LayoutOrder layoutOrder, @NonNull RecyclerView.Recycler recycler, int i) {
        View view2 = this.bindChild(layoutOrder.mItemAdapterPosition, recycler);
        ViewCompat.setElevation((View)view2, (float)i);
        ItemTransformation transformation = null;
        if (null != this.mViewPostLayout) {
            transformation = this.mViewPostLayout.transformChild(view2, layoutOrder.mItemPositionDiff, this.mOrientation);
        }
        if (null == transformation) {
            view2.layout(start, top, end, bottom);
        } else {
            view2.layout(Math.round((float)start + transformation.mTranslationX), Math.round((float)top + transformation.mTranslationY), Math.round((float)end + transformation.mTranslationX), Math.round((float)bottom + transformation.mTranslationY));
            view2.setScaleX(transformation.mScaleX);
            view2.setScaleY(transformation.mScaleY);
        }
    }

    private float getCurrentScrollPosition() {
        int fullScrollSize = this.getMaxScrollOffset();
        if (0 == fullScrollSize) {
            return 0.0f;
        }
        return 1.0f * (float)this.mLayoutHelper.mScrollOffset / (float)this.getScrollItemSize();
    }

    private int getMaxScrollOffset() {
        return this.getScrollItemSize() * (this.mItemsCount - 1);
    }

    private void generateLayoutOrder(float currentScrollPosition, @NonNull RecyclerView.State state) {
        this.mItemsCount = state.getItemCount();
        float absCurrentScrollPosition = CarouselLayoutManager.makeScrollPositionInRange0ToCount(currentScrollPosition, this.mItemsCount);
        int centerItem = Math.round(absCurrentScrollPosition);
        if (this.mCircleLayout && 1 < this.mItemsCount) {
            int position;
            int i;
            int layoutCount = Math.min(this.mLayoutHelper.mMaxVisibleItems * 2 + 3, this.mItemsCount);
            this.mLayoutHelper.initLayoutOrder(layoutCount);
            int countLayoutHalf = layoutCount / 2;
            for (i = 1; i <= countLayoutHalf; ++i) {
                position = Math.round(absCurrentScrollPosition - (float)i + (float)this.mItemsCount) % this.mItemsCount;
                this.mLayoutHelper.setLayoutOrder(countLayoutHalf - i, position, (float)centerItem - absCurrentScrollPosition - (float)i);
            }
            for (i = layoutCount - 1; i >= countLayoutHalf + 1; --i) {
                position = Math.round(absCurrentScrollPosition - (float)i + (float)layoutCount) % this.mItemsCount;
                this.mLayoutHelper.setLayoutOrder(i - 1, position, (float)centerItem - absCurrentScrollPosition + (float)layoutCount - (float)i);
            }
            this.mLayoutHelper.setLayoutOrder(layoutCount - 1, centerItem, (float)centerItem - absCurrentScrollPosition);
        } else {
            int firstVisible = Math.max(centerItem - this.mLayoutHelper.mMaxVisibleItems - 1, 0);
            int lastVisible = Math.min(centerItem + this.mLayoutHelper.mMaxVisibleItems + 1, this.mItemsCount - 1);
            int layoutCount = lastVisible - firstVisible + 1;
            this.mLayoutHelper.initLayoutOrder(layoutCount);
            for (int i = firstVisible; i <= lastVisible; ++i) {
                if (i == centerItem) {
                    this.mLayoutHelper.setLayoutOrder(layoutCount - 1, i, (float)i - absCurrentScrollPosition);
                    continue;
                }
                if (i < centerItem) {
                    this.mLayoutHelper.setLayoutOrder(i - firstVisible, i, (float)i - absCurrentScrollPosition);
                    continue;
                }
                this.mLayoutHelper.setLayoutOrder(layoutCount - (i - centerItem) - 1, i, (float)i - absCurrentScrollPosition);
            }
        }
    }

    public int getWidthNoPadding() {
        return this.getWidth() - this.getPaddingStart() - this.getPaddingEnd();
    }

    public int getHeightNoPadding() {
        return this.getHeight() - this.getPaddingEnd() - this.getPaddingStart();
    }

    private View bindChild(int position, @NonNull RecyclerView.Recycler recycler) {
        View view2 = recycler.getViewForPosition(position);
        this.addView(view2);
        this.measureChildWithMargins(view2, 0, 0);
        return view2;
    }

    private void recyclerOldViews(RecyclerView.Recycler recycler) {
        for (RecyclerView.ViewHolder viewHolder : new ArrayList(recycler.getScrapList())) {
            int adapterPosition = viewHolder.getAdapterPosition();
            boolean found = false;
            for (LayoutOrder layoutOrder : this.mLayoutHelper.mLayoutOrder) {
                if (layoutOrder.mItemAdapterPosition != adapterPosition) continue;
                found = true;
                break;
            }
            if (found) continue;
            recycler.recycleView(viewHolder.itemView);
        }
    }

    protected int getCardOffsetByPositionDiff(float itemPositionDiff) {
        double smoothPosition = this.convertItemPositionDiffToSmoothPositionDiff(itemPositionDiff);
        int dimenDiff = 1 == this.mOrientation ? (this.getHeightNoPadding() - this.mDecoratedChildHeight) / 2 : (this.getWidthNoPadding() - this.mDecoratedChildWidth) / 2;
        return (int)Math.round((double)(Math.signum(itemPositionDiff) * (float)dimenDiff) * smoothPosition);
    }

    protected double convertItemPositionDiffToSmoothPositionDiff(float itemPositionDiff) {
        float absIemPositionDiff = Math.abs(itemPositionDiff);
        if ((double)absIemPositionDiff > StrictMath.pow(1.0f / (float)this.mLayoutHelper.mMaxVisibleItems, 0.3333333432674408)) {
            return StrictMath.pow(absIemPositionDiff / (float)this.mLayoutHelper.mMaxVisibleItems, 0.5);
        }
        return StrictMath.pow(absIemPositionDiff, 2.0);
    }

    protected int getScrollItemSize() {
        if (1 == this.mOrientation) {
            return this.mDecoratedChildHeight;
        }
        return this.mDecoratedChildWidth;
    }

    public Parcelable onSaveInstanceState() {
        if (null != this.mPendingCarouselSavedState) {
            return new CarouselSavedState(this.mPendingCarouselSavedState);
        }
        CarouselSavedState savedState = new CarouselSavedState(super.onSaveInstanceState());
        savedState.mCenterItemPosition = this.mCenterItemPosition;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof CarouselSavedState) {
            this.mPendingCarouselSavedState = (CarouselSavedState)state;
            super.onRestoreInstanceState(this.mPendingCarouselSavedState.mSuperState);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public int getOffsetCenterView() {
        return Math.round(this.getCurrentScrollPosition()) * this.getScrollItemSize() - this.mLayoutHelper.mScrollOffset;
    }

    protected int getOffsetForCurrentView(@NonNull View view2) {
        int targetPosition = this.getPosition(view2);
        float directionDistance = this.getScrollDirection(targetPosition);
        int distance = Math.round(directionDistance * (float)this.getScrollItemSize());
        if (this.mCircleLayout) {
            return distance;
        }
        return distance;
    }

    private static float makeScrollPositionInRange0ToCount(float currentScrollPosition, int count) {
        float absCurrentScrollPosition;
        for (absCurrentScrollPosition = currentScrollPosition; 0.0f > absCurrentScrollPosition; absCurrentScrollPosition += (float)count) {
        }
        while (Math.round(absCurrentScrollPosition) >= count) {
            absCurrentScrollPosition -= (float)count;
        }
        return absCurrentScrollPosition;
    }

    protected static class CarouselSavedState
    implements Parcelable {
        private final Parcelable mSuperState;
        private int mCenterItemPosition;
        public static final Parcelable.Creator<CarouselSavedState> CREATOR = new Parcelable.Creator<CarouselSavedState>(){

            public CarouselSavedState createFromParcel(Parcel parcel) {
                return new CarouselSavedState(parcel);
            }

            public CarouselSavedState[] newArray(int i) {
                return new CarouselSavedState[i];
            }
        };

        protected CarouselSavedState(@Nullable Parcelable superState) {
            this.mSuperState = superState;
        }

        private CarouselSavedState(@NonNull Parcel in) {
            this.mSuperState = in.readParcelable(Parcelable.class.getClassLoader());
            this.mCenterItemPosition = in.readInt();
        }

        protected CarouselSavedState(@NonNull CarouselSavedState other) {
            this.mSuperState = other.mSuperState;
            this.mCenterItemPosition = other.mCenterItemPosition;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeParcelable(this.mSuperState, i);
            parcel.writeInt(this.mCenterItemPosition);
        }
    }

    private static class LayoutOrder {
        private int mItemAdapterPosition;
        private float mItemPositionDiff;

        private LayoutOrder() {
        }
    }

    private static class LayoutHelper {
        private int mMaxVisibleItems;
        private int mScrollOffset;
        private LayoutOrder[] mLayoutOrder;
        private final List<WeakReference<LayoutOrder>> mReusedItems = new ArrayList<WeakReference<LayoutOrder>>();

        LayoutHelper(int maxVisibleItems) {
            this.mMaxVisibleItems = maxVisibleItems;
        }

        void initLayoutOrder(int layoutCount) {
            if (null == this.mLayoutOrder || this.mLayoutOrder.length != layoutCount) {
                if (null != this.mLayoutOrder) {
                    this.recycleItems(this.mLayoutOrder);
                }
                this.mLayoutOrder = new LayoutOrder[layoutCount];
                this.fillLayoutOrder();
            }
        }

        void setLayoutOrder(int arrayPosition, int itemAdapterPosition, float itemPositionDiff) {
            LayoutOrder item = this.mLayoutOrder[arrayPosition];
            item.mItemAdapterPosition = itemAdapterPosition;
            item.mItemPositionDiff = itemPositionDiff;
        }

        boolean hasAdapterPosition(int adapterPosition) {
            if (null != this.mLayoutOrder) {
                for (LayoutOrder layoutOrder : this.mLayoutOrder) {
                    if (layoutOrder.mItemAdapterPosition != adapterPosition) continue;
                    return true;
                }
            }
            return false;
        }

        private void recycleItems(LayoutOrder ... layoutOrders) {
            for (LayoutOrder layoutOrder : layoutOrders) {
                this.mReusedItems.add(new WeakReference<LayoutOrder>(layoutOrder));
            }
        }

        private void fillLayoutOrder() {
            int length = this.mLayoutOrder.length;
            for (int i = 0; i < length; ++i) {
                if (null != this.mLayoutOrder[i]) continue;
                this.mLayoutOrder[i] = this.createLayoutOrder();
            }
        }

        private LayoutOrder createLayoutOrder() {
            Iterator<WeakReference<LayoutOrder>> iterator = this.mReusedItems.iterator();
            while (iterator.hasNext()) {
                WeakReference<LayoutOrder> layoutOrderWeakReference = iterator.next();
                LayoutOrder layoutOrder = (LayoutOrder)layoutOrderWeakReference.get();
                iterator.remove();
                if (null == layoutOrder) continue;
                return layoutOrder;
            }
            return new LayoutOrder();
        }
    }

    public static interface OnCenterItemSelectionListener {
        public void onCenterItemChanged(int var1);
    }

    public static interface PostLayoutListener {
        public ItemTransformation transformChild(@NonNull View var1, float var2, int var3);
    }
}

