/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager.widget.PagerAdapter;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.hiyo.channel.base.bean.ChannelConfigParse;
import com.yy.hiyo.channel.module.creator.IRoomCreateCallback;
import com.yy.hiyo.channel.module.creator.RoomPageTypeHelper;
import com.yy.hiyo.channel.module.creator.adapter.ITabPage;
import com.yy.hiyo.channel.module.creator.bean.RoomPageTypeData;
import com.yy.hiyo.channel.module.creator.bean.RoomPermissionData;
import com.yy.hiyo.channel.module.creator.page.CreateChannelPage;
import com.yy.hiyo.channel.module.creator.page.CreatePartyPage;
import com.yy.hiyo.channel.module.creator.page.MultiVideoCreatePage;
import com.yy.hiyo.channel.module.creator.page.ShowCreatePage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u000bH\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020 H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u000e\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bJ\u0010\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0010\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010*\u001a\u00020\u000bJ\b\u0010+\u001a\u00020\u001bH\u0002J\u0018\u0010,\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0018\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u00100\u001a\u00020\u001bH\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R6\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u0012j\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00061"}, d2={"Lcom/yy/hiyo/channel/module/creator/adapter/CreateRoomPageAdapter;", "Landroidx/viewpager/widget/PagerAdapter;", "mContext", "Landroidx/fragment/app/FragmentActivity;", "uiCallback", "Lcom/yy/hiyo/channel/module/creator/IRoomCreateCallback;", "fromGroup", "", "(Landroidx/fragment/app/FragmentActivity;Lcom/yy/hiyo/channel/module/creator/IRoomCreateCallback;Z)V", "activePages", "", "", "Lcom/yy/hiyo/channel/module/creator/adapter/ITabPage;", "getFromGroup", "()Z", "getMContext", "()Landroidx/fragment/app/FragmentActivity;", "pageCaches", "Ljava/util/LinkedHashMap;", "Ljava/util/LinkedList;", "Lkotlin/collections/LinkedHashMap;", "tabs", "", "Lcom/yy/hiyo/channel/module/creator/bean/RoomPageTypeData;", "getUiCallback", "()Lcom/yy/hiyo/channel/module/creator/IRoomCreateCallback;", "destroyItem", "", "container", "Landroid/view/ViewGroup;", "position", "obj", "", "getCount", "getItemPosition", "object", "getPageTitle", "", "getPositionFromType", "roomType", "getTabPage", "getTabPageByType", "type", "initPageData", "instantiateItem", "isViewFromObject", "view", "Landroid/view/View;", "updatePageData", "channel-components_debug"})
public final class CreateRoomPageAdapter
extends PagerAdapter {
    private final List<RoomPageTypeData> tabs;
    private final Map<Integer, ITabPage> activePages;
    private final LinkedHashMap<Integer, LinkedList<ITabPage>> pageCaches;
    @NotNull
    private final FragmentActivity mContext;
    @NotNull
    private final IRoomCreateCallback uiCallback;
    private final boolean fromGroup;

    private final void initPageData() {
        Object object;
        RoomPermissionData permission;
        block5: {
            block4: {
                this.tabs.clear();
                permission = this.uiCallback.getRoomPermissionData();
                AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.CHANNEL_COMMON);
                if (!(aConfigData instanceof ChannelConfigParse)) {
                    aConfigData = null;
                }
                if ((object = (ChannelConfigParse)aConfigData) == null || (object = object.getData()) == null) break block4;
                int[] nArray = object.getCreateChannelEntryTypes();
                object = nArray;
                if (nArray != null) break block5;
            }
            int[] nArray = new int[4];
            nArray[0] = 4;
            nArray[1] = 1;
            nArray[2] = 2;
            object = nArray;
            nArray[3] = 3;
        }
        Object entryTypes = object;
        RoomPermissionData roomPermissionData = permission;
        Intrinsics.checkExpressionValueIsNotNull((Object)roomPermissionData, (String)"permission");
        this.tabs.addAll((Collection<RoomPageTypeData>)RoomPageTypeHelper.INSTANCE.getRoomPageList(roomPermissionData, (int[])entryTypes));
    }

    private final void updatePageData() {
        for (RoomPageTypeData item : this.tabs) {
            LinkedList<ITabPage> linkedList = this.pageCaches.get(item.getType());
            if (linkedList == null || (linkedList = linkedList.poll()) == null) continue;
            linkedList.update(item);
        }
    }

    @Nullable
    public final ITabPage getTabPage(int position) {
        if (position >= 0 && position < this.tabs.size()) {
            return this.getTabPageByType(this.tabs.get(position).getType());
        }
        return null;
    }

    @Nullable
    public final ITabPage getTabPageByType(int type) {
        return this.activePages.get(type);
    }

    public boolean isViewFromObject(@NotNull View view2, @NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return Intrinsics.areEqual((Object)view2, (Object)obj);
    }

    public int getCount() {
        return this.tabs.size();
    }

    @Nullable
    public CharSequence getPageTitle(int position) {
        return this.tabs.get(position).getTabName();
    }

    public int getItemPosition(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        return -2;
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup container, int position) {
        ITabPage tabPage;
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        RoomPageTypeData tab = this.tabs.get(position);
        LinkedList<ITabPage> linkedList = this.pageCaches.get(tab.getType());
        ITabPage iTabPage = tabPage = linkedList != null ? linkedList.poll() : null;
        if (tabPage == null) {
            switch (tab.getType()) {
                case 4: {
                    tabPage = new CreateChannelPage(this.mContext, this.uiCallback, this.fromGroup);
                    break;
                }
                case 1: {
                    tabPage = new CreatePartyPage(this.mContext, this.uiCallback, this.fromGroup);
                    break;
                }
                case 2: {
                    tabPage = new MultiVideoCreatePage(this.mContext, this.uiCallback, this.fromGroup);
                    break;
                }
                default: {
                    tabPage = new ShowCreatePage(this.mContext, this.uiCallback, this.fromGroup);
                }
            }
        }
        tabPage.update(tab);
        View view2 = tabPage.getView();
        if (view2.getParent() instanceof ViewGroup) {
            ViewParent viewParent = view2.getParent();
            if (viewParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            ((ViewGroup)viewParent).removeView(view2);
        }
        container.addView(view2);
        this.activePages.put(tab.getType(), tabPage);
        return view2;
    }

    public void destroyItem(@NotNull ViewGroup container, int position, @NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        View tabPage = (View)obj;
        container.removeView(tabPage);
        if (tabPage instanceof ITabPage) {
            int n = ((ITabPage)tabPage).getType();
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            LinkedList<ITabPage> cacheList = this.pageCaches.get(it);
            if (cacheList == null) {
                cacheList = new LinkedList();
                ((Map)this.pageCaches).put(it, cacheList);
            }
            cacheList.offer((ITabPage)tabPage);
            this.activePages.remove(((ITabPage)tabPage).getType());
            ((ITabPage)tabPage).clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getPositionFromType(int roomType) {
        Iterable $this$forEachIndexed$iv = this.tabs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void roomPageTypeData;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            RoomPageTypeData roomPageTypeData2 = (RoomPageTypeData)item$iv;
            int index = n2;
            boolean bl2 = false;
            if (roomPageTypeData.getType() != roomType) continue;
            return index;
        }
        return 0;
    }

    @NotNull
    public final FragmentActivity getMContext() {
        return this.mContext;
    }

    @NotNull
    public final IRoomCreateCallback getUiCallback() {
        return this.uiCallback;
    }

    public final boolean getFromGroup() {
        return this.fromGroup;
    }

    public CreateRoomPageAdapter(@NotNull FragmentActivity mContext, @NotNull IRoomCreateCallback uiCallback, boolean fromGroup) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)uiCallback, (String)"uiCallback");
        this.mContext = mContext;
        this.uiCallback = uiCallback;
        this.fromGroup = fromGroup;
        CreateRoomPageAdapter createRoomPageAdapter = this;
        boolean bl = false;
        Object object = new ArrayList();
        createRoomPageAdapter.tabs = object;
        createRoomPageAdapter = this;
        bl = false;
        createRoomPageAdapter.activePages = object = (Map)new LinkedHashMap();
        this.pageCaches = new LinkedHashMap();
        this.activePages.clear();
        this.initPageData();
        this.updatePageData();
        this.notifyDataSetChanged();
    }
}

