/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.voicefilter;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.config.VoiceFilterConfig;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.hiyo.channel.R;

public class VoiceFilterAnimItem
extends YYRelativeLayout {
    private CircleImageView mLogo;

    public VoiceFilterAnimItem(Context context) {
        super(context);
        this.init();
    }

    public VoiceFilterAnimItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public VoiceFilterAnimItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        VoiceFilterAnimItem.inflate((Context)this.getContext(), (int)R.layout.layout_voice_filter_anim_item, (ViewGroup)this);
        this.mLogo = (CircleImageView)this.findViewById(R.id.lvfai_logo);
    }

    public void update(VoiceFilterConfig.VoiceFilterConfigData.VoiceFilterConfigItem item, final int x, final int y) {
        ImageLoader.loadImage((ImageView)this.mLogo, (String)item.url, null, null, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                VoiceFilterAnimItem.this.startDismissAnim(x, y);
            }
        });
    }

    private void startDismissAnim(int x, int y) {
        ObjectAnimator transYAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{0.0f, -100.0f, y});
        ObjectAnimator transXAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{0.0f, 0.0f, x});
        ObjectAnimator scaleXAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{1.0f, 1.0f, 0.3f});
        ObjectAnimator scaleYAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{1.0f, 1.0f, 0.3f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{transXAnim, transYAnim, scaleXAnim, scaleYAnim});
        animatorSet.setDuration(500L);
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                ViewGroup viewGroup = (ViewGroup)VoiceFilterAnimItem.this.getParent();
                if (viewGroup != null) {
                    viewGroup.removeView((View)VoiceFilterAnimItem.this);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.start();
    }
}

