/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.theme;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.ArrayList;
import java.util.List;
import net.ihago.channel.srv.mgr.Background;
import net.ihago.channel.srv.mgr.GetBackgroundListReq;
import net.ihago.channel.srv.mgr.GetBackgroundListRes;
import net.ihago.channel.srv.mgr.GetPartyBackgroundListReq;
import net.ihago.channel.srv.mgr.GetPartyBackgroundListRes;
import net.ihago.channel.srv.mgr.SetBackgroundReq;
import net.ihago.channel.srv.mgr.SetBackgroundRes;
import net.ihago.channel.srv.mgr.SetPartyBackgroundReq;
import net.ihago.channel.srv.mgr.SetPartyBackgroundRes;

public enum ThemeManager {
    INSTANCE;

    private List<ThemeItemBean> mThemeList = new ArrayList<ThemeItemBean>();
    private List<ThemeItemBean> mPartyThemeList = new ArrayList<ThemeItemBean>();

    public void requestThemeList(final String roomId, final IThemeListCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback2 != null) {
                        callback2.onFailed(-1L, "requestThemeList roomId null");
                    }
                }
            });
            return;
        }
        GetBackgroundListReq getThemeListReq = new GetBackgroundListReq.Builder().build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)getThemeListReq, (IProtoCallback)new IProtoCallback<GetBackgroundListRes>(){

            public void onResponse(@NonNull GetBackgroundListRes message, final long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    FeatureLog.i((String)"FTVoiceRoomTheme", (String)"requestThemeList roomId:%s, requestThemeList null", (Object[])new Object[]{roomId});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback2 != null) {
                                callback2.onFailed(-1L, "requestThemeList message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback2 != null) {
                                callback2.onFailed(code, "requestThemeList not success");
                            }
                        }
                    });
                    return;
                }
                List themeList = message.background;
                if (themeList != null) {
                    ArrayList<ThemeItemBean> themeItemBeanList = new ArrayList<ThemeItemBean>();
                    for (Background theme : themeList) {
                        ThemeItemBean themeItemBean = new ThemeItemBean();
                        themeItemBean.setThemeId(theme.id.intValue());
                        themeItemBean.setUrl(theme.bg_url);
                        themeItemBean.setTitleColor(theme.title_color);
                        themeItemBean.setPreUrl(theme.preview_url);
                        themeItemBean.setExpire(theme.expire.longValue());
                        themeItemBean.setType(theme.type.intValue());
                        themeItemBean.setDynamic(theme.dynamic_type == 1);
                        themeItemBean.setSvgaUrl(theme.svga_url);
                        themeItemBeanList.add(themeItemBean);
                    }
                    ThemeManager.this.mThemeList.clear();
                    ThemeManager.this.mThemeList.addAll(themeItemBeanList);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onSuccess(roomId, ThemeManager.this.mThemeList);
                        }
                    }
                });
                FeatureLog.i((String)"FTVoiceRoomTheme", (String)"requestThemeList roomId:%s, requestThemeList:%s", (Object[])new Object[]{roomId, ThemeManager.this.mThemeList});
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.e((String)"FTVoiceRoomTheme", (String)"requestThemeList timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFailed(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFailed(code, reason);
                        }
                    }
                });
                FeatureLog.e((String)"FTVoiceRoomTheme", (String)"requestThemeList error code:%s reason:%s", (Object[])new Object[]{code, reason});
                return false;
            }
        });
    }

    public ThemeItemBean getTheme(int themeId) {
        for (ThemeItemBean bean2 : this.mThemeList) {
            if (bean2.getThemeId() != themeId) continue;
            return bean2;
        }
        return null;
    }

    public List<ThemeItemBean> getThemeList() {
        ArrayList<ThemeItemBean> themeItemBeans = new ArrayList<ThemeItemBean>();
        themeItemBeans.addAll(this.mThemeList);
        return themeItemBeans;
    }

    public void setThemeReq(final String roomId, final int themeId, final IThemeChangeListener listener2) {
        SetBackgroundReq request = new SetBackgroundReq.Builder().id(Integer.valueOf(themeId)).cid(roomId).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)request, (IProtoCallback)new IProtoCallback<SetBackgroundRes>(){

            public void onResponse(final @NonNull SetBackgroundRes message, final long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setThemeReq message null", (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (listener2 != null) {
                                listener2.onFailed(-1L, "message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (listener2 != null) {
                                listener2.onFailed(code, "setThemeReq not success");
                            }
                        }
                    });
                    BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    return;
                }
                BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                final ThemeItemBean themeItemBean = ThemeItemBean.toThemeItemBean((Background)message.background);
                if (themeItemBean == null) {
                    FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setThemeReq theme null", (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (listener2 != null) {
                                listener2.onFailed(-1L, "theme null");
                            }
                        }
                    });
                    return;
                }
                RoomTrack.INSTANCE.reportThemeChangeEvent(roomId, "1");
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener2 != null && !message.background.__isDefaultInstance()) {
                            FeatureLog.i((String)"FTVoiceRoomTheme", (String)"roomid:%s setThemeReq success, set themeId:%s, server return themeId:%s", (Object[])new Object[]{roomId, themeId, message.background.id});
                            listener2.onSuccess(roomId, themeItemBean);
                        }
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                RoomTrack.INSTANCE.reportThemeChangeEvent(roomId, "2");
                BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener2 != null) {
                            listener2.onFailed(-1L, "time out");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                RoomTrack.INSTANCE.reportThemeChangeEvent(roomId, "2");
                BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener2 != null) {
                            listener2.onFailed(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void setPartyThemeReq(final String roomId, final int themeId, final IThemeChangeListener listener2) {
        SetPartyBackgroundReq request = new SetPartyBackgroundReq.Builder().id(Integer.valueOf(themeId)).cid(roomId).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)request, (IProtoCallback)new IProtoCallback<SetPartyBackgroundRes>(){

            public void onResponse(final @NonNull SetPartyBackgroundRes message, final long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setPartyThemeReq message null", (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (listener2 != null) {
                                listener2.onFailed(-1L, "message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (listener2 != null) {
                                listener2.onFailed(code, "setPartyThemeReq not success");
                            }
                        }
                    });
                    BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    return;
                }
                BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                final ThemeItemBean themeItemBean = ThemeItemBean.toThemeItemBean((Background)message.background);
                if (themeItemBean == null) {
                    FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setPartyThemeReq theme null", (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (listener2 != null) {
                                listener2.onFailed(-1L, "theme null");
                            }
                        }
                    });
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener2 != null && !message.background.__isDefaultInstance()) {
                            FeatureLog.i((String)"FTVoiceRoomTheme", (String)"roomid:%s setPartyThemeReq success, set themeId:%s, server return themeId:%s", (Object[])new Object[]{roomId, themeId, message.background.id});
                            listener2.onSuccess(roomId, themeItemBean);
                        }
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener2 != null) {
                            listener2.onFailed(-1L, "time out");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                BaseRequestManager.statMetric((String)"channel/setbg", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener2 != null) {
                            listener2.onFailed(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void requestPartyThemeList(final String roomId, final IThemeListCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback2 != null) {
                        callback2.onFailed(-1L, "requestPartyThemeList roomId null");
                    }
                }
            });
            return;
        }
        GetPartyBackgroundListReq getThemeListReq = new GetPartyBackgroundListReq.Builder().build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)getThemeListReq, (IProtoCallback)new IProtoCallback<GetPartyBackgroundListRes>(){

            public void onResponse(@NonNull GetPartyBackgroundListRes message, final long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    FeatureLog.i((String)"FTVoiceRoomTheme", (String)"requestPartyThemeList roomId:%s, requestPartyThemeList null", (Object[])new Object[]{roomId});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback2 != null) {
                                callback2.onFailed(-1L, "requestPartyThemeList message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback2 != null) {
                                callback2.onFailed(code, "requestPartyThemeList not success");
                            }
                        }
                    });
                    return;
                }
                List themeList = message.background;
                if (themeList != null) {
                    ArrayList<ThemeItemBean> themeItemBeanList = new ArrayList<ThemeItemBean>();
                    for (Background theme : themeList) {
                        ThemeItemBean themeItemBean = new ThemeItemBean();
                        themeItemBean.setThemeId(theme.id.intValue());
                        themeItemBean.setUrl(theme.bg_url);
                        themeItemBean.setTitleColor(theme.title_color);
                        themeItemBean.setPreUrl(theme.preview_url);
                        themeItemBean.setExpire(theme.expire.longValue());
                        themeItemBean.setType(theme.type.intValue());
                        themeItemBeanList.add(themeItemBean);
                    }
                    ThemeManager.this.mPartyThemeList.clear();
                    ThemeManager.this.mPartyThemeList.addAll(themeItemBeanList);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onSuccess(roomId, ThemeManager.this.mPartyThemeList);
                        }
                    }
                });
                FeatureLog.i((String)"FTVoiceRoomTheme", (String)"requestPartyThemeList roomId:%s, requestThemeList:%s", (Object[])new Object[]{roomId, ThemeManager.this.mPartyThemeList});
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.e((String)"FTVoiceRoomTheme", (String)"requestPartyThemeList timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFailed(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFailed(code, reason);
                        }
                    }
                });
                FeatureLog.e((String)"FTVoiceRoomTheme", (String)"requestThemeList error code:%s reason:%s", (Object[])new Object[]{code, reason});
                return false;
            }
        });
    }

    public boolean hasActivityTheme() {
        if (this.mThemeList == null) {
            return false;
        }
        if (this.mThemeList.size() == 0) {
            return false;
        }
        boolean hasActivityTheme = false;
        for (ThemeItemBean themeItemBean : this.mThemeList) {
            if (themeItemBean == null || themeItemBean.getType() != 1) continue;
            hasActivityTheme = true;
            break;
        }
        return hasActivityTheme;
    }

    public static interface IThemeChangeListener {
        public void onSuccess(String var1, ThemeItemBean var2);

        public void onFailed(long var1, String var3);
    }

    public static interface IThemeListCallback {
        public void onSuccess(String var1, List<ThemeItemBean> var2);

        public void onFailed(long var1, String var3);
    }
}

