/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.textgroup;

import android.os.SystemClock;
import com.yy.appbase.R;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.db.ChannelMsgData;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import java.util.List;

public class GroupUtils {
    private static int SESSION_INDEX = 0;

    public static boolean containFlag(int inputFlag, int matchFlags) {
        return ChannelMsgData.containFlag((int)inputFlag, (int)matchFlags);
    }

    public static boolean containFlag(long flag, int matchFlags) {
        return ChannelMsgData.containFlag((long)flag, (int)matchFlags);
    }

    public static String getRoleName(long role) {
        if (role == 1L) {
            return ResourceUtils.getString((int)R.string.title_guest);
        }
        if (role == 15L) {
            return ResourceUtils.getString((int)R.string.title_owner);
        }
        if (role == 10L) {
            return ResourceUtils.getString((int)R.string.title_master);
        }
        if (role == 5L) {
            return ResourceUtils.getString((int)R.string.title_member);
        }
        return "";
    }

    public static String createJoinSession() {
        return "" + String.valueOf(System.currentTimeMillis()) + String.valueOf(SystemClock.uptimeMillis()) + ++SESSION_INDEX;
    }

    public static int getMessageType(BaseImMsg msg) {
        List msgSections = msg.getSections();
        if (msgSections == null || msgSections.isEmpty()) {
            return -1;
        }
        MsgSection section = (MsgSection)msgSections.get(0);
        return section.getType();
    }

    public static boolean containMessageType(BaseImMsg msg, int type) {
        List msgSections = msg.getSections();
        if (msgSections == null || msgSections.isEmpty()) {
            return false;
        }
        for (MsgSection section : msgSections) {
            if (section.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean canSendMessageFilterByGuestLimit(int msgType, int guestSpeakLimitBitmask) {
        if (msgType == 2005 || msgType == 1) {
            return true;
        }
        if (msgType == 2) {
            return (guestSpeakLimitBitmask & 2) == 0;
        }
        if (msgType == 3) {
            return (guestSpeakLimitBitmask & 4) == 0;
        }
        if (msgType == 2000 || msgType == 3103 || msgType == 3100) {
            return (guestSpeakLimitBitmask & 8) == 0;
        }
        if (msgType == 3000) {
            return true;
        }
        return true;
    }

    public static String getSendMessageTips(int msgType) {
        if (msgType == 2005 || msgType == 1) {
            return ResourceUtils.getString((int)R.string.channel_tourist_speech_limit_text);
        }
        if (msgType == 2) {
            return ResourceUtils.getString((int)R.string.channel_tourist_speech_limit_image);
        }
        if (msgType == 3) {
            return ResourceUtils.getString((int)R.string.channel_tourist_speech_limit_voice);
        }
        if (msgType == 2000 || msgType == 3103 || msgType == 3100) {
            return ResourceUtils.getString((int)R.string.channel_tourist_speech_limit_game_invite);
        }
        if (msgType == 3000) {
            return ResourceUtils.getString((int)R.string.channel_tourist_speech_limit_face);
        }
        return null;
    }
}

