/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.setting.controller;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import android.text.TextUtils;
import androidx.fragment.app.FragmentActivity;
import biz.CInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnCameraCallbak;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.channel.DR;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.bean.ChannelCoverItemBean;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.component.setting.callback.IChannelCoverCallback;
import com.yy.hiyo.channel.component.setting.callback.ICoverUpdateCallback;
import com.yy.hiyo.channel.component.setting.data.ChannelCoverItem;
import com.yy.hiyo.channel.component.setting.window.ChannelCoverWindow;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.mvp.base.MvpController;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.ihago.channel.srv.mgr.ModifyReq;
import net.ihago.channel.srv.mgr.ModifyRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0014H\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u001cH\u0016J\u0012\u0010&\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020\u001cH\u0002J\b\u0010*\u001a\u00020\u001cH\u0002J\u0012\u0010+\u001a\u00020\u001c2\b\u0010,\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u0016H\u0002J\b\u0010/\u001a\u00020\u001cH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/yy/hiyo/channel/component/setting/controller/ChannelCoverController;", "Lcom/yy/hiyo/mvp/base/MvpController;", "Lcom/yy/hiyo/channel/component/setting/callback/IChannelCoverCallback;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "channelDetailInfo", "Lcom/yy/hiyo/channel/base/bean/ChannelDetailInfo;", "coverCallback", "Lcom/yy/hiyo/channel/component/setting/callback/ICoverUpdateCallback;", "defaultPos", "", "isDel", "", "localDefaultCovers", "", "Lcom/yy/hiyo/dyres/inner/DResource;", "kotlin.jvm.PlatformType", "[Lcom/yy/hiyo/dyres/inner/DResource;", "selectedItemBean", "Lcom/yy/hiyo/channel/base/bean/ChannelCoverItemBean;", "selectedPath", "", "window", "Lcom/yy/hiyo/channel/component/setting/window/ChannelCoverWindow;", "getChannelDetailInfo", "getSelectedItemBean", "handleMessage", "", "msg", "Landroid/os/Message;", "onBack", "onDeleteClick", "position", "data", "onItemClick", "onRightClick", "onUpdateCoverClick", "onWindowDetach", "abstractWindow", "Lcom/yy/framework/core/ui/AbstractWindow;", "openPhotoListAndUpload", "setData", "showChannelCoverPage", "channelInfo", "updateCover", "url", "uploadFile", "Companion", "channel-components_debug"})
public final class ChannelCoverController
extends MvpController
implements IChannelCoverCallback {
    private ChannelCoverWindow window;
    private ChannelDetailInfo channelDetailInfo;
    private ChannelCoverItemBean selectedItemBean;
    private ICoverUpdateCallback coverCallback;
    private String selectedPath;
    private int defaultPos;
    private boolean isDel;
    private final DResource[] localDefaultCovers;
    @NotNull
    public static final String TAG = "ChannelCoverController";
    public static final Companion Companion = new Companion(null);

    public void handleMessage(@Nullable Message msg) {
        super.handleMessage(msg);
        Message message = msg;
        if (message != null) {
            if (message.what == AppbaseMsgDef.ChannelMsgDef.OPEN_CHANNEL_COVER_SETTING_PAGE) {
                if (msg.obj instanceof WeakReference) {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.ref.WeakReference<*>");
                    }
                    Object callback2 = ((WeakReference)object).get();
                    if (callback2 instanceof ICoverUpdateCallback) {
                        this.coverCallback = (ICoverUpdateCallback)callback2;
                        this.showChannelCoverPage(((ICoverUpdateCallback)callback2).getGroupDetailInfo());
                    }
                }
            }
        }
    }

    private final void showChannelCoverPage(ChannelDetailInfo channelInfo) {
        this.channelDetailInfo = channelInfo;
        if (this.window == null) {
            FragmentActivity fragmentActivity = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"context");
            this.window = new ChannelCoverWindow((Context)fragmentActivity, (UICallBacks)this, this);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.window, false);
        this.isDel = false;
        this.setData();
    }

    private final void setData() {
        block7: {
            ChannelCoverItemBean channelCoverItemBean;
            if (this.channelDetailInfo == null) {
                return;
            }
            boolean bl = false;
            ArrayList<ChannelCoverItem> localDefaultCoverDataList = new ArrayList<ChannelCoverItem>();
            ICoverUpdateCallback iCoverUpdateCallback = this.coverCallback;
            if (CommonExtensionsKt.isNotNullOrEmpty((String)(iCoverUpdateCallback != null ? iCoverUpdateCallback.getRoomAvatar() : null)) && !this.isDel) {
                Object object;
                if (this.defaultPos < 0) {
                    this.defaultPos = 0;
                }
                if ((object = this.coverCallback) == null || (object = object.getRoomAvatar()) == null) {
                    object = "";
                }
                channelCoverItemBean = new ChannelCoverItemBean(false, (String)object, true);
            } else {
                channelCoverItemBean = new ChannelCoverItemBean(false, "", true);
            }
            ChannelCoverItemBean addItemBean = channelCoverItemBean;
            addItemBean.setPath(this.selectedPath);
            if (this.defaultPos < 0) {
                double random = Math.random() * (double)this.localDefaultCovers.length;
                this.defaultPos = 1 + (RangesKt.intRangeContains((ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])this.localDefaultCovers)), (double)random) ? (int)random : 0);
            }
            localDefaultCoverDataList.add(new ChannelCoverItem(addItemBean));
            DResource[] $this$forEach$iv = this.localDefaultCovers;
            boolean $i$f$forEach = false;
            DResource[] dResourceArray = $this$forEach$iv;
            int n = dResourceArray.length;
            for (int i = 0; i < n; ++i) {
                DResource element$iv;
                DResource it = element$iv = dResourceArray[i];
                boolean bl2 = false;
                ChannelCoverItemBean itemBean = new ChannelCoverItemBean(false, it.getResUrl(), false, 4, null);
                localDefaultCoverDataList.add(new ChannelCoverItem(itemBean));
            }
            localDefaultCoverDataList.add(new ChannelCoverItem(new ChannelCoverItemBean(false, null, false, 6, null)));
            ChannelCoverItemBean channelCoverItemBean2 = ((ChannelCoverItem)localDefaultCoverDataList.get(this.defaultPos)).getData();
            boolean bl3 = false;
            boolean bl4 = false;
            ChannelCoverItemBean $this$apply = channelCoverItemBean2;
            boolean bl5 = false;
            $this$apply.setSelected(true);
            this.selectedItemBean = $this$apply;
            ChannelCoverWindow channelCoverWindow = this.window;
            if (channelCoverWindow == null) break block7;
            channelCoverWindow.setData((List<ChannelCoverItem>)localDefaultCoverDataList);
        }
    }

    @Override
    @Nullable
    public ChannelCoverItemBean getSelectedItemBean() {
        return this.selectedItemBean;
    }

    @Override
    @Nullable
    public ChannelDetailInfo getChannelDetailInfo() {
        return this.channelDetailInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onItemClick(int position, @NotNull ChannelCoverItemBean data2) {
        block2: {
            block4: {
                boolean bl;
                CharSequence charSequence;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
                    this.defaultPos = position;
                    if (!data2.isAdd()) break block2;
                    if (!data2.isSelected()) break block3;
                    charSequence = data2.getPath();
                    bl = false;
                    if (charSequence.length() > 0) break block4;
                }
                charSequence = data2.getPath();
                bl = false;
                if (!(charSequence.length() == 0)) break block2;
            }
            this.openPhotoListAndUpload();
            return;
        }
        this.setData();
    }

    @Override
    public void onDeleteClick(int position, @NotNull ChannelCoverItemBean data2) {
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        OkCancelDialog tipsDialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.short_tips_channel_cover_del), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, false, new OkCancelDialogListener(this){
            final /* synthetic */ ChannelCoverController this$0;

            public void onCancel() {
            }

            public void onOk() {
                ChannelCoverController.access$setSelectedPath$p(this.this$0, "");
                ChannelCoverController.access$setDefaultPos$p(this.this$0, -1);
                ChannelCoverController.access$setDel$p(this.this$0, true);
                ChannelCoverController.access$setData(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        });
        this.getDialogLinkManager().showDialog((BaseDialog)tipsDialog2);
    }

    @Override
    public void onBack() {
        block0: {
            ChannelCoverWindow channelCoverWindow = this.window;
            if (channelCoverWindow == null) break block0;
            ChannelCoverWindow channelCoverWindow2 = channelCoverWindow;
            boolean bl = false;
            boolean bl2 = false;
            ChannelCoverWindow it = channelCoverWindow2;
            boolean bl3 = false;
            this.mWindowMgr.popWindow(false, (AbstractWindow)it);
        }
    }

    @Override
    public void onRightClick() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onUpdateCoverClick() {
        if (this.selectedItemBean == null) {
            MLog.error((Object)TAG, (String)"onUpdateCoverClick return", (Object[])new Object[0]);
            return;
        }
        ChannelCoverWindow channelCoverWindow = this.window;
        if (channelCoverWindow != null) {
            channelCoverWindow.showLoading();
        }
        ChannelCoverItemBean channelCoverItemBean = this.selectedItemBean;
        if (channelCoverItemBean == null) {
            Intrinsics.throwNpe();
        }
        if (channelCoverItemBean.isAdd()) {
            CharSequence charSequence = this.selectedPath;
            boolean bl = false;
            if (charSequence.length() > 0) {
                this.uploadFile();
                return;
            }
        }
        ChannelCoverItemBean channelCoverItemBean2 = this.selectedItemBean;
        if (channelCoverItemBean2 == null) {
            Intrinsics.throwNpe();
        }
        this.updateCover(channelCoverItemBean2.getUrl());
    }

    private final void openPhotoListAndUpload() {
        ((ICameraService)ServiceManagerProxy.getService(ICameraService.class)).pickPhotoWithClip("FTModifyProfile", new OnCameraCallbak(this){
            final /* synthetic */ ChannelCoverController this$0;

            public final void onFinish(String path) {
                block0: {
                    String string2 = path;
                    if (string2 == null) break block0;
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    ChannelCoverController.access$setSelectedPath$p(this.this$0, it);
                    ChannelCoverController.access$setData(this.this$0);
                }
            }
            {
                this.this$0 = channelCoverController;
            }
        }, 13);
    }

    private final void uploadFile() {
        block1: {
            String ext = YYFileUtils.getFileExtension((String)this.selectedPath);
            if (TextUtils.isEmpty((CharSequence)ext)) {
                ext = ".jpg";
            }
            String key = "cover/" + AccountUtil.getUid() + "_" + System.currentTimeMillis() + ext;
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null || (iServiceManager = (IOOSService)iServiceManager.getService(IOOSService.class)) == null) break block1;
            iServiceManager.uploadFile(key, this.selectedPath, new IUploadObjectCallBack(this){
                final /* synthetic */ ChannelCoverController this$0;

                public void onSuccess(@Nullable UploadObjectRequest request) {
                    block2: {
                        block1: {
                            UploadObjectRequest uploadObjectRequest = request;
                            MLog.info((Object)"ChannelCoverController", (String)("onFinish onSuccess " + (uploadObjectRequest != null ? uploadObjectRequest.mUrl : null)), (Object[])new Object[0]);
                            Object object = request;
                            if (object == null || (object = object.mUrl) == null) break block1;
                            if (!CommonExtensionsKt.isNotNullOrEmpty((String)object)) break block1;
                            ChannelCoverItemBean channelCoverItemBean = ChannelCoverController.access$getSelectedItemBean$p(this.this$0);
                            if (channelCoverItemBean != null) {
                                String string2 = request.mUrl;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.mUrl");
                                channelCoverItemBean.setUrl(string2);
                            }
                            String string3 = request.mUrl;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"request.mUrl");
                            ChannelCoverController.access$updateCover(this.this$0, string3);
                            break block2;
                        }
                        ChannelCoverWindow channelCoverWindow = ChannelCoverController.access$getWindow$p(this.this$0);
                        if (channelCoverWindow == null) break block2;
                        channelCoverWindow.hideLoading();
                    }
                }

                public void onFailure(@Nullable UploadObjectRequest request, int errorCode, @Nullable Exception exception) {
                    UploadObjectRequest uploadObjectRequest = request;
                    MLog.info((Object)"ChannelCoverController", (String)("onFinish onFailure " + (uploadObjectRequest != null ? uploadObjectRequest.mUrl : null)), (Object[])new Object[0]);
                    ChannelCoverWindow channelCoverWindow = ChannelCoverController.access$getWindow$p(this.this$0);
                    if (channelCoverWindow != null) {
                        channelCoverWindow.hideLoading();
                    }
                    ToastUtils.showToast((Activity)((Activity)this.this$0.getContext()), (int)R.string.upload_failed, (int)0);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void updateCover(String url) {
        CInfo.Builder cinfoBuilder = new CInfo.Builder().room_avatar("1");
        ChannelInfo channelInfo = new ChannelInfo();
        boolean bl = false;
        boolean bl2 = false;
        ChannelInfo $this$apply = channelInfo;
        boolean bl3 = false;
        ChannelDetailInfo channelDetailInfo = this.channelDetailInfo;
        $this$apply.gid = channelDetailInfo != null && (channelDetailInfo = channelDetailInfo.baseInfo) != null ? channelDetailInfo.getChannelId() : null;
        $this$apply.roomAvatar = url;
        ChannelInfo channelInfo2 = channelInfo;
        ModifyReq modifyReq = new ModifyReq.Builder().cinfo(BaseRequestManager.obtianCInfo((ChannelInfo)channelInfo2)).set_fields(cinfoBuilder.build()).push_bulletin(Boolean.valueOf(false)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)modifyReq, (IProtoCallback)new SimpleProtoCallback<ModifyRes>(this, url){
            final /* synthetic */ ChannelCoverController this$0;
            final /* synthetic */ String $url;

            public void onResponse(@NotNull ModifyRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    ICoverUpdateCallback iCoverUpdateCallback = ChannelCoverController.access$getCoverCallback$p(this.this$0);
                    if (iCoverUpdateCallback != null) {
                        iCoverUpdateCallback.updateCoverSuccess(this.$url);
                    }
                    ToastUtils.showToast((Activity)((Activity)this.this$0.getContext()), (int)R.string.short_tips_channel_cover_use_succ, (int)0);
                }
                ChannelCoverWindow channelCoverWindow = ChannelCoverController.access$getWindow$p(this.this$0);
                if (channelCoverWindow != null) {
                    channelCoverWindow.hideLoading();
                }
                MLog.info((Object)"ChannelCoverController", (String)("updateCover to:" + msg + " onResponse,code:" + code), (Object[])new Object[0]);
            }

            public void onError(@Nullable String reason, int code) {
                block0: {
                    super.onError(reason, code);
                    MLog.info((Object)"ChannelCoverController", (String)("updateCover onError,code:" + code + " reason:" + reason), (Object[])new Object[0]);
                    ChannelCoverWindow channelCoverWindow = ChannelCoverController.access$getWindow$p(this.this$0);
                    if (channelCoverWindow == null) break block0;
                    channelCoverWindow.hideLoading();
                }
            }
            {
                this.this$0 = $outer;
                this.$url = $captured_local_variable$1;
            }
        });
    }

    public void onWindowDetach(@Nullable AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        ChannelCoverWindow channelCoverWindow = this.window;
        if (channelCoverWindow != null) {
            channelCoverWindow.hideLoading();
        }
        this.window = null;
        this.channelDetailInfo = null;
        this.defaultPos = -1;
        this.selectedPath = "";
        this.getDialogLinkManager().dismissDialog();
    }

    public ChannelCoverController(@NotNull Environment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        super(env);
        this.selectedPath = "";
        this.defaultPos = -1;
        this.localDefaultCovers = new DResource[]{DR.icon_channel_cover1, DR.icon_channel_cover2, DR.icon_channel_cover3, DR.icon_channel_cover4, DR.icon_channel_cover5, DR.icon_channel_cover6, DR.icon_channel_cover7, DR.icon_channel_cover8, DR.icon_channel_cover9, DR.icon_channel_cover10, DR.icon_channel_cover11};
    }

    public static final /* synthetic */ String access$getSelectedPath$p(ChannelCoverController $this) {
        return $this.selectedPath;
    }

    public static final /* synthetic */ void access$setSelectedPath$p(ChannelCoverController $this, String string2) {
        $this.selectedPath = string2;
    }

    public static final /* synthetic */ int access$getDefaultPos$p(ChannelCoverController $this) {
        return $this.defaultPos;
    }

    public static final /* synthetic */ void access$setDefaultPos$p(ChannelCoverController $this, int n) {
        $this.defaultPos = n;
    }

    public static final /* synthetic */ boolean access$isDel$p(ChannelCoverController $this) {
        return $this.isDel;
    }

    public static final /* synthetic */ void access$setDel$p(ChannelCoverController $this, boolean bl) {
        $this.isDel = bl;
    }

    public static final /* synthetic */ void access$setData(ChannelCoverController $this) {
        $this.setData();
    }

    public static final /* synthetic */ ChannelCoverItemBean access$getSelectedItemBean$p(ChannelCoverController $this) {
        return $this.selectedItemBean;
    }

    public static final /* synthetic */ void access$setSelectedItemBean$p(ChannelCoverController $this, ChannelCoverItemBean channelCoverItemBean) {
        $this.selectedItemBean = channelCoverItemBean;
    }

    public static final /* synthetic */ void access$updateCover(ChannelCoverController $this, String url) {
        $this.updateCover(url);
    }

    public static final /* synthetic */ ChannelCoverWindow access$getWindow$p(ChannelCoverController $this) {
        return $this.window;
    }

    public static final /* synthetic */ void access$setWindow$p(ChannelCoverController $this, ChannelCoverWindow channelCoverWindow) {
        $this.window = channelCoverWindow;
    }

    public static final /* synthetic */ ICoverUpdateCallback access$getCoverCallback$p(ChannelCoverController $this) {
        return $this.coverCallback;
    }

    public static final /* synthetic */ void access$setCoverCallback$p(ChannelCoverController $this, ICoverUpdateCallback iCoverUpdateCallback) {
        $this.coverCallback = iCoverUpdateCallback;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/setting/controller/ChannelCoverController$Companion;", "", "()V", "TAG", "", "channel-components_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

