/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.redpoint;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum ChannelRedPointManager {
    INSTANCE;

    private static final String TAG = "ChannelRedPointManager";
    private static final String TAG_ROOM_PLUGIN_ACTIVITY = "tag_room_plugin_activity";
    private static final String OLD_KEY_ROOM_PLUGIN_READ = "key_room_plugin_read_";
    private static final String KEY_ROOM_PLUGIN_READ = "r_";
    private static final String UPGRADE_VERSION = "upgrade_version";
    private SharedPreferences mSp;

    private void checkInit() {
        if (this.mSp != null) {
            return;
        }
        this.mSp = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, TAG_ROOM_PLUGIN_ACTIVITY, 0, true);
        int version = this.mSp.getInt(UPGRADE_VERSION, 0);
        MLog.info((Object)TAG, (String)("init version: " + version), (Object[])new Object[0]);
        if (version == 0) {
            String activityIds = SettingFlags.getStringValue((String)TAG_ROOM_PLUGIN_ACTIVITY);
            MLog.info((Object)TAG, (String)("init activityId: " + activityIds), (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((String)activityIds)) {
                List<String> keyList = this.splitActivityId(activityIds);
                this.migrateData(keyList);
            }
            SettingFlags.removeKey((String)TAG_ROOM_PLUGIN_ACTIVITY);
            this.mSp.edit().putInt(UPGRADE_VERSION, 1).apply();
        }
    }

    private void migrateData(List<String> keyList) {
        if (keyList == null) {
            return;
        }
        for (String key : keyList) {
            if (!StringUtils.isNotEmpty((String)key) || !SettingFlags.containKey((String)key)) continue;
            boolean aBoolean = SettingFlags.getBoolean((String)key, (boolean)false);
            String newKey = key;
            if (key.contains(OLD_KEY_ROOM_PLUGIN_READ)) {
                newKey = key.replace(OLD_KEY_ROOM_PLUGIN_READ, "");
            } else if (key.contains(KEY_ROOM_PLUGIN_READ)) {
                newKey = key.replace(KEY_ROOM_PLUGIN_READ, "");
            }
            SettingFlags.removeKey((String)key);
            this.mSp.edit().putBoolean(newKey, aBoolean);
        }
        this.mSp.edit().apply();
    }

    private List<String> splitActivityId(String keyString) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return null;
        }
        String[] splitStr = keyString.split(",");
        return new ArrayList<String>(Arrays.asList(splitStr));
    }

    public void setKey(int actionType, boolean value) {
        this.checkInit();
        MLog.debug((Object)TAG, (String)"addKey, key:%s, value\uff1a%s", (Object[])new Object[]{actionType, value});
        this.mSp.edit().putBoolean(String.valueOf(actionType), value).apply();
    }

    public boolean checkKey(int actionType, boolean defaultValue) {
        this.checkInit();
        String key = String.valueOf(actionType);
        if (!this.mSp.contains(key)) {
            this.mSp.edit().putBoolean(key, defaultValue).apply();
            return defaultValue;
        }
        return this.mSp.getBoolean(key, defaultValue);
    }

    public boolean checkAllReadState(boolean defaultValue) {
        this.checkInit();
        boolean hasRead = defaultValue;
        Set entrySet = this.mSp.getAll().entrySet();
        for (Map.Entry entry : entrySet) {
            if (!(entry.getValue() instanceof Boolean) || ((Boolean)entry.getValue()).equals(defaultValue)) continue;
            hasRead = (Boolean)entry.getValue();
            break;
        }
        return hasRead;
    }
}

