/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.publicscreen.receiver;

import androidx.annotation.NonNull;
import biz.IMMsgItem;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.config.SceneOptConfigItem;
import com.yy.appbase.unifyconfig.config.ScenePerformanceOptConfig;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.callback.IMsgReceiver;
import com.yy.hiyo.channel.base.service.IMsgSource;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import java.util.ArrayList;
import java.util.List;
import net.ihago.channel.srv.mgr.Notify;
import net.ihago.channel.srv.mgr.NotifyReceiveMsg;
import net.ihago.channel.srv.mgr.Uri;

public class HagoMsgSource
extends DefaultController
implements IMsgSource {
    public static final String TAG = "HagoMsgSource";
    private IQueueTaskExecutor taskExecutor = YYTaskExecutor.createAQueueExcuter();
    private IMsgReceiver mMsgReceive;
    private final ArrayList<MyMsg> mMsgsToHandle = new ArrayList();
    private IFrequencyLimitExecutor mFrequencyLimitExecutor = null;
    private Runnable command;
    private IProtoNotify<Notify> mNotify = new IProtoNotify<Notify>(){

        public String serviceName() {
            return "net.ihago.channel.srv.mgr";
        }

        public void onNotify(@NonNull Notify notify2) {
            if (notify2 == null) {
                return;
            }
            List uris = notify2.uris;
            if (uris.isEmpty() || !uris.contains(Uri.UriReceiveMsg.getValue())) {
                MLog.info((Object)HagoMsgSource.TAG, (String)"uri is not valid, urr:%s", (Object[])new Object[]{HagoMsgSource.this.getList(uris)});
                return;
            }
            String notifyCid = notify2.cid;
            NotifyReceiveMsg receiveMsg = notify2.receive_msg;
            IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
            if (receiveMsg != null) {
                if (service == null || service.getMsgItemFactory().isUnSupportBelow_3_3(receiveMsg.msg)) {
                    MLog.info((Object)HagoMsgSource.TAG, (String)"3.3 \u4e4b\u540e\u7684\u7248\u672c\uff0c\u516c\u5c4f\u4e0d\u9700\u8981\u663e\u793a\u4e0d\u517c\u5bb9\u73a9\u6cd5\u6d88\u606f", (Object[])new Object[0]);
                    return;
                }
                if (!ScenePerformanceOptConfig.isTotalSwitchOn()) {
                    HagoMsgSource.this.handleMsg(notifyCid, receiveMsg);
                } else {
                    SceneOptConfigItem item = ScenePerformanceOptConfig.getItem((String)"publicscreen");
                    if (item != null && item.unconventionalSwitchOn) {
                        HagoMsgSource.this.handleMsgWithAggregation(notifyCid, receiveMsg);
                    } else {
                        HagoMsgSource.this.handleMsg(notifyCid, receiveMsg);
                    }
                }
            }
        }
    };

    private String getList(List<Integer> list2) {
        if (list2 == null || list2.isEmpty()) {
            return "empty";
        }
        StringBuilder msg = new StringBuilder();
        for (Integer integer : list2) {
            msg.append(integer).append(",");
        }
        return msg.toString();
    }

    private BaseImMsg getBaseImMsg(String notifyCid, NotifyReceiveMsg receiveMsg) {
        boolean all = receiveMsg.all;
        String msgId = receiveMsg.msgid;
        IMMsgItem msg = receiveMsg.msg;
        IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
        if (msg == null || StringUtils.isEmpty((String)msgId) || service == null || msg.sections == null || msg.sections.size() <= 0) {
            if (!ChannelDefine.sUnEnableLog) {
                MLog.info((Object)TAG, (String)"onNotify receiver unkown Msg:%s", (Object[])new Object[]{receiveMsg.toString()});
            }
            return null;
        }
        BaseImMsg baseImMsg = service.getMsgItemFactory().transformMsgItem(msgId, msg, null);
        if (baseImMsg != null && StringUtils.isEmpty((String)baseImMsg.getCid()) && StringUtils.isNotEmpty((String)notifyCid)) {
            baseImMsg.setCid(notifyCid);
        }
        if (!ChannelDefine.sUnEnableLog && baseImMsg == null) {
            MLog.info((Object)TAG, (String)"onNotify receiver unkown Msg:%s", (Object[])new Object[]{receiveMsg.toString()});
        }
        return baseImMsg;
    }

    private void handleMsg(final String notifyCid, final NotifyReceiveMsg receiveMsg) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final BaseImMsg baseImMsg = HagoMsgSource.this.getBaseImMsg(notifyCid, receiveMsg);
                if (baseImMsg == null) {
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (HagoMsgSource.this.mMsgReceive != null && baseImMsg != null) {
                            if (!ChannelDefine.sUnEnableLog) {
                                MLog.info((Object)HagoMsgSource.TAG, (String)"onNotify receiver Msg:%s", (Object[])new Object[]{baseImMsg.toString()});
                            }
                            HagoMsgSource.this.mMsgReceive.onReceiveMsg(HagoMsgSource.this.channelName(), baseImMsg);
                        }
                    }
                });
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMsgWithAggregation(String notifyCid, NotifyReceiveMsg receiveMsg) {
        ArrayList<MyMsg> arrayList = this.mMsgsToHandle;
        synchronized (arrayList) {
            MyMsg myMsg = new MyMsg();
            myMsg.notifyCid = notifyCid;
            myMsg.receiveMsg = receiveMsg;
            this.mMsgsToHandle.add(myMsg);
        }
        if (this.mFrequencyLimitExecutor == null) {
            this.mFrequencyLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)150L, (boolean)false);
        }
        if (this.command == null) {
            this.command = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MyMsg myMsg = null;
                    ArrayList msgsCopy = null;
                    ArrayList arrayList = HagoMsgSource.this.mMsgsToHandle;
                    synchronized (arrayList) {
                        if (HagoMsgSource.this.mMsgsToHandle.size() == 1) {
                            myMsg = (MyMsg)HagoMsgSource.this.mMsgsToHandle.get(0);
                        } else {
                            msgsCopy = new ArrayList(HagoMsgSource.this.mMsgsToHandle.size());
                            msgsCopy.addAll(HagoMsgSource.this.mMsgsToHandle);
                        }
                        HagoMsgSource.this.mMsgsToHandle.clear();
                    }
                    if (myMsg != null) {
                        HagoMsgSource.this.handleMsg(myMsg.notifyCid, myMsg.receiveMsg);
                    } else if (msgsCopy != null && msgsCopy.size() > 0) {
                        final ArrayList<BaseImMsg> baseImMsgs = new ArrayList<BaseImMsg>(msgsCopy.size());
                        for (MyMsg msg : msgsCopy) {
                            msg.baseImMsg = HagoMsgSource.this.getBaseImMsg(msg.notifyCid, msg.receiveMsg);
                            baseImMsgs.add(msg.baseImMsg);
                            if (ChannelDefine.sUnEnableLog || msg.baseImMsg == null) continue;
                            MLog.info((Object)HagoMsgSource.TAG, (String)"notify receiver Msgs:%s", (Object[])new Object[]{msg.baseImMsg.toString()});
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (HagoMsgSource.this.mMsgReceive != null) {
                                    HagoMsgSource.this.mMsgReceive.onReceiveMsgs(HagoMsgSource.this.channelName(), (List)baseImMsgs);
                                }
                            }
                        });
                    }
                }
            };
        }
        this.mFrequencyLimitExecutor.execute(this.command);
    }

    public HagoMsgSource(Environment env) {
        super(env);
    }

    public void init(IMsgReceiver receiver) {
        this.mMsgReceive = receiver;
        ProtoManager.getInstance().registerNotify(this.mNotify);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"init!", (Object[])new Object[0]);
        }
    }

    public String channelName() {
        return "hago_source";
    }

    private static class MyMsg {
        String notifyCid;
        NotifyReceiveMsg receiveMsg;
        BaseImMsg baseImMsg;

        private MyMsg() {
        }
    }
}

