/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.publicscreen;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import biz.IMMsgItem;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.BaseShareData;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.channel.base.bean.ShareBbsData;
import com.yy.hiyo.channel.base.bean.ShareBigData;
import com.yy.hiyo.channel.base.bean.ShareChannelMsg;
import com.yy.hiyo.channel.base.bean.SharePureImage;
import com.yy.hiyo.channel.base.bean.SharePureText;
import com.yy.hiyo.channel.base.bean.ShareSmallData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IMsgItemFactory;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteCancelMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.ImageMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.OutsideGameInviteMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.channel.service.msg.IChannelMsgModel;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MsgService
extends BaseService
implements IMsgService,
IMsgService.IDataListener {
    private static final String TAG = "MsgService";
    private ArrayList<WeakReference<IMsgService.IDataListener>> dataListeners;
    private IChannelMsgModel groupMsgModel;
    private ChannelRequestManager requestManager;
    private IQueueTaskExecutor taskExecutor;
    private int msgReceiveMode = 1;
    private Runnable updateLastReadCommand = null;
    private boolean isInPage = false;
    private IMsgService.IAppendLocalCallback appendLocalCallback = null;

    public MsgService(IChannelMsgModel groupMsgModel, IChannel group) {
        super(group);
        this.groupMsgModel = groupMsgModel;
        this.requestManager = new ChannelRequestManager();
    }

    public void inMsgPage() {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)"inMsgPage", (Object[])new Object[0]);
        }
        if (!this.isInPage) {
            this.isInPage = true;
            this.groupMsgModel.addDataListener(this.getGroupId(), this);
            this.groupMsgModel.inMsgPage(this.getGroupId());
        }
        this.chekUnread(true);
    }

    public void exitMsgPage() {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)"exitMsgPage", (Object[])new Object[0]);
        }
        this.chekUnread();
        if (this.isInPage) {
            this.isInPage = false;
            this.groupMsgModel.removeDataListener(this.getGroupId(), this);
            this.groupMsgModel.exitMsgPage(this.getGroupId());
        }
    }

    public void deleteMsg(String msgId) {
        this.groupMsgModel.deleteMsg(this.getGroupId(), msgId);
    }

    public void sendMsg(BaseImMsg msg) {
        ChannelDetailInfo channelInfo = this.channel.getDataService().getChannelDetailInfo(null);
        String pid = channelInfo != null ? channelInfo.baseInfo.pid : "";
        String cName = channelInfo != null ? channelInfo.baseInfo.name : "";
        msg.setPid(pid);
        msg.setChannelName(cName);
        this.groupMsgModel.sendMsg(this.getGroupId(), msg);
    }

    public void deleteMsg(BaseImMsg section) {
        this.channel.getDataService().getChannelBaseInfo((channelId, info) -> {
            if (info != null && info.region != null && !TextUtils.isEmpty((CharSequence)info.region.region)) {
                this.groupMsgModel.deleteMsg(this.getGroupId(), info.region.region.toLowerCase(), section);
            }
        });
    }

    public void revokeMsg(BaseImMsg section) {
        this.groupMsgModel.revokeMsg(this.getGroupId(), section);
    }

    public void addLocalMsg(BaseImMsg msg) {
        this.groupMsgModel.addLocalMsg(this.getGroupId(), msg);
    }

    public void addLocalMsgs(List<BaseImMsg> msgs) {
        this.groupMsgModel.addLocalMsgs(this.getGroupId(), msgs);
    }

    public void sendOutsideGameInvite(@NonNull GameMessageModel gameMessageModel, @NonNull String cid, String name) {
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameMessageModel.getGameId());
        if (gameInfo == null || this.getItemFactory() == null) {
            MLog.info((Object)TAG, (String)"sendTeamGameInvite gameInfo is null", (Object[])new Object[0]);
            return;
        }
        int role = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(cid).getRoleService().getRoleCache(AccountUtil.getUid());
        OutsideGameInviteMsg msg = this.getItemFactory().generateLocalOutsideGameInviteMsg(cid, gameMessageModel.getPkId(), gameInfo.getTeamTemplate(), gameInfo, role);
        msg.setPid(cid);
        msg.setChannelName(name);
        this.groupMsgModel.sendMsg(cid, (BaseImMsg)msg);
    }

    public void sendSysLocalMsg(String cid, String msg) {
        if (this.getItemFactory() == null) {
            MLog.info((Object)TAG, (String)"sendSysLocalMsg getItemFactory is null", (Object[])new Object[0]);
            return;
        }
        PureTextMsg baseImMsg = this.getItemFactory().generateLocalPureTextMsg(cid, (CharSequence)msg, 0, 0L);
        baseImMsg.setMsgState(1);
        if (this.appendLocalCallback != null) {
            this.appendLocalCallback.onAppendLocal((BaseImMsg)baseImMsg);
        }
    }

    public void sendShareMsg(@NonNull BaseShareData shareData, @NonNull String cid, boolean appendToLocal) {
        int role = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(cid).getRoleService().getRoleCache(AccountUtil.getUid());
        boolean isMultiVideo = false;
        if (this.getItemFactory() == null) {
            MLog.info((Object)TAG, (String)"sendShareMsg getItemFactory is null", (Object[])new Object[0]);
            return;
        }
        if (((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(shareData.getId()) != null && ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(shareData.getId()).getPluginService() != null) {
            boolean bl = isMultiVideo = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel((String)shareData.getId()).getPluginService().getCurPluginData().mode == 15;
        }
        if (shareData instanceof ShareBigData) {
            BaseImMsg msg = this.getItemFactory().generateShareBigMsg(cid, role, shareData.getSource(), shareData.getType(), shareData.getId(), shareData.getTitle(), shareData.getSubTitle(), shareData.getContent(), shareData.getJumpUrl(), shareData.getImgUrl(), ((ShareBigData)shareData).getShowBtn(), ((ShareBigData)shareData).getButtonText(), shareData.getShareLimit());
            this.sendShareMsg(shareData, cid, role, msg, appendToLocal);
        } else if (shareData instanceof ShareSmallData) {
            boolean isCircle = isMultiVideo ? false : ((ShareSmallData)shareData).getCircleIcon();
            BaseImMsg msg = this.getItemFactory().generateShareSmallMsg(cid, role, shareData.getSource(), shareData.getType(), shareData.getId(), shareData.getTitle(), shareData.getSubTitle(), shareData.getContent(), shareData.getJumpUrl(), shareData.getImgUrl(), isCircle, shareData.getShareLimit(), shareData.getSmallUrl(), isMultiVideo);
            this.sendShareMsg(shareData, cid, role, msg, appendToLocal);
        } else if (shareData instanceof SharePureText) {
            PureTextMsg msg = this.getItemFactory().generateShareTextMsg(cid, (CharSequence)shareData.getContent(), role, shareData.getShareLimit());
            this.sendShareMsg(shareData, cid, role, (BaseImMsg)msg, appendToLocal);
        } else if (shareData instanceof SharePureImage) {
            ImageMsg.Config config2 = new ImageMsg.Config();
            config2.width = ((SharePureImage)shareData).getImgWidth();
            config2.height = ((SharePureImage)shareData).getImgHeight();
            ImageMsg msg = this.getItemFactory().generateShareImageMsg(cid, role, shareData.getImgUrl(), config2, shareData.getShareLimit());
            this.sendShareMsg(shareData, cid, role, (BaseImMsg)msg, appendToLocal);
        } else if (shareData instanceof ShareChannelMsg) {
            BaseImMsg msg = this.getItemFactory().generateShareChannelMsg(cid, (ShareChannelMsg)shareData, role);
            this.sendShareMsg(shareData, cid, role, msg, appendToLocal);
        } else if (shareData instanceof ShareBbsData) {
            boolean isCircle = isMultiVideo ? false : ((ShareBbsData)shareData).getCircleIcon();
            BaseImMsg msg = this.getItemFactory().generateShareBbsMsg(cid, role, shareData.getSource(), shareData.getType(), shareData.getId(), shareData.getTitle(), shareData.getSubTitle(), shareData.getContent(), shareData.getJumpUrl(), shareData.getImgUrl(), isCircle, shareData.getShareLimit(), shareData.getSmallUrl(), isMultiVideo, ((ShareBbsData)shareData).getExtra(), ((ShareBbsData)shareData).getReverse());
            this.sendShareMsg(shareData, cid, role, msg, appendToLocal);
        } else {
            MLog.info((Object)TAG, (String)"sendShareMsg data is error", (Object[])new Object[0]);
        }
    }

    private void sendShareMsg(@NonNull BaseShareData shareData, @NonNull String cid, int role, BaseImMsg msg, boolean appendLocal) {
        msg.setPid(cid);
        if (this.getItemFactory() == null) {
            MLog.info((Object)TAG, (String)"sendShareMsg getItemFactory is null", (Object[])new Object[0]);
            return;
        }
        if (this.appendLocalCallback != null && appendLocal) {
            this.appendLocalCallback.onAppendLocal(msg);
        }
        this.groupMsgModel.sendMsg(cid, msg);
        if (!TextUtils.isEmpty((CharSequence)shareData.getInoutMsg())) {
            YYTaskExecutor.postToMainThread(() -> this.groupMsgModel.sendMsg(cid, (BaseImMsg)this.getItemFactory().generateShareTextMsg(cid, (CharSequence)shareData.getInoutMsg(), role, 1)), (long)500L);
        }
    }

    public void sendCancelOutsideGameInvite(String gid, String mRoomId, @NonNull JoinedChannelInfo channelInfo) {
        if (this.getItemFactory() == null) {
            MLog.info((Object)TAG, (String)"sendShareMsg getItemFactory is null", (Object[])new Object[0]);
            return;
        }
        int role = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(channelInfo.cid).getRoleService().getRoleCache(AccountUtil.getUid());
        GameInviteCancelMsg msg = this.getItemFactory().generateLocalGameInviteCancelMsg(gid, role, mRoomId, 1);
        msg.setPid(channelInfo.cid);
        msg.setChannelName(channelInfo.name);
        this.groupMsgModel.sendMsg(channelInfo.cid, (BaseImMsg)msg);
    }

    public long getUnreadNum(final IMsgService.IGetUnreadNumCallBack callBack) {
        ArrayList<String> groups = new ArrayList<String>(1);
        groups.add(this.getGroupId());
        return this.groupMsgModel.getUnreadNum(groups, new IMsgService.IGetUnreadNumsCallBack(){

            public void onUnreadNum(HashMap<String, Long> unreadDatas) {
                if (callBack != null) {
                    callBack.onUnreadNum(MsgService.this.getGroupId(), unreadDatas.get(MsgService.this.getGroupId()).longValue());
                }
            }
        });
    }

    public void getHistoryMsgList(final IMsgService.MsgAnchor anchor, final int pullNum, final boolean nextFromColdData, final IMsgService.IGetMsgList callBack) {
        this.channel.getDataService().getChannelBaseInfo(new IDataService.IGetGroupBaseInfoCallBack(){

            public void onSuccess(String channelId, ChannelInfo info) {
                if (MsgService.this.getItemFactory() == null) {
                    MLog.info((Object)MsgService.TAG, (String)"sendShareMsg getItemFactory is null", (Object[])new Object[0]);
                    return;
                }
                if (info == null) {
                    return;
                }
                MsgService.this.groupMsgModel.getHistoryMsgList(MsgService.this.getGroupId(), info.region, anchor, pullNum, nextFromColdData, new IMsgService.IGetMsgList(){

                    public void onMsgs(String channelId, boolean hasMore, boolean nextFromColdData, IMsgService.MsgAnchor nextAnchor, List<BaseImMsg> msgs) {
                        if (msgs != null && msgs.size() > 0) {
                            MsgService.this.chekUnread();
                        }
                        if (callBack != null) {
                            callBack.onMsgs(channelId, hasMore, nextFromColdData, nextAnchor, msgs);
                        }
                    }

                    public boolean isUnSupportBelow_3_3(IMMsgItem msg) {
                        return MsgService.this.getItemFactory().isUnSupportBelow_3_3(msg);
                    }

                    public BaseImMsg transformMsgItem(String msgId, IMMsgItem msg, ChannelPushContent pushContent) {
                        return MsgService.this.getItemFactory().transformMsgItem(msgId, msg, pushContent);
                    }

                    public void onError(String channelId, int errorCode, String errorTips) {
                        if (callBack != null) {
                            callBack.onError(channelId, errorCode, errorTips);
                        }
                    }
                });
            }
        });
    }

    public void getMsgListByUid(String channelId, long uid, int pullNum, IMsgService.IGetMsgListByUidCallBack callBack) {
        this.groupMsgModel.getMsgListByUid(channelId, uid, pullNum, callBack);
    }

    public void getMsgListByUidIncludeLocal(String channelId, long uid, int pullNum, IMsgService.IGetMsgListByUidCallBack callBack) {
        this.groupMsgModel.getMsgListByUidIncludeLocal(channelId, uid, pullNum, callBack);
    }

    public void addDataListener(IMsgService.IDataListener listener2) {
        this.groupMsgModel.addDataListener(this.getGroupId(), listener2);
        this.addToMyDataListener(listener2);
    }

    public void removeDataListener(IMsgService.IDataListener listener2) {
        this.removeMyDataListener(listener2);
        this.groupMsgModel.removeDataListener(this.getGroupId(), listener2);
    }

    public void updateDoNotDisturb(boolean switchOn, final IMsgService.ISetDoNotDisturbCallBack callBack) {
        this.requestManager.updateDoNotDisturb(this.getGroupId(), switchOn, new IMsgService.ISetDoNotDisturbCallBack(){

            public void onSuccess(String channelId, boolean switchOn) {
                MsgService.this.msgReceiveMode = switchOn ? 2 : 1;
                ((BaseService)MsgService.this.channel.getRoleService()).onDoNotDisturbChanged(AccountUtil.getUid(), MsgService.this.msgReceiveMode);
                MsgService.this.onMsgDoNotDisturbSwitchChanged(switchOn, MsgService.this.msgReceiveMode);
                if (callBack != null) {
                    callBack.onSuccess(channelId, switchOn);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channelId, errorCode, errorTips, e);
                }
            }
        });
    }

    public boolean isOpenDoNotDisturb(final long uid, final IMsgService.IIsOpenDoNotDisturbCallBack callBack) {
        this.channel.getRoleService().getMemberAndMasterList(1000, 0, new IRoleService.IGetUserListCallBack(){

            public void onSuccess(IChannel channel, long total, List<ChannelUser> members) {
                int mode = 1;
                if (members != null) {
                    for (ChannelUser user : members) {
                        if (user.uid != uid) continue;
                        mode = user.msgReceiveMode;
                        if (MsgService.this.msgReceiveMode == mode || uid != AccountUtil.getUid()) break;
                        MsgService.this.msgReceiveMode = mode;
                        MsgService.this.onMsgDoNotDisturbSwitchChanged(MsgService.this.msgReceiveMode == 2, MsgService.this.msgReceiveMode);
                        break;
                    }
                }
                if (callBack != null) {
                    callBack.onSuccess(MsgService.this.getGroupId(), uid, mode == 2);
                }
            }

            public void onError(IChannel channel, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onSuccess(MsgService.this.getGroupId(), uid, false);
                }
            }
        });
        if (AccountUtil.getUid() == uid) {
            return this.msgReceiveMode == 2;
        }
        return false;
    }

    public void setAppendLocalCallback(IMsgService.IAppendLocalCallback appendLocalCallback) {
        this.appendLocalCallback = appendLocalCallback;
    }

    @Override
    public void onJoined(boolean rejoin2, ChannelDetailInfo info, EnterChannelData data2) {
        super.onJoined(rejoin2, info, data2);
        if (data2.memberInThisChannel != null && data2.memberInThisChannel.uid == AccountUtil.getUid() && data2.memberInThisChannel.msgReceiveMode > 0) {
            this.msgReceiveMode = data2.memberInThisChannel.msgReceiveMode;
        } else {
            int n = this.msgReceiveMode = this.isOpenDoNotDisturb(AccountUtil.getUid(), null) ? 2 : 1;
        }
        if (rejoin2) {
            if (this.dataListeners == null || this.dataListeners.size() == 0) {
                return;
            }
            boolean deleteAllMsg = false;
            IMsgService.IDataListener listenerReal = null;
            for (WeakReference<IMsgService.IDataListener> item : this.dataListeners) {
                if (item == null || (listenerReal = (IMsgService.IDataListener)item.get()) == null || !listenerReal.needRePullMsg(1) || deleteAllMsg) continue;
                deleteAllMsg = true;
                this.groupMsgModel.deleteAllMsg(this.getGroupId());
            }
        }
        if (this.taskExecutor == null) {
            this.taskExecutor = YYTaskExecutor.createAQueueExcuter();
        }
    }

    @Override
    public void onLeaved() {
        this.groupMsgModel.deleteAllMsg(this.getGroupId());
        super.onLeaved();
    }

    private void onMsgDoNotDisturbSwitchChanged(final boolean switchOn, final int mode) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MsgService.this.callBack.getMyJoinedChannels().onMsgDoNotDisturbSwitchChanged(MsgService.this.getGroupId(), mode);
                if (MsgService.this.dataListeners == null || MsgService.this.dataListeners.size() == 0) {
                    return;
                }
                IMsgService.IDataListener listenerReal = null;
                for (WeakReference item : MsgService.this.dataListeners) {
                    if (item == null || (listenerReal = (IMsgService.IDataListener)item.get()) == null) continue;
                    listenerReal.onMsgDoNotDisturbSwitchChanged(switchOn);
                }
            }
        });
    }

    private void addToMyDataListener(IMsgService.IDataListener listener2) {
        if (listener2 == null) {
            return;
        }
        if (this.dataListeners == null) {
            this.dataListeners = new ArrayList(2);
        } else {
            IMsgService.IDataListener listenerReal = null;
            for (WeakReference<IMsgService.IDataListener> item : this.dataListeners) {
                if (item == null || (listenerReal = (IMsgService.IDataListener)item.get()) != listener2) continue;
                return;
            }
        }
        this.dataListeners.add(new WeakReference<IMsgService.IDataListener>(listener2));
    }

    private void removeMyDataListener(IMsgService.IDataListener listener2) {
        if (listener2 == null || this.dataListeners == null || this.dataListeners.size() <= 0) {
            return;
        }
        IMsgService.IDataListener listenerReal = null;
        for (WeakReference<IMsgService.IDataListener> item : this.dataListeners) {
            if (item == null || (listenerReal = (IMsgService.IDataListener)item.get()) != listener2) continue;
            this.dataListeners.remove(item);
            return;
        }
    }

    private boolean isNotBaseModeChannel() {
        IPluginService pluginService = this.channel.getPluginService();
        if (pluginService != null && pluginService.getCurPluginData() != null) {
            return pluginService.getCurPluginData().mode != 1;
        }
        return false;
    }

    private void chekUnread() {
        this.chekUnread(false);
    }

    private void chekUnread(final boolean firstInPage) {
        if (this.isInPage && !this.isNotBaseModeChannel()) {
            this.groupMsgModel.setUnreadNumZero(this.getGroupId());
            this.groupMsgModel.getLastMsg(this.getGroupId(), new IMsgService.IGetMsgCallBack(){

                public void onMsg(String channelId, BaseImMsg baseImMsg) {
                    long serverTimeNow;
                    long ts = -1L;
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info((Object)MsgService.TAG, (String)"updateChannelMsgData:%s, %s", (Object[])new Object[]{channelId, baseImMsg != null ? String.valueOf(baseImMsg.getTs()) : ""});
                    }
                    if (baseImMsg != null && StringUtils.isNotEmpty((String)baseImMsg.getCid()) && !baseImMsg.isLocalMsg() && baseImMsg.isValid()) {
                        ts = baseImMsg.getTs() * 1000L + 1020L;
                    }
                    if ((firstInPage || ts <= 0L) && ts < (serverTimeNow = TimeUtils.getServiceRealTime())) {
                        ts = serverTimeNow;
                    }
                    if (MsgService.this.callBack != null && ts > 0L) {
                        MsgService.this.callBack.getMyJoinedChannels().updateChannelMsgData(MsgService.this.getGroupId(), 0L, ts, baseImMsg);
                    }
                }
            });
        } else if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)"chekUnread:%d, %d", (Object[])new Object[]{this.isInPage ? 1 : 0, this.isNotBaseModeChannel() ? 1 : 0});
        }
    }

    @Override
    public void handleNotifyReceiveMsg(String msgId, BaseImMsg msgItem) {
        if (this.updateLastReadCommand == null) {
            this.updateLastReadCommand = new Runnable(){

                @Override
                public void run() {
                    MsgService.this.updateLastReadCommand = null;
                    if (!MsgService.this.isInPage) {
                        return;
                    }
                    MsgService.this.chekUnread();
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)this.updateLastReadCommand);
        }
    }

    public void onMsgStatuChanged(BaseImMsg baseImMsg, int state) {
        this.chekUnread();
    }

    public void clearUnRead() {
        if (this.groupMsgModel != null) {
            this.groupMsgModel.setUnreadNumZero(this.getGroupId());
            this.groupMsgModel.getLastMsg(this.getGroupId(), new IMsgService.IGetMsgCallBack(){

                public void onMsg(String channelId, BaseImMsg baseImMsg) {
                    long serverTimeNow;
                    long ts = -1L;
                    if (baseImMsg != null && StringUtils.isNotEmpty((String)baseImMsg.getCid()) && !baseImMsg.isLocalMsg() && baseImMsg.isValid()) {
                        ts = baseImMsg.getTs() * 1000L + 1020L;
                    }
                    if (ts <= 0L && ts < (serverTimeNow = TimeUtils.getServiceRealTime())) {
                        ts = serverTimeNow;
                    }
                    if (MsgService.this.callBack != null && ts > 0L) {
                        MsgService.this.callBack.getMyJoinedChannels().updateChannelMsgData(MsgService.this.getGroupId(), 0L, ts, baseImMsg);
                    }
                }
            });
        }
    }

    public boolean isUnSupportBelow_3_3(IMMsgItem msg) {
        return this.getItemFactory() != null && this.getItemFactory().isUnSupportBelow_3_3(msg);
    }

    public BaseImMsg transformMsgItem(String msgId, IMMsgItem msg, ChannelPushContent pushContent) {
        return this.getItemFactory() == null ? null : this.getItemFactory().transformMsgItem(msgId, msg, pushContent);
    }

    private IMsgItemFactory getItemFactory() {
        if (ServiceManagerProxy.getService(IPublicScreenService.class) != null) {
            return ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory();
        }
        return null;
    }
}

